/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.impl.combat.RiftCascadeEffect;
import com.fs.starfarer.api.impl.combat.RiftLanceEffect;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiftTrailEffect
extends BaseEveryFrameCombatPlugin {
    protected IntervalUtil interval = new IntervalUtil(0.1f, 0.3f);
    protected MissileAPI missile;
    protected String loopId;

    public RiftTrailEffect(MissileAPI missile, String loopId) {
        this.missile = missile;
        this.loopId = loopId;
    }

    @Override
    public void advance(float amount, List<InputEventAPI> events) {
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        if (this.loopId != null) {
            Global.getSoundPlayer().playLoop(this.loopId, this.missile, 1.0f, this.missile.getBrightness(), this.missile.getLocation(), this.missile.getVelocity());
        }
        this.interval.advance(amount);
        if (this.interval.intervalElapsed()) {
            this.addParticles();
        }
        if (this.missile.isExpired() || this.missile.didDamage() || !Global.getCombatEngine().isEntityInPlay(this.missile)) {
            Global.getCombatEngine().removePlugin(this);
        }
    }

    public void addParticles() {
        CombatEngineAPI engine = Global.getCombatEngine();
        Color c = RiftLanceEffect.getColorForDarkening(RiftCascadeEffect.STANDARD_RIFT_COLOR);
        Color undercolor = RiftCascadeEffect.EXPLOSION_UNDERCOLOR;
        float b = this.missile.getCurrentBaseAlpha();
        c = Misc.scaleAlpha(c, b);
        undercolor = Misc.scaleAlpha(undercolor, b);
        float baseDuration = 4.0f;
        float size = 30.0f;
        size = this.missile.getSpec().getGlowRadius() * 0.5f;
        Vector2f point = new Vector2f((ReadableVector2f)this.missile.getLocation());
        Vector2f pointOffset = new Vector2f((ReadableVector2f)this.missile.getVelocity());
        pointOffset.scale(0.1f);
        Vector2f.add((Vector2f)point, (Vector2f)pointOffset, (Vector2f)point);
        Vector2f vel = new Vector2f();
        int i = 0;
        while (i < 1) {
            float dur = baseDuration + baseDuration * (float)Math.random();
            float nSize = size;
            Vector2f pt = Misc.getPointWithinRadius(point, nSize * 0.5f);
            Vector2f v = Misc.getUnitVectorAtDegreeAngle((float)Math.random() * 360.0f);
            v.scale(nSize + nSize * (float)Math.random() * 0.5f);
            v.scale(0.2f);
            Vector2f.add((Vector2f)vel, (Vector2f)v, (Vector2f)v);
            float maxSpeed = nSize * 1.5f * 0.2f;
            float minSpeed = nSize * 1.0f * 0.2f;
            float overMin = v.length() - minSpeed;
            if (overMin > 0.0f) {
                float durMult = 1.0f - overMin / (maxSpeed - minSpeed);
                if (durMult < 0.1f) {
                    durMult = 0.1f;
                }
                dur *= 0.5f + 0.5f * durMult;
            }
            engine.addNegativeNebulaParticle(pt, v, nSize * 1.0f, 2.0f, 0.5f, 0.0f, dur, c);
            ++i;
        }
        float dur = baseDuration;
        float rampUp = 0.0f;
        rampUp = 0.5f;
        c = undercolor;
        int i2 = 0;
        while (i2 < 2) {
            Vector2f loc = new Vector2f((ReadableVector2f)point);
            loc = Misc.getPointWithinRadius(loc, size * 1.0f);
            float s = size * 3.0f * (0.5f + (float)Math.random() * 0.5f);
            engine.addNebulaParticle(loc, vel, s, 1.5f, rampUp, 0.0f, dur, c);
            ++i2;
        }
    }
}

