/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetingFeedStats
extends BaseShipSystemScript {
    public static final Object KEY_JITTER = new Object();
    public static final float DAMAGE_INCREASE_PERCENT = 50.0f;
    public static final Color JITTER_UNDER_COLOR = new Color(255, 50, 0, 125);
    public static final Color JITTER_COLOR = new Color(255, 50, 0, 75);

    @Override
    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = null;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        if (effectLevel > 0.0f) {
            float jitterLevel = effectLevel;
            float maxRangeBonus = 5.0f;
            float jitterRangeBonus = jitterLevel * maxRangeBonus;
            for (ShipAPI fighter : this.getFighters(ship)) {
                if (fighter.isHulk()) continue;
                MutableShipStatsAPI fStats = fighter.getMutableStats();
                fStats.getBallisticWeaponDamageMult().modifyMult(id, 1.0f + 0.5f * effectLevel);
                fStats.getEnergyWeaponDamageMult().modifyMult(id, 1.0f + 0.5f * effectLevel);
                fStats.getMissileWeaponDamageMult().modifyMult(id, 1.0f + 0.5f * effectLevel);
                if (!(jitterLevel > 0.0f)) continue;
                fighter.setWeaponGlow(effectLevel, Misc.setAlpha(JITTER_UNDER_COLOR, 255), EnumSet.allOf(WeaponAPI.WeaponType.class));
                fighter.setJitterUnder(KEY_JITTER, JITTER_COLOR, jitterLevel, 5, 0.0f, jitterRangeBonus);
                fighter.setJitter(KEY_JITTER, JITTER_UNDER_COLOR, jitterLevel, 2, 0.0f, 0.0f + jitterRangeBonus * 1.0f);
                Global.getSoundPlayer().playLoop("system_targeting_feed_loop", ship, 1.0f, 1.0f, fighter.getLocation(), fighter.getVelocity());
            }
        }
    }

    private List<ShipAPI> getFighters(ShipAPI carrier) {
        ArrayList<ShipAPI> result = new ArrayList<ShipAPI>();
        for (ShipAPI ship : Global.getCombatEngine().getShips()) {
            if (!ship.isFighter() || ship.getWing() == null || ship.getWing().getSourceShip() != carrier) continue;
            result.add(ship);
        }
        return result;
    }

    @Override
    public void unapply(MutableShipStatsAPI stats, String id) {
        ShipAPI ship = null;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        for (ShipAPI fighter : this.getFighters(ship)) {
            if (fighter.isHulk()) continue;
            MutableShipStatsAPI fStats = fighter.getMutableStats();
            fStats.getBallisticWeaponDamageMult().unmodify(id);
            fStats.getEnergyWeaponDamageMult().unmodify(id);
            fStats.getMissileWeaponDamageMult().unmodify(id);
        }
    }

    @Override
    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        float percent = 50.0f * effectLevel;
        if (index == 0) {
            return new ShipSystemStatsScript.StatusData(Misc.getRoundedValueMaxOneAfterDecimal(1.0f + 50.0f * effectLevel * 0.01f) + "x \u6218\u673a\u4f24\u5bb3", false);
        }
        return null;
    }
}

