/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dem;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.GuidedMissileAI;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.loading.WeaponGroupSpec;
import com.fs.starfarer.api.loading.WeaponGroupType;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DEMScript
extends BaseEveryFrameCombatPlugin
implements MissileAIPlugin {
    protected State state = State.WAIT;
    protected MissileAPI missile;
    protected ShipAPI ship;
    protected WeaponAPI weapon;
    protected CombatEntityAPI fireTarget;
    protected ShipAPI demDrone;
    protected List<Vector2f> targetingLaserFireOffset = new ArrayList<Vector2f>();
    protected List<Vector2f> targetingLaserSweepAngles = new ArrayList<Vector2f>();
    protected List<Vector2f> payloadSweepAngles = new ArrayList<Vector2f>();
    protected List<Float> payloadSweepPhaseShift = new ArrayList<Float>();
    protected float minDelayBeforeTriggering = 0.0f;
    protected boolean useTriggerAngle = false;
    protected float triggerAngle = 0.0f;
    protected float allowedDriftFraction = 0.0f;
    protected float triggerDistance = 0.0f;
    protected float turnRateBoost = 0.0f;
    protected float turnRateMultOnSignal = 1.0f;
    protected float targetingLaserArc = 0.0f;
    protected float targetingTime = 1.0f;
    protected float firingTime = 1.0f;
    protected String targetingLaserId;
    protected String payloadWeaponId;
    protected float preferredMinFireDistance;
    protected float preferredMaxFireDistance;
    protected float targetingLaserRange;
    protected float payloadSweepRateMult;
    protected boolean bombPumped;
    protected boolean fadeOutEngineWhenFiring;
    protected boolean destroyMissleWhenDoneFiring;
    protected boolean randomStrafe;
    protected boolean randomPayloadSweepPhaseShift;
    protected boolean payloadCenterSweepOnOriginalOffset;
    protected boolean snapFacingToTargetIfCloseEnough = true;
    protected Color destroyedExplosionColor;
    protected float elapsedWaiting = 0.0f;
    protected float elapsedTargeting = 0.0f;
    protected float elapsedFiring = 0.0f;
    protected int explosionDelayFrames = 0;
    protected float strafeDur = 0.0f;
    protected float strafeDir = 0.0f;
    protected boolean exploded = false;
    protected ShapedExplosionParams p;

    public DEMScript(MissileAPI missile, ShipAPI ship, WeaponAPI weapon) {
        Vector2f v;
        int i;
        JSONArray arr;
        this.missile = missile;
        this.ship = ship;
        this.weapon = weapon;
        JSONObject json = missile.getSpec().getBehaviorJSON();
        this.minDelayBeforeTriggering = DEMScript.getValue(json, "minDelayBeforeTriggering", 1.0f);
        this.allowedDriftFraction = (float)json.optDouble("allowedDriftFraction", (double)0.33f);
        this.triggerDistance = DEMScript.getValue(json, "triggerDistance", 500.0f);
        try {
            if (json.optBoolean("withShapedExplosion")) {
                this.p = new ShapedExplosionParams();
                this.p.load(json);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.snapFacingToTargetIfCloseEnough = json.optBoolean("snapFacingToTargetIfCloseEnough", false);
        if (json.has("triggerAngle")) {
            this.useTriggerAngle = true;
            this.triggerAngle = DEMScript.getValue(json, "triggerAngle", 0.0f);
        }
        this.preferredMaxFireDistance = DEMScript.getValue(json, "preferredMaxFireDistance", this.triggerDistance);
        this.preferredMinFireDistance = DEMScript.getValue(json, "preferredMinFireDistance", 0.0f);
        this.targetingLaserRange = json.has("targetingLaserRange") ? (float)json.optDouble("targetingLaserRange", 600.0) : Math.max(this.triggerDistance, this.preferredMinFireDistance) + 200.0f;
        this.turnRateBoost = (float)json.optDouble("turnRateBoost", 100.0);
        this.turnRateMultOnSignal = (float)json.optDouble("turnRateMultOnSignal", 1.0);
        this.targetingTime = DEMScript.getValue(json, "targetingTime", 1.0f);
        this.firingTime = (float)json.optDouble("firingTime", 1.25);
        this.targetingLaserId = json.optString("targetingLaserId", null);
        this.payloadWeaponId = json.optString("payloadWeaponId", null);
        this.targetingLaserArc = (float)json.optDouble("targetingLaserArc", 10.0);
        this.payloadSweepRateMult = (float)json.optDouble("payloadSweepRateMult", 1.0);
        this.bombPumped = json.optBoolean("bombPumped", false);
        this.fadeOutEngineWhenFiring = json.optBoolean("fadeOutEngineWhenFiring", false);
        this.destroyMissleWhenDoneFiring = json.optBoolean("destroyMissleWhenDoneFiring", false);
        this.randomStrafe = json.optBoolean("randomStrafe", false);
        this.randomPayloadSweepPhaseShift = json.optBoolean("randomPayloadSweepPhaseShift", false);
        this.payloadCenterSweepOnOriginalOffset = json.optBoolean("payloadCenterSweepOnOriginalOffset", false);
        if (json.has("destroyedExplosionColor")) {
            try {
                this.destroyedExplosionColor = Misc.optColor(json, "destroyedExplosionColor", null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if ((arr = json.optJSONArray("targetingLaserFireOffset")) != null) {
            i = 0;
            while (i < arr.length()) {
                v = new Vector2f((float)arr.optDouble(i), (float)arr.optDouble(i + 1));
                this.targetingLaserFireOffset.add(v);
                i += 2;
            }
        }
        if ((arr = json.optJSONArray("targetingLaserSweepAngles")) != null) {
            i = 0;
            while (i < arr.length()) {
                v = new Vector2f((float)arr.optDouble(i), (float)arr.optDouble(i + 1));
                this.targetingLaserSweepAngles.add(v);
                i += 2;
            }
        }
        if ((arr = json.optJSONArray("payloadSweepAngles")) != null) {
            i = 0;
            while (i < arr.length()) {
                v = new Vector2f((float)arr.optDouble(i), (float)arr.optDouble(i + 1));
                if (this.payloadCenterSweepOnOriginalOffset) {
                    float orig = Global.getSettings().getWeaponSpec(this.payloadWeaponId).getTurretAngleOffsets().get(i / 2).floatValue();
                    v.x += orig;
                    v.y += orig;
                }
                this.payloadSweepAngles.add(v);
                i += 2;
            }
        }
        if (this.randomPayloadSweepPhaseShift) {
            i = 0;
            while (i < this.payloadSweepAngles.size()) {
                this.payloadSweepPhaseShift.add(Float.valueOf((float)Math.random()));
                ++i;
            }
        }
        float maxSpeed = Math.max(50.0f, missile.getMaxSpeed());
        float etaMod = -1.0f * this.triggerDistance / maxSpeed;
        missile.setEtaModifier(etaMod);
    }

    public static float getValue(JSONObject json, String key, float defaultValue) {
        JSONArray arr = json.optJSONArray(key);
        if (arr != null) {
            Vector2f v = new Vector2f((float)arr.optDouble(0), (float)arr.optDouble(1));
            return v.x + (v.y - v.x) * (float)Math.random();
        }
        return (float)json.optDouble(key, (double)defaultValue);
    }

    @Override
    public void advance(float amount, List<InputEventAPI> events) {
        boolean doCleanup;
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        if (this.missile.isFizzling() && this.demDrone != null) {
            Global.getCombatEngine().removeEntity(this.demDrone);
        }
        boolean bl = doCleanup = this.state == State.DONE || (!this.bombPumped || this.state.ordinal() < State.FIRE.ordinal()) && (this.missile.isExpired() || this.missile.didDamage() || !Global.getCombatEngine().isEntityInPlay(this.missile));
        if (doCleanup) {
            if (this.demDrone != null) {
                Global.getCombatEngine().removeEntity(this.demDrone);
            }
            Global.getCombatEngine().removePlugin(this);
            return;
        }
        if (this.state == State.WAIT && this.missile.isArmed() && !this.missile.isFizzling() && !this.missile.isFading()) {
            CombatEntityAPI target = null;
            if (this.missile.getAI() instanceof GuidedMissileAI) {
                GuidedMissileAI ai = (GuidedMissileAI)this.missile.getAI();
                target = ai.getTarget();
            }
            this.elapsedWaiting += amount;
            if (this.useTriggerAngle && target != null) {
                Vector2f from = target.getLocation();
                if (target instanceof ShipAPI) {
                    from = ((ShipAPI)target).getShieldCenterEvenIfNoShield();
                }
                float toMissile = Misc.getAngleInDegrees(from, this.missile.getLocation());
                float toShip = Misc.getAngleInDegrees(from, this.missile.getSpawnLocation());
                float diff = Misc.getAngleDiff(toShip, toMissile);
                if (diff >= this.triggerAngle) {
                    this.elapsedWaiting = this.minDelayBeforeTriggering;
                }
            }
            if (target != null && this.elapsedWaiting >= this.minDelayBeforeTriggering) {
                float dist = Misc.getDistance(target.getLocation(), this.missile.getLocation());
                if ((dist -= Global.getSettings().getTargetingRadius(this.missile.getLocation(), target, false)) < this.triggerDistance) {
                    this.missile.setMaxFlightTime(10000.0f);
                    this.state = State.TURN_TO_TARGET;
                    this.fireTarget = target;
                    this.missile.setMissileAI(this);
                    this.missile.getEngineStats().getMaxTurnRate().modifyFlat("dem", this.turnRateBoost);
                    this.missile.getEngineStats().getTurnAcceleration().modifyFlat("dem", this.turnRateBoost * 2.0f);
                    ShipHullSpecAPI spec = Global.getSettings().getHullSpec("dem_drone");
                    ShipVariantAPI v = Global.getSettings().createEmptyVariant("dem_drone", spec);
                    v.addWeapon("WS 000", this.targetingLaserId);
                    WeaponGroupSpec g = new WeaponGroupSpec(WeaponGroupType.LINKED);
                    g.addSlot("WS 000");
                    v.addWeaponGroup(g);
                    v.addWeapon("WS 001", this.payloadWeaponId);
                    g = new WeaponGroupSpec(WeaponGroupType.LINKED);
                    g.addSlot("WS 001");
                    v.addWeaponGroup(g);
                    this.demDrone = Global.getCombatEngine().createFXDrone(v);
                    this.demDrone.setLayer(CombatEngineLayers.ABOVE_SHIPS_AND_MISSILES_LAYER);
                    this.demDrone.setOwner(this.ship.getOriginalOwner());
                    this.demDrone.getMutableStats().getBeamWeaponRangeBonus().modifyFlat("dem", this.targetingLaserRange);
                    this.demDrone.getMutableStats().getHullDamageTakenMult().modifyMult("dem", 0.0f);
                    this.demDrone.setDrone(true);
                    this.demDrone.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.DRONE_MOTHERSHIP, 100000.0f, this.ship);
                    this.demDrone.getMutableStats().getEnergyWeaponDamageMult().applyMods(this.ship.getMutableStats().getMissileWeaponDamageMult());
                    this.demDrone.getMutableStats().getMissileWeaponDamageMult().applyMods(this.ship.getMutableStats().getMissileWeaponDamageMult());
                    this.demDrone.getMutableStats().getBallisticWeaponDamageMult().applyMods(this.ship.getMutableStats().getMissileWeaponDamageMult());
                    this.demDrone.setCollisionClass(CollisionClass.NONE);
                    this.demDrone.giveCommand(ShipCommand.SELECT_GROUP, null, 0);
                    Global.getCombatEngine().addEntity(this.demDrone);
                    if (this.targetingLaserFireOffset.size() > 0) {
                        WeaponAPI tLaser = this.demDrone.getWeaponGroupsCopy().get(0).getWeaponsCopy().get(0);
                        tLaser.ensureClonedSpec();
                        tLaser.getSpec().getTurretFireOffsets().clear();
                        tLaser.getSpec().getTurretFireOffsets().addAll(this.targetingLaserFireOffset);
                    }
                }
            }
        } else if (this.state == State.TURN_TO_TARGET) {
            float angle = Misc.getAngleInDegrees(this.missile.getLocation(), this.fireTarget.getLocation());
            if (Misc.isInArc(this.missile.getFacing(), this.targetingLaserArc, angle)) {
                this.missile.getEngineStats().getMaxTurnRate().modifyMult("dem_mult", this.turnRateMultOnSignal);
                this.state = State.SIGNAL;
            }
        } else if (this.state == State.SIGNAL) {
            if (this.targetingLaserSweepAngles.size() > 0) {
                float progress = this.elapsedTargeting / this.targetingTime;
                WeaponAPI tLaser = this.demDrone.getWeaponGroupsCopy().get(0).getWeaponsCopy().get(0);
                tLaser.ensureClonedSpec();
                tLaser.getSpec().getTurretAngleOffsets().clear();
                for (Vector2f curr : this.targetingLaserSweepAngles) {
                    float angle = 0.0f;
                    angle = progress < 0.5f ? curr.x + (curr.y - curr.x) * progress * 2.0f : curr.x + (curr.y - curr.x) * (1.0f - progress) * 2.0f;
                    tLaser.getSpec().getTurretAngleOffsets().add(Float.valueOf(angle));
                }
            }
            if (this.targetingLaserRange > 0.0f && this.targetingTime > 0.0f) {
                this.demDrone.giveCommand(ShipCommand.FIRE, this.fireTarget.getLocation(), 0);
            }
            this.elapsedTargeting += amount;
            if (this.elapsedTargeting >= this.targetingTime) {
                this.state = State.FIRE;
                this.demDrone.giveCommand(ShipCommand.SELECT_GROUP, null, 1);
                if (!this.bombPumped) {
                    this.missile.setFlightTime(0.0f);
                    this.missile.setMaxFlightTime(this.firingTime);
                    this.missile.setNoFlameoutOnFizzling(true);
                    this.missile.setNoGlowTime(0.0f);
                    this.missile.setFizzleTime(0.5f);
                    this.missile.setFadeTime(0.5f);
                    this.missile.setEtaModifier(0.0f);
                }
            }
        } else if (this.state == State.FIRE) {
            if (this.bombPumped && !this.exploded && this.explosionDelayFrames >= 1) {
                this.missile.explode();
                Global.getCombatEngine().removeEntity(this.missile);
                if (this.p != null) {
                    this.spawnShapedExplosion(this.missile.getLocation(), this.missile.getFacing(), this.p);
                }
                this.exploded = true;
            }
            ++this.explosionDelayFrames;
            if (this.fadeOutEngineWhenFiring) {
                float progress = this.elapsedFiring / this.firingTime;
                if ((progress *= 2.0f) > 1.0f) {
                    progress = 1.0f;
                }
                this.missile.getEngineController().fadeToOtherColor(this, Misc.zeroColor, Misc.zeroColor, progress, 1.0f);
            }
            if (this.payloadSweepAngles.size() > 0) {
                WeaponAPI payload = this.demDrone.getWeaponGroupsCopy().get(1).getWeaponsCopy().get(0);
                payload.ensureClonedSpec();
                payload.getSpec().getTurretAngleOffsets().clear();
                int index = 0;
                for (Vector2f curr : this.payloadSweepAngles) {
                    float angle = 0.0f;
                    float progress = this.elapsedFiring / this.firingTime;
                    angle = progress < 0.5f ? curr.x + (curr.y - curr.x) * progress * 2.0f : curr.x + (curr.y - curr.x) * (1.0f - progress) * 2.0f;
                    if (this.randomPayloadSweepPhaseShift) {
                        progress += this.payloadSweepPhaseShift.get(index).floatValue();
                        progress = (float)Math.sin((double)progress * Math.PI * (double)this.payloadSweepRateMult);
                        progress = Math.abs(progress);
                        angle = curr.x + (curr.y - curr.x) * progress;
                    }
                    payload.getSpec().getTurretAngleOffsets().add(Float.valueOf(angle));
                    ++index;
                }
            }
            this.demDrone.getMutableStats().getBeamWeaponRangeBonus().unmodifyFlat("dem");
            this.demDrone.giveCommand(ShipCommand.FIRE, this.fireTarget.getLocation(), 0);
            this.elapsedFiring += amount;
            if (this.elapsedFiring >= this.firingTime) {
                this.missile.setNoGlowTime(10.0f);
                this.state = State.DONE;
                if (this.destroyMissleWhenDoneFiring) {
                    this.missile.getVelocity().set(0.0f, 0.0f);
                    if (this.destroyedExplosionColor != null) {
                        this.missile.setDestroyedExplosionColorOverride(this.destroyedExplosionColor);
                    }
                    Global.getCombatEngine().applyDamage(this.missile, this.missile.getLocation(), 100000.0f, DamageType.ENERGY, 0.0f, false, false, this.demDrone, false);
                } else {
                    this.missile.setFizzleTime(1.0f);
                    this.missile.setArmedWhileFizzling(false);
                }
            }
        }
        this.doMissileControl(amount);
        this.updateDroneState(amount);
    }

    protected void updateDroneState(float amount) {
        if (this.demDrone != null) {
            this.demDrone.setOwner(this.missile.getOwner());
            this.demDrone.getLocation().set((ReadableVector2f)this.missile.getLocation());
            this.demDrone.setFacing(this.missile.getFacing());
            this.demDrone.getVelocity().set((ReadableVector2f)this.missile.getVelocity());
            this.demDrone.setAngularVelocity(this.missile.getAngularVelocity());
            Vector2f dir = Misc.getUnitVectorAtDegreeAngle(this.missile.getFacing());
            dir.scale(1000.0f);
            Vector2f.add((Vector2f)dir, (Vector2f)this.missile.getLocation(), (Vector2f)dir);
            this.demDrone.getMouseTarget().set((ReadableVector2f)dir);
            WeaponAPI tLaser = this.demDrone.getWeaponGroupsCopy().get(0).getWeaponsCopy().get(0);
            WeaponAPI payload = this.demDrone.getWeaponGroupsCopy().get(1).getWeaponsCopy().get(0);
            tLaser.setFacing(this.missile.getFacing());
            payload.setFacing(this.missile.getFacing());
            tLaser.setKeepBeamTargetWhileChargingDown(true);
            payload.setKeepBeamTargetWhileChargingDown(true);
            tLaser.setScaleBeamGlowBasedOnDamageEffectiveness(false);
            if (this.firingTime <= 2.0f) {
                payload.setScaleBeamGlowBasedOnDamageEffectiveness(false);
            }
            tLaser.updateBeamFromPoints();
            payload.updateBeamFromPoints();
        }
    }

    protected void doMissileControl(float amount) {
        if (this.state == State.TURN_TO_TARGET || this.state == State.SIGNAL || this.state == State.FIRE && !this.bombPumped && !this.fadeOutEngineWhenFiring) {
            boolean phased;
            float dist = Misc.getDistance(this.fireTarget.getLocation(), this.missile.getLocation());
            if ((dist -= Global.getSettings().getTargetingRadius(this.missile.getLocation(), this.fireTarget, false)) < this.preferredMinFireDistance) {
                this.missile.giveCommand(ShipCommand.ACCELERATE_BACKWARDS);
            } else if (dist > this.preferredMaxFireDistance) {
                this.missile.giveCommand(ShipCommand.ACCELERATE);
            } else if (this.missile.getVelocity().length() > this.missile.getMaxSpeed() * this.allowedDriftFraction) {
                this.missile.giveCommand(ShipCommand.DECELERATE);
            }
            float dir = Misc.getAngleInDegrees(this.missile.getLocation(), this.fireTarget.getLocation());
            float diff = Misc.getAngleDiff(this.missile.getFacing(), dir);
            float rate = this.missile.getMaxTurnRate() * amount;
            boolean turningTowardsDesiredFacing = true;
            boolean bl = phased = this.fireTarget instanceof ShipAPI && ((ShipAPI)this.fireTarget).isPhased();
            if (!phased) {
                if (diff <= rate * 0.25f && turningTowardsDesiredFacing && this.snapFacingToTargetIfCloseEnough) {
                    this.missile.setFacing(dir);
                } else {
                    Misc.turnTowardsPointV2(this.missile, this.fireTarget.getLocation(), 0.0f);
                }
            }
            if (this.randomStrafe) {
                if (this.strafeDur <= 0.0f) {
                    float r = (float)Math.random();
                    this.strafeDir = this.strafeDir == 0.0f ? (r < 0.4f ? 1.0f : (r < 0.8f ? -1.0f : 0.0f)) : (r < 0.8f ? -this.strafeDir : 0.0f);
                    this.strafeDur = 0.5f + (float)Math.random() * 0.5f;
                }
                Vector2f driftDir = Misc.getUnitVectorAtDegreeAngle(this.missile.getFacing() + 90.0f);
                if (this.strafeDir == 1.0f) {
                    driftDir.negate();
                }
                float distToShip = Misc.getDistance(this.ship.getLocation(), this.missile.getLocation());
                float shipToFireTarget = Misc.getDistance(this.ship.getLocation(), this.fireTarget.getLocation());
                float extra = 0.0f;
                if (dist > shipToFireTarget) {
                    extra = dist - shipToFireTarget;
                }
                if (distToShip < this.ship.getCollisionRadius() * 1.0f + extra) {
                    float turnDir;
                    float away = Misc.getAngleInDegrees(this.ship.getLocation(), this.missile.getLocation());
                    this.strafeDir = turnDir = Misc.getClosestTurnDirection(away, this.missile.getFacing());
                }
                float maxDrift = this.missile.getMaxSpeed() * this.allowedDriftFraction;
                float speedInDir = Vector2f.dot((Vector2f)driftDir, (Vector2f)this.missile.getVelocity());
                if (speedInDir < maxDrift) {
                    if (this.strafeDir == 1.0f) {
                        this.missile.giveCommand(ShipCommand.STRAFE_RIGHT);
                    } else if (this.strafeDir == -1.0f) {
                        this.missile.giveCommand(ShipCommand.STRAFE_LEFT);
                    }
                }
                this.strafeDur -= amount;
            }
        }
    }

    @Override
    public void advance(float amount) {
    }

    public void spawnShapedExplosion(Vector2f loc, float angle, ShapedExplosionParams p) {
        if (Global.getCombatEngine().getViewport().isNearViewport(this.ship.getLocation(), 800.0f)) {
            int numParticles = p.shapedExplosionNumParticles;
            float minSize = p.shapedExplosionMinParticleSize;
            float maxSize = p.shapedExplosionMaxParticleSize;
            Color pc = p.shapedExplosionColor;
            float minDur = p.shapedExplosionMinParticleDur;
            float maxDur = p.shapedExplosionMaxParticleDur;
            float arc = p.shapedExplosionArc;
            float scatter = p.shapedExplosionScatter;
            float minVel = p.shapedExplosionMinParticleVel;
            float maxVel = p.shapedExplosionMaxParticleVel;
            float endSizeMin = p.shapedExplosionEndSizeMin;
            float endSizeMax = p.shapedExplosionEndSizeMax;
            Vector2f spawnPoint = new Vector2f((ReadableVector2f)loc);
            int i = 0;
            while (i < numParticles) {
                float angleOffset = (float)Math.random();
                if (angleOffset > 0.2f) {
                    angleOffset *= angleOffset;
                }
                float speedMult = 1.0f - angleOffset;
                speedMult = 0.5f + speedMult * 0.5f;
                angleOffset *= Math.signum((float)Math.random() - 0.5f);
                float theta = (float)Math.toRadians(angle + (angleOffset *= arc / 2.0f));
                float r = (float)(Math.random() * Math.random() * (double)scatter);
                float x = (float)Math.cos(theta) * r;
                float y = (float)Math.sin(theta) * r;
                Vector2f pLoc = new Vector2f(spawnPoint.x + x, spawnPoint.y + y);
                float speed = minVel + (maxVel - minVel) * (float)Math.random();
                Vector2f pVel = Misc.getUnitVectorAtDegreeAngle((float)Math.toDegrees(theta));
                pVel.scale(speed *= speedMult);
                float pSize = minSize + (maxSize - minSize) * (float)Math.random();
                float pDur = minDur + (maxDur - minDur) * (float)Math.random();
                float endSize = endSizeMin + (endSizeMax - endSizeMin) * (float)Math.random();
                Global.getCombatEngine().addNebulaParticle(pLoc, pVel, pSize, endSize, 0.1f, 0.5f, pDur, pc);
                ++i;
            }
        }
    }

    public static class ShapedExplosionParams {
        public float shapedExplosionEndSizeMin = 1.0f;
        public float shapedExplosionEndSizeMax = 2.0f;
        public Color shapedExplosionColor = new Color(255, 150, 130, 155);
        public int shapedExplosionNumParticles = 200;
        public float shapedExplosionMinParticleSize = 80.0f;
        public float shapedExplosionMaxParticleSize = 100.0f;
        public float shapedExplosionScatter = 100.0f;
        public float shapedExplosionMinParticleVel = 100.0f;
        public float shapedExplosionMaxParticleVel = 350.0f;
        public float shapedExplosionMinParticleDur = 1.0f;
        public float shapedExplosionMaxParticleDur = 2.0f;
        public float shapedExplosionArc = 90.0f;

        public void load(JSONObject json) throws JSONException {
            this.shapedExplosionEndSizeMin = (float)json.optDouble("shapedExplosionEndSizeMin");
            this.shapedExplosionEndSizeMax = (float)json.optDouble("shapedExplosionEndSizeMax");
            this.shapedExplosionNumParticles = json.optInt("shapedExplosionNumParticles");
            this.shapedExplosionMinParticleSize = (float)json.optDouble("shapedExplosionMinParticleSize");
            this.shapedExplosionMaxParticleSize = (float)json.optDouble("shapedExplosionMaxParticleSize");
            this.shapedExplosionScatter = (float)json.optDouble("shapedExplosionScatter");
            this.shapedExplosionMinParticleVel = (float)json.optDouble("shapedExplosionMinParticleVel");
            this.shapedExplosionMaxParticleVel = (float)json.optDouble("shapedExplosionMaxParticleVel");
            this.shapedExplosionMinParticleDur = (float)json.optDouble("shapedExplosionMinParticleDur");
            this.shapedExplosionMaxParticleDur = (float)json.optDouble("shapedExplosionMaxParticleDur");
            this.shapedExplosionArc = (float)json.optDouble("shapedExplosionArc");
            this.shapedExplosionColor = Misc.optColor(json, "shapedExplosionColor", null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        WAIT,
        TURN_TO_TARGET,
        SIGNAL,
        FIRE,
        DONE;

    }
}

