/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.hullmods.MilitarizedSubsystems;

public class AssaultPackage
extends BaseHullMod {
    public static float FLUX_CAPACITY_PERCENT = 10.0f;
    public static float HULL_PERCENT = 10.0f;
    public static float ARMOR_PERCENT = 5.0f;

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        float mult = MilitarizedSubsystems.getEffectMult(stats);
        stats.getHullBonus().modifyPercent(id, HULL_PERCENT * mult);
        stats.getArmorBonus().modifyPercent(id, ARMOR_PERCENT * mult);
        stats.getFluxCapacity().modifyPercent(id, FLUX_CAPACITY_PERCENT * mult);
        stats.getDynamic().getMod("act_as_combat_ship").modifyFlat(id, 1.0f);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        float mult = MilitarizedSubsystems.getEffectMult(null);
        if (index == 0) {
            return Math.round(HULL_PERCENT * mult) + "%";
        }
        if (index == 1) {
            return Math.round(ARMOR_PERCENT * mult) + "%";
        }
        if (index == 2) {
            return Math.round(FLUX_CAPACITY_PERCENT * mult) + "%";
        }
        return null;
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        if (this.shipHasOtherModInCategory(ship, this.spec.getId(), "civ_package")) {
            return false;
        }
        return ship.getVariant().hasHullMod("militarized_subsystems");
    }

    public String getUnapplicableReason(ShipAPI ship) {
        if (this.shipHasOtherModInCategory(ship, this.spec.getId(), "civ_package")) {
            return "\u6c11\u7528\u8239\u4f53\u4e0a\u53ea\u80fd\u5b89\u88c5\u4e00\u4e2a\u4f5c\u6218\u5957\u4ef6";
        }
        if (!ship.getVariant().hasHullMod("militarized_subsystems")) {
            return "\u53ea\u80fd\u5b89\u88c5\u5728\u5e26\u6709\u519b\u4e8b\u5316\u5b50\u7cfb\u7edf\u7684\u6c11\u7528\u8239\u4f53\u4e0a";
        }
        return super.getUnapplicableReason(ship);
    }
}

