/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;

public class Automated
extends BaseHullMod {
    public static float MAX_CR_PENALTY = 1.0f;

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getMinCrewMod().modifyMult(id, 0.0f);
        stats.getMaxCrewMod().modifyMult(id, 0.0f);
        if (this.isInPlayerFleet(stats) && !Automated.isAutomatedNoPenalty(stats)) {
            stats.getMaxCombatReadiness().modifyFlat(id, -MAX_CR_PENALTY, "\u65e0\u6cd5\u7ef4\u62a4");
        }
    }

    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        ship.setInvalidTransferCommandTarget(true);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return Math.round(MAX_CR_PENALTY * 100.0f) + "%";
        }
        return null;
    }

    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
        if (this.isInPlayerFleet(ship)) {
            float opad = 10.0f;
            boolean noPenalty = Automated.isAutomatedNoPenalty(ship);
            String usually = "";
            if (noPenalty) {
                usually = "usually ";
            }
            if (noPenalty) {
                tooltip.addPara("\u4f46\u662f\u8be5\u8230\u8239\u7684\u81ea\u52a8\u5316\u7cfb\u7edf\u5e76\u4e0d\u9700\u8981\u7279\u522b\u7684\u4e13\u957f\u6765\u7ef4\u62a4\u3002\u6709\u4e00\u4e9b\u4f7f\u7528\u7684\u6280\u672f\u4e0d\u597d\u7406\u89e3\uff0c\u5f88\u53ef\u80fd\u6765\u81ea\u66f4\u65e9\u7684\u5e74\u4ee3\u3002", opad, Misc.getHighlightColor(), "\u4e0d\u9700\u8981\u7684\u7279\u6b8a\u7684 \u4e13\u957f");
            }
        }
    }

    public static boolean isAutomatedNoPenalty(MutableShipStatsAPI stats) {
        if (stats == null) {
            return false;
        }
        FleetMemberAPI member = stats.getFleetMember();
        if (member == null) {
            return false;
        }
        return member.getHullSpec().hasTag("no_auto_penalty") || member.getVariant().hasTag("no_auto_penalty");
    }

    public static boolean isAutomatedNoPenalty(ShipAPI ship) {
        if (ship == null) {
            return false;
        }
        FleetMemberAPI member = ship.getFleetMember();
        if (member == null) {
            return false;
        }
        return member.getHullSpec().hasTag("no_auto_penalty") || member.getVariant().hasTag("no_auto_penalty");
    }

    public static boolean isAutomatedNoPenalty(FleetMemberAPI member) {
        if (member == null) {
            return false;
        }
        return member.getHullSpec().hasTag("no_auto_penalty") || member.getVariant().hasTag("no_auto_penalty");
    }
}

