/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.FighterLaunchBayAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.listeners.AdvanceableListener;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;

public class BDeck
extends BaseHullMod {
    public static float REPLACEMENT_RATE_THRESHOLD = 0.4f;
    public static float REPLACEMENT_RATE_RESET = 1.0f;
    public static float CR_COST_MULT = 0.0f;
    public static Object STATUS_KEY = new Object();

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
    }

    public void advanceInCombat(ShipAPI ship, float amount) {
        super.advanceInCombat(ship, amount);
    }

    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        ship.addListener(new BDeckListener(ship));
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return String.valueOf(Math.round(REPLACEMENT_RATE_THRESHOLD * 100.0f)) + "%";
        }
        if (index == 1) {
            return String.valueOf(Math.round(REPLACEMENT_RATE_RESET * 100.0f)) + "%";
        }
        return null;
    }

    public static class BDeckListener
    implements AdvanceableListener {
        protected ShipAPI ship;
        protected boolean fired = false;

        public BDeckListener(ShipAPI ship) {
            this.ship = ship;
        }

        public void advance(float amount) {
            float cr = this.ship.getCurrentCR();
            float crCost = this.ship.getDeployCost() * CR_COST_MULT;
            if (!this.fired && cr >= crCost && this.ship.getSharedFighterReplacementRate() <= REPLACEMENT_RATE_THRESHOLD) {
                this.fired = true;
                for (FighterLaunchBayAPI bay : this.ship.getLaunchBaysCopy()) {
                    if (bay.getWing() == null) continue;
                    float rate = REPLACEMENT_RATE_RESET;
                    bay.setCurrRate(rate);
                    bay.makeCurrentIntervalFast();
                    FighterWingSpecAPI spec = bay.getWing().getSpec();
                    int maxTotal = spec.getNumFighters();
                    int actualAdd = maxTotal - bay.getWing().getWingMembers().size();
                    if (actualAdd > 0) {
                        bay.setFastReplacements(bay.getFastReplacements() + actualAdd);
                    }
                    if (!(crCost > 0.0f)) continue;
                    this.ship.setCurrentCR(this.ship.getCurrentCR() - crCost);
                }
            }
            if (Global.getCurrentState() == GameState.COMBAT && Global.getCombatEngine() != null && Global.getCombatEngine().getPlayerShip() == this.ship) {
                String status = "ON STANDBY";
                boolean penalty = false;
                if (this.fired) {
                    status = "OPERATIONAL";
                }
                if (!this.fired && cr < crCost) {
                    status = "NOT READY";
                    penalty = true;
                }
                Global.getCombatEngine().maintainStatusForPlayerShip(STATUS_KEY, Global.getSettings().getSpriteName("ui", "icon_tactical_bdeck"), "B-DECK", status, penalty);
            }
        }
    }
}

