/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.WeaponBaseRangeModifier;
import com.fs.starfarer.api.loading.WeaponSlotAPI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class BallisticRangefinder
extends BaseHullMod {
    public static float BONUS_MAX_1 = 800.0f;
    public static float BONUS_MAX_2 = 800.0f;
    public static float BONUS_MAX_3 = 900.0f;
    public static float BONUS_SMALL_1 = 100.0f;
    public static float BONUS_SMALL_2 = 100.0f;
    public static float BONUS_SMALL_3 = 200.0f;
    public static float BONUS_MEDIUM_3 = 100.0f;
    public static float HYBRID_MULT = 2.0f;
    public static float HYBRID_BONUS_MIN = 100.0f;

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
    }

    public static WeaponAPI.WeaponSize getLargestBallisticSlot(ShipAPI ship) {
        if (ship == null) {
            return null;
        }
        Enum largest = null;
        for (WeaponSlotAPI slot : ship.getHullSpec().getAllWeaponSlotsCopy()) {
            if (slot.isDecorative() || slot.getWeaponType() != WeaponAPI.WeaponType.BALLISTIC || largest != null && largest.ordinal() >= slot.getSlotSize().ordinal()) continue;
            largest = slot.getSlotSize();
        }
        return largest;
    }

    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        WeaponAPI.WeaponSize largest = BallisticRangefinder.getLargestBallisticSlot(ship);
        if (largest == null) {
            return;
        }
        float small = 0.0f;
        float medium = 0.0f;
        float max = 0.0f;
        switch (largest) {
            case LARGE: {
                small = BONUS_SMALL_3;
                medium = BONUS_MEDIUM_3;
                max = BONUS_MAX_3;
                break;
            }
            case MEDIUM: {
                small = BONUS_SMALL_2;
                max = BONUS_MAX_2;
                break;
            }
            case SMALL: {
                small = BONUS_SMALL_1;
                max = BONUS_MAX_1;
            }
        }
        ship.addListener(new RangefinderRangeModifier(small, medium, max));
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        return null;
    }

    public boolean shouldAddDescriptionToTooltip(ShipAPI.HullSize hullSize, ShipAPI ship, boolean isForModSpec) {
        return false;
    }

    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
        float colW;
        float pad = 3.0f;
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        Color t = Misc.getTextColor();
        Color g = Misc.getGrayColor();
        WeaponAPI.WeaponSize largest = BallisticRangefinder.getLargestBallisticSlot(ship);
        tooltip.addPara("\u4f7f\u7528 \u8230\u8239\u6700\u5927\u7684\u5b9e\u5f39\u69fd\u4f4d \u7684\u5b9a\u4f4d\u6570\u636e\u63d0\u9ad8\u67d0\u4e9b\u6b66\u5668\u7684 \u57fa\u7840\u5c04\u7a0b \uff0c\u8ba9\u5b9e\u5f39\u6b66\u5668\u8db3\u4ee5\u548c\u7c7b\u4f3c\u4f46\u66f4\u5927\u7684\u6b66\u5668\u76f8\u6bd4\uff0c\u5bf9\u6df7\u5408\u6b66\u5668\u4e5f\u6709\u6548\u3002\u4f46\u70b9\u9632\u5fa1\u6b66\u5668\u4e0d\u53d7\u5f71\u54cd\u3002", opad, h, "\u8230\u8239\u6700\u5927\u7684\u5b9e\u5f39\u69fd\u4f4d", "\u57fa\u7840\u5c04\u7a0b");
        tooltip.addPara("\u63d0\u9ad8\u6b66\u5668\u7684\u57fa\u7840\u5c04\u7a0b\uff0c\u5177\u4f53\u589e\u76ca\u53d6\u51b3\u4e8e\u8230\u8239\u6700\u5927\u7684 \u5b9e\u5f39\u6b66\u5668\u69fd \u7684 \u5927\u5c0f\u3002\u672c\u63d2\u4ef6\u7684\u589e\u76ca\u4e0d\u4f1a\u8ba9\u6b66\u5668\u7684\u57fa\u7840\u5c04\u7a0b\u8d85\u8fc7 \"\u589e\u76ca\u9650\u5236\"\uff0c\u4f46\u4e0d\u4f1a\u5e72\u6270\u5176\u4ed6\u6765\u6e90\u7684\u5f71\u54cd\u3002", opad);
        tooltip.addSectionHeading("\u5b9e\u5f39\u6b66\u5668\u5c04\u7a0b", Alignment.MID, opad);
        tooltip.addPara("\u6839\u636e\u8230\u8239\u4e0a\u6700\u5927\u5b9e\u5f39\u69fd\u4f4d\u7684\u5177\u4f53\u5927\u5c0f\uff0c\u5f71\u54cd\u4e2d\u5c0f\u578b\u5b9e\u5f39\u6b66\u5668\u3002", opad);
        float col1W = 120.0f;
        float lastW = colW = (float)((int)((width - col1W - 12.0f) / 3.0f));
        tooltip.beginTable(Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), 20.0f, true, true, new Object[]{"\u6700\u5927\u5b9e\u5f39\u69fd\u4f4d", Float.valueOf(col1W), "\u5c0f\u578b", Float.valueOf(colW), "\u4e2d\u578b", Float.valueOf(colW), "\u589e\u76ca\u9650\u5236", Float.valueOf(lastW)});
        Color c = null;
        c = largest == WeaponAPI.WeaponSize.SMALL ? h : (largest == WeaponAPI.WeaponSize.MEDIUM ? h : g);
        tooltip.addRow(new Object[]{Alignment.MID, c, "\u5c0f\u578b / \u4e2d\u578b", Alignment.MID, c, "+" + (int)BONUS_SMALL_1, Alignment.MID, g, " \u2014\u2014 ", Alignment.MID, c, "" + (int)BONUS_MAX_1});
        c = largest == WeaponAPI.WeaponSize.LARGE ? h : g;
        tooltip.addRow(new Object[]{Alignment.MID, c, "\u5927\u578b", Alignment.MID, c, "+" + (int)BONUS_SMALL_3, Alignment.MID, c, "+" + (int)BONUS_MEDIUM_3, Alignment.MID, c, "" + (int)BONUS_MAX_3});
        tooltip.addTable("", 0, opad);
        tooltip.addSectionHeading("\u6df7\u5408\u6b66\u5668\u5c04\u7a0b", Alignment.MID, opad + 7.0f);
        tooltip.addPara("\u6839\u636e\u8230\u8239\u4e0a\u6700\u5927\u5b9e\u5f39\u69fd\u4f4d\u7684\u5177\u4f53\u5927\u5c0f\uff0c\u5f71\u54cd\u6240\u6709\u5927\u5c0f\u7684\u6df7\u5408\u6b66\u5668 (\u6df7\u5408\u6b66\u5668\u662f\u53ef\u4ee5\u653e\u5165\u80fd\u91cf\u6216\u5b9e\u5f39\u69fd\u4f4d\u7684\u6b66\u5668) \u3002", opad);
        col1W = 120.0f;
        colW = (int)((width - col1W - lastW - 15.0f) / 3.0f);
        tooltip.beginTable(Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), 20.0f, true, true, new Object[]{"\u6700\u5927\u5b9e\u5f39\u69fd\u4f4d", Float.valueOf(col1W), "\u5c0f\u578b", Float.valueOf(colW), "\u4e2d\u578b", Float.valueOf(colW), "\u5927\u578b", Float.valueOf(colW), "\u589e\u76ca\u9650\u5236", Float.valueOf(lastW)});
        c = null;
        c = largest == WeaponAPI.WeaponSize.SMALL ? h : (largest == WeaponAPI.WeaponSize.MEDIUM ? h : g);
        tooltip.addRow(new Object[]{Alignment.MID, c, "\u5c0f\u578b / \u4e2d\u578b", Alignment.MID, c, "+" + (int)(BONUS_SMALL_1 * HYBRID_MULT), Alignment.MID, c, "+" + (int)HYBRID_BONUS_MIN, Alignment.MID, c, "+" + (int)HYBRID_BONUS_MIN, Alignment.MID, c, "" + (int)BONUS_MAX_1});
        c = largest == WeaponAPI.WeaponSize.LARGE ? h : g;
        tooltip.addRow(new Object[]{Alignment.MID, c, "\u5927\u578b", Alignment.MID, c, "+" + (int)(BONUS_SMALL_3 * HYBRID_MULT), Alignment.MID, c, "+" + (int)(BONUS_MEDIUM_3 * HYBRID_MULT), Alignment.MID, c, "+" + (int)HYBRID_BONUS_MIN, Alignment.MID, c, "" + (int)BONUS_MAX_3});
        tooltip.addTable("", 0, opad);
        tooltip.addSectionHeading("\u4e0e\u5176\u4ed6\u6548\u679c\u4e4b\u95f4\u7684\u5f71\u54cd", Alignment.MID, opad + 7.0f);
        tooltip.addPara("\u7531\u4e8e\u63d0\u9ad8\u7684\u662f\u57fa\u7840\u5c04\u7a0b\uff0c\u6240\u4ee5\u672c\u589e\u76ca\u5728\u7edd\u5927\u591a\u6570\u5176\u4ed6\u589e\u76ca\u7684\u8ba1\u7b97\u4e4b\u524d\u751f\u6548\uff0c\u53ef\u4ee5\u8fdb\u4e00\u6b65\u53d7\u5230\u5176\u4ed6\u6280\u80fd\u548c\u63d2\u4ef6\u6bd4\u4f8b\u4fee\u6b63\u5f71\u54cd\u3002", opad);
    }

    public float getTooltipWidth() {
        return 412.0f;
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        WeaponAPI.WeaponSize largest = BallisticRangefinder.getLargestBallisticSlot(ship);
        if (ship != null && largest == null) {
            return false;
        }
        return this.getUnapplicableReason(ship) == null;
    }

    public String getUnapplicableReason(ShipAPI ship) {
        WeaponAPI.WeaponSize largest = BallisticRangefinder.getLargestBallisticSlot(ship);
        if (ship != null && largest == null) {
            return "\u8230\u8239\u6ca1\u6709\u5b9e\u5f39\u6b66\u5668\u69fd";
        }
        if (ship != null && ship.getHullSize() != ShipAPI.HullSize.CAPITAL_SHIP && ship.getHullSize() != ShipAPI.HullSize.DESTROYER && ship.getHullSize() != ShipAPI.HullSize.CRUISER) {
            return "\u53ea\u80fd\u5b89\u88c5\u5728\u9a71\u9010\u8230\u6216\u66f4\u5927\u578b\u7684\u8230\u8239\u4e0a";
        }
        return null;
    }

    public static class RangefinderRangeModifier
    implements WeaponBaseRangeModifier {
        public float small;
        public float medium;
        public float max;

        public RangefinderRangeModifier(float small, float medium, float max) {
            this.small = small;
            this.medium = medium;
            this.max = max;
        }

        public float getWeaponBaseRangePercentMod(ShipAPI ship, WeaponAPI weapon) {
            return 0.0f;
        }

        public float getWeaponBaseRangeMultMod(ShipAPI ship, WeaponAPI weapon) {
            return 1.0f;
        }

        public float getWeaponBaseRangeFlatMod(ShipAPI ship, WeaponAPI weapon) {
            if (weapon.getSpec() == null) {
                return 0.0f;
            }
            if (weapon.getSpec().getMountType() != WeaponAPI.WeaponType.BALLISTIC && weapon.getSpec().getMountType() != WeaponAPI.WeaponType.HYBRID) {
                return 0.0f;
            }
            if (weapon.hasAIHint(WeaponAPI.AIHints.PD)) {
                return 0.0f;
            }
            float bonus = 0.0f;
            if (weapon.getSize() == WeaponAPI.WeaponSize.SMALL) {
                bonus = this.small;
            } else if (weapon.getSize() == WeaponAPI.WeaponSize.MEDIUM) {
                bonus = this.medium;
            }
            if (weapon.getSpec().getMountType() == WeaponAPI.WeaponType.HYBRID && (bonus *= HYBRID_MULT) < HYBRID_BONUS_MIN) {
                bonus = HYBRID_BONUS_MIN;
            }
            if (bonus == 0.0f) {
                return 0.0f;
            }
            float base = weapon.getSpec().getMaxRange();
            if (base + bonus > this.max) {
                bonus = this.max - base;
            }
            if (bonus < 0.0f) {
                bonus = 0.0f;
            }
            return bonus;
        }
    }
}

