/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertedHangar
extends BaseHullMod {
    public static float FIGHTER_OP_PER_DP = 5.0f;
    public static int MIN_DP = 1;
    public static float REPLACEMENT_TIME_MULT = 1.5f;
    public static int CREW_REQ = 20;
    public static float REARM_TIME_FRACTION = 0.4f;
    public static float SMOD_CRUISER = 10.0f;
    public static float SMOD_CAPITAL = 25.0f;
    public static float CR_THRESHOLD_UNINSTALLABLE = 70.0f;

    public static int computeDPModifier(float fighterOPCost) {
        int mod = (int)Math.ceil(fighterOPCost / FIGHTER_OP_PER_DP);
        if (mod < MIN_DP) {
            mod = MIN_DP;
        }
        return mod;
    }

    public static float getFighterOPCost(MutableShipStatsAPI stats) {
        float cost = 0.0f;
        for (String wingId : ConvertedHangar.getFighterWings(stats)) {
            FighterWingSpecAPI spec = Global.getSettings().getFighterWingSpec(wingId);
            cost += spec.getOpCost(stats);
        }
        return cost;
    }

    public static List<String> getFighterWings(MutableShipStatsAPI stats) {
        if (stats.getVariant() != null) {
            return stats.getVariant().getFittedWings();
        }
        return new ArrayList<String>();
    }

    public float computeCRMult(float suppliesPerDep, float dpMod) {
        return 1.0f + dpMod / suppliesPerDep;
    }

    @Override
    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        float dpMod;
        boolean refitPenalty;
        float numBays = 1.0f;
        stats.getNumFighterBays().modifyFlat(id, numBays += stats.getDynamic().getMod("converted_hangar_mod").computeEffective(0.0f));
        boolean sMod = this.isSMod(stats);
        if (sMod) {
            float bonus = 0.0f;
            if (hullSize == ShipAPI.HullSize.CRUISER) {
                bonus = SMOD_CRUISER;
            } else if (hullSize == ShipAPI.HullSize.CAPITAL_SHIP) {
                bonus = SMOD_CAPITAL;
            }
            if (bonus != 0.0f) {
                stats.getDynamic().getStat("replacement_rate_increase_mult").modifyPercent(id, bonus);
            }
        }
        boolean crewIncrease = stats.getDynamic().getMod("converted_hangar_no_crew_increase").computeEffective(0.0f) <= 0.0f;
        boolean rearmIncrease = stats.getDynamic().getMod("converted_hangar_no_rearm_increase").computeEffective(0.0f) <= 0.0f;
        boolean dpIncrease = stats.getDynamic().getMod("converted_hangar_no_dp_increase").computeEffective(0.0f) <= 0.0f;
        boolean bl = refitPenalty = stats.getDynamic().getMod("converted_hangar_no_refit_penalty").computeEffective(0.0f) <= 0.0f;
        if (refitPenalty) {
            stats.getFighterRefitTimeMult().modifyMult(id, REPLACEMENT_TIME_MULT);
            stats.getDynamic().getStat("replacement_rate_decrease_mult").modifyMult(id, 1.0f / REPLACEMENT_TIME_MULT);
            stats.getDynamic().getStat("replacement_rate_increase_mult").modifyMult(id, 1.0f / REPLACEMENT_TIME_MULT);
        }
        if (rearmIncrease) {
            stats.getDynamic().getMod("fighter_rearm_time_extra_fraction_of_base_refit_time_mod").modifyFlat(id, REARM_TIME_FRACTION);
        }
        if (dpIncrease && (dpMod = (float)ConvertedHangar.computeDPModifier(ConvertedHangar.getFighterOPCost(stats))) > 0.0f) {
            stats.getDynamic().getMod("deployment_points_mod").modifyFlat(id, dpMod);
            if (stats.getFleetMember() != null) {
                float perDep = stats.getFleetMember().getHullSpec().getSuppliesToRecover();
                float mult = this.computeCRMult(perDep, dpMod);
                stats.getCRPerDeploymentPercent().modifyMult(id, mult);
            }
            stats.getSuppliesToRecover().modifyFlat(id, dpMod);
        }
        if (crewIncrease) {
            stats.getMinCrewMod().modifyFlat(id, CREW_REQ);
        }
    }

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        if (ship != null && ship.getHullSpec().getCRToDeploy() > CR_THRESHOLD_UNINSTALLABLE) {
            return false;
        }
        return ship != null && !ship.isFrigate() && ship.getHullSpec().getFighterBays() <= 0 && !ship.getVariant().hasHullMod("converted_bay") && !ship.getHullSpec().isPhase();
    }

    @Override
    public String getUnapplicableReason(ShipAPI ship) {
        if (ship != null && ship.getHullSpec().getCRToDeploy() > CR_THRESHOLD_UNINSTALLABLE) {
            return "\u8230\u8239\u7684\u90e8\u7f72 \u6218\u5907\u503c \u635f\u8017\u592a\u9ad8";
        }
        if (ship != null && ship.isFrigate()) {
            return "\u65e0\u6cd5\u5b89\u88c5\u5728\u62a4\u536b\u8230\u4e0a";
        }
        if (ship != null && ship.getHullSpec().getFighterBays() > 0) {
            return "\u8230\u8239\u6709\u6807\u51c6\u98de\u884c\u7532\u677f";
        }
        if (ship != null && ship.getVariant().hasHullMod("converted_bay")) {
            return "\u8230\u8239\u6709\u98de\u884c\u7532\u677f";
        }
        return "\u65e0\u6cd5\u5b89\u88c5\u5728\u76f8\u4f4d\u8230\u8239\u4e0a";
    }

    @Override
    public void applyEffectsToFighterSpawnedByShip(ShipAPI fighter, ShipAPI ship, String id) {
    }

    public static void setFighterSkin(ShipAPI fighter, ShipAPI carrier) {
        SpriteAPI sprite = ConvertedHangar.getFighterSkin(fighter, carrier);
        if (sprite != null) {
            fighter.setSprite(sprite);
        }
    }

    public static SpriteAPI getFighterSkin(ShipAPI fighter, ShipAPI carrier) {
        if (carrier.getHullStyleId().equals(fighter.getHullStyleId())) {
            return null;
        }
        String cat = null;
        SpriteAPI skin = null;
        if (carrier.getOwner() == 0 || carrier.getOriginalOwner() == 0) {
            cat = "fighterSkinsPlayerOnly";
            skin = ConvertedHangar.getFighterSkin(cat, fighter, carrier);
        }
        if (skin != null) {
            return skin;
        }
        cat = "fighterSkinsPlayerAndNPC";
        skin = ConvertedHangar.getFighterSkin(cat, fighter, carrier);
        return skin;
    }

    public static SpriteAPI getFighterSkin(String cat, ShipAPI fighter, ShipAPI carrier) {
        String exclude = "fighterSkinsExcludeFromSharing";
        String id = fighter.getHullSpec().getHullId();
        String style = carrier.getHullStyleId();
        List<String> skins = Global.getSettings().getSpriteKeys(cat);
        LinkedHashSet<String> noSharing = new LinkedHashSet<String>(Global.getSettings().getSpriteKeys(exclude));
        ArrayList<SpriteAPI> matching = new ArrayList<SpriteAPI>();
        for (String key : skins) {
            if (key.equals(String.valueOf(id) + "_" + style)) {
                return Global.getSettings().getSprite(cat, key);
            }
            if (!key.startsWith(id) || noSharing.contains(key)) continue;
            matching.add(Global.getSettings().getSprite(cat, key));
        }
        if (!matching.isEmpty()) {
            SpriteAPI best = null;
            float minDist = Float.MAX_VALUE;
            for (SpriteAPI curr : matching) {
                float dist = Misc.getColorDist(carrier.getSpriteAPI().getAverageBrightColor(), curr.getAverageBrightColor());
                if (!(dist < minDist)) continue;
                best = curr;
                minDist = dist;
            }
            return best;
        }
        return null;
    }

    @Override
    public boolean shouldAddDescriptionToTooltip(ShipAPI.HullSize hullSize, ShipAPI ship, boolean isForModSpec) {
        return false;
    }

    @Override
    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
        float pad = 3.0f;
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        tooltip.addPara("\u5c06\u8be5\u8230\u8239\u7684\u6807\u51c6 \u7a7f\u68ad\u673a\u5e93 \u6539\u9020\u4e3a \u98de\u884c\u7532\u677f\u3002\u8fd9\u4e2a\u4e34\u65f6\u6539\u9020\u7684 \u98de\u884c\u7532\u677f \u4ee5\u53ca\u5176\u7ec4\u5458\u548c\u8bbe\u5907\u7684\u6574\u5907\u901f\u5ea6\u5747\u4f4e\u4e8e\u6b63\u89c4\u822a\u6bcd\u3002", opad);
        tooltip.addPara("\u63d0\u9ad8\u8230\u8f7d\u673a\u6574\u5907\u65f6\u95f4 %s}\uff0c\u540c\u65f6 \u6218\u673a\u6574\u5907\u7387 \u7684\u56de\u590d\u548c\u635f\u8017\u90fd\u964d\u4f4e %s}\u3002\u6b64\u5916\uff0c\u6240\u6709\u56de\u8230\u91cd\u65b0\u88c5\u586b\u7684\u8f70\u70b8\u673a\u548c\u56de\u8230\u7ef4\u4fee\u7684\u6218\u6597\u673a\u9700\u8981\u82b1\u8d39\u5176\u57fa\u7840\u6574\u5907\u65f6\u95f4\u7684 %s \u624d\u80fd\u91cd\u65b0\u8d77\u98de\uff0c\u6b63\u5e38\u60c5\u51b5\u4e0b\u8fd9\u53ea\u9700\u4e0d\u5230\u4e00\u79d2\u3002", opad, h, Misc.getRoundedValueMaxOneAfterDecimal(REPLACEMENT_TIME_MULT) + "\u00d7", Misc.getRoundedValueMaxOneAfterDecimal(REPLACEMENT_TIME_MULT) + "\u00d7", Math.round(REARM_TIME_FRACTION * 100.0f) + "%");
        tooltip.addPara("\u4e3a\u8865\u5145\u98de\u884c\u5458\u548c\u6574\u5907\u4eba\u5458\uff0c\u63d0\u9ad8 %s \u6700\u4f4e\u8239\u5458\u9700\u6c42\u3002\u8230\u8239\u7684\u90e8\u7f72\u70b9\u6218\u540e\u6062\u590d\u6240\u9700\u8865\u7ed9\u90fd\u63d0\u9ad8 %s}\uff0c\u6bcf\u5728\u8230\u8f7d\u673a\u4e0a\u82b1\u8d39 %s \u88c5\u914d\u70b9\u5c31\u4f1a\u4f7f\u4e4b\u63d0\u9ad8\uff0c\u4e14\u81f3\u5c11\u4e3a %s \u70b9\u3002\u8fd9\u4e5f\u4f1a\u63d0\u9ad8\u6bcf\u6b21\u90e8\u7f72\u6240\u635f\u8017\u7684 \u6218\u5907\u503c\u3002", opad, h, "" + CREW_REQ, "1", "" + (int)FIGHTER_OP_PER_DP, "" + MIN_DP);
        if (isForModSpec || ship == null || ship.getMutableStats() == null) {
            return;
        }
        MutableShipStatsAPI stats = ship.getMutableStats();
        boolean crewIncrease = stats.getDynamic().getMod("converted_hangar_no_crew_increase").computeEffective(0.0f) <= 0.0f;
        boolean rearmIncrease = stats.getDynamic().getMod("converted_hangar_no_rearm_increase").computeEffective(0.0f) <= 0.0f;
        boolean dpIncrease = stats.getDynamic().getMod("converted_hangar_no_dp_increase").computeEffective(0.0f) <= 0.0f;
        boolean refitPenalty = stats.getDynamic().getMod("converted_hangar_no_refit_penalty").computeEffective(0.0f) <= 0.0f;
        int dpMod = ConvertedHangar.computeDPModifier(ConvertedHangar.getFighterOPCost(stats));
        if (dpMod > 0) {
            if (dpIncrease) {
                tooltip.addPara("\u90e8\u7f72\u6210\u672c\uff1a %s", opad, h, "+" + dpMod);
            }
            float numW = 160.0f;
            float sizeW = width - numW - 10.0f;
            if (!ConvertedHangar.getFighterWings(stats).isEmpty() && rearmIncrease) {
                tooltip.beginTable(Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), 20.0f, true, true, new Object[]{"\u6218\u673a", Float.valueOf(sizeW), "\u91cd\u65b0\u8d77\u98de\u65f6\u95f4 (\u79d2)", Float.valueOf(numW)});
                for (String wingId : ConvertedHangar.getFighterWings(stats)) {
                    FighterWingSpecAPI spec = Global.getSettings().getFighterWingSpec(wingId);
                    float refitPortion = spec.getRefitTime() * ship.getMutableStats().getDynamic().getValue("fighter_rearm_time_extra_fraction_of_base_refit_time_mod", 0.0f);
                    Color c = Misc.getTextColor();
                    tooltip.addRow(new Object[]{Alignment.MID, c, spec.getWingName(), Alignment.MID, h, Misc.getRoundedValueOneAfterDecimalIfNotWhole(refitPortion)});
                }
                tooltip.addTable("", 0, opad);
            }
        }
        ArrayList<String> negated = new ArrayList<String>();
        if (!refitPenalty) {
            negated.add("\u6218\u673a\u6574\u5907\u65f6\u95f4\u4e0e\u6574\u5907\u7387\u6062\u590d\u56e0\u7d20");
        }
        if (!rearmIncrease) {
            negated.add("\u8865\u5145\u5f39\u836f\u6240\u9700\u7684\u65f6\u95f4");
        }
        if (!crewIncrease) {
            negated.add("\u589e\u52a0\u8239\u5458\u6570\u91cf\u9700\u6c42");
        }
        if (!dpIncrease) {
            negated.add("\u90e8\u7f72\u70b9\u7684\u63d0\u9ad8");
        }
        if (!negated.isEmpty()) {
            Color c = Misc.getPositiveHighlightColor();
            String isOrAre = "\u65b9\u9762\u7684\u8d1f\u9762\u6548\u679c\u5df2";
            if (negated.size() > 1) {
                isOrAre = "\u65b9\u9762\u7684\u8d1f\u9762\u6548\u679c\u5df2";
            }
            if (negated.size() >= 4) {
                isOrAre = String.valueOf(isOrAre) + "\u5747";
            }
            tooltip.addPara("" + Misc.getAndJoined(negated) + " " + isOrAre + "\u88ab\u514d\u9664\u3002", c, opad);
        }
    }

    @Override
    public String getSModDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        if (index == 0) {
            return (int)SMOD_CRUISER + "%";
        }
        if (index == 1) {
            return (int)SMOD_CAPITAL + "%";
        }
        return null;
    }
}

