/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.hullmods.CompromisedStructure;

public class DefectiveManufactory
extends BaseHullMod {
    public static float SPEED_REDUCTION = 0.25f;
    public static float DAMAGE_INCREASE = 0.25f;

    public void applyEffectsToFighterSpawnedByShip(ShipAPI fighter, ShipAPI ship, String id) {
        float effect = ship.getMutableStats().getDynamic().getValue("dmod_effect_mult");
        MutableShipStatsAPI stats = fighter.getMutableStats();
        stats.getMaxSpeed().modifyMult(id, 1.0f - SPEED_REDUCTION * effect);
        stats.getArmorDamageTakenMult().modifyPercent(id, DAMAGE_INCREASE * 100.0f * effect);
        stats.getShieldDamageTakenMult().modifyPercent(id, DAMAGE_INCREASE * 100.0f * effect);
        stats.getHullDamageTakenMult().modifyPercent(id, DAMAGE_INCREASE * 100.0f * effect);
        fighter.setLightDHullOverlay();
    }

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        CompromisedStructure.modifyCost(hullSize, stats, id);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        float effect = 1.0f;
        if (ship != null) {
            effect = ship.getMutableStats().getDynamic().getValue("dmod_effect_mult");
        }
        if (index == 0) {
            return Math.round(SPEED_REDUCTION * 100.0f * effect) + "%";
        }
        if (index == 1) {
            return Math.round(DAMAGE_INCREASE * 100.0f * effect) + "%";
        }
        if (index >= 2) {
            return CompromisedStructure.getCostDescParam(index, 2);
        }
        return null;
    }
}

