/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class DefensiveTargetingArray
extends BaseHullMod {
    public static float PD_DAMAGE_BONUS = 50.0f;
    public static float SMOD_RANGE_BONUS = 100.0f;

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getFighterWingRange().modifyMult(id, 0.0f);
    }

    public void applyEffectsToFighterSpawnedByShip(ShipAPI fighter, ShipAPI ship, String id) {
        fighter.getMutableStats().getDamageToFighters().modifyFlat(id, PD_DAMAGE_BONUS / 100.0f);
        fighter.getMutableStats().getDamageToMissiles().modifyFlat(id, PD_DAMAGE_BONUS / 100.0f);
        boolean sMod = this.isSMod(ship);
        if (sMod) {
            fighter.getMutableStats().getBallisticWeaponRangeBonus().modifyFlat(id, SMOD_RANGE_BONUS);
            fighter.getMutableStats().getEnergyWeaponRangeBonus().modifyFlat(id, SMOD_RANGE_BONUS);
        }
        if (fighter.getWing() != null && fighter.getWing().getSpec() != null && (fighter.getWing().getSpec().isRegularFighter() || fighter.getWing().getSpec().isAssault() || fighter.getWing().getSpec().isBomber() || fighter.getWing().getSpec().isInterceptor())) {
            fighter.addTag("stay_in_front_of_ship");
        }
    }

    public String getSModDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "" + (int)SMOD_RANGE_BONUS;
        }
        return null;
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return (int)PD_DAMAGE_BONUS + "%";
        }
        return null;
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        int bays = (int)ship.getMutableStats().getNumFighterBays().getModifiedValue();
        return ship != null && bays > 0;
    }

    public String getUnapplicableReason(ShipAPI ship) {
        return "\u8230\u8239\u6ca1\u6709\u98de\u884c\u7532\u677f";
    }
}

