/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.WeaponBaseRangeModifier;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class EnergyBoltCoherer
extends BaseHullMod {
    public static float RANGE_BONUS = 200.0f;
    public static float CREWED_RANGE_BONUS = 100.0f;
    public static float CREW_CASUALTIES = 50.0f;

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        if (!Misc.isAutomated(stats)) {
            stats.getCrewLossMult().modifyPercent(id, CREW_CASUALTIES);
        }
    }

    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        ship.addListener(new EnergyBoltCohererRangeModifier());
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        return null;
    }

    public boolean shouldAddDescriptionToTooltip(ShipAPI.HullSize hullSize, ShipAPI ship, boolean isForModSpec) {
        return false;
    }

    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
        float pad = 3.0f;
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        if (!Misc.isAutomated(ship)) {
            tooltip.addPara("\u8d77\u521d\u7531\u901f\u5b50\u79d1\u6280\u8bbe\u8ba1\u7528\u4e8e\u65e0\u4eba\u6218\u8230\uff0c\u56e0\u6b64\u5728\u8f7d\u4eba\u6218\u8230\u4e0a\u8fd0\u4f5c\u65f6\uff0c\u540c\u8c03\u573a\u7684\u5f3a\u5ea6\u5fc5\u987b\u8c03\u4f4e\u3002", opad);
            tooltip.addPara("\u63d0\u9ad8 \u975e\u5149\u675f \u80fd\u91cf\u6b66\u5668\u4e0e\u6df7\u5408\u6b66\u5668\u7684\u57fa\u7840\u5c04\u7a0b %s}\u3002", opad, h, "" + (int)CREWED_RANGE_BONUS);
            tooltip.addPara("\u540c\u8c03\u573a \u5728\u6218\u6597\u73af\u5883\u4e0b\u5e76\u4e0d\u7a33\u5b9a\uff0c\u8239\u4f53\u627f\u53d7\u7684\u5e94\u529b\u53ef\u80fd\u4f1a\u5bfc\u81f4 \u540c\u8c03\u573a \u5c40\u90e8\u5931\u6548\uff0c\u7206\u53d1\u6027\u5730\u6cc4\u9732\u81f4\u547d\u8f90\u5c04\u3002\u6218\u6597\u4e2d\u8239\u5458\u7684\u635f\u5931\u589e\u52a0 %s}\u3002", opad, h, (int)CREW_CASUALTIES + "%");
        } else {
            tooltip.addPara("\u63d0\u9ad8 \u975e\u5149\u675f \u80fd\u91cf\u6b66\u5668\u4e0e\u6df7\u5408\u6b66\u5668\u7684\u57fa\u7840\u5c04\u7a0b %s}\u3002", opad, h, "" + (int)RANGE_BONUS);
        }
        tooltip.addSectionHeading("\u4e0e\u5176\u4ed6\u6548\u679c\u4e4b\u95f4\u7684\u5f71\u54cd", Alignment.MID, opad);
        tooltip.addPara("\u7531\u4e8e\u63d0\u9ad8\u7684\u662f\u57fa\u7840\u5c04\u7a0b\uff0c\u6240\u4ee5\u672c\u589e\u76ca\u5728\u7edd\u5927\u591a\u6570\u5176\u4ed6\u589e\u76ca\u7684\u8ba1\u7b97\u4e4b\u524d\u751f\u6548\uff0c\u53ef\u4ee5\u8fdb\u4e00\u6b65\u53d7\u5230\u5176\u4ed6\u6280\u80fd\u548c\u63d2\u4ef6\u6bd4\u4f8b\u4fee\u6b63\u5f71\u54cd\u3002", opad);
    }

    public static class EnergyBoltCohererRangeModifier
    implements WeaponBaseRangeModifier {
        public float getWeaponBaseRangePercentMod(ShipAPI ship, WeaponAPI weapon) {
            return 0.0f;
        }

        public float getWeaponBaseRangeMultMod(ShipAPI ship, WeaponAPI weapon) {
            return 1.0f;
        }

        public float getWeaponBaseRangeFlatMod(ShipAPI ship, WeaponAPI weapon) {
            if (weapon.isBeam()) {
                return 0.0f;
            }
            if (weapon.getType() == WeaponAPI.WeaponType.ENERGY || weapon.getType() == WeaponAPI.WeaponType.HYBRID) {
                if (Misc.isAutomated(ship)) {
                    return RANGE_BONUS;
                }
                return CREWED_RANGE_BONUS;
            }
            return 0.0f;
        }
    }
}

