/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class ExpandedDeckCrew
extends BaseHullMod {
    public static float RATE_DECREASE_MODIFIER = 15.0f;
    public static float RATE_INCREASE_MODIFIER = 25.0f;
    public static float CREW_PER_DECK = 20.0f;

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getDynamic().getStat("replacement_rate_decrease_mult").modifyMult(id, 1.0f - RATE_DECREASE_MODIFIER / 100.0f);
        stats.getDynamic().getStat("replacement_rate_increase_mult").modifyPercent(id, RATE_INCREASE_MODIFIER);
        int crew = (int)(stats.getNumFighterBays().getBaseValue() * CREW_PER_DECK);
        stats.getMinCrewMod().modifyFlat(id, crew);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return (int)RATE_DECREASE_MODIFIER + "%";
        }
        if (index == 1) {
            return (int)RATE_INCREASE_MODIFIER + "%";
        }
        if (index == 2) {
            return "" + (int)CREW_PER_DECK;
        }
        return null;
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        int baysModified = (int)ship.getMutableStats().getNumFighterBays().getModifiedValue();
        if (baysModified <= 0) {
            return false;
        }
        int bays = (int)ship.getMutableStats().getNumFighterBays().getBaseValue();
        return ship != null && bays > 0;
    }

    public String getUnapplicableReason(ShipAPI ship) {
        return "\u8be5\u8230\u6ca1\u6709\u6807\u51c6\u98de\u884c\u7532\u677f";
    }
}

