/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.DamageDealtModifier;
import com.fs.starfarer.api.combat.listeners.WeaponBaseRangeModifier;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class HighScatterAmp
extends BaseHullMod {
    public static float RANGE_THRESHOLD = 200.0f;
    public static float RANGE_MULT = 0.5f;
    public static float DAMAGE_BONUS_PERCENT = 10.0f;
    public static float SMOD_MODIFIER = 5.0f;

    public boolean isApplicableToShip(ShipAPI ship) {
        return !ship.getVariant().getHullMods().contains("advancedoptics");
    }

    public String getUnapplicableReason(ShipAPI ship) {
        if (ship.getVariant().getHullMods().contains("advancedoptics")) {
            return "\u4e0d\u517c\u5bb9\u4e8e \u5148\u8fdb\u5149\u5b66\u5668\u4ef6";
        }
        return null;
    }

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        boolean sMod = this.isSMod(stats);
        stats.getBeamWeaponDamageMult().modifyPercent(id, DAMAGE_BONUS_PERCENT + (sMod ? SMOD_MODIFIER : 0.0f));
    }

    public String getSModDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        if (index == 0) {
            return Math.round(SMOD_MODIFIER) + "%";
        }
        return null;
    }

    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        ship.addListener(new HighScatterAmpDamageDealtMod(ship));
        ship.addListener(new HighScatterAmpRangeMod());
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        return null;
    }

    public boolean shouldAddDescriptionToTooltip(ShipAPI.HullSize hullSize, ShipAPI ship, boolean isForModSpec) {
        return false;
    }

    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
        float pad = 3.0f;
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        tooltip.addPara("\u5149\u675f\u6b66\u5668\u9020\u6210\u7684\u4f24\u5bb3\u63d0\u9ad8 %s}\uff0c\u8fd8\u53ef\u5bf9\u62a4\u76fe\u9020\u6210\u786c\u5e45\u80fd\u4f24\u5bb3\u3002", opad, h, (int)DAMAGE_BONUS_PERCENT + "%");
        tooltip.addPara("\u5f53\u5149\u675f\u6b66\u5668\u7684\u57fa\u7840\u5c04\u7a0b\u8d85\u8fc7 %s}\uff0c\u5219\u5c06\u8d85\u51fa\u7684\u90a3\u90e8\u5206\u964d\u4f4e %s}\u3002", opad, h, "" + (int)RANGE_THRESHOLD, Math.round((1.0f - RANGE_MULT) * 100.0f) + "%");
        tooltip.addSectionHeading("\u4e0e\u5176\u4ed6\u6548\u679c\u4e4b\u95f4\u7684\u5f71\u54cd", Alignment.MID, opad);
        tooltip.addPara("\u56e0\u4e3a\u964d\u4f4e\u7684\u662f\u57fa\u7840\u5c04\u7a0b\uff0c\u56e0\u6b64\u767e\u5206\u6bd4\u6216\u76f8\u4e58\u7684\u4fee\u6b63 \u2014\u2014 \u4f8b\u5982\u6765\u81ea \u76ee\u6807\u5b9a\u4f4d\u7cfb\u7edf\uff0c\u6280\u80fd\uff0c\u6216\u5176\u4ed6\u7c7b\u4f3c\u7684\u52a0\u6210 \u2014\u2014 \u57fa\u4e8e\u964d\u4f4e\u540e\u7684\u57fa\u7840\u5c04\u7a0b\u6765\u7ed3\u7b97\u3002", opad);
    }

    public static class HighScatterAmpDamageDealtMod
    implements DamageDealtModifier {
        protected ShipAPI ship;

        public HighScatterAmpDamageDealtMod(ShipAPI ship) {
            this.ship = ship;
        }

        public String modifyDamageDealt(Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
            if (!(param instanceof DamagingProjectileAPI) && param instanceof BeamAPI) {
                damage.setForceHardFlux(true);
            }
            return null;
        }
    }

    public static class HighScatterAmpRangeMod
    implements WeaponBaseRangeModifier {
        public float getWeaponBaseRangePercentMod(ShipAPI ship, WeaponAPI weapon) {
            return 0.0f;
        }

        public float getWeaponBaseRangeMultMod(ShipAPI ship, WeaponAPI weapon) {
            return 1.0f;
        }

        public float getWeaponBaseRangeFlatMod(ShipAPI ship, WeaponAPI weapon) {
            if (weapon.isBeam()) {
                float range = weapon.getSpec().getMaxRange();
                if (range < RANGE_THRESHOLD) {
                    return 0.0f;
                }
                float past = range - RANGE_THRESHOLD;
                float penalty = past * (1.0f - RANGE_MULT);
                return -penalty;
            }
            return 0.0f;
        }
    }
}

