/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.loading.WeaponSlotAPI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;

public class MissileAutoloader
extends BaseHullMod {
    public static List<ReloadCapacityData> CAPACITY_DATA = new ArrayList<ReloadCapacityData>();
    public static float BASIC_COOLDOWN;
    public static float SMOD_COOLDOWN;
    public static String MA_DATA_KEY;

    static {
        CAPACITY_DATA.add(new ReloadCapacityData(ShipAPI.HullSize.FRIGATE, 1, 1, 6));
        CAPACITY_DATA.add(new ReloadCapacityData(ShipAPI.HullSize.FRIGATE, 2, -1, 4));
        CAPACITY_DATA.add(new ReloadCapacityData(ShipAPI.HullSize.DESTROYER, 1, 1, 9));
        CAPACITY_DATA.add(new ReloadCapacityData(ShipAPI.HullSize.DESTROYER, 2, -1, 4));
        CAPACITY_DATA.add(new ReloadCapacityData(ShipAPI.HullSize.CRUISER, 1, 2, 15));
        CAPACITY_DATA.add(new ReloadCapacityData(ShipAPI.HullSize.CRUISER, 3, 3, 12));
        CAPACITY_DATA.add(new ReloadCapacityData(ShipAPI.HullSize.CRUISER, 4, -1, 8));
        CAPACITY_DATA.add(new ReloadCapacityData(ShipAPI.HullSize.CAPITAL_SHIP, 1, 3, 24));
        CAPACITY_DATA.add(new ReloadCapacityData(ShipAPI.HullSize.CAPITAL_SHIP, 4, 6, 18));
        CAPACITY_DATA.add(new ReloadCapacityData(ShipAPI.HullSize.CAPITAL_SHIP, 7, -1, 10));
        BASIC_COOLDOWN = 5.0f;
        SMOD_COOLDOWN = 10.0f;
        MA_DATA_KEY = "core_missile_autoloader_data_key";
    }

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
    }

    public void advanceInCombat(ShipAPI ship, float amount) {
        super.advanceInCombat(ship, amount);
        if (!ship.isAlive()) {
            return;
        }
        String key = MA_DATA_KEY;
        ship.getCustomData().get(key);
        MissileAutoloaderData data = (MissileAutoloaderData)ship.getCustomData().get(key);
        if (data == null) {
            data = new MissileAutoloaderData();
            ReloadCapacityData cap = MissileAutoloader.getCapacityData(ship);
            if (cap != null) {
                data.opLeft = cap.capacity;
            } else {
                data.showExhaustedStatus = 0.0f;
            }
            ship.setCustomData(key, data);
        }
        if (data.opLeft <= 0.05f) {
            data.opLeft = 0.0f;
            data.showExhaustedStatus -= amount;
            if (data.showExhaustedStatus <= 0.0f) {
                return;
            }
        }
        boolean playerShip = Global.getCurrentState() == GameState.COMBAT && Global.getCombatEngine() != null && Global.getCombatEngine().getPlayerShip() == ship;
        float mult = ship.getMutableStats().getMissileRoFMult().getModifiedValue();
        data.cooldown.advance(amount * mult);
        for (WeaponAPI w : data.cooldown.getItems()) {
            w.setRemainingCooldownTo(w.getCooldown());
        }
        data.interval.advance(amount);
        if (data.interval.intervalElapsed()) {
            boolean playSound = false;
            for (WeaponAPI w : ship.getAllWeapons()) {
                if (!MissileAutoloader.isAffected(w) || data.cooldown.contains(w) || !w.usesAmmo() || w.getAmmo() > 0) continue;
                float reloadSize = w.getSpec().getMaxAmmo();
                float reloadCost = MissileAutoloader.getReloadCost(w, ship);
                float salvoSize = w.getSpec().getBurstSize();
                if (salvoSize < 1.0f) {
                    salvoSize = 1.0f;
                }
                if (reloadCost > data.opLeft) {
                    float f = data.opLeft / reloadCost;
                    if (f <= 0.0f) continue;
                    reloadSize *= f;
                    reloadSize /= salvoSize;
                    reloadSize = (float)Math.ceil(reloadSize);
                    reloadSize *= salvoSize;
                    reloadSize = Math.round(reloadSize);
                }
                playSound = true;
                w.setAmmo((int)reloadSize);
                boolean sMod = this.isSMod(ship);
                if (sMod) {
                    if (SMOD_COOLDOWN > 0.0f) {
                        data.cooldown.set(w, SMOD_COOLDOWN);
                    }
                } else if (BASIC_COOLDOWN > 0.0f) {
                    data.cooldown.set(w, BASIC_COOLDOWN);
                }
                data.opLeft -= reloadCost;
                if (data.opLeft < 0.0f) {
                    data.opLeft = 0.0f;
                }
                if (data.opLeft <= 0.0f) break;
            }
            playSound = false;
            if (playerShip && playSound) {
                Global.getSoundPlayer().playSound("missile_weapon_reloaded", 1.0f, 1.0f, ship.getLocation(), ship.getVelocity());
            }
        }
        if (playerShip) {
            String status = Misc.getRoundedValueOneAfterDecimalIfNotWhole(data.opLeft) + " \u5269\u4f59\u5bb9\u91cf";
            if (data.opLeft <= 0.0f) {
                status = "\u5bb9\u91cf\u8017\u5c3d";
            }
            Global.getCombatEngine().maintainStatusForPlayerShip(data, Global.getSettings().getSpriteName("ui", "icon_tactical_missile_autoloader"), this.spec.getDisplayName(), status, data.opLeft <= 0.0f);
        }
    }

    public static ReloadCapacityData getCapacityData(ShipAPI ship) {
        if (ship == null) {
            return null;
        }
        int count = 0;
        for (WeaponSlotAPI slot : ship.getHullSpec().getAllWeaponSlotsCopy()) {
            if (slot.getSlotSize() != WeaponAPI.WeaponSize.SMALL || slot.getWeaponType() != WeaponAPI.WeaponType.MISSILE) continue;
            ++count;
        }
        for (ReloadCapacityData data : CAPACITY_DATA) {
            if (data.size != ship.getHullSize()) continue;
            if (count >= data.minW && count <= data.maxW) {
                return data;
            }
            if (count < data.minW || data.maxW >= 0) continue;
            return data;
        }
        return null;
    }

    public static boolean isAffected(WeaponAPI w) {
        if (w == null) {
            return false;
        }
        if (w.getType() != WeaponAPI.WeaponType.MISSILE) {
            return false;
        }
        if (w.getSize() != WeaponAPI.WeaponSize.SMALL) {
            return false;
        }
        if (w.getSlot().getWeaponType() != WeaponAPI.WeaponType.MISSILE) {
            return false;
        }
        if (w.getSlot().getSlotSize() != WeaponAPI.WeaponSize.SMALL) {
            return false;
        }
        if (w.getSpec().hasTag("no_reload")) {
            return false;
        }
        if (!w.usesAmmo() || w.getAmmoPerSecond() > 0.0f) {
            return false;
        }
        if (w.isDecorative()) {
            return false;
        }
        return w.getSlot() == null || !w.getSlot().isSystemSlot();
    }

    public static float getReloadCost(WeaponAPI w, ShipAPI ship) {
        if (w.getSpec().hasTag("reload_1pt")) {
            return 1.0f;
        }
        if (w.getSpec().hasTag("reload_1_and_a_half_pt")) {
            return 1.5f;
        }
        if (w.getSpec().hasTag("reload_2pt")) {
            return 2.0f;
        }
        if (w.getSpec().hasTag("reload_3pt")) {
            return 3.0f;
        }
        if (w.getSpec().hasTag("reload_4pt")) {
            return 4.0f;
        }
        if (w.getSpec().hasTag("reload_5pt")) {
            return 5.0f;
        }
        if (w.getSpec().hasTag("reload_6pt")) {
            return 6.0f;
        }
        int op = Math.round(w.getSpec().getOrdnancePointCost(null, null));
        if (op == 1) {
            return 1.0f;
        }
        if (op == 2 || op == 3) {
            return 2.0f;
        }
        if (op == 4) {
            return 3.0f;
        }
        if (op == 5 || op == 6) {
            return 4.0f;
        }
        if (op == 7 || op == 8) {
            return 6.0f;
        }
        return 6.0f;
    }

    public boolean shouldAddDescriptionToTooltip(ShipAPI.HullSize hullSize, ShipAPI ship, boolean isForModSpec) {
        return false;
    }

    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, final ShipAPI ship, float width, boolean isForModSpec) {
        float pad = 3.0f;
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        tooltip.addPara("\u4e00\u4e2a\u519b\u7528\u81ea\u52a8\u88c5\u586b\u5668\uff0c\u5177\u5907\u6709\u9650\u7684 \"\u88c5\u586b\u5bb9\u91cf\"\uff0c\u53ef\u4ee5\u4e3a\u5c0f\u578b\u5bfc\u5f39\u69fd\u4f4d\u5185\u7684\u5bfc\u5f39\u6b66\u5668\u6062\u590d\u5907\u5f39\u91cf\u3002", opad, h, "\u5b89\u88c5\u5728\u5c0f\u578b\u5bfc\u5f39\u69fd\u4f4d\u4e0a\u7684\u5bfc\u5f39\u6b66\u5668");
        tooltip.addPara("\u4e0d\u5f71\u54cd\u65e0\u9650\u5907\u5f39\u91cf\u6216\u4f1a\u81ea\u884c\u6062\u590d\u5907\u5f39\u91cf\u7684\u6b66\u5668\uff0c\u4e5f\u4e0d\u5f71\u54cd\u5b89\u88c5\u5728\u5176\u4ed6\u7c7b\u578b\u69fd\u4f4d\u4e0a\u7684\u6b66\u5668\u3002\u91cd\u88c5\u6570\u91cf\u7b49\u4e8e\u57fa\u7840\u5907\u5f39\u91cf\u4e0a\u9650\uff0c\u4e0d\u53d7\u5230\u589e\u52a0\u5bfc\u5f39\u5907\u5f39\u91cf\u7684\u6280\u80fd\u6216\u8230\u8239\u63d2\u4ef6\u7684\u5f71\u54cd\u3002", opad);
        tooltip.addSectionHeading("\u88c5\u586b\u5bb9\u91cf", Alignment.MID, opad);
        tooltip.addPara("\u53d6\u51b3\u4e8e\u8230\u8239\u5927\u5c0f\u548c\u5c0f\u578b\u5bfc\u5f39\u69fd\u4f4d\u7684\u6570\u91cf\uff0c\u65e0\u8bba\u8fd9\u4e9b\u69fd\u4f4d\u662f\u5426\u771f\u7684\u88c5\u4e86\u6b66\u5668\u3002\u69fd\u4f4d\u8d8a\u5c11\uff0c\u88c5\u586b\u8d8a\u5bb9\u6613\uff0c\u56e0\u6b64\u53ef\u4ee5\u88c5\u586b\u66f4\u591a\u6b21\u3002", opad);
        if (isForModSpec || ship == null) {
            return;
        }
        tooltip.setBgAlpha(0.9f);
        ArrayList<WeaponAPI> weapons = new ArrayList<WeaponAPI>();
        LinkedHashSet<String> seen = new LinkedHashSet<String>();
        for (WeaponAPI w : ship.getAllWeapons()) {
            String id;
            if (!MissileAutoloader.isAffected(w) || seen.contains(id = w.getId())) continue;
            seen.add(id);
            weapons.add(w);
        }
        float numW = 130.0f;
        float reloadW = 130.0f;
        float sizeW = width - numW - reloadW - 10.0f;
        tooltip.beginTable(Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), 20.0f, true, true, new Object[]{"\u8230\u8239\u5927\u5c0f", Float.valueOf(sizeW), "\u5c0f\u578b\u5bfc\u5f39\u69fd\u4f4d", Float.valueOf(numW), "\u88c5\u586b\u5bb9\u91cf", Float.valueOf(reloadW)});
        ReloadCapacityData cap = MissileAutoloader.getCapacityData(ship);
        ArrayList<ReloadCapacityData> sortedCap = new ArrayList<ReloadCapacityData>(CAPACITY_DATA);
        Collections.sort(sortedCap, new Comparator<ReloadCapacityData>(){

            @Override
            public int compare(ReloadCapacityData o1, ReloadCapacityData o2) {
                if (o1.size != o2.size) {
                    return (int)Math.signum(o1.size.ordinal() - o2.size.ordinal());
                }
                return (int)Math.signum(o1.capacity - o2.capacity);
            }
        });
        ShipAPI.HullSize prev = ShipAPI.HullSize.FRIGATE;
        for (ReloadCapacityData curr : sortedCap) {
            Color c = Misc.getGrayColor();
            if (cap == curr) {
                c = Misc.getHighlightColor();
            }
            if (curr.size != hullSize) continue;
            tooltip.addRow(new Object[]{Alignment.MID, c, curr.getSizeStr(), Alignment.MID, c, curr.getWeaponsString(), Alignment.MID, c, "" + curr.capacity});
            prev = curr.size;
        }
        tooltip.addTable("", 0, opad);
        Collections.sort(weapons, new Comparator<WeaponAPI>(){

            @Override
            public int compare(WeaponAPI o1, WeaponAPI o2) {
                float c1 = MissileAutoloader.getReloadCost(o1, ship);
                float c2 = MissileAutoloader.getReloadCost(o2, ship);
                return (int)Math.signum(c1 - c2);
            }
        });
        tooltip.addSectionHeading("\u5bb9\u91cf\u6d88\u8017 (\u6bcf\u8f6e\u6062\u590d)", Alignment.MID, opad + 5.0f);
        float costW = 100.0f;
        float nameW = width - costW - 5.0f;
        tooltip.beginTable(Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), 20.0f, true, true, new Object[]{"\u53d7\u5f71\u54cd\u7684\u6b66\u5668", Float.valueOf(nameW), "\u5bb9\u91cf\u6d88\u8017 (\u6bcf\u8f6e\u6062\u590d)", Float.valueOf(costW)});
        int max = 10;
        int count = 0;
        for (WeaponAPI w : weapons) {
            float cost = MissileAutoloader.getReloadCost(w, ship);
            String name = tooltip.shortenString(w.getDisplayName(), nameW - 20.0f);
            tooltip.addRow(new Object[]{Alignment.LMID, Misc.getTextColor(), name, Alignment.MID, h, Misc.getRoundedValueOneAfterDecimalIfNotWhole(cost)});
            if (++count >= max) break;
        }
        tooltip.addTable("\u6ca1\u6709\u5b89\u88c5\u53ef\u88ab\u5f71\u54cd\u7684\u6b66\u5668", weapons.size() - max, opad);
        tooltip.addPara("\u5269\u4f59\u88c5\u586b\u5bb9\u91cf\u7528\u5c3d\u65f6\u4ecd\u53ef\u90e8\u5206\u5730\u8865\u5145\u5907\u5f39\u91cf\u3002", opad);
        if (BASIC_COOLDOWN > 0.0f) {
            tooltip.addPara("\u91cd\u65b0\u88c5\u586b\u540e\uff0c\u6b66\u5668\u9700\u8981\u989d\u5916\u51b7\u5374 %s \u79d2\u624d\u80fd\u518d\u6b21\u53d1\u5c04\uff0c\u8be5\u65f6\u95f4\u548c\u6b66\u5668\u672c\u8eab\u7684\u51b7\u5374\u65f6\u95f4\u53e0\u52a0\u3002", opad, h, "" + (int)BASIC_COOLDOWN);
        }
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        return MissileAutoloader.getCapacityData(ship) != null;
    }

    public String getUnapplicableReason(ShipAPI ship) {
        return "\u8230\u8239\u6ca1\u6709\u4efb\u4f55\u5c0f\u578b\u5bfc\u5f39\u69fd\u4f4d";
    }

    public boolean isSModEffectAPenalty() {
        return true;
    }

    public String getSModDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        if (index == 0) {
            return "" + (int)SMOD_COOLDOWN;
        }
        return null;
    }

    public static class MissileAutoloaderData {
        public IntervalUtil interval = new IntervalUtil(0.2f, 0.4f);
        public float opLeft = 0.0f;
        public float showExhaustedStatus = 5.0f;
        public TimeoutTracker<WeaponAPI> cooldown = new TimeoutTracker();
    }

    public static class ReloadCapacityData {
        public ShipAPI.HullSize size;
        public int minW;
        public int maxW;
        public int capacity;

        public ReloadCapacityData(ShipAPI.HullSize size, int minW, int maxW, int capacity) {
            this.size = size;
            this.minW = minW;
            this.maxW = maxW;
            this.capacity = capacity;
        }

        public String getSizeStr() {
            return Misc.getHullSizeStr(this.size);
        }

        public String getWeaponsString() {
            if (this.maxW < 0) {
                return this.minW + "+";
            }
            if (this.minW != this.maxW) {
                return this.minW + "-" + this.maxW;
            }
            return "" + this.minW;
        }
    }
}

