/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.impl.campaign.skills.NeuralLinkScript;
import com.fs.starfarer.api.impl.campaign.skills.SupportDoctrine;
import com.fs.starfarer.api.impl.hullmods.NeuralIntegrator;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class NeuralInterface
extends BaseHullMod {
    public static float SYSTEM_RESET_TIMEOUT_MULT = 2.0f;
    public static final String SYSTEM_RESET_TIMEOUT_KEY = "neural_interface_reset_timeout";

    public void advanceInCombat(ShipAPI ship, float amount) {
        String key = SYSTEM_RESET_TIMEOUT_KEY;
        Float timeout = (Float)ship.getCustomData().get(key);
        if (timeout == null) {
            timeout = Float.valueOf(0.0f);
        }
        if ((timeout = Float.valueOf(timeout.floatValue() - amount)).floatValue() < 0.0f) {
            timeout = Float.valueOf(0.0f);
        }
        ship.setCustomData(key, timeout);
        if (ship == Global.getCombatEngine().getPlayerShip()) {
            if (ship.getCustomData().containsKey("neural_transfer_complete_key")) {
                ShipSystemAPI system = ship.getSystem();
                if (system != null && timeout.floatValue() <= 0.0f) {
                    boolean didSomething = false;
                    float maxTimeout = 0.0f;
                    if (system.getCooldownRemaining() > 0.0f && system.isCoolingDown()) {
                        maxTimeout = Math.max(system.getCooldownRemaining(), maxTimeout);
                        system.setCooldownRemaining(0.0f);
                        didSomething = true;
                    }
                    if (system.getAmmo() < system.getMaxAmmo() && system.getAmmoPerSecond() > 0.0f) {
                        system.setAmmo(system.getAmmo() + 1);
                        didSomething = true;
                        maxTimeout = Math.max(1.0f / system.getAmmoPerSecond() * (1.0f - system.getAmmoReloadProgress()), maxTimeout);
                    }
                    if (maxTimeout > 0.0f) {
                        ship.setCustomData(key, Float.valueOf(maxTimeout *= SYSTEM_RESET_TIMEOUT_MULT));
                    }
                }
                ship.removeCustomData("neural_transfer_complete_key");
            }
        } else {
            ship.removeCustomData("neural_transfer_complete_key");
        }
    }

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getDynamic().getMod("has_neural_link").modifyFlat(id, 1.0f);
        stats.getDynamic().getMod("deployment_points_mod").unmodify(SupportDoctrine.SUPPORT_DOCTRINE_DP_REDUCTION_ID);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (this instanceof NeuralIntegrator) {
            if (index == 0) {
                return "\u53d7\u5230\u4f60\u7684\u6218\u6597\u6280\u80fd\u6548\u679c\u5f71\u54cd";
            }
            if (index == 1) {
                return "" + (int)NeuralLinkScript.INSTANT_TRANSFER_DP;
            }
            if (index == 2) {
                return (int)NeuralIntegrator.DP_INCREASE_PERCENT + "%";
            }
        }
        if (index == 0) {
            return "\u53d7\u5230\u4f60\u7684\u6218\u6597\u6280\u80fd\u6548\u679c\u5f71\u54cd";
        }
        if (index == 1) {
            return "" + (int)NeuralLinkScript.INSTANT_TRANSFER_DP;
        }
        return null;
    }

    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
        float pad = 3.0f;
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        Color g = Misc.getGrayColor();
        tooltip.addSectionHeading("\u6218\u672f\u7cfb\u7edf\u91cd\u7f6e", Alignment.MID, opad);
        tooltip.addPara("\u8f6c\u6362\u5b8c\u6bd5\u540e\uff0c\u76ee\u6807\u8230\u8239\u7684\u6218\u672f\u7cfb\u7edf\u51b7\u5374\u65f6\u95f4\u4f1a\u88ab\u91cd\u7f6e\u3002\u5982\u679c\u6218\u672f\u7cfb\u7edf\u6709\u5145\u80fd\u6b21\u6570\uff0c\u5219\u7acb\u523b\u56de\u590d\u4e00\u6b21\u3002\u6b64\u6548\u679c\u7684\u51b7\u5374\u65f6\u95f4\u53d6\u51b3\u4e8e \u8be5\u6280\u80fd\u5f97\u4ee5\u8282\u7ea6\u7684\u51b7\u5374\u6216\u5145\u80fd\u65f6\u95f4\u7684 %s}\u3002", opad, h, (int)SYSTEM_RESET_TIMEOUT_MULT + "\u500d");
        if (Global.getCurrentState() == GameState.CAMPAIGN && Global.getSector().getPlayerStats().getDynamic().getMod("has_neural_link").computeEffective(0.0f) <= 0.0f) {
            tooltip.addPara("\u9700\u8981 \u795e\u7ecf\u94fe\u63a5 \u6280\u80fd\u624d\u80fd\u53d1\u6325\u4f5c\u7528", Misc.getNegativeHighlightColor(), opad);
        }
        if (isForModSpec || ship == null) {
            return;
        }
        String control = Global.getSettings().getControlStringForEnumName(NeuralLinkScript.TRANSFER_CONTROL);
        String desc = Global.getSettings().getControlDescriptionForEnumName(NeuralLinkScript.TRANSFER_CONTROL);
        tooltip.addPara("\u5982\u9700 \"" + desc + "\" \u5219\u6309 [" + control + "] \u952e \u5373\u53ef\u5728\u4e0d\u540c\u8230\u8239\u4e4b\u95f4\u8fdb\u884c\u5207\u6362\u3002", opad, g, h, control);
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        if (Misc.isAutomated(ship)) {
            return false;
        }
        return !ship.getHullSpec().getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.NO_NEURAL_LINK);
    }

    public String getUnapplicableReason(ShipAPI ship) {
        if (Misc.isAutomated(ship)) {
            return "\u4e0d\u80fd\u5b89\u88c5\u5728\u81ea\u52a8\u5316\u8230\u8239\u4e0a\uff0c\u9700\u6539\u4e3a\u5b89\u88c5 \u795e\u7ecf\u96c6\u6210\u5668";
        }
        if (ship.getHullSpec().getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.NO_NEURAL_LINK)) {
            return "\u8be5\u8230\u65e0\u6cd5\u5b89\u88c5";
        }
        return null;
    }
}

