/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.HullModFleetEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;

public class PhaseField
extends BaseHullMod
implements HullModFleetEffect {
    public static float MIN_CR = 0.1f;
    public static String MOD_KEY = "core_PhaseField";
    public static float PROFILE_MULT = 0.5f;
    public static float MIN_FIELD_MULT = 0.25f;

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getSensorProfile().modifyMult(id, PROFILE_MULT);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return (int)((1.0f - PROFILE_MULT) * 100.0f) + "%";
        }
        return null;
    }

    public void advanceInCampaign(CampaignFleetAPI fleet) {
        String key = "$updatedPhaseFieldModifier";
        if (fleet.isPlayerFleet() && fleet.getMemoryWithoutUpdate() != null && !fleet.getMemoryWithoutUpdate().getBoolean(key) && fleet.getMemoryWithoutUpdate().getBoolean("$justToggledTransponder")) {
            this.onFleetSync(fleet);
            fleet.getMemoryWithoutUpdate().set(key, true, 0.1f);
        }
    }

    public boolean withAdvanceInCampaign() {
        return true;
    }

    public boolean withOnFleetSync() {
        return true;
    }

    public void onFleetSync(CampaignFleetAPI fleet) {
        float mult = PhaseField.getPhaseFieldMultBaseProfileAndTotal(fleet, null, 0.0f, 0.0f)[0];
        if (fleet.isTransponderOn()) {
            mult = 1.0f;
        }
        if (mult <= 0.0f) {
            fleet.getDetectedRangeMod().unmodifyMult(MOD_KEY);
        } else {
            fleet.getDetectedRangeMod().modifyMult(MOD_KEY, mult, "\u76f8\u4f4d\u529b\u573a");
        }
    }

    public boolean shouldAddDescriptionToTooltip(ShipAPI.HullSize hullSize, ShipAPI ship, boolean isForModSpec) {
        return true;
    }

    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
        float pad = 3.0f;
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        int numProfileShips = Global.getSettings().getInt("maxSensorShips");
        tooltip.addPara("\u9664\u6b64\u4e4b\u5916\uff0c\u8230\u961f\u7684\u4f20\u611f\u5668\u622a\u9762\u5c06\u6309\u6bd4\u4f8b\u88ab\u51cf\u5c11\u3002\u8be5\u51cf\u6210\u57fa\u4e8e\u8230\u961f\u4e2d\u4f20\u611f\u5668\u622a\u9762\u6700\u9ad8\u7684 %s \u8230\u8239\u7684\u603b\u548c\uff0c\u4ee5\u53ca\u4f20\u611f\u5668\u63a2\u6d4b\u5f3a\u5ea6\u6700\u9ad8\u7684 %s \u76f8\u4f4d\u8230\u8239\u7684\u603b\u548c\u3002\u6b64\u6548\u679c\u53ea\u6709\u5728\u8230\u961f\u5173\u95ed \u5e94\u7b54\u5668 \u65f6\u65b9\u80fd\u751f\u6548\u3002", opad, h, "" + numProfileShips, "" + numProfileShips);
        tooltip.addPara("\u63d0\u9ad8\u5168\u8230\u961f\u4f20\u611f\u5668\u63a2\u6d4b\u5f3a\u5ea6\u7684\u589e\u76ca (\u4f8b\u5982 \u9ad8\u7cbe\u5ea6\u4f20\u611f\u5668)\uff0c\u5c06\u4e0d\u7eb3\u5165\u8ba1\u7b97\u4e2d\u3002", opad);
        if (isForModSpec || ship == null) {
            return;
        }
        if (Global.getSettings().getCurrentState() == GameState.TITLE) {
            return;
        }
        CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        float[] data = PhaseField.getPhaseFieldMultBaseProfileAndTotal(fleet, null, 0.0f, 0.0f);
        float[] dataWithOneMore = PhaseField.getPhaseFieldMultBaseProfileAndTotal(fleet, null, ship.getMutableStats().getSensorProfile().getModifiedValue(), ship.getMutableStats().getSensorStrength().getModifiedValue());
        float[] dataWithOneLess = PhaseField.getPhaseFieldMultBaseProfileAndTotal(fleet, ship.getFleetMemberId(), 0.0f, 0.0f);
        float mult = data[0];
        float profile = data[1];
        float sensors = data[2];
        tooltip.addPara("\u8230\u961f\u4e2d\u4f20\u611f\u5668\u622a\u9762\u524d %s \u7684\u603b\u548c\u4e3a %s}\uff0c\u800c\u76f8\u4f4d\u8230\u4e2d\u4f20\u611f\u5668\u63a2\u6d4b\u5f3a\u5ea6\u524d %s \u7684\u603b\u548c\u4e3a %s}\u3002", opad, h, "" + numProfileShips, "" + Math.round(profile), "" + numProfileShips, "" + Math.round(sensors));
        tooltip.addPara("\u60f3\u8ba9\u8230\u961f\u83b7\u5f97\u4fa6\u6d4b\u8303\u56f4 %s \u7684\u589e\u76ca\u5c31\u5fc5\u987b \u5173\u95ed\u5e94\u7b54\u5668\u3002", opad, h, "\u00d7" + Misc.getRoundedValueFloat(mult), "\u5173\u95ed\u5e94\u7b54\u5668");
        float cr = ship.getCurrentCR();
        for (FleetMemberAPI member : Global.getSector().getPlayerFleet().getFleetData().getMembersListCopy()) {
            if (!member.getId().equals(ship.getFleetMemberId())) continue;
            cr = member.getRepairTracker().getCR();
        }
        if (cr < MIN_CR) {
            LabelAPI label = tooltip.addPara("\u5f53\u8be5\u8230\u6218\u5907\u503c\u4f4e\u4e8e (CR) %s \u65f6\uff0c\u5c06\u65e0\u6cd5\u83b7\u5f97\u8be5\u589e\u76ca\u3002\u5f53\u8be5\u8230\u7684\u6218\u5907\u5145\u8db3\u65f6\uff0c\u5c06\u83b7\u5f97 %s \u7684\u589e\u76ca\u3002", opad, h, Math.round(MIN_CR * 100.0f) + "%", "\u00d7" + Misc.getRoundedValueFloat(dataWithOneMore[0]));
            label.setHighlightColors(bad, h);
            label.setHighlight(Math.round(MIN_CR * 100.0f) + "%", "\u00d7" + Misc.getRoundedValueFloat(dataWithOneMore[0]));
        } else {
            tooltip.addPara("\u79fb\u9664\u8be5\u8230\u4f1a\u4f7f\u589e\u76ca\u53d8\u4e3a %s}\u3002\u6dfb\u52a0\u540c\u7c7b\u8230\u8239\u5219\u53d8\u4e3a %s}\u3002", opad, h, "\u00d7" + Misc.getRoundedValueFloat(dataWithOneLess[0]), "\u00d7" + Misc.getRoundedValueFloat(dataWithOneMore[0]));
        }
    }

    public static float[] getPhaseFieldMultBaseProfileAndTotal(CampaignFleetAPI fleet, String skipId, float addProfile, float addSensor) {
        float totalPhaseSensors;
        float total;
        int numProfileShips;
        ArrayList<FleetMemberAPI> members = new ArrayList<FleetMemberAPI>();
        ArrayList<FleetMemberAPI> phase = new ArrayList<FleetMemberAPI>();
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            if (member.getId().equals(skipId)) continue;
            members.add(member);
            if (member.isMothballed() || member.getRepairTracker().getCR() < MIN_CR || !member.getVariant().hasHullMod("phasefield")) continue;
            phase.add(member);
        }
        float[] profiles = new float[members.size()];
        profiles = addProfile <= 0.0f ? new float[members.size()] : new float[members.size() + 1];
        float[] phaseSensors = addSensor <= 0.0f ? new float[phase.size()] : new float[phase.size() + 1];
        int i = 0;
        for (FleetMemberAPI member : members) {
            profiles[i] = member.getStats().getSensorProfile().getModifiedValue();
            ++i;
        }
        if (addProfile > 0.0f) {
            profiles[i] = addProfile;
        }
        i = 0;
        for (FleetMemberAPI member : phase) {
            phaseSensors[i] = member.getStats().getSensorStrength().getModifiedValue();
            ++i;
        }
        if (addSensor > 0.0f) {
            phaseSensors[i] = addSensor;
        }
        int numPhaseShips = numProfileShips = Global.getSettings().getInt("maxSensorShips");
        float totalProfile = PhaseField.getTopKValuesSum(profiles, numProfileShips);
        float mult = totalProfile / (total = Math.max(totalProfile + (totalPhaseSensors = PhaseField.getTopKValuesSum(phaseSensors, numPhaseShips)), 1.0f));
        if (mult < MIN_FIELD_MULT) {
            mult = MIN_FIELD_MULT;
        }
        if (mult > 1.0f) {
            mult = 1.0f;
        }
        return new float[]{mult, totalProfile, totalPhaseSensors};
    }

    public static float getTopKValuesSum(float[] arr, int k) {
        k = Math.min(k, arr.length);
        float kVal = Misc.findKth(arr, arr.length - k);
        float total = 0.0f;
        int found = 0;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] > kVal) {
                ++found;
                total += arr[i];
            }
            ++i;
        }
        if (k > found) {
            total += (float)(k - found) * kVal;
        }
        return total;
    }
}

