/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.loading;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.impl.campaign.intel.bar.PortsideBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.loading.PersonMissionSpec;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarEventSpec {
    protected String id;
    protected Set<String> tags = new HashSet<String>();
    protected float freq;
    protected float prob;
    protected float minDur;
    protected float maxDur;
    protected float minTimeout;
    protected float maxTimeout;
    protected float minAcceptedTimeout;
    protected float maxAcceptedTimeout;
    protected String pluginClass;

    public BarEventSpec(JSONObject row) throws JSONException {
        this.id = row.getString("bar event id");
        this.freq = (float)row.optDouble("freq", 10.0);
        this.prob = (float)row.optDouble("prob", 1.0);
        this.minDur = (float)row.optDouble("min dur", 30.0);
        this.maxDur = (float)row.optDouble("max dur", 40.0);
        this.minTimeout = (float)row.optDouble("min timeout", 30.0);
        this.maxTimeout = (float)row.optDouble("max timeout", 40.0);
        this.minAcceptedTimeout = (float)row.optDouble("min accepted timeout", 60.0);
        this.maxAcceptedTimeout = (float)row.optDouble("max accepted timeout", 90.0);
        this.pluginClass = row.getString("plugin");
        String tagsStr = row.optString("tags", null);
        if (tagsStr != null) {
            String[] split;
            String[] stringArray = split = tagsStr.split(",");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (!(tag = tag.trim()).isEmpty()) {
                    this.tags.add(tag);
                }
                ++n2;
            }
        }
    }

    public boolean isMission() {
        return Global.getSettings().getInstanceOfScript(this.pluginClass) instanceof HubMissionWithBarEvent;
    }

    public HubMissionWithBarEvent createMission() {
        HubMissionWithBarEvent mission = (HubMissionWithBarEvent)Global.getSettings().getInstanceOfScript(this.pluginClass);
        PersonMissionSpec spec = Global.getSettings().getMissionSpec(this.id);
        if (spec != null && spec.getIcon() != null) {
            mission.setIconName(spec.getIcon());
        }
        mission.setMissionId(this.id);
        return mission;
    }

    public PortsideBarEvent createEvent() {
        PortsideBarEvent event = (PortsideBarEvent)Global.getSettings().getInstanceOfScript(this.pluginClass);
        return event;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public float getFreq() {
        return this.freq;
    }

    public void setFreq(float freq) {
        this.freq = freq;
    }

    public float getProb() {
        return this.prob;
    }

    public void setProb(float prob) {
        this.prob = prob;
    }

    public float getMinDur() {
        return this.minDur;
    }

    public void setMinDur(float minDur) {
        this.minDur = minDur;
    }

    public float getMaxDur() {
        return this.maxDur;
    }

    public void setMaxDur(float maxDur) {
        this.maxDur = maxDur;
    }

    public float getMinTimeout() {
        return this.minTimeout;
    }

    public void setMinTimeout(float minTimeout) {
        this.minTimeout = minTimeout;
    }

    public float getMaxTimeout() {
        return this.maxTimeout;
    }

    public void setMaxTimeout(float maxTimeout) {
        this.maxTimeout = maxTimeout;
    }

    public float getMinAcceptedTimeout() {
        return this.minAcceptedTimeout;
    }

    public void setMinAcceptedTimeout(float minAcceptedTimeout) {
        this.minAcceptedTimeout = minAcceptedTimeout;
    }

    public float getMaxAcceptedTimeout() {
        return this.maxAcceptedTimeout;
    }

    public void setMaxAcceptedTimeout(float maxAcceptedTimeout) {
        this.maxAcceptedTimeout = maxAcceptedTimeout;
    }

    public String getPluginClass() {
        return this.pluginClass;
    }

    public void setPluginClass(String pluginClass) {
        this.pluginClass = pluginClass;
    }
}

