/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.plugins.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.OfficerDataAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.DModManager;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflater;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialMissionIntel;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.loading.VariantSource;
import com.fs.starfarer.api.loading.WeaponGroupSpec;
import com.fs.starfarer.api.loading.WeaponSlotAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.plugins.AutofitPlugin;
import com.fs.starfarer.api.plugins.impl.BaseAutofitPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreAutofitPlugin
extends BaseAutofitPlugin {
    public static float RANDOMIZE_CHANCE = 0.5f;
    public static int PRIORITY = 1000;
    public static String BUY_FROM_MARKET = new String("buy_from_market");
    public static String USE_FROM_CARGO = new String("use_from_cargo");
    public static String USE_FROM_STORAGE = new String("use_from_storage");
    public static String BUY_FROM_BLACK_MARKET = new String("black_market");
    public static String UPGRADE = new String("upgrade");
    public static String ALWAYS_REINFORCED_HULL = new String("always_reinforced_hull");
    public static String ALWAYS_BLAST_DOORS = new String("always_blast_doors");
    public static String STRIP = new String("strip");
    public static String RANDOMIZE = new String("randomize");
    public static String LR = "LR";
    public static String SR = "SR";
    public static String KINETIC = "kinetic";
    public static String HE = "he";
    public static String ENERGY = "energy";
    public static String PD = "pd";
    public static String BEAM = "beam";
    public static String STRIKE = "strike";
    public static String MISSILE = "missile";
    public static String UTILITY = "utility";
    public static String ROCKET = "rocket";
    public static String INTERCEPTOR = "interceptor";
    public static String BOMBER = "bomber";
    public static String FIGHTER = "fighter";
    public static String SUPPORT = "support";
    protected static Map<String, Category> reusableCategories = null;
    protected List<AutofitPlugin.AutofitOption> options = new ArrayList<AutofitPlugin.AutofitOption>();
    protected Map<String, Category> categories = new LinkedHashMap<String, Category>();
    protected Map<WeaponSpecAPI, List<String>> altWeaponCats = new LinkedHashMap<WeaponSpecAPI, List<String>>();
    protected Map<FighterWingSpecAPI, List<String>> altFighterCats = new LinkedHashMap<FighterWingSpecAPI, List<String>>();
    protected boolean debug = false;
    protected PersonAPI fleetCommander;
    protected MutableCharacterStatsAPI stats;
    protected Random random;
    protected boolean randomize = false;
    protected long weaponFilterSeed = 0L;
    protected String emptyWingTarget = null;
    protected Map<String, AutofitPlugin.AvailableWeapon> fittedWeapons = new HashMap<String, AutofitPlugin.AvailableWeapon>();
    protected Map<String, AutofitPlugin.AvailableFighter> fittedFighters = new HashMap<String, AutofitPlugin.AvailableFighter>();
    protected Set<String> availableMods;
    protected Set<String> slotsToSkip = new HashSet<String>();
    protected Set<Integer> baysToSkip = new HashSet<Integer>();
    protected boolean fittingModule = false;
    protected int missilesWithAmmoOnCurrent = 0;
    protected static transient Map<String, Integer> tagLevels = new HashMap<String, Integer>();

    public Random getRandom() {
        return this.random;
    }

    @Override
    public void setRandom(Random random) {
        this.random = random;
    }

    public boolean isChecked(String id) {
        for (AutofitPlugin.AutofitOption option : this.options) {
            if (!option.id.equals(id)) continue;
            return option.checked;
        }
        return false;
    }

    public void setChecked(String id, boolean checked) {
        for (AutofitPlugin.AutofitOption option : this.options) {
            if (!option.id.equals(id)) continue;
            option.checked = checked;
            return;
        }
    }

    public CoreAutofitPlugin(PersonAPI fleetCommander) {
        this.fleetCommander = fleetCommander;
        if (fleetCommander != null) {
            this.stats = fleetCommander.getStats();
        }
        this.options.add(new AutofitPlugin.AutofitOption(USE_FROM_CARGO, "\u641c\u7d22\u8d27\u8231\u4f7f\u7528\u88c5\u5907", true, "\u4f7f\u7528\u4f60\u8230\u961f\u7684\u8d27\u8231\u5185\u7684 \u6b66\u5668 \u548c \u6218\u673a LPC\u3002"));
        this.options.add(new AutofitPlugin.AutofitOption(USE_FROM_STORAGE, "\u641c\u7d22\u4ed3\u5e93\u4f7f\u7528\u88c5\u5907", true, "\u4f7f\u7528\u5f53\u5730\u6e2f\u53e3\u7684\u4ed3\u5e93\u5185\u7684 \u6b66\u5668 \u548c \u6218\u673a LPC\u3002"));
        this.options.add(new AutofitPlugin.AutofitOption(BUY_FROM_MARKET, "\u641c\u7d22\u5e02\u573a\u8d2d\u4e70\u88c5\u5907", true, "\u4ece\u5e02\u573a\u4e2d\u8d2d\u4e70 \u6b66\u5668 \u548c \u6218\u673a LPC \u4ee5\u4f9b\u88c5\u914d\uff0c\u5982\u679c\u60c5\u51b5\u5141\u8bb8\u3002\n\n\u5982\u679c\u4f60\u7684\u8d27\u8231\u5185\u6709\u5b8c\u5168\u7b26\u5408\u6216\u8d28\u91cf\u7c7b\u4f3c\u7684 \u6b66\u5668 \u548c \u6218\u673a LPC\uff0c\u4e14\u52fe\u9009\u4e86\u5bf9\u5e94\u9009\u9879\uff0c\u90a3\u4e48\u4f1a\u4f18\u5148\u4f7f\u7528\u8d27\u8231\u5185\u7684\u88c5\u5907\u3002"));
        this.options.add(new AutofitPlugin.AutofitOption(BUY_FROM_BLACK_MARKET, "\u5141\u8bb8\u641c\u7d22\u9ed1\u5e02\u8d2d\u4e70", true, "\u4ece\u9ed1\u5e02\u4e2d\u8d2d\u4e70 \u6b66\u5668 \u548c \u6218\u673a LPC \u4ee5\u4f9b\u88c5\u914d\u3002\n\n\u5982\u679c\u5176\u4ed6\u5e38\u89c4\u5e02\u573a\u5185\u6709\u5b8c\u5168\u7b26\u5408\u6216\u8d28\u91cf\u7c7b\u4f3c\u7684 \u6b66\u5668 \u548c \u6218\u673a LPC\uff0c\u4e14\u52fe\u9009\u4e86\u5bf9\u5e94\u9009\u9879\uff0c\u90a3\u4e48\u4f1a\u4f18\u5148\u8d2d\u4e70\u5e38\u89c4\u5e02\u573a\u5185\u7684\u88c5\u5907\u3002"));
        this.options.add(new AutofitPlugin.AutofitOption(UPGRADE, "\u5347\u7ea7\u6b66\u5668\uff0c\u5982\u679c\u6709\u5269\u4f59\u88c5\u914d\u70b9", false, "\u5c3d\u53ef\u80fd\u4f7f\u7528\u6bd4\u76ee\u6807\u88c5\u914d\u4e2d\u7684\u6b66\u5668\u66f4\u5f3a\u5927\u7684\u6b66\u5668\uff0c\u5982\u679c\u5269\u4f59\u88c5\u914d\u70b9\u5145\u8db3\u3002\n\n\u5c06\u4f18\u5148\u6ee1\u8db3\u76ee\u6807\u88c5\u914d\u7684\u8017\u6563\u901a\u9053\u4e0e\u5e45\u80fd\u5bc4\u5b58\u5668\u6570\u91cf\u8981\u6c42\uff0c\u7136\u540e\u624d\u5347\u7ea7\u6b66\u5668\uff0c\u6700\u540e\u8865\u5145\u66f4\u591a\u8017\u6563\u901a\u9053\u4e0e\u5176\u4ed6\u8230\u8239\u63d2\u4ef6\u3002\n\n\u5728\u76ee\u6807\u88c5\u914d\u4e2d\u9884\u7559\u4e00\u4e9b\u5197\u4f59\u88c5\u914d\u70b9\u53ef\u4ee5\u8ba9\u8fd9\u4e2a\u9009\u9879\u8868\u73b0\u5730\u66f4\u597d\u3002"));
        this.options.add(new AutofitPlugin.AutofitOption(STRIP, "\u6e05\u7a7a\u5f53\u524d\u88c5\u914d", true, "\u5728\u6267\u884c \u81ea\u52a8\u88c5\u914d \u4e4b\u524d\uff0c\u6e05\u7a7a\u5f53\u524d\u88c5\u914d\u4e0a\u7684\u6240\u6709\u88c5\u5907\u6216\u7ec4\u4ef6\u3002\u8fd9\u53ef\u80fd\u5bfc\u81f4 \u81ea\u52a8\u88c5\u914d \u8868\u73b0\u66f4\u4f73\u3002\n\n\u7136\u800c\uff0c\u5728\u672a\u5bf9\u63a5\u6e2f\u53e3\u7684\u60c5\u51b5\u4e0b\u66f4\u6539\u88c5\u914d\u4f1a\u964d\u4f4e\u8230\u8239\u7684\u6218\u5907\u503c (CR)\uff0c\u52fe\u9009\u6b64\u9009\u9879\u5c06\u7531\u4e8e\u6539\u52a8\u8f83\u591a\u800c\u4f7f\u4e4b\u964d\u4f4e\u5f97\u5c24\u5176\u591a\u3002"));
        this.options.add(new AutofitPlugin.AutofitOption(ALWAYS_REINFORCED_HULL, "\u9ed8\u8ba4\u5b89\u88c5 \"\u5f3a\u5316\u8231\u58c1\"", false, "\u4f18\u5148\u5b89\u88c5 \"\u5f3a\u5316\u8231\u58c1\"\uff0c\u53ef\u4ee5\u63d0\u9ad8\u8239\u4f53\u7ed3\u6784\u503c\u5e76\u8ba9\u8230\u8239\u51e0\u4e4e\u603b\u662f\u53ef\u5728\u6218\u540e\u88ab\u6253\u635e\u5e76\u4fee\u590d\u3002\n\n\u5982\u679c\u4e0d\u52fe\u9009\u6b64\u9009\u9879\uff0c\"\u5f3a\u5316\u8231\u58c1\" \u4e5f\u53ef\u80fd\u5728\u88c5\u914d\u70b9\u8db3\u591f\u7684\u60c5\u51b5\u4e0b\u88ab\u5b89\u88c5\u3002"));
        this.options.add(new AutofitPlugin.AutofitOption(ALWAYS_BLAST_DOORS, "\u9ed8\u8ba4\u5b89\u88c5 \"\u9632\u7206\u6c14\u5bc6\u95e8\"", false, "\u4f18\u5148\u5b89\u88c5 \"\u9632\u7206\u6c14\u5bc6\u95e8\"\uff0c\u53ef\u4ee5\u63d0\u9ad8\u8239\u4f53\u7ed3\u6784\u503c\u5e76\u5927\u5e45\u964d\u4f4e\u6218\u6597\u4e2d\u56e0\u8239\u4f53\u7ed3\u6784\u53d7\u635f\u800c\u9020\u6210\u7684\u8239\u5458\u4f24\u4ea1\u3002\n\n\u5982\u679c\u4e0d\u52fe\u9009\u6b64\u9009\u9879\uff0c\"\u9632\u7206\u6c14\u5bc6\u95e8\" \u4e5f\u53ef\u80fd\u5728\u88c5\u914d\u70b9\u8db3\u591f\u7684\u60c5\u51b5\u4e0b\u88ab\u5b89\u88c5\u3002"));
        this.options.add(new AutofitPlugin.AutofitOption(RANDOMIZE, "\u968f\u673a\u914d\u5907\u6b66\u5668\u4e0e\u8239\u4f53\u63d2\u4ef6", false, "\u57fa\u4e8e\u76ee\u6807\u88c5\u914d\u6c34\u51c6\uff0c\u534a\u968f\u673a\u5730\u8fdb\u884c\u914d\u7f6e\u3002"));
        if (reusableCategories != null) {
            this.categories = reusableCategories;
        } else {
            new Category(KINETIC, this.categories).addFallback(KINETIC, ENERGY, HE, BEAM, PD, ROCKET, MISSILE, UTILITY, STRIKE);
            new Category(HE, this.categories).addFallback(HE, ENERGY, KINETIC, BEAM, PD, ROCKET, MISSILE, UTILITY, STRIKE);
            new Category(ENERGY, this.categories).addFallback(ENERGY, KINETIC, HE, BEAM, PD, ROCKET, MISSILE, UTILITY, STRIKE);
            new Category(PD, this.categories).addFallback(PD, BEAM, HE, KINETIC, UTILITY, ROCKET, MISSILE, STRIKE);
            new Category(BEAM, this.categories).addFallback(BEAM, ENERGY, HE, KINETIC, ROCKET, MISSILE, UTILITY, STRIKE);
            new Category(STRIKE, this.categories).addFallback(STRIKE, MISSILE, ROCKET, HE, ENERGY, KINETIC, UTILITY, BEAM, PD);
            new Category(MISSILE, this.categories).addFallback(MISSILE, STRIKE, ROCKET, HE, ENERGY, KINETIC, UTILITY, BEAM, PD);
            new Category(UTILITY, this.categories).addFallback(UTILITY, MISSILE, ROCKET, STRIKE, HE, KINETIC, ENERGY, BEAM, PD);
            new Category(ROCKET, this.categories).addFallback(ROCKET, UTILITY, MISSILE, STRIKE, HE, ENERGY, KINETIC, BEAM, PD);
            new Category(INTERCEPTOR, this.categories).addFallback(INTERCEPTOR, FIGHTER, SUPPORT, BOMBER);
            new Category(BOMBER, this.categories).addFallback(BOMBER, FIGHTER, INTERCEPTOR, SUPPORT);
            new Category(FIGHTER, this.categories).addFallback(FIGHTER, INTERCEPTOR, BOMBER, SUPPORT);
            new Category(SUPPORT, this.categories).addFallback(SUPPORT, INTERCEPTOR, FIGHTER, BOMBER);
            reusableCategories = this.categories;
        }
    }

    protected void stripWeapons(ShipVariantAPI current, AutofitPlugin.AutofitPluginDelegate delegate) {
        for (String id : current.getFittedWeaponSlots()) {
            WeaponSlotAPI slot = current.getSlot(id);
            if (slot.isDecorative() || slot.isBuiltIn() || slot.isHidden() || slot.isSystemSlot() || slot.isStationModule()) continue;
            this.clearWeaponSlot(slot, delegate, current);
        }
    }

    protected void stripFighters(ShipVariantAPI current, AutofitPlugin.AutofitPluginDelegate delegate) {
        int numBays = 20;
        int i = 0;
        while (i < numBays) {
            if (current.getWingId(i) != null) {
                this.clearFighterSlot(i, delegate, current);
            }
            ++i;
        }
    }

    @Override
    public int getCreditCost() {
        int cost = 0;
        for (AutofitPlugin.AvailableWeapon availableWeapon : this.fittedWeapons.values()) {
            cost = (int)((float)cost + availableWeapon.getPrice());
        }
        for (AutofitPlugin.AvailableFighter availableFighter : this.fittedFighters.values()) {
            cost = (int)((float)cost + availableFighter.getPrice());
        }
        return cost;
    }

    @Override
    public void doFit(ShipVariantAPI current, ShipVariantAPI target, int maxSMods, AutofitPlugin.AutofitPluginDelegate delegate) {
        boolean player;
        boolean bl = player = this.fleetCommander != null && this.fleetCommander.isPlayer();
        if (!this.fittingModule) {
            this.fittedWeapons.clear();
            this.fittedFighters.clear();
            this.randomize = this.isChecked(RANDOMIZE);
            this.availableMods = new LinkedHashSet<String>(delegate.getAvailableHullmods());
        }
        current.setMayAutoAssignWeapons(false);
        current.getStationModules().putAll(target.getStationModules());
        int index = 0;
        for (String slotId : current.getStationModules().keySet()) {
            Object moduleCurrent = current.getModuleVariant(slotId);
            boolean forceClone = false;
            if (moduleCurrent == null) {
                forceClone = true;
                moduleCurrent = target.getModuleVariant(slotId);
            }
            if (moduleCurrent == null) {
                String variantId = current.getHullVariantId();
                throw new RuntimeException("Module variant for slotId [" + slotId + "] not found for " + "variantId [" + variantId + "] of hull [" + current.getHullSpec().getHullId() + "]");
            }
            if (moduleCurrent.isStockVariant() || forceClone) {
                moduleCurrent = moduleCurrent.clone();
                moduleCurrent.setSource(VariantSource.REFIT);
                if (!forceClone) {
                    moduleCurrent.setHullVariantId(String.valueOf(moduleCurrent.getHullVariantId()) + "_" + index);
                }
            }
            ++index;
            ShipVariantAPI moduleTarget = target.getModuleVariant(slotId);
            if (moduleTarget == null) continue;
            this.fittingModule = true;
            this.doFit((ShipVariantAPI)moduleCurrent, moduleTarget, 0, delegate);
            this.fittingModule = false;
            current.setModuleVariant(slotId, (ShipVariantAPI)moduleCurrent);
        }
        current.setSource(VariantSource.REFIT);
        this.weaponFilterSeed = this.random.nextLong();
        this.emptyWingTarget = null;
        if (delegate.getAvailableFighters().size() > 0) {
            this.emptyWingTarget = delegate.getAvailableFighters().get(this.random.nextInt(delegate.getAvailableFighters().size())).getId();
        }
        this.altWeaponCats.clear();
        this.altFighterCats.clear();
        this.slotsToSkip.clear();
        this.baysToSkip.clear();
        this.missilesWithAmmoOnCurrent = 0;
        boolean strip = this.isChecked(STRIP);
        if (strip) {
            this.stripWeapons(current, delegate);
            this.stripFighters(current, delegate);
            current.setNumFluxCapacitors(0);
            current.setNumFluxVents(0);
            if (delegate.isPlayerCampaignRefit()) {
                for (String modId : current.getNonBuiltInHullmods()) {
                    boolean canRemove = delegate.canAddRemoveHullmodInPlayerCampaignRefit(modId);
                    if (!canRemove) continue;
                    current.removeMod(modId);
                }
            } else {
                current.clearHullMods();
            }
            if (!this.fittingModule) {
                delegate.syncUIWithVariant(current);
            }
        } else {
            this.slotsToSkip.addAll(current.getFittedWeaponSlots());
            int i = 0;
            while (i < 20) {
                String wingId = current.getWingId(i);
                if (wingId != null && !wingId.isEmpty()) {
                    this.baysToSkip.add(i);
                }
                ++i;
            }
        }
        boolean reinforcedHull = this.isChecked(ALWAYS_REINFORCED_HULL);
        boolean blastDoors = this.isChecked(ALWAYS_BLAST_DOORS);
        if (reinforcedHull) {
            this.addHullmods(current, delegate, "reinforcedhull");
        }
        if (blastDoors) {
            this.addHullmods(current, delegate, "blast_doors");
        }
        ArrayList<String> targetMods = new ArrayList<String>();
        for (String id : target.getNonBuiltInHullmods()) {
            targetMods.add(id);
        }
        if (!targetMods.isEmpty()) {
            this.addHullmods(current, delegate, targetMods.toArray(new String[0]));
        }
        int addedRandomHullmodPts = 0;
        if (this.randomize) {
            addedRandomHullmodPts = this.addRandomizedHullmodsPre(current, delegate);
        }
        this.fitFighters(current, target, false, delegate);
        this.fitWeapons(current, target, false, delegate);
        if (current.hasHullMod("fragile_subsystems") && (current.getHullSize() == ShipAPI.HullSize.FRIGATE || current.getHullSize() == ShipAPI.HullSize.DESTROYER)) {
            this.addHullmods(current, delegate, "hardened_subsystems");
        }
        float addedMax = (float)current.getHullSpec().getOrdnancePoints(this.stats) * 0.1f;
        if (this.randomize && (float)addedRandomHullmodPts <= addedMax) {
            this.addRandomizedHullmodsPost(current, delegate);
        }
        float ventsCapsFraction = 1.0f;
        boolean upgrade = this.isChecked(UPGRADE);
        if (upgrade) {
            ventsCapsFraction = 0.5f;
        }
        this.addVentsAndCaps(current, target, ventsCapsFraction);
        if (upgrade) {
            this.fitFighters(current, target, true, delegate);
            this.fitWeapons(current, target, true, delegate);
            this.addVentsAndCaps(current, target, 1.0f - ventsCapsFraction);
        }
        this.addExtraVentsAndCaps(current, target);
        this.addHullmods(current, delegate, "reinforcedhull", "blast_doors", "hardened_subsystems");
        this.addModsWithSpareOPIfAny(current, target, false, delegate);
        if (maxSMods > 0) {
            int added = this.convertToSMods(current, maxSMods);
            this.addExtraVents(current);
            this.addExtraCaps(current);
            if (!current.hasHullMod("fluxdistributor")) {
                this.addDistributor(current, delegate);
            }
            if (!current.hasHullMod("fluxcoil")) {
                this.addCoil(current, delegate);
            }
            if (current.getHullSize() == ShipAPI.HullSize.FRIGATE || current.hasHullMod("safetyoverrides")) {
                this.addHullmods(current, delegate, "hardened_subsystems", "reinforcedhull", "blast_doors");
            } else {
                this.addHullmods(current, delegate, "reinforcedhull", "blast_doors", "hardened_subsystems");
            }
            int remaining = maxSMods - added;
            if (remaining > 0) {
                ArrayList<String> mods = new ArrayList<String>();
                mods.add("fluxdistributor");
                mods.add("fluxcoil");
                if (current.getHullSize() == ShipAPI.HullSize.FRIGATE || current.hasHullMod("safetyoverrides")) {
                    mods.add("hardened_subsystems");
                    mods.add("reinforcedhull");
                } else {
                    mods.add("reinforcedhull");
                    mods.add("hardened_subsystems");
                }
                mods.add("blast_doors");
                Iterator iter = mods.iterator();
                while (iter.hasNext()) {
                    String modId = (String)iter.next();
                    if (!current.getPermaMods().contains(modId)) continue;
                    iter.remove();
                }
                int i = 0;
                while (i < remaining && !mods.isEmpty()) {
                    current.setNumFluxCapacitors(0);
                    current.setNumFluxVents(0);
                    String modId = (String)mods.get(Math.min(i, mods.size() - 1));
                    this.addHullmods(current, delegate, modId);
                    this.convertToSMods(current, 1);
                    ++i;
                }
            }
        }
        if (current.getHullSpec().isPhase()) {
            this.addExtraCaps(current);
        } else {
            this.addExtraVents(current);
        }
        this.addHullmods(current, delegate, "armoredweapons");
        int opCost = current.computeOPCost(this.stats);
        int opMax = current.getHullSpec().getOrdnancePoints(this.stats);
        int opLeft = opMax - opCost;
        if (opLeft > 0) {
            this.addRandomizedHullmodsPost(current, delegate);
        }
        if (current.getHullSpec().isPhase()) {
            this.addExtraVents(current);
        } else {
            this.addExtraCaps(current);
        }
        current.setVariantDisplayName(target.getDisplayName());
        current.getWeaponGroups().clear();
        for (WeaponGroupSpec group : target.getWeaponGroups()) {
            WeaponGroupSpec copy = new WeaponGroupSpec(group.getType());
            copy.setAutofireOnByDefault(group.isAutofireOnByDefault());
            for (String slotId : group.getSlots()) {
                if (current.getWeaponId(slotId) == null) continue;
                copy.addSlot(slotId);
            }
            if (copy.getSlots().isEmpty()) continue;
            current.addWeaponGroup(copy);
        }
        if (player) {
            if (current.getWeaponGroups().isEmpty() || this.randomize || current.hasUnassignedWeapons()) {
                current.setMayAutoAssignWeapons(true);
                current.autoGenerateWeaponGroups();
            }
        } else {
            current.getWeaponGroups().clear();
        }
        if (!this.fittingModule) {
            delegate.syncUIWithVariant(current);
        }
    }

    protected int convertToSMods(ShipVariantAPI current, int num) {
        if (num <= 0) {
            return 0;
        }
        ArrayList<HullModSpecAPI> mods = new ArrayList<HullModSpecAPI>();
        for (String id : current.getHullMods()) {
            HullModSpecAPI mod;
            if (current.getPermaMods().contains(id) || current.getHullSpec().getBuiltInMods().contains(id) || (mod = DModManager.getMod(id)).hasTag("no_build_in")) continue;
            mods.add(mod);
        }
        final ShipAPI.HullSize size = current.getHullSize();
        Collections.sort(mods, new Comparator<HullModSpecAPI>(){

            @Override
            public int compare(HullModSpecAPI o1, HullModSpecAPI o2) {
                return Misc.getOPCost(o2, size) - Misc.getOPCost(o1, size);
            }
        });
        int count = 0;
        int i = 0;
        while (i < num && i < mods.size()) {
            String id = ((HullModSpecAPI)mods.get(i)).getId();
            current.addPermaMod(id, true);
            ++count;
            ++i;
        }
        return count;
    }

    protected void addModsWithSpareOPIfAny(ShipVariantAPI current, ShipVariantAPI target, boolean sModMode, AutofitPlugin.AutofitPluginDelegate delegate) {
        int opCost = current.computeOPCost(this.stats);
        int opMax = current.getHullSpec().getOrdnancePoints(this.stats);
        int opLeft = opMax - opCost;
        if (opLeft <= 0) {
            return;
        }
        float total = target.getNumFluxVents() + target.getNumFluxCapacitors();
        float ventsFraction = 1.0f;
        if (total > 0.0f) {
            ventsFraction = (float)target.getNumFluxVents() / total;
        }
        if (sModMode) {
            if (ventsFraction >= 0.5f) {
                this.addDistributorRemoveVentsIfNeeded(current, delegate);
                this.addCoilRemoveCapsIfNeeded(current, delegate);
            } else {
                this.addCoil(current, delegate);
                this.addCoilRemoveCapsIfNeeded(current, delegate);
            }
        } else if (ventsFraction >= 0.5f) {
            this.addDistributor(current, delegate);
            this.addCoil(current, delegate);
        } else {
            this.addCoil(current, delegate);
            this.addDistributor(current, delegate);
        }
    }

    protected void addCoil(ShipVariantAPI current, AutofitPlugin.AutofitPluginDelegate delegate) {
        int opCost = current.computeOPCost(this.stats);
        int opMax = current.getHullSpec().getOrdnancePoints(this.stats);
        int opLeft = opMax - opCost;
        if (opLeft <= 0) {
            return;
        }
        int vents = current.getNumFluxVents();
        HullModSpecAPI coil = Misc.getMod("fluxcoil");
        int cost = coil.getCostFor(current.getHullSize());
        if ((float)cost < (float)opLeft + (float)vents * 0.3f) {
            int remove = cost - opLeft;
            if (remove > 0) {
                opLeft -= this.addVents(-remove, current, 1000);
            }
            opLeft -= this.addModIfPossible("fluxcoil", delegate, current, opLeft);
        }
    }

    protected void addCoilRemoveCapsIfNeeded(ShipVariantAPI current, AutofitPlugin.AutofitPluginDelegate delegate) {
        int opCost = current.computeOPCost(this.stats);
        int opMax = current.getHullSpec().getOrdnancePoints(this.stats);
        int opLeft = opMax - opCost;
        if (opLeft <= 0) {
            return;
        }
        int caps = current.getNumFluxCapacitors();
        HullModSpecAPI coil = Misc.getMod("fluxcoil");
        int cost = coil.getCostFor(current.getHullSize());
        if ((float)cost < (float)opLeft + (float)caps * 0.3f) {
            int remove = cost - opLeft;
            if (remove > 0) {
                opLeft -= this.addCapacitors(-remove, current, 1000);
            }
            opLeft -= this.addModIfPossible("fluxcoil", delegate, current, opLeft);
        }
    }

    protected void addDistributor(ShipVariantAPI current, AutofitPlugin.AutofitPluginDelegate delegate) {
        int opCost = current.computeOPCost(this.stats);
        int opMax = current.getHullSpec().getOrdnancePoints(this.stats);
        int opLeft = opMax - opCost;
        if (opLeft <= 0) {
            return;
        }
        int caps = current.getNumFluxCapacitors();
        HullModSpecAPI distributor = Misc.getMod("fluxdistributor");
        int cost = distributor.getCostFor(current.getHullSize());
        if ((float)cost <= (float)opLeft + (float)caps * 0.3f) {
            int remove = cost - opLeft;
            if (remove > 0) {
                opLeft -= this.addCapacitors(-remove, current, 1000);
            }
            opLeft -= this.addModIfPossible("fluxdistributor", delegate, current, opLeft);
        }
    }

    protected void addDistributorRemoveVentsIfNeeded(ShipVariantAPI current, AutofitPlugin.AutofitPluginDelegate delegate) {
        int opCost = current.computeOPCost(this.stats);
        int opMax = current.getHullSpec().getOrdnancePoints(this.stats);
        int opLeft = opMax - opCost;
        if (opLeft <= 0) {
            return;
        }
        int vents = current.getNumFluxVents();
        HullModSpecAPI distributor = Misc.getMod("fluxdistributor");
        int cost = distributor.getCostFor(current.getHullSize());
        if ((float)cost <= (float)opLeft + (float)vents * 0.3f) {
            int remove = cost - opLeft;
            if (remove > 0) {
                opLeft -= this.addVents(-remove, current, 1000);
            }
            opLeft -= this.addModIfPossible("fluxdistributor", delegate, current, opLeft);
        }
    }

    protected List<AutofitPlugin.AvailableWeapon> getWeapons(AutofitPlugin.AutofitPluginDelegate delegate) {
        boolean buy = this.isChecked(BUY_FROM_MARKET);
        boolean storage = this.isChecked(USE_FROM_STORAGE);
        boolean useCargo = this.isChecked(USE_FROM_CARGO);
        boolean useBlack = this.isChecked(BUY_FROM_BLACK_MARKET);
        ArrayList<AutofitPlugin.AvailableWeapon> weapons = new ArrayList<AutofitPlugin.AvailableWeapon>(delegate.getAvailableWeapons());
        Iterator iter = weapons.iterator();
        while (iter.hasNext()) {
            AutofitPlugin.AvailableWeapon w = (AutofitPlugin.AvailableWeapon)iter.next();
            if (!(!buy && w.getPrice() > 0.0f || !storage && w.getPrice() <= 0.0f && w.getSubmarket() != null || !useCargo && w.getSubmarket() == null) && (useBlack || w.getSubmarket() == null || !w.getSubmarket().getPlugin().isBlackMarket())) continue;
            iter.remove();
        }
        return weapons;
    }

    protected List<AutofitPlugin.AvailableFighter> getFighters(AutofitPlugin.AutofitPluginDelegate delegate) {
        boolean buy = this.isChecked(BUY_FROM_MARKET);
        boolean storage = this.isChecked(USE_FROM_STORAGE);
        boolean useCargo = this.isChecked(USE_FROM_CARGO);
        boolean useBlack = this.isChecked(BUY_FROM_BLACK_MARKET);
        boolean automated = Misc.isAutomated(delegate.getShip());
        ArrayList<AutofitPlugin.AvailableFighter> fighters = new ArrayList<AutofitPlugin.AvailableFighter>(delegate.getAvailableFighters());
        Iterator iter = fighters.iterator();
        while (iter.hasNext()) {
            AutofitPlugin.AvailableFighter f = (AutofitPlugin.AvailableFighter)iter.next();
            if (!(!buy && f.getPrice() > 0.0f || automated && !f.getWingSpec().hasTag("auto_fighter") || !storage && f.getPrice() <= 0.0f && f.getSubmarket() != null || !useCargo && f.getSubmarket() == null) && (useBlack || f.getSubmarket() == null || !f.getSubmarket().getPlugin().isBlackMarket())) continue;
            iter.remove();
        }
        return fighters;
    }

    public int addHullmods(ShipVariantAPI current, AutofitPlugin.AutofitPluginDelegate delegate, String ... mods) {
        if (this.fittingModule) {
            return 0;
        }
        int opCost = current.computeOPCost(this.stats);
        int opMax = current.getHullSpec().getOrdnancePoints(this.stats);
        int opLeft = opMax - opCost;
        int addedTotal = 0;
        String[] stringArray = mods;
        int n = mods.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                String mod;
                block9: {
                    mod = stringArray[n2];
                    if (current.hasHullMod(mod)) break block8;
                    if (this.availableMods.contains(mod)) break block9;
                    if (!mod.equals("targetingunit") || current.getHullSize().ordinal() < ShipAPI.HullSize.CRUISER.ordinal()) break block8;
                    mod = "dedicated_targeting_core";
                }
                if (mod.equals("dedicated_targeting_core") && this.availableMods.contains("targetingunit")) {
                    mod = "targetingunit";
                }
                HullModSpecAPI modSpec = Misc.getMod(mod);
                if (mod.equals("targetingunit") && current.hasHullMod("dedicated_targeting_core")) {
                    current.removeMod("dedicated_targeting_core");
                    HullModSpecAPI dtc = Misc.getMod("dedicated_targeting_core");
                    int cost = dtc.getCostFor(current.getHullSize());
                    addedTotal -= cost;
                    opLeft += cost;
                }
                if (!((current.hasHullMod("advancedcore") || current.hasHullMod("distributed_fire_control")) && (mod.equals("targetingunit") || mod.equals("dedicated_targeting_core")) || current.getHullSpec().isPhase() && modSpec.hasTag("non_phase") || !current.getHullSpec().isPhase() && modSpec.hasTag("phase"))) {
                    int cost = this.addModIfPossible(modSpec, delegate, current, opLeft);
                    opLeft -= cost;
                    addedTotal += cost;
                }
            }
            ++n2;
        }
        return addedTotal;
    }

    public int addModIfPossible(String id, AutofitPlugin.AutofitPluginDelegate delegate, ShipVariantAPI current, int opLeft) {
        if (current.hasHullMod(id)) {
            return 0;
        }
        if (delegate.isPlayerCampaignRefit() && !delegate.canAddRemoveHullmodInPlayerCampaignRefit(id)) {
            return 0;
        }
        HullModSpecAPI mod = Misc.getMod(id);
        return this.addModIfPossible(mod, delegate, current, opLeft);
    }

    public int addModIfPossible(HullModSpecAPI mod, AutofitPlugin.AutofitPluginDelegate delegate, ShipVariantAPI current, int opLeft) {
        if (mod == null) {
            return 0;
        }
        if (current.hasHullMod(mod.getId())) {
            return 0;
        }
        if (delegate.isPlayerCampaignRefit() && !delegate.canAddRemoveHullmodInPlayerCampaignRefit(mod.getId())) {
            return 0;
        }
        int cost = mod.getCostFor(current.getHullSize());
        if (cost > opLeft) {
            return 0;
        }
        ShipAPI ship = delegate.getShip();
        ShipVariantAPI orig = null;
        if (ship != null) {
            orig = ship.getVariant();
            ship.setVariantForHullmodCheckOnly(current);
        }
        if (ship != null && mod.getEffect() != null && ship.getVariant() != null && !mod.getEffect().isApplicableToShip(ship) && !ship.getVariant().hasHullMod(mod.getId())) {
            if (orig != null) {
                ship.setVariantForHullmodCheckOnly(orig);
            }
            return 0;
        }
        if (orig != null && ship != null) {
            ship.setVariantForHullmodCheckOnly(orig);
        }
        current.addMod(mod.getId());
        return cost;
    }

    public void addVentsAndCaps(ShipVariantAPI current, ShipVariantAPI target, float fraction) {
        if (fraction < 0.0f) {
            return;
        }
        int opCost = current.computeOPCost(this.stats);
        int opMax = current.getHullSpec().getOrdnancePoints(this.stats);
        int opLeft = opMax - opCost;
        int maxVents = this.getMaxVents(current.getHullSize());
        int maxCapacitors = this.getMaxCaps(current.getHullSize());
        int add = Math.max((int)Math.ceil((float)target.getNumFluxVents() * fraction) - current.getNumFluxVents(), 0);
        if (add > opLeft) {
            add = opLeft;
        }
        opLeft -= this.addVents(add, current, maxVents);
        add = Math.max((int)Math.ceil((float)target.getNumFluxCapacitors() * fraction) - current.getNumFluxCapacitors(), 0);
        if (add > opLeft) {
            add = opLeft;
        }
        opLeft -= this.addCapacitors(add, current, maxCapacitors);
    }

    public void addExtraVents(ShipVariantAPI current) {
        int opCost = current.computeOPCost(this.stats);
        int opMax = current.getHullSpec().getOrdnancePoints(this.stats);
        int opLeft = opMax - opCost;
        if (opLeft > 0) {
            int maxVents = this.getMaxVents(current.getHullSize());
            opLeft -= this.addVents(opLeft, current, maxVents);
        }
    }

    public void addExtraCaps(ShipVariantAPI current) {
        int opCost = current.computeOPCost(this.stats);
        int opMax = current.getHullSpec().getOrdnancePoints(this.stats);
        int opLeft = opMax - opCost;
        if (opLeft > 0) {
            int maxCaps = this.getMaxCaps(current.getHullSize());
            opLeft -= this.addCapacitors(opLeft, current, maxCaps);
        }
    }

    public void addExtraVentsAndCaps(ShipVariantAPI current, ShipVariantAPI target) {
        int opCost = current.computeOPCost(this.stats);
        int opMax = current.getHullSpec().getOrdnancePoints(this.stats);
        int opLeft = opMax - opCost;
        int maxVents = this.getMaxVents(current.getHullSize());
        int maxCapacitors = this.getMaxCaps(current.getHullSize());
        if (opLeft > 0) {
            float targetCaps;
            float targetVents;
            float total = current.getNumFluxVents() + current.getNumFluxCapacitors();
            float ventsFraction = 1.0f;
            if (total > 0.0f) {
                ventsFraction = (float)current.getNumFluxVents() / total;
            }
            int add = (int)((float)opLeft * ventsFraction);
            opLeft -= this.addVents(add, current, maxVents);
            add = opLeft;
            opLeft -= this.addCapacitors(add, current, maxCapacitors);
            add = opLeft;
            opLeft -= this.addVents(add, current, maxVents);
            if (target != null && ((targetVents = (float)target.getNumFluxVents()) > (targetCaps = (float)target.getNumFluxCapacitors()) || targetVents >= (float)maxVents)) {
                int currCapsDesired;
                float currVents = current.getNumFluxVents();
                float currCaps = current.getNumFluxCapacitors();
                float currTotal = currVents + currCaps;
                int currVentsDesired = (int)(currVents + currCaps * 0.5f);
                if (currVentsDesired > maxVents) {
                    currVentsDesired = maxVents;
                }
                if ((currCapsDesired = (int)(currTotal - (float)currVentsDesired)) > maxCapacitors) {
                    currCapsDesired = maxCapacitors;
                }
                current.setNumFluxVents(currVentsDesired);
                current.setNumFluxCapacitors(currCapsDesired);
            }
        }
    }

    public int getMaxVents(ShipAPI.HullSize size) {
        int maxVents = CoreAutofitPlugin.getBaseMax(size);
        if (this.stats != null) {
            maxVents = (int)this.stats.getMaxVentsBonus().computeEffective(maxVents);
        }
        return maxVents;
    }

    public int getMaxCaps(ShipAPI.HullSize size) {
        int maxCapacitors = CoreAutofitPlugin.getBaseMax(size);
        if (this.stats != null) {
            maxCapacitors = (int)this.stats.getMaxCapacitorsBonus().computeEffective(maxCapacitors);
        }
        return maxCapacitors;
    }

    public static int getBaseMax(ShipAPI.HullSize size) {
        int max = 100;
        switch (size) {
            case CAPITAL_SHIP: {
                max = 50;
                break;
            }
            case CRUISER: {
                max = 30;
                break;
            }
            case DESTROYER: {
                max = 20;
                break;
            }
            case FRIGATE: {
                max = 10;
                break;
            }
            case FIGHTER: {
                max = 5;
            }
        }
        return max;
    }

    public int addVents(int add, ShipVariantAPI current, int max) {
        int target = current.getNumFluxVents() + add;
        if (target > max) {
            target = max;
        }
        if (target < 0) {
            target = 0;
        }
        int actual = target - current.getNumFluxVents();
        current.setNumFluxVents(target);
        return actual;
    }

    public int addCapacitors(int add, ShipVariantAPI current, int max) {
        int target = current.getNumFluxCapacitors() + add;
        if (target > max) {
            target = max;
        }
        if (target < 0) {
            target = 0;
        }
        int actual = target - current.getNumFluxCapacitors();
        current.setNumFluxCapacitors(target);
        return actual;
    }

    public void clearWeaponSlot(WeaponSlotAPI slot, AutofitPlugin.AutofitPluginDelegate delegate, ShipVariantAPI variant) {
        this.fittedWeapons.remove(String.valueOf(variant.getHullVariantId()) + "_" + slot.getId());
        delegate.clearWeaponSlot(slot, variant);
    }

    public void clearFighterSlot(int index, AutofitPlugin.AutofitPluginDelegate delegate, ShipVariantAPI variant) {
        this.fittedFighters.remove(String.valueOf(variant.getHullVariantId()) + "_" + index);
        delegate.clearFighterSlot(index, variant);
    }

    public void fitWeapons(ShipVariantAPI current, ShipVariantAPI target, boolean upgradeMode, AutofitPlugin.AutofitPluginDelegate delegate) {
        HashSet<String> alreadyUsed = new HashSet<String>();
        for (WeaponSlotAPI slot : this.getWeaponSlotsInPriorityOrder(current, target, upgradeMode)) {
            List<AutofitPlugin.AvailableWeapon> weapons;
            List<AutofitPlugin.AvailableWeapon> possible;
            WeaponSpecAPI desired;
            WeaponSpecAPI curr;
            if (this.slotsToSkip.contains(slot.getId())) continue;
            float opCost = current.computeOPCost(this.stats);
            float opMax = current.getHullSpec().getOrdnancePoints(this.stats);
            float opLeft = opMax - opCost;
            float levelToBeat = -1.0f;
            if (upgradeMode && (curr = current.getWeaponSpec(slot.getId())) != null) {
                float cost = curr.getOrdnancePointCost(this.stats, current.getStatsForOpCosts());
                opLeft += cost;
                for (String tag : curr.getTags()) {
                    levelToBeat = Math.max(levelToBeat, this.getLevel(tag));
                }
                if (delegate.isPriority(curr)) {
                    levelToBeat += (float)PRIORITY;
                }
            }
            if ((desired = target.getWeaponSpec(slot.getId())) == null || (possible = this.getPossibleWeapons(slot, desired, current, opLeft, weapons = this.getWeapons(delegate))).isEmpty()) continue;
            List<String> categories = desired.getAutofitCategoriesInPriorityOrder();
            List<String> alternate = this.altWeaponCats.get(desired);
            RANDOMIZE_CHANCE = 1.0f;
            if (this.randomize) {
                this.altWeaponCats.put(desired, new ArrayList());
            }
            AutofitPlugin.AvailableWeapon pick = null;
            for (String catId : categories) {
                pick = this.getBestMatch(desired, upgradeMode, catId, alreadyUsed, possible, slot, delegate);
                if (pick != null || upgradeMode) break;
            }
            if (pick == null && !upgradeMode) {
                block3: for (String catId : categories) {
                    Category cat = this.categories.get(catId);
                    if (cat == null) continue;
                    for (String fallbackCatId : cat.fallback) {
                        pick = this.getBestMatch(desired, true, fallbackCatId, alreadyUsed, possible, delegate);
                        if (pick != null) break block3;
                    }
                }
            }
            if (pick == null) continue;
            if (upgradeMode) {
                Category cat;
                float pickLevel = -1.0f;
                if (!categories.isEmpty() && (cat = this.categories.get(categories.get(0))) != null) {
                    String tag = this.getCategoryTag(cat, pick.getSpec().getTags());
                    pickLevel = this.getLevel(tag);
                    if (delegate.isPriority(pick.getSpec())) {
                        pickLevel += (float)PRIORITY;
                    }
                }
                if (pickLevel <= levelToBeat) continue;
            }
            alreadyUsed.add(pick.getId());
            this.clearWeaponSlot(slot, delegate, current);
            delegate.fitWeaponInSlot(slot, pick, current);
            this.fittedWeapons.put(String.valueOf(current.getHullVariantId()) + "_" + slot.getId(), pick);
            if (pick.getSpec().getType() != WeaponAPI.WeaponType.MISSILE || !pick.getSpec().usesAmmo()) continue;
            ++this.missilesWithAmmoOnCurrent;
        }
    }

    public void fitFighters(ShipVariantAPI current, ShipVariantAPI target, boolean upgradeMode, AutofitPlugin.AutofitPluginDelegate delegate) {
        int numBays = Global.getSettings().computeNumFighterBays(current);
        HashSet<String> alreadyUsed = new HashSet<String>();
        int i = 0;
        while (i < numBays) {
            block20: {
                AutofitPlugin.AvailableFighter pick;
                block24: {
                    Category cat;
                    FighterWingSpecAPI desired;
                    String desiredWingId;
                    List<AutofitPlugin.AvailableFighter> possible;
                    float levelToBeat;
                    block23: {
                        List<AutofitPlugin.AvailableFighter> fighters;
                        float opLeft;
                        block22: {
                            block21: {
                                if (this.baysToSkip.contains(i)) break block20;
                                float opCost = current.computeOPCost(this.stats);
                                float opMax = current.getHullSpec().getOrdnancePoints(this.stats);
                                opLeft = opMax - opCost;
                                levelToBeat = -1.0f;
                                if (!upgradeMode) break block21;
                                FighterWingSpecAPI curr = current.getWing(i);
                                if (curr != null) {
                                    float cost = curr.getOpCost(current.getStatsForOpCosts());
                                    opLeft += cost;
                                    for (String tag : curr.getTags()) {
                                        levelToBeat = Math.max(levelToBeat, this.getLevel(tag));
                                    }
                                    if (delegate.isPriority(curr)) {
                                        levelToBeat += (float)PRIORITY;
                                    }
                                }
                                break block22;
                            }
                            if (current.getWingId(i) != null) break block20;
                        }
                        if ((possible = this.getPossibleFighters(current, opLeft, fighters = this.getFighters(delegate))).isEmpty()) break block20;
                        desiredWingId = target.getWingId(i);
                        if (desiredWingId != null && !desiredWingId.isEmpty()) break block23;
                        if (!this.randomize) break block20;
                        desiredWingId = this.emptyWingTarget;
                    }
                    if ((desired = Global.getSettings().getFighterWingSpec(desiredWingId)) == null) break block20;
                    List<String> categories = desired.getAutofitCategoriesInPriorityOrder();
                    List<String> alternate = this.altFighterCats.get(desired);
                    if (this.randomize && (alternate != null || this.random.nextFloat() < RANDOMIZE_CHANCE)) {
                        if (alternate == null) {
                            alternate = new ArrayList<String>();
                            for (String cat2 : categories) {
                                int index;
                                Category category = this.categories.get(cat2);
                                if (category == null || category.fallback.isEmpty() || (index = this.random.nextInt(category.fallback.size() - 1) + 1) == 0) continue;
                                alternate.add(category.fallback.get(index));
                            }
                            this.altFighterCats.put(desired, alternate);
                        }
                        if (!alternate.isEmpty()) {
                            categories = alternate;
                        }
                    } else if (this.randomize) {
                        this.altFighterCats.put(desired, new ArrayList());
                    }
                    pick = null;
                    for (String catId : categories) {
                        pick = this.getBestMatch(desired, upgradeMode, catId, alreadyUsed, possible, delegate);
                        if (pick != null || upgradeMode) break;
                    }
                    if (pick == null && !upgradeMode) {
                        block4: for (String catId : categories) {
                            Category cat3 = this.categories.get(catId);
                            if (cat3 == null) continue;
                            for (String fallbackCatId : cat3.fallback) {
                                pick = this.getBestMatch(desired, true, fallbackCatId, alreadyUsed, possible, delegate);
                                if (pick != null) break block4;
                            }
                        }
                    }
                    if (pick == null) break block20;
                    if (!upgradeMode) break block24;
                    float pickLevel = -1.0f;
                    if (!categories.isEmpty() && (cat = this.categories.get(categories.get(0))) != null) {
                        String tag = this.getCategoryTag(cat, pick.getWingSpec().getTags());
                        pickLevel = this.getLevel(tag);
                        if (delegate.isPriority(pick.getWingSpec())) {
                            pickLevel += (float)PRIORITY;
                        }
                    }
                    if (pickLevel <= levelToBeat) break block20;
                }
                alreadyUsed.add(pick.getId());
                this.clearFighterSlot(i, delegate, current);
                delegate.fitFighterInSlot(i, pick, current);
                this.fittedFighters.put(String.valueOf(current.getHullVariantId()) + "_" + i, pick);
            }
            ++i;
        }
    }

    public AutofitPlugin.AvailableWeapon getBestMatch(WeaponSpecAPI desired, boolean useBetter, String catId, Set<String> alreadyUsed, List<AutofitPlugin.AvailableWeapon> possible, AutofitPlugin.AutofitPluginDelegate delegate) {
        return this.getBestMatch(desired, useBetter, catId, alreadyUsed, possible, null, delegate);
    }

    public AutofitPlugin.AvailableWeapon getBestMatch(WeaponSpecAPI desired, boolean useBetter, String catId, Set<String> alreadyUsed, List<AutofitPlugin.AvailableWeapon> possible, WeaponSlotAPI slot, AutofitPlugin.AutofitPluginDelegate delegate) {
        float bestScore = -1.0f;
        boolean bestIsPriority = false;
        int bestSize = -1;
        Category cat = this.categories.get(catId);
        if (cat == null) {
            return null;
        }
        String desiredTag = this.getCategoryTag(cat, desired.getTags());
        float desiredLevel = this.getLevel(desiredTag);
        if (desiredTag == null) {
            desiredLevel = 10000.0f;
        }
        boolean longRange = desired.hasTag(LR);
        boolean shortRange = desired.hasTag(SR);
        boolean midRange = !longRange && !shortRange;
        boolean desiredPD = desired.getAIHints().contains((Object)WeaponAPI.AIHints.PD);
        WeightedRandomPicker<AutofitPlugin.AvailableWeapon> best = new WeightedRandomPicker<AutofitPlugin.AvailableWeapon>(this.random);
        int iter = 0;
        for (AutofitPlugin.AvailableWeapon w : possible) {
            float score;
            boolean worseDueToPriority;
            boolean currMidRange;
            ++iter;
            WeaponSpecAPI spec = w.getSpec();
            String catTag = this.getCategoryTag(cat, spec.getTags());
            if (catTag == null) continue;
            boolean currLongRange = spec.hasTag(LR);
            boolean currShortRange = spec.hasTag(SR);
            boolean bl = currMidRange = !currLongRange && !currShortRange;
            if (!desiredPD && currShortRange && (midRange || longRange)) continue;
            boolean isPrimaryCategory = cat.base.equals(spec.getAutofitCategory());
            boolean currIsPriority = isPrimaryCategory && delegate.isPriority(spec);
            int currSize = spec.getSize().ordinal();
            boolean betterDueToPriority = currSize >= bestSize && currIsPriority && !bestIsPriority;
            boolean bl2 = worseDueToPriority = currSize <= bestSize && !currIsPriority && bestIsPriority;
            if (worseDueToPriority) continue;
            float level = this.getLevel(catTag);
            if (!this.randomize && !useBetter && !betterDueToPriority && level > desiredLevel) continue;
            int rMag = 0;
            if (this.randomize && desired.getSize() == spec.getSize()) {
                rMag = 20;
            } else if (desired.getSize() == spec.getSize() && delegate.isAllowSlightRandomization()) {
                rMag = 4;
            }
            if (rMag > 0) {
                boolean symmetric;
                boolean bl3 = symmetric = this.random.nextFloat() < 0.75f;
                if (slot != null && symmetric) {
                    long seed = (long)Math.abs((int)(slot.getLocation().x / 2.0f)) * 723489413945245311L ^ 0x106689D45497FDB5L;
                    Random r = new Random((seed + this.weaponFilterSeed) * (long)iter);
                    level += (float)r.nextInt(rMag);
                } else {
                    level += (float)this.random.nextInt(rMag);
                }
            }
            if ((score = level) > bestScore || betterDueToPriority) {
                best.clear();
                best.add(w);
                bestScore = score;
                bestSize = currSize;
                bestIsPriority = currIsPriority;
                continue;
            }
            if (score != bestScore) continue;
            best.add(w);
        }
        ArrayList<AutofitPlugin.AvailableWeapon> allMatches = new ArrayList<AutofitPlugin.AvailableWeapon>();
        ArrayList<AutofitPlugin.AvailableWeapon> freeMatches = new ArrayList<AutofitPlugin.AvailableWeapon>();
        for (AutofitPlugin.AvailableWeapon w : best.getItems()) {
            if (!desired.getWeaponId().equals(w.getId())) continue;
            allMatches.add(w);
            if (!(w.getPrice() <= 0.0f)) continue;
            freeMatches.add(w);
        }
        if (!freeMatches.isEmpty()) {
            return (AutofitPlugin.AvailableWeapon)freeMatches.get(0);
        }
        if (!allMatches.isEmpty()) {
            return (AutofitPlugin.AvailableWeapon)allMatches.get(0);
        }
        boolean hasFree = false;
        boolean hasNonBlackMarket = false;
        for (AutofitPlugin.AvailableWeapon w : best.getItems()) {
            if (w.getPrice() <= 0.0f) {
                hasFree = true;
            }
            if (w.getSubmarket() != null && w.getSubmarket().getPlugin().isBlackMarket()) continue;
            hasNonBlackMarket = true;
        }
        if (hasFree) {
            for (AutofitPlugin.AvailableWeapon w : new ArrayList(best.getItems())) {
                if (!(w.getPrice() > 0.0f)) continue;
                best.remove(w);
            }
        } else if (hasNonBlackMarket) {
            for (AutofitPlugin.AvailableWeapon w : new ArrayList(best.getItems())) {
                if (w.getSubmarket() == null || !w.getSubmarket().getPlugin().isBlackMarket()) continue;
                best.remove(w);
            }
        }
        if (!alreadyUsed.isEmpty()) {
            for (AutofitPlugin.AvailableWeapon w : best.getItems()) {
                if (!alreadyUsed.contains(w.getId())) continue;
                return w;
            }
        }
        if (best.isEmpty()) {
            return null;
        }
        return (AutofitPlugin.AvailableWeapon)best.pick();
    }

    public AutofitPlugin.AvailableFighter getBestMatch(FighterWingSpecAPI desired, boolean useBetter, String catId, Set<String> alreadyUsed, List<AutofitPlugin.AvailableFighter> possible, AutofitPlugin.AutofitPluginDelegate delegate) {
        float bestScore = -1.0f;
        boolean bestIsPriority = false;
        Category cat = this.categories.get(catId);
        if (cat == null) {
            return null;
        }
        String desiredTag = this.getCategoryTag(cat, desired.getTags());
        float desiredLevel = this.getLevel(desiredTag);
        WeightedRandomPicker<AutofitPlugin.AvailableFighter> best = new WeightedRandomPicker<AutofitPlugin.AvailableFighter>(this.random);
        for (AutofitPlugin.AvailableFighter f : possible) {
            float score;
            boolean worseDueToPriority;
            FighterWingSpecAPI spec = f.getWingSpec();
            String catTag = this.getCategoryTag(cat, spec.getTags());
            if (catTag == null) continue;
            boolean isPrimaryCategory = cat.base.equals(spec.getAutofitCategory());
            boolean currIsPriority = isPrimaryCategory && delegate.isPriority(spec);
            boolean betterDueToPriority = currIsPriority && !bestIsPriority;
            boolean bl = worseDueToPriority = !currIsPriority && bestIsPriority;
            if (worseDueToPriority) continue;
            float level = this.getLevel(catTag);
            if (!this.randomize && !useBetter && !betterDueToPriority && level > desiredLevel) continue;
            int rMag = 0;
            if (this.randomize) {
                rMag = 20;
            } else if (delegate.isAllowSlightRandomization()) {
                rMag = 2;
            }
            if (rMag > 0) {
                level += (float)this.random.nextInt(rMag);
            }
            if ((score = level) > bestScore || betterDueToPriority) {
                best.clear();
                best.add(f);
                bestScore = score;
                bestScore = score;
                bestIsPriority = currIsPriority;
                continue;
            }
            if (score != bestScore) continue;
            best.add(f);
        }
        ArrayList<AutofitPlugin.AvailableFighter> allMatches = new ArrayList<AutofitPlugin.AvailableFighter>();
        ArrayList<AutofitPlugin.AvailableFighter> freeMatches = new ArrayList<AutofitPlugin.AvailableFighter>();
        for (AutofitPlugin.AvailableFighter f : best.getItems()) {
            if (!desired.getId().equals(f.getId())) continue;
            allMatches.add(f);
            if (!(f.getPrice() <= 0.0f)) continue;
            freeMatches.add(f);
        }
        if (!freeMatches.isEmpty()) {
            return (AutofitPlugin.AvailableFighter)freeMatches.get(0);
        }
        if (!allMatches.isEmpty()) {
            return (AutofitPlugin.AvailableFighter)allMatches.get(0);
        }
        boolean hasFree = false;
        boolean hasNonBlackMarket = false;
        for (AutofitPlugin.AvailableFighter f : best.getItems()) {
            if (f.getPrice() <= 0.0f) {
                hasFree = true;
            }
            if (f.getSubmarket() != null && f.getSubmarket().getPlugin().isBlackMarket()) continue;
            hasNonBlackMarket = true;
        }
        if (hasFree) {
            for (AutofitPlugin.AvailableFighter f : new ArrayList(best.getItems())) {
                if (!(f.getPrice() > 0.0f)) continue;
                best.remove(f);
            }
        } else if (hasNonBlackMarket) {
            for (AutofitPlugin.AvailableFighter f : new ArrayList(best.getItems())) {
                if (f.getSubmarket() == null || !f.getSubmarket().getPlugin().isBlackMarket()) continue;
                best.remove(f);
            }
        }
        if (!alreadyUsed.isEmpty()) {
            for (AutofitPlugin.AvailableFighter f : best.getItems()) {
                if (!alreadyUsed.contains(f.getId())) continue;
                return f;
            }
        }
        if (best.isEmpty()) {
            return null;
        }
        return (AutofitPlugin.AvailableFighter)best.pick();
    }

    public String getCategoryTag(Category cat, Set<String> tags) {
        String catTag = null;
        for (String tag : tags) {
            if (!cat.tags.contains(tag)) continue;
            catTag = tag;
            break;
        }
        return catTag;
    }

    public float getLevel(String tag) {
        Integer result = tagLevels.get(tag);
        if (result != null) {
            return result.intValue();
        }
        Category cat = this.categories.get(tag);
        if (cat == null) {
            tagLevels.put(tag, -1);
            return -1.0f;
        }
        try {
            result = (int)Float.parseFloat(tag.replaceAll(cat.base, ""));
            tagLevels.put(tag, result);
            return result.intValue();
        }
        catch (Throwable t) {
            tagLevels.put(tag, -1);
            return -1.0f;
        }
    }

    public List<WeaponSlotAPI> getWeaponSlotsInPriorityOrder(ShipVariantAPI current, ShipVariantAPI target, boolean upgradeMode) {
        ArrayList<WeaponSlotAPI> result = new ArrayList<WeaponSlotAPI>();
        for (WeaponSlotAPI slot : current.getHullSpec().getAllWeaponSlotsCopy()) {
            if (slot.isBuiltIn() || slot.isDecorative() || target.getWeaponId(slot.getId()) == null || !upgradeMode && current.getWeaponId(slot.getId()) != null) continue;
            result.add(slot);
        }
        Collections.sort(result, new Comparator<WeaponSlotAPI>(){

            @Override
            public int compare(WeaponSlotAPI w1, WeaponSlotAPI w2) {
                float s1 = CoreAutofitPlugin.this.getSlotPriorityScore(w1);
                float s2 = CoreAutofitPlugin.this.getSlotPriorityScore(w2);
                return (int)Math.signum(s2 - s1);
            }
        });
        return result;
    }

    public float getSlotPriorityScore(WeaponSlotAPI slot) {
        float score = 0.0f;
        switch (slot.getSlotSize()) {
            case LARGE: {
                score = 10000.0f;
                break;
            }
            case MEDIUM: {
                score = 5000.0f;
                break;
            }
            case SMALL: {
                score = 2500.0f;
            }
        }
        float angleDiff = Misc.getAngleDiff(slot.getAngle(), 0.0f);
        boolean front = Misc.isInArc(slot.getAngle(), slot.getArc(), 0.0f);
        if (front) {
            score += 180.0f - angleDiff;
        }
        return score;
    }

    public List<AutofitPlugin.AvailableWeapon> getPossibleWeapons(WeaponSlotAPI slot, WeaponSpecAPI desired, ShipVariantAPI current, float opLeft, List<AutofitPlugin.AvailableWeapon> weapons) {
        ArrayList<AutofitPlugin.AvailableWeapon> result = new ArrayList<AutofitPlugin.AvailableWeapon>();
        for (AutofitPlugin.AvailableWeapon w : weapons) {
            boolean guided;
            if (w.getQuantity() <= 0) continue;
            WeaponSpecAPI spec = w.getSpec();
            float cost = w.getOPCost(this.stats, current.getStatsForOpCosts());
            if (cost > opLeft || !slot.weaponFits(spec)) continue;
            if (spec != desired && (spec.getType() == WeaponAPI.WeaponType.MISSILE || spec.getAIHints().contains((Object)WeaponAPI.AIHints.STRIKE)) && !(guided = spec.getAIHints().contains((Object)WeaponAPI.AIHints.DO_NOT_AIM))) {
                boolean guidedPoor = spec.getAIHints().contains((Object)WeaponAPI.AIHints.GUIDED_POOR);
                float angleDiff = Misc.getDistanceFromArc(slot.getAngle(), slot.getArc(), 0.0f);
                if (angleDiff > 45.0f || !guidedPoor && angleDiff > 20.0f) continue;
            }
            result.add(w);
        }
        if (TutorialMissionIntel.isTutorialInProgress() && current.getHullSpec() != null && current.getHullSpec().hasTag("derelict")) {
            ArrayList<AutofitPlugin.AvailableWeapon> remove = new ArrayList<AutofitPlugin.AvailableWeapon>();
            for (AutofitPlugin.AvailableWeapon w : result) {
                if (!w.getId().equals("heatseeker")) continue;
                remove.add(w);
            }
            result.removeAll(remove);
        }
        return result;
    }

    public List<AutofitPlugin.AvailableFighter> getPossibleFighters(ShipVariantAPI current, float opLeft, List<AutofitPlugin.AvailableFighter> fighters) {
        ArrayList<AutofitPlugin.AvailableFighter> result = new ArrayList<AutofitPlugin.AvailableFighter>();
        for (AutofitPlugin.AvailableFighter f : fighters) {
            FighterWingSpecAPI spec;
            float cost;
            if (f.getQuantity() <= 0 || (cost = (spec = f.getWingSpec()).getOpCost(current.getStatsForOpCosts())) > opLeft) continue;
            result.add(f);
        }
        if (this.randomize) {
            Random filterRandom = new Random(this.weaponFilterSeed);
            int num = Math.max(1, result.size() / 3 * 2);
            Set<Integer> picks = DefaultFleetInflater.makePicks(num, result.size(), filterRandom);
            ArrayList<AutofitPlugin.AvailableFighter> filtered = new ArrayList<AutofitPlugin.AvailableFighter>();
            for (Integer pick : picks) {
                filtered.add((AutofitPlugin.AvailableFighter)result.get(pick));
            }
            result = filtered;
        }
        return result;
    }

    @Override
    public List<AutofitPlugin.AutofitOption> getOptions() {
        return this.options;
    }

    @Override
    public float getRating(ShipVariantAPI current, ShipVariantAPI target, AutofitPlugin.AutofitPluginDelegate delegate) {
        return 0.0f;
    }

    @Override
    public void doQuickAction(ShipVariantAPI current, AutofitPlugin.AutofitPluginDelegate delegate) {
        this.availableMods = new LinkedHashSet<String>(delegate.getAvailableHullmods());
        if (current.getHullSize().ordinal() >= ShipAPI.HullSize.DESTROYER.ordinal() && !current.isCivilian()) {
            this.addHullmods(current, delegate, "targetingunit");
        }
        this.addExtraVentsAndCaps(current, null);
        this.addDistributor(current, delegate);
        this.addDistributorRemoveVentsIfNeeded(current, delegate);
        this.addCoilRemoveCapsIfNeeded(current, delegate);
        this.addHullmods(current, delegate, "reinforcedhull", "blast_doors", "hardened_subsystems");
        if (!this.fittingModule) {
            delegate.syncUIWithVariant(current);
        }
    }

    @Override
    public String getQuickActionText() {
        return "\u81ea\u52a8\u88c5\u914d";
    }

    @Override
    public String getQuickActionTooltip() {
        return "\u5c06\u6240\u6709\u672a\u4f7f\u7528\u7684\u88c5\u914d\u70b9\u6295\u5165\u5230\u8017\u6563\u901a\u9053\u3001\u5e45\u80fd\u5bc4\u5b58\u5668\u4e0e\u5176\u4ed6\u5fc5\u8981\u7684\u8230\u8239\u63d2\u4ef6\u4e2d\u53bb\u3002\n\n\u4e0d\u4f1a\u5bf9\u6b66\u5668\u4ea7\u751f\u4efb\u4f55\u6539\u52a8\uff0c\u4e5f\u4e0d\u4f1a\u5f71\u54cd\u8230\u8239\u7684\u6a21\u5757 (\u5982\u679c\u6709)\uff0c\u4e14\u4e0d\u4f1a\u82b1\u8d39\u4efb\u4f55\u661f\u5e01\u3002";
    }

    @Override
    public boolean isQuickActionEnabled(ShipVariantAPI currentVariant) {
        int unusedOpTotal = 0;
        for (String slotId : currentVariant.getStationModules().keySet()) {
            ShipVariantAPI moduleCurrent = currentVariant.getModuleVariant(slotId);
            if (moduleCurrent == null) continue;
            unusedOpTotal += moduleCurrent.getUnusedOP(this.stats);
        }
        return (unusedOpTotal += currentVariant.getUnusedOP(this.stats)) > 0;
    }

    @Override
    public void autoAssignOfficers(CampaignFleetAPI fleet) {
        AutoAssignScore score;
        ArrayList<FleetMemberAPI> members = new ArrayList<FleetMemberAPI>();
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            if (member.isMothballed() || !member.getCaptain().isDefault() || fleet.isPlayerFleet() && Misc.isAutomated(member)) continue;
            members.add(member);
        }
        ArrayList<OfficerDataAPI> officers = new ArrayList<OfficerDataAPI>();
        int max = (int)fleet.getCommander().getStats().getOfficerNumber().getModifiedValue();
        int count = 0;
        for (OfficerDataAPI officer : fleet.getFleetData().getOfficersCopy()) {
            boolean merc = Misc.isMercenary(officer.getPerson());
            if (!merc) {
                ++count;
            }
            if (count > max && !merc) continue;
            boolean found = false;
            for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                if (member.getCaptain() != officer.getPerson()) continue;
                found = true;
                break;
            }
            if (found) continue;
            officers.add(officer);
        }
        ArrayList<AutoAssignScore> shipScores = new ArrayList<AutoAssignScore>();
        ArrayList<AutoAssignScore> officerScores = new ArrayList<AutoAssignScore>();
        float maxMemberTotal = 1.0f;
        float maxOfficerTotal = 1.0f;
        for (FleetMemberAPI member : members) {
            score = new AutoAssignScore();
            shipScores.add(score);
            score.member = member;
            score.score = this.computeMemberScore(member);
            maxMemberTotal = Math.max(maxMemberTotal, score.score[4]);
        }
        for (OfficerDataAPI officer : officers) {
            score = new AutoAssignScore();
            officerScores.add(score);
            score.officer = officer.getPerson();
            score.score = this.computeOfficerScore(officer.getPerson());
            maxOfficerTotal = Math.max(maxOfficerTotal, score.score[4]);
        }
        for (AutoAssignScore score2 : officerScores) {
            score2.score[4] = maxMemberTotal + (maxOfficerTotal - score2.score[4]);
        }
        while (!shipScores.isEmpty() && !officerScores.isEmpty()) {
            float minDist = Float.MAX_VALUE;
            AutoAssignScore bestShip = null;
            AutoAssignScore bestOfficer = null;
            for (AutoAssignScore ship : shipScores) {
                for (AutoAssignScore officer : officerScores) {
                    float dist = Math.abs(ship.score[0] - officer.score[0]) + Math.abs(ship.score[1] - officer.score[1]) + Math.abs(ship.score[2] - officer.score[2]) + Math.abs(ship.score[3] - officer.score[3]) + Math.abs(ship.score[4] - officer.score[4]);
                    if (!(dist < minDist)) continue;
                    minDist = dist;
                    bestShip = ship;
                    bestOfficer = officer;
                }
            }
            if (bestShip == null) break;
            shipScores.remove(bestShip);
            officerScores.remove(bestOfficer);
            bestShip.member.setCaptain(bestOfficer.officer);
        }
    }

    public float[] computeOfficerScore(PersonAPI officer) {
        float energy = 0.0f;
        float ballistic = 0.0f;
        float missile = 0.0f;
        float defense = 0.0f;
        float total = 0.0f;
        for (MutableCharacterStatsAPI.SkillLevelAPI sl : officer.getStats().getSkillsCopy()) {
            if (!sl.getSkill().isCombatOfficerSkill()) continue;
            float w = sl.getLevel();
            if (w == 2.0f) {
                w = 1.33f;
            }
            if (w <= 0.0f) continue;
            if (sl.getSkill().hasTag("energy_weapons")) {
                energy += 1.0f;
            } else if (sl.getSkill().hasTag("ballistic_weapons")) {
                ballistic += 1.0f;
            } else if (sl.getSkill().hasTag("missile_weapons")) {
                missile += 1.0f;
            } else if (sl.getSkill().hasTag("active_defenses")) {
                defense += 1.0f;
            }
            total += 1.0f;
        }
        if (total < 1.0f) {
            total = 1.0f;
        }
        float[] result = new float[]{energy /= total, ballistic /= total, missile /= total, defense /= total, total};
        return result;
    }

    public float[] computeMemberScore(FleetMemberAPI member) {
        float energy = 0.0f;
        float ballistic = 0.0f;
        float missile = 0.0f;
        float total = 0.0f;
        boolean civ = member.isCivilian();
        for (String slotId : member.getVariant().getFittedWeaponSlots()) {
            WeaponAPI.WeaponType type;
            WeaponSlotAPI slot = member.getVariant().getSlot(slotId);
            if (slot.isDecorative() || slot.isSystemSlot()) continue;
            WeaponSpecAPI weapon = member.getVariant().getWeaponSpec(slotId);
            float w = 1.0f;
            switch (weapon.getSize()) {
                case LARGE: {
                    w = 4.0f;
                    break;
                }
                case MEDIUM: {
                    w = 2.0f;
                    break;
                }
                case SMALL: {
                    w = 1.0f;
                }
            }
            if (civ) {
                w *= 0.1f;
            }
            if ((type = weapon.getType()) == WeaponAPI.WeaponType.BALLISTIC) {
                ballistic += w;
                total += w;
                continue;
            }
            if (type == WeaponAPI.WeaponType.ENERGY) {
                energy += w;
                total += w;
                continue;
            }
            if (type == WeaponAPI.WeaponType.MISSILE) {
                missile += w;
                total += w;
                continue;
            }
            total += w;
        }
        if (total < 1.0f) {
            total = 1.0f;
        }
        boolean d = member.getHullSpec().getShieldType() == ShieldAPI.ShieldType.FRONT || member.getHullSpec().getShieldType() == ShieldAPI.ShieldType.OMNI || member.getHullSpec().isPhase();
        float[] result = new float[]{energy /= total, ballistic /= total, missile /= total, d ? 1.0f : 0.0f, total};
        return result;
    }

    public float getVariantOPFraction(FleetMemberAPI member) {
        float f = 1.0f;
        float op = member.getVariant().getHullSpec().getOrdnancePoints(this.stats);
        if (op > 0.0f) {
            f = (op - (float)member.getVariant().getUnusedOP(this.stats)) / op;
        }
        return f;
    }

    public float getSkillTotal(OfficerDataAPI officer, boolean carrier) {
        float total = 0.0f;
        for (MutableCharacterStatsAPI.SkillLevelAPI skill : officer.getPerson().getStats().getSkillsCopy()) {
            float level;
            SkillSpecAPI spec = skill.getSkill();
            if (!spec.isCombatOfficerSkill() || (level = skill.getLevel()) <= 0.0f || carrier && !spec.hasTag("carrier")) continue;
            total += level;
        }
        return total;
    }

    protected int addRandomizedHullmodsPre(ShipVariantAPI current, AutofitPlugin.AutofitPluginDelegate delegate) {
        int num = 0;
        if (this.random.nextFloat() > 0.5f) {
            ++num;
            if (this.random.nextFloat() > 0.75f) {
                ++num;
            }
        }
        if (num <= 0) {
            return 0;
        }
        ShipHullSpecAPI hull = current.getHullSpec();
        boolean omni = hull.getShieldType() == ShieldAPI.ShieldType.OMNI;
        boolean front = hull.getShieldType() == ShieldAPI.ShieldType.FRONT;
        boolean shield = omni || front;
        boolean phase = hull.getShieldType() == ShieldAPI.ShieldType.PHASE;
        int bays = hull.getFighterBays();
        float shieldArc = hull.getShieldSpec().getArc();
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(this.random);
        if (this.availableMods.contains("frontemitter") && omni && shieldArc < 270.0f) {
            picker.add("frontemitter", 1.0f);
        }
        if (this.availableMods.contains("extendedshieldemitter") && shield && shieldArc <= 300.0f) {
            picker.add("extendedshieldemitter", 1.0f);
        }
        if (this.availableMods.contains("converted_hangar") && hull.getHullSize() != ShipAPI.HullSize.FRIGATE && bays <= 0) {
            FactionAPI faction = delegate.getFaction();
            if (faction == null) {
                if (this.random.nextFloat() < 0.2f) {
                    picker.add("converted_hangar", 1.0f);
                }
            } else if (this.random.nextFloat() < (float)faction.getDoctrine().getCarriers() / 5.0f) {
                picker.add("converted_hangar", 1.0f);
            }
        }
        if (this.availableMods.contains("frontshield") && !shield && !phase) {
            picker.add("frontshield", 1.0f);
        }
        if (this.availableMods.contains("expanded_deck_crew") && bays >= 2) {
            picker.add("expanded_deck_crew", 1.0f);
        }
        if (this.availableMods.contains("ecm")) {
            picker.add("ecm", 1.0f);
        }
        if (this.availableMods.contains("targetingunit")) {
            picker.add("targetingunit", 100.0f);
        } else if (this.availableMods.contains("dedicated_targeting_core") && hull.getHullSize().ordinal() >= ShipAPI.HullSize.CRUISER.ordinal()) {
            picker.add("dedicated_targeting_core", 100.0f);
        }
        if (this.availableMods.contains("hardenedshieldemitter") && shield) {
            picker.add("hardenedshieldemitter", 1.0f);
        }
        if (this.availableMods.contains("stabilizedshieldemitter") && shield) {
            picker.add("stabilizedshieldemitter", 1.0f);
        }
        if (this.availableMods.contains("heavyarmor")) {
            picker.add("heavyarmor", 1.0f);
        }
        if (this.availableMods.contains("insulatedengine") && !omni) {
            picker.add("insulatedengine", 1.0f);
        }
        if (this.availableMods.contains("fluxbreakers")) {
            if (shield) {
                picker.add("fluxbreakers", 1.0f);
            } else {
                picker.add("fluxbreakers", 10.0f);
            }
        }
        if (this.availableMods.contains("unstable_injector")) {
            picker.add("unstable_injector", 1.0f);
        }
        float addedTotal = 0.0f;
        float addedMax = (float)current.getHullSpec().getOrdnancePoints(this.stats) * 0.2f;
        int i = 0;
        while (i < num) {
            String modId = (String)picker.pickAndRemove();
            if (modId == null) break;
            if (current.hasHullMod(modId)) {
                --i;
            } else {
                if (modId.equals("extendedshieldemitter")) {
                    picker.remove("frontemitter");
                } else if (modId.equals("frontemitter") && shieldArc >= 180.0f) {
                    picker.remove("extendedshieldemitter");
                }
                addedTotal = this.addHullmods(current, delegate, modId);
                if (addedTotal >= addedMax) break;
            }
            ++i;
        }
        return (int)addedTotal;
    }

    protected int addRandomizedHullmodsPost(ShipVariantAPI current, AutofitPlugin.AutofitPluginDelegate delegate) {
        int num = 0;
        if (this.random.nextFloat() > 0.5f) {
            ++num;
            if (this.random.nextFloat() > 0.75f) {
                ++num;
            }
        }
        if (num <= 0) {
            return 0;
        }
        ShipHullSpecAPI hull = current.getHullSpec();
        boolean omni = hull.getShieldType() == ShieldAPI.ShieldType.OMNI;
        boolean front = hull.getShieldType() == ShieldAPI.ShieldType.FRONT;
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(this.random);
        if (this.availableMods.contains("armoredweapons")) {
            picker.add("armoredweapons", 1.0f);
        }
        if (this.availableMods.contains("missleracks") && this.missilesWithAmmoOnCurrent >= 2) {
            picker.add("missleracks", this.missilesWithAmmoOnCurrent);
        }
        if (this.availableMods.contains("eccm") && this.missilesWithAmmoOnCurrent >= 2) {
            picker.add("eccm", 1.0f);
        }
        float addedTotal = 0.0f;
        float addedMax = (float)current.getHullSpec().getOrdnancePoints(this.stats) * 0.2f;
        int i = 0;
        while (i < num) {
            String modId = (String)picker.pickAndRemove();
            if (modId == null) break;
            if (current.hasHullMod(modId)) {
                --i;
            } else {
                addedTotal = this.addHullmods(current, delegate, modId);
                if (addedTotal >= addedMax) break;
            }
            ++i;
        }
        return (int)addedTotal;
    }

    public static class AutoAssignScore {
        public float[] score;
        public FleetMemberAPI member;
        public PersonAPI officer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Category {
        public String base;
        public Set<String> tags = new HashSet<String>();
        public List<String> fallback = new ArrayList<String>();

        public Category(String base, Map<String, Category> categories) {
            this.base = base;
            categories.put(base, this);
            int i = 0;
            while (i < 100) {
                String id = String.valueOf(base) + i;
                this.tags.add(id);
                categories.put(id, this);
                ++i;
            }
        }

        public void addFallback(String ... categories) {
            String[] stringArray = categories;
            int n = categories.length;
            int n2 = 0;
            while (n2 < n) {
                String catId = stringArray[n2];
                this.fallback.add(catId);
                ++n2;
            }
        }
    }
}

