/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.util;

import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.util.CampaignEngineGlowIndividualEngine;
import com.fs.starfarer.api.util.CampaignEntityMovementUtil;
import com.fs.starfarer.api.util.ColorShifterUtil;
import com.fs.starfarer.api.util.ValueShifterUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class CampaignEngineGlowUtil
implements CampaignEntityMovementUtil.EngineGlowControls {
    public static String KEY1 = "key1";
    public static String KEY2 = "key2";
    public static String KEY3 = "key3";
    public static String KEY4 = "key4";
    public static String KEY5 = "key5";
    public static String KEY6 = "key6";
    protected List<CampaignEngineGlowIndividualEngine> engines = new ArrayList<CampaignEngineGlowIndividualEngine>();
    protected SectorEntityToken entity;
    protected ValueShifterUtil glowCoreMult = new ValueShifterUtil(1.0f);
    protected ValueShifterUtil glowFringeMult = new ValueShifterUtil(1.0f);
    protected ValueShifterUtil glowMult = new ValueShifterUtil(0.0f);
    protected ValueShifterUtil lengthMult = new ValueShifterUtil(0.0f);
    protected ValueShifterUtil widthMult = new ValueShifterUtil(0.0f);
    protected ValueShifterUtil flickerMult = new ValueShifterUtil(0.0f);
    protected ValueShifterUtil flickerRateMult = new ValueShifterUtil(1.0f);
    protected ValueShifterUtil textureScrollMult = new ValueShifterUtil(1.0f);
    protected ColorShifterUtil glowColorCore;
    protected ColorShifterUtil glowColorFringe;
    protected ColorShifterUtil flameColor;
    private float shiftRate;

    public CampaignEngineGlowUtil(SectorEntityToken entity, Color fringe, Color core, Color flame, float shiftRate) {
        this.entity = entity;
        this.shiftRate = shiftRate;
        this.glowColorCore = new ColorShifterUtil(core);
        this.glowColorFringe = new ColorShifterUtil(fringe);
        this.flameColor = new ColorShifterUtil(flame);
    }

    public void addEngine(CampaignEngineGlowIndividualEngine engine) {
        this.engines.add(engine);
    }

    public void showOtherAction() {
        this.glowMult.shift(KEY1, 1.5f, 1.0f, 1.0f, 1.0f);
        this.lengthMult.shift(KEY1, 0.33f, 1.0f, 1.0f, 1.0f);
        this.widthMult.shift(KEY1, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void showAccelerating() {
        this.glowMult.shift(KEY2, 1.0f, 1.0f, 1.0f, 1.0f);
        this.lengthMult.shift(KEY2, 1.0f, 1.0f, 1.0f, 1.0f);
        this.widthMult.shift(KEY2, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void showIdling() {
        this.glowMult.shift(KEY3, 0.5f, 1.0f, 1.0f, 1.0f);
        this.glowFringeMult.shift(KEY3, 1.5f, 1.0f, 1.0f, 1.0f);
        this.lengthMult.shift(KEY3, 0.25f, 1.0f, 1.0f, 1.0f);
        this.widthMult.shift(KEY3, 1.5f, 1.0f, 1.0f, 1.0f);
        this.glowColorCore.shift(KEY3, this.glowColorFringe.getBase(), 1.0f, 1.0f, 0.5f);
        this.glowColorFringe.shift(KEY3, Color.black, 1.0f, 1.0f, 0.5f);
        this.flameColor.shift(KEY3, Color.black, 1.0f, 1.0f, 0.75f);
    }

    public void showSuppressed() {
        this.glowMult.shift(KEY4, 0.5f, 1.0f, 1.0f, 1.0f);
        this.glowFringeMult.shift(KEY4, 0.5f, 1.0f, 1.0f, 1.0f);
        this.lengthMult.shift(KEY4, 0.25f, 1.0f, 1.0f, 1.0f);
        this.widthMult.shift(KEY4, 1.0f, 1.0f, 1.0f, 1.0f);
        float in = 0.5f;
        if (this.lengthMult.getCurr() <= 0.0f || this.widthMult.getCurr() <= 0.0f) {
            in = 0.0f;
        }
        this.glowColorCore.shift(KEY4, Color.black, in, 1.0f, 1.0f);
        this.glowColorFringe.shift(KEY4, Color.black, in, 1.0f, 1.0f);
        this.flameColor.shift(KEY4, Color.black, in, 1.0f, 1.0f);
    }

    public void advance(float amount) {
        float shiftAmount = amount * this.shiftRate;
        this.glowMult.advance(shiftAmount);
        this.glowFringeMult.advance(shiftAmount);
        this.glowCoreMult.advance(shiftAmount);
        this.lengthMult.advance(shiftAmount);
        this.widthMult.advance(shiftAmount);
        this.flickerMult.advance(shiftAmount);
        this.flickerRateMult.advance(shiftAmount);
        this.textureScrollMult.advance(shiftAmount);
        this.glowColorCore.advance(shiftAmount);
        this.glowColorFringe.advance(shiftAmount);
        this.flameColor.advance(shiftAmount);
        for (CampaignEngineGlowIndividualEngine engine : this.engines) {
            engine.advance(amount);
        }
    }

    public void render(float alphaMult) {
        for (CampaignEngineGlowIndividualEngine engine : this.engines) {
            engine.render(this.entity.getLocation(), this.entity.getFacing(), alphaMult);
        }
    }

    public ValueShifterUtil getGlowMult() {
        return this.glowMult;
    }

    public ValueShifterUtil getLengthMult() {
        return this.lengthMult;
    }

    public ValueShifterUtil getWidthMult() {
        return this.widthMult;
    }

    public ValueShifterUtil getTextureScrollMult() {
        return this.textureScrollMult;
    }

    public ColorShifterUtil getGlowColorCore() {
        return this.glowColorCore;
    }

    public ColorShifterUtil getGlowColorFringe() {
        return this.glowColorFringe;
    }

    public ColorShifterUtil getFlameColor() {
        return this.flameColor;
    }

    public ValueShifterUtil getFlickerMult() {
        return this.flickerMult;
    }

    public ValueShifterUtil getFlickerRateMult() {
        return this.flickerRateMult;
    }

    public ValueShifterUtil getGlowCoreMult() {
        return this.glowCoreMult;
    }

    public ValueShifterUtil getGlowFringeMult() {
        return this.glowFringeMult;
    }
}

