/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.util;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.MusicPlayerPlugin;
import com.fs.starfarer.api.campaign.AICoreAdminPlugin;
import com.fs.starfarer.api.campaign.AICoreOfficerPlugin;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignClockAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.CampaignUIAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CommDirectoryEntryAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.FleetInflater;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.ParticleControllerAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.ResourceCostPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.econ.AbandonMarketPlugin;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.ImmigrationPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.campaign.econ.StabilizeMarketPlugin;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventManagerAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.OfficerDataAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.combat.listeners.CombatListenerUtil;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.DModManager;
import com.fs.starfarer.api.impl.campaign.RuleBasedInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.WarningBeaconEntityPlugin;
import com.fs.starfarer.api.impl.campaign.abilities.ReversePolarityToggle;
import com.fs.starfarer.api.impl.campaign.econ.impl.ConstructionQueue;
import com.fs.starfarer.api.impl.campaign.econ.impl.ShipQuality;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.ids.MemFlags;
import com.fs.starfarer.api.impl.campaign.intel.FactionCommissionIntel;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.impl.campaign.intel.contacts.ContactIntel;
import com.fs.starfarer.api.impl.campaign.plog.PlaythroughLog;
import com.fs.starfarer.api.impl.campaign.plog.SModRecord;
import com.fs.starfarer.api.impl.campaign.population.CoreImmigrationPluginImpl;
import com.fs.starfarer.api.impl.campaign.procgen.DefenderDataOverride;
import com.fs.starfarer.api.impl.campaign.procgen.PlanetConditionGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.SalvageEntityGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.unsetAll;
import com.fs.starfarer.api.impl.campaign.submarkets.BaseSubmarketPlugin;
import com.fs.starfarer.api.impl.campaign.submarkets.StoragePlugin;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidSource;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTiledTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.DebrisFieldTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.MagneticFieldTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.PulsarBeamTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.StarCoronaTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamTerrainPlugin2;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.loading.IndustrySpecAPI;
import com.fs.starfarer.api.plugins.FactionPersonalityPickerPlugin;
import com.fs.starfarer.api.plugins.SurveyPlugin;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Pair;
import com.fs.starfarer.api.util.RuleException;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public class Misc {
    public static boolean CAN_SMOD_BUILT_IN = true;
    public static String SIR = "\u5148\u751f";
    public static String MAAM = "\u5973\u58eb";
    public static String CAPTAIN = "\u8230\u957f";
    public static float FLUX_PER_CAPACITOR = Global.getSettings().getFloat("fluxPerCapacitor");
    public static float DISSIPATION_PER_VENT = Global.getSettings().getFloat("dissipationPerVent");
    private static boolean cbMode = Global.getSettings().getBoolean("colorblindMode");
    public static Color MOUNT_BALLISTIC = Global.getSettings().getColor("mountYellowColor");
    public static Color MOUNT_MISSILE = Global.getSettings().getColor("mountGreenColor");
    public static Color MOUNT_ENERGY = cbMode ? new Color(155, 155, 155, 255) : Global.getSettings().getColor("mountBlueColor");
    public static Color MOUNT_UNIVERSAL = Global.getSettings().getColor("mountGrayColor");
    public static Color MOUNT_HYBRID = Global.getSettings().getColor("mountOrangeColor");
    public static Color MOUNT_SYNERGY = Global.getSettings().getColor("mountCyanColor");
    public static Color MOUNT_COMPOSITE = Global.getSettings().getColor("mountCompositeColor");
    public static final int OWNER_NEUTRAL = 100;
    public static final int OWNER_PLAYER = 0;
    public static Color FLOATY_EMP_DAMAGE_COLOR = new Color(255, 255, 255, 255);
    public static Color FLOATY_ARMOR_DAMAGE_COLOR = new Color(255, 255, 0, 220);
    public static Color FLOATY_SHIELD_DAMAGE_COLOR = new Color(200, 200, 255, 220);
    public static Color FLOATY_HULL_DAMAGE_COLOR = new Color(255, 50, 0, 220);
    public static float GATE_FUEL_COST_MULT = Global.getSettings().getFloat("gateTransitFuelCostMult");
    public static int MAX_COLONY_SIZE = Global.getSettings().getInt("maxColonySize");
    public static int OVER_MAX_INDUSTRIES_PENALTY = Global.getSettings().getInt("overMaxIndustriesPenalty");
    public static float FP_TO_BOMBARD_COST_APPROX_MULT = 12.0f;
    public static float FP_TO_GROUND_RAID_STR_APPROX_MULT = 6.0f;
    public static String UNKNOWN = " ";
    public static String UNSURVEYED = "??";
    public static String PRELIMINARY = "?";
    public static String FULL = "X";
    public static String STORY = "\u6545\u4e8b";
    public static float MAX_OFFICER_LEVEL = Global.getSettings().getFloat("officerMaxLevel");
    public static Random random = new Random();
    public static final Vector2f ZERO = new Vector2f(0.0f, 0.0f);
    private static Vector2f temp3 = new Vector2f();
    public static float DEG_PER_RAD = 57.295784f;
    public static float RAD_PER_DEG = (float)Math.PI / 180;
    protected static DecimalFormat format = null;
    private static Vector3f temp4 = new Vector3f();
    public static Color zeroColor = new Color(0, 0, 0, 0);
    public static final String ASTEROID_SOURCE = "misc_astrdSource";
    private static final AtomicLong seedUniquifier = new AtomicLong(8682522807148012L);
    public static final String D_HULL_SUFFIX = "_default_D";
    public static String FLEET_RETURNING_TO_DESPAWN = "$core_fleetReturningToDespawn";
    public static Map<String, Integer> variantToFPCache = new HashMap<String, Integer>();
    public static Map<String, String> variantToHullCache = new HashMap<String, String>();
    public static float MIN_TERRAIN_EFFECT_MULT = Global.getSettings().getFloat("minTerrainEffectMult");
    public static float BURN_PENALTY_MULT = Global.getSettings().getFloat("standardBurnPenaltyMult");
    public static float SAME_FACTION_BONUS = Global.getSettings().getFloat("accessibilitySameFactionBonus");
    public static float PER_UNIT_SHIPPING = Global.getSettings().getFloat("accessibilityPerUnitShipping");
    public static MusicPlayerPlugin musicPlugin = null;
    public static String DANGER_LEVEL_OVERRIDE = "$dangerLevelOverride";
    public static String MENTORED = "$mentored";
    public static final String IS_MERCENARY = "$isMercenary";
    public static final String MERCENARY_HIRE_TIMESTAMP = "$mercHireTS";
    public static final String CAPTAIN_UNREMOVABLE = "$captain_unremovable";
    public static String RECOVERY_TAGS_KEY = "$core_recoveryTags";
    public static int MAX_PERMA_MODS = Global.getSettings().getInt("maxPermanentHullmods");
    public static float SNEAK_BURN_MULT = Global.getSettings().getFloat("sneakBurnMult");
    public static String LAST_RAIDED_AT = "$lastRaidedAt";
    public static String DEFEAT_TRIGGERS = "$defeatTriggers";
    protected static Boolean canCheckVramNVIDIA = null;
    public static float IMPACT_VOLUME_MULT = Global.getSettings().getFloat("impactSoundVolumeMult");
    public static float FRINGE_THRESHOLD = 0.7f;

    public static List<Token> tokenize(String string) {
        ArrayList<Token> result = new ArrayList<Token>();
        boolean inQuote = false;
        boolean inOperator = false;
        StringBuffer currToken = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            String str;
            char curr = string.charAt(i);
            char next = '\u0000';
            if (i + 1 < string.length()) {
                next = string.charAt(i + 1);
            }
            boolean charEscaped = false;
            if (curr == '\\') {
                if (++i >= string.length()) {
                    throw new RuleException("Escape character at end of string in: [" + string + "]");
                }
                curr = string.charAt(i);
                if (i + 1 < string.length()) {
                    next = string.charAt(i + 1);
                }
                charEscaped = true;
            }
            if (curr == '\"' && !charEscaped) {
                boolean bl = inQuote = !inQuote;
                if (!inQuote && currToken.length() <= 0) {
                    result.add(new Token("", TokenType.LITERAL));
                } else if (currToken.length() > 0) {
                    str = currToken.toString();
                    if (!inQuote) {
                        result.add(new Token(str, TokenType.LITERAL));
                    } else if (str.startsWith("$")) {
                        result.add(new Token(str, TokenType.VARIABLE));
                    } else if (inOperator) {
                        result.add(new Token(str, TokenType.OPERATOR));
                    } else {
                        result.add(new Token(str, TokenType.LITERAL));
                    }
                }
                inOperator = false;
                currToken.delete(0, 1000000);
                continue;
            }
            if (!(inQuote || curr != ' ' && curr != '\t')) {
                if (currToken.length() > 0) {
                    str = currToken.toString();
                    if (str.startsWith("$")) {
                        result.add(new Token(str, TokenType.VARIABLE));
                    } else if (inOperator) {
                        result.add(new Token(str, TokenType.OPERATOR));
                    } else {
                        result.add(new Token(str, TokenType.LITERAL));
                    }
                }
                inOperator = false;
                currToken.delete(0, 1000000);
                continue;
            }
            if (!inQuote && Misc.isChinese(curr) != Misc.isChinese(next)) {
                currToken.append(curr);
                if (currToken.length() > 0) {
                    str = currToken.toString();
                    if (str.startsWith("$")) {
                        result.add(new Token(str, TokenType.VARIABLE));
                    } else if (inOperator) {
                        result.add(new Token(str, TokenType.OPERATOR));
                    } else {
                        result.add(new Token(str, TokenType.LITERAL));
                    }
                }
                inOperator = false;
                currToken.delete(0, 1000000);
                continue;
            }
            if (!(inQuote || inOperator || !Misc.isOperatorChar(curr) || curr == '-' && Misc.isDigit(next))) {
                if (currToken.length() > 0) {
                    str = currToken.toString();
                    if (str.startsWith("$")) {
                        result.add(new Token(str, TokenType.VARIABLE));
                    } else {
                        result.add(new Token(str, TokenType.LITERAL));
                    }
                }
                currToken.delete(0, 1000000);
                inOperator = true;
                if (charEscaped && curr == 'n') {
                    currToken.append("\n");
                    continue;
                }
                currToken.append(curr);
                continue;
            }
            if (!inQuote && inOperator && !Misc.isOperatorChar(curr)) {
                if (currToken.length() > 0) {
                    str = currToken.toString();
                    result.add(new Token(str, TokenType.OPERATOR));
                }
                currToken.delete(0, 1000000);
                inOperator = false;
                if (charEscaped && curr == 'n') {
                    currToken.append("\n");
                    continue;
                }
                currToken.append(curr);
                continue;
            }
            if (charEscaped && curr == 'n') {
                currToken.append("\n");
                continue;
            }
            currToken.append(curr);
        }
        if (inQuote) {
            throw new RuleException("Unmatched quotes in string: " + string + "]");
        }
        if (currToken.length() > 0) {
            String str = currToken.toString();
            if (str.startsWith("$")) {
                result.add(new Token(str, TokenType.VARIABLE));
            } else if (inOperator) {
                result.add(new Token(str, TokenType.OPERATOR));
            } else {
                result.add(new Token(str, TokenType.LITERAL));
            }
        }
        return result;
    }

    private static boolean isDigit(char c) {
        if (c == '\u0000') {
            return false;
        }
        String digits = "1234567890";
        return digits.contains("" + c);
    }

    private static boolean isOperatorChar(char c) {
        String operatorChars = "=<>!+-";
        return operatorChars.contains("" + c);
    }

    private static boolean isChinese(char c) {
        Character.UnicodeScript sc = Character.UnicodeScript.of(c);
        return sc == Character.UnicodeScript.HAN;
    }

    public static String ucFirst(String str) {
        if (str == null) {
            return "Null";
        }
        if (str.isEmpty()) {
            return "";
        }
        switch (str) {
            case "frigate": {
                return "\u62a4\u536b\u8230";
            }
            case "destroyer": {
                return "\u9a71\u9010\u8230";
            }
            case "cruiser": {
                return "\u5de1\u6d0b\u8230";
            }
            case "normal": {
                return "\u6b63\u5e38";
            }
            case "easy": {
                return "\u7b80\u5355";
            }
        }
        return ("" + str.charAt(0)).toUpperCase() + str.substring(1);
    }

    public static String lcFirst(String str) {
        if (str == null) {
            return "Null";
        }
        if (str.isEmpty()) {
            return "";
        }
        return ("" + str.charAt(0)).toLowerCase() + str.substring(1);
    }

    public static String replaceTokensFromMemory(String text, Map<String, MemoryAPI> memoryMap) {
        ArrayList<String> keySet = new ArrayList<String>(memoryMap.keySet());
        if (keySet.contains("local")) {
            keySet.remove("local");
            keySet.add(0, "local");
        }
        for (String key : keySet) {
            MemoryAPI memory = memoryMap.get(key);
            ArrayList<String> keys = new ArrayList<String>(memory.getKeys());
            Collections.sort(keys, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o2.length() - o1.length();
                }
            });
            for (String token : keys) {
                Object value = memory.get(token);
                if (value == null) {
                    value = "null";
                }
                if (!(value instanceof String) && !(value instanceof Boolean) && !(value instanceof Float) && !(value instanceof Integer)) continue;
                text = text.replaceAll("(?s)\\$" + Pattern.quote(key) + "\\." + Pattern.quote(token.substring(1)), value.toString());
                text = text.replaceAll("(?s)\\$" + Pattern.quote(token.substring(1)), value.toString());
            }
        }
        return text;
    }

    public static float getDistance(SectorEntityToken from, SectorEntityToken to) {
        return Misc.getDistance(from.getLocation(), to.getLocation());
    }

    public static float getDistanceLY(SectorEntityToken from, SectorEntityToken to) {
        return Misc.getDistanceLY(from.getLocationInHyperspace(), to.getLocationInHyperspace());
    }

    public static float getDistance(Vector2f v1, Vector2f v2) {
        return (float)Math.sqrt((v1.x - v2.x) * (v1.x - v2.x) + (v1.y - v2.y) * (v1.y - v2.y));
    }

    public static float getDistanceSq(Vector2f v1, Vector2f v2) {
        return (v1.x - v2.x) * (v1.x - v2.x) + (v1.y - v2.y) * (v1.y - v2.y);
    }

    public static float getDistance(float x1, float y1, float x2, float y2) {
        return (float)Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public static float getDistanceToPlayerLY(Vector2f locInHyper) {
        if (Global.getSector().getPlayerFleet() == null) {
            return 100000.0f;
        }
        return Misc.getDistanceLY(Global.getSector().getPlayerFleet().getLocationInHyperspace(), locInHyper);
    }

    public static float getDistanceToPlayerLY(SectorEntityToken other) {
        if (Global.getSector().getPlayerFleet() == null) {
            return 100000.0f;
        }
        return Misc.getDistanceLY(Global.getSector().getPlayerFleet().getLocationInHyperspace(), other.getLocationInHyperspace());
    }

    public static float getDistanceLY(Vector2f v1, Vector2f v2) {
        return Vector2f.sub((Vector2f)v1, (Vector2f)v2, (Vector2f)temp3).length() / Misc.getUnitsPerLightYear();
    }

    public static float getRounded(float in) {
        if (in <= 10.0f) {
            return Math.max(1, (int)in);
        }
        float pow = (int)Math.log10(in);
        float div = (float)Math.pow(10.0, Math.max(0.0f, pow - 1.0f));
        if (pow == 1.0f) {
            div = 10.0f;
        }
        return (float)Math.round(in / div) * div;
    }

    public static String getRoundedValue(float value) {
        if (Math.abs((float)Math.round(value) - value) < 1.0E-4f) {
            return String.format("%d", Math.round(value));
        }
        if (Math.round(value * 100.0f) == Math.round(value * 10.0f) * 10) {
            return value > 10.0f || value < -10.0f ? "" + Math.round(value) : String.format("%.1f", Float.valueOf(value));
        }
        return value > 10.0f || value < -10.0f ? "" + Math.round(value) : String.format("%.2f", Float.valueOf(value));
    }

    public static float getRoundedValueFloat(float value) {
        if (Math.abs((float)Math.round(value) - value) < 1.0E-4f) {
            return Math.round(value);
        }
        if (Math.round(value * 100.0f) == Math.round(value * 10.0f) * 10) {
            return value > 10.0f || value < -10.0f ? (float)Math.round(value) : (float)Math.round(value * 10.0f) / 10.0f;
        }
        return value > 10.0f || value < -10.0f ? (float)Math.round(value) : (float)Math.round(value * 100.0f) / 100.0f;
    }

    public static String getRoundedValueMaxOneAfterDecimal(float value) {
        if (Math.abs((float)Math.round(value) - value) < 1.0E-4f) {
            return String.format("%d", Math.round(value));
        }
        if (Math.round(value * 100.0f) == Math.round(value * 10.0f) * 10) {
            return value >= 10.0f || value <= -10.0f ? "" + Math.round(value) : String.format("%.1f", Float.valueOf(value));
        }
        return value >= 10.0f || value <= -10.0f ? "" + Math.round(value) : String.format("%.1f", Float.valueOf(value));
    }

    public static String getRoundedValueOneAfterDecimalIfNotWhole(float value) {
        if (Math.abs((float)Math.round(value) - value) < 1.0E-4f) {
            return String.format("%d", Math.round(value));
        }
        return String.format("%.1f", Float.valueOf(value));
    }

    public static float logOfBase(float base, float num) {
        return (float)(Math.log(num) / Math.log(base));
    }

    public static Vector2f getPointAtRadius(Vector2f from, float r) {
        float angle = (float)((double)((float)Math.random()) * Math.PI * 2.0);
        float x = (float)(Math.cos(angle) * (double)r) + from.x;
        float y = (float)(Math.sin(angle) * (double)r) + from.y;
        return new Vector2f(x, y);
    }

    public static Vector2f getPointAtRadius(Vector2f from, float r, Random random) {
        float angle = (float)((double)random.nextFloat() * Math.PI * 2.0);
        float x = (float)(Math.cos(angle) * (double)r) + from.x;
        float y = (float)(Math.sin(angle) * (double)r) + from.y;
        return new Vector2f(x, y);
    }

    public static Vector2f getPointWithinRadius(Vector2f from, float r) {
        return Misc.getPointWithinRadius(from, r, random);
    }

    public static Vector2f getPointWithinRadius(Vector2f from, float r, Random random) {
        float angle = (float)((double)random.nextFloat() * Math.PI * 2.0);
        float x = (float)(Math.cos(angle) * (double)(r *= random.nextFloat())) + from.x;
        float y = (float)(Math.sin(angle) * (double)r) + from.y;
        return new Vector2f(x, y);
    }

    public static Vector2f getPointWithinRadiusUniform(Vector2f from, float r, Random random) {
        r = (float)((double)r * Math.sqrt(random.nextFloat()));
        float angle = (float)((double)random.nextFloat() * Math.PI * 2.0);
        float x = (float)(Math.cos(angle) * (double)r) + from.x;
        float y = (float)(Math.sin(angle) * (double)r) + from.y;
        return new Vector2f(x, y);
    }

    public static Vector2f getPointWithinRadiusUniform(Vector2f from, float minR, float maxR, Random random) {
        float r = (float)((double)minR + (double)(maxR - minR) * Math.sqrt(random.nextFloat()));
        float angle = (float)((double)random.nextFloat() * Math.PI * 2.0);
        float x = (float)(Math.cos(angle) * (double)r) + from.x;
        float y = (float)(Math.sin(angle) * (double)r) + from.y;
        return new Vector2f(x, y);
    }

    public static float getSnapshotFPLost(CampaignFleetAPI fleet) {
        float fp = fleet.getFleetPoints();
        float before = 0.0f;
        for (FleetMemberAPI member : fleet.getFleetData().getSnapshot()) {
            before += (float)member.getFleetPointCost();
        }
        return before - fp;
    }

    public static List<FleetMemberAPI> getSnapshotMembersLost(CampaignFleetAPI fleet) {
        ArrayList<FleetMemberAPI> lost = new ArrayList<FleetMemberAPI>();
        List<FleetMemberAPI> curr = fleet.getFleetData().getMembersListCopy();
        for (FleetMemberAPI member : fleet.getFleetData().getSnapshot()) {
            if (curr.contains(member)) continue;
            lost.add(member);
        }
        return lost;
    }

    public static CampaignEventPlugin startEvent(CampaignEventTarget eventTarget, String eventId, Object params) {
        CampaignEventManagerAPI manager = Global.getSector().getEventManager();
        CampaignEventPlugin event = manager.getOngoingEvent(eventTarget, eventId);
        if (event == null) {
            event = manager.startEvent(eventTarget, eventId, params);
        }
        return event;
    }

    public static Color getStoryDarkBrighterColor() {
        return Misc.setAlpha(Misc.scaleColorOnly(Misc.getStoryOptionColor(), 0.65f), 255);
    }

    public static Color getStoryDarkColor() {
        return Misc.setAlpha(Misc.scaleColorOnly(Misc.getStoryOptionColor(), 0.4f), 175);
    }

    public static Color getStoryBrightColor() {
        Color bright = Misc.interpolateColor(Misc.getStoryOptionColor(), Misc.setAlpha(Color.white, 255), 0.35f);
        return bright;
    }

    public static Color getStoryOptionColor() {
        return Global.getSettings().getColor("storyOptionColor");
    }

    public static Color getHighlightedOptionColor() {
        return Global.getSettings().getColor("buttonShortcut");
    }

    public static Color getHighlightColor() {
        return Global.getSettings().getColor("buttonShortcut");
    }

    public static Color getDarkHighlightColor() {
        Color hc = Misc.getHighlightColor();
        return Misc.setAlpha(hc, 255);
    }

    public static Color getTooltipTitleAndLightHighlightColor() {
        return Global.getSettings().getColor("tooltipTitleAndLightHighlightColor");
    }

    public static Color getNegativeHighlightColor() {
        if (Global.getSettings().getBoolean("colorblindMode")) {
            return new Color(0, 100, 255);
        }
        return Global.getSettings().getColor("textEnemyColor");
    }

    public static Color getBallisticMountColor() {
        return Global.getSettings().getColor("mountYellowColor");
    }

    public static Color getMissileMountColor() {
        return Global.getSettings().getColor("mountGreenColor");
    }

    public static Color getEnergyMountColor() {
        if (Global.getSettings().getBoolean("colorblindMode")) {
            return new Color(155, 155, 155, 255);
        }
        return Global.getSettings().getColor("mountBlueColor");
    }

    public static Color getPositiveHighlightColor() {
        return Global.getSettings().getColor("textFriendColor");
    }

    public static Color getGrayColor() {
        return Global.getSettings().getColor("textGrayColor");
    }

    public static Color getBrightPlayerColor() {
        return Global.getSector().getPlayerFaction().getBrightUIColor();
    }

    public static Color getBasePlayerColor() {
        return Global.getSector().getPlayerFaction().getBaseUIColor();
    }

    public static Color getDarkPlayerColor() {
        return Global.getSector().getPlayerFaction().getDarkUIColor();
    }

    public static Color getTextColor() {
        return Global.getSettings().getColor("standardTextColor");
    }

    public static Color getButtonTextColor() {
        return Global.getSettings().getColor("buttonText");
    }

    public static float getUnitsPerLightYear() {
        return Global.getSettings().getFloat("unitsPerLightYear");
    }

    public static float getProfitMarginFlat() {
        return Global.getSettings().getFloat("profitMarginFlat");
    }

    public static float getProfitMarginMult() {
        return Global.getSettings().getFloat("profitMarginMult");
    }

    public static float getEconomyInterval() {
        return Global.getSettings().getFloat("economyIntervalnGameDays");
    }

    public static float getGenericRollingAverageFactor() {
        return Global.getSettings().getFloat("genericRollingAverageFactor");
    }

    public static IntervalUtil createEconIntervalTracker() {
        float interval = Misc.getEconomyInterval();
        return new IntervalUtil(interval * 0.75f, interval * 1.25f);
    }

    public static String getAndJoined(List<String> strings) {
        return Misc.getAndJoined(strings.toArray(new String[0]));
    }

    public static String getAndJoined(String ... strings) {
        return Misc.getJoined("\u548c", strings);
    }

    public static String getJoined(String joiner, List<String> strings) {
        return Misc.getJoined(joiner, strings.toArray(new String[0]));
    }

    public static String getJoined(String joiner, String ... strings) {
        if (strings.length == 1) {
            return strings[0];
        }
        String result = "";
        for (int i = 0; i < strings.length - 1; ++i) {
            result = result + strings[i] + ", ";
        }
        if (!result.isEmpty()) {
            result = result.substring(0, result.length() - 2);
        }
        if (strings.length > 2) {
            result = joiner.isEmpty() ? result + ", " + strings[strings.length - 1] : result + ", " + joiner + " " + strings[strings.length - 1];
        } else if (strings.length == 2) {
            result = joiner.isEmpty() ? result + ", " + strings[strings.length - 1] : result + " " + joiner + " " + strings[strings.length - 1];
        }
        return result;
    }

    public static List<CampaignFleetAPI> findNearbyFleets(SectorEntityToken from, float maxRange, FleetFilter filter) {
        ArrayList<CampaignFleetAPI> result = new ArrayList<CampaignFleetAPI>();
        for (CampaignFleetAPI fleet : from.getContainingLocation().getFleets()) {
            float dist;
            if (fleet == from || (dist = Misc.getDistance(fleet.getLocation(), from.getLocation())) > maxRange || filter != null && !filter.accept(fleet)) continue;
            result.add(fleet);
        }
        return result;
    }

    public static List<CampaignFleetAPI> getFleetsInOrNearSystem(StarSystemAPI system) {
        ArrayList<CampaignFleetAPI> result = new ArrayList<CampaignFleetAPI>(system.getFleets());
        for (CampaignFleetAPI fleet : Global.getSector().getHyperspace().getFleets()) {
            if (!fleet.isInOrNearSystem(system)) continue;
            result.add(fleet);
        }
        return result;
    }

    public static List<MarketAPI> getMarketsInLocation(LocationAPI location, String factionId) {
        ArrayList<MarketAPI> result = new ArrayList<MarketAPI>();
        for (MarketAPI curr : Misc.getMarketsInLocation(location)) {
            if (!curr.getFactionId().equals(factionId)) continue;
            result.add(curr);
        }
        return result;
    }

    public static MarketAPI getBiggestMarketInLocation(LocationAPI location) {
        int max = 0;
        MarketAPI best = null;
        for (MarketAPI curr : Misc.getMarketsInLocation(location)) {
            int size = curr.getSize();
            if (size <= max && (size != max || !curr.getFaction().isPlayerFaction())) continue;
            max = size;
            best = curr;
        }
        return best;
    }

    public static List<MarketAPI> getMarketsInLocation(LocationAPI location) {
        if (location == null) {
            return new ArrayList<MarketAPI>();
        }
        return Global.getSector().getEconomy().getMarkets(location);
    }

    public static List<MarketAPI> getFactionMarkets(FactionAPI faction, String econGroup) {
        ArrayList<MarketAPI> result = new ArrayList<MarketAPI>();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsInGroup(econGroup)) {
            if (market.getFaction() != faction) continue;
            result.add(market);
        }
        return result;
    }

    public static List<MarketAPI> getPlayerMarkets(boolean includeNonPlayerFaction) {
        FactionAPI player = Global.getSector().getFaction("player");
        ArrayList<MarketAPI> result = new ArrayList<MarketAPI>();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (market.getFaction() == player) {
                result.add(market);
                continue;
            }
            if (!includeNonPlayerFaction || !market.isPlayerOwned()) continue;
            result.add(market);
        }
        return result;
    }

    public static List<StarSystemAPI> getPlayerSystems(boolean includeNonPlayerFaction) {
        return Misc.getSystemsWithPlayerColonies(includeNonPlayerFaction);
    }

    public static List<StarSystemAPI> getSystemsWithPlayerColonies(boolean includeNonPlayerFaction) {
        List<MarketAPI> markets = Misc.getPlayerMarkets(includeNonPlayerFaction);
        ArrayList<StarSystemAPI> systems = new ArrayList<StarSystemAPI>();
        for (MarketAPI market : markets) {
            StarSystemAPI system = market.getStarSystem();
            if (system == null || systems.contains(system)) continue;
            systems.add(system);
        }
        return systems;
    }

    public static List<MarketAPI> getFactionMarkets(String factionId) {
        return Misc.getFactionMarkets(Global.getSector().getFaction(factionId));
    }

    public static List<MarketAPI> getFactionMarkets(FactionAPI faction) {
        ArrayList<MarketAPI> result = new ArrayList<MarketAPI>();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (market.getFaction() != faction) continue;
            result.add(market);
        }
        return result;
    }

    public static List<MarketAPI> getNearbyMarkets(Vector2f locInHyper, float distLY) {
        ArrayList<MarketAPI> result = new ArrayList<MarketAPI>();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            float dist = Misc.getDistanceLY(market.getLocationInHyperspace(), locInHyper);
            if (dist > distLY) continue;
            result.add(market);
        }
        return result;
    }

    public static int getNumHostileMarkets(FactionAPI faction, SectorEntityToken from, float maxDist) {
        int hostileMarketsNearPoint = 0;
        for (MarketAPI market : Misc.getMarketsInLocation(from.getContainingLocation())) {
            SectorEntityToken primary = market.getPrimaryEntity();
            float dist = Misc.getDistance(primary.getLocation(), from.getLocation());
            if (dist > maxDist || market.getFaction() == null || !market.getFaction().isHostileTo(faction)) continue;
            ++hostileMarketsNearPoint;
        }
        return hostileMarketsNearPoint;
    }

    public static List<StarSystemAPI> getNearbyStarSystems(SectorEntityToken token, float maxRangeLY) {
        ArrayList<StarSystemAPI> result = new ArrayList<StarSystemAPI>();
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            float dist = Misc.getDistanceLY(token.getLocationInHyperspace(), system.getLocation());
            if (dist > maxRangeLY) continue;
            result.add(system);
        }
        return result;
    }

    public static StarSystemAPI getNearbyStarSystem(SectorEntityToken token, float maxRangeLY) {
        if (token.getContainingLocation() instanceof StarSystemAPI) {
            return (StarSystemAPI)token.getContainingLocation();
        }
        StarSystemAPI closest = null;
        float minDist = Float.MAX_VALUE;
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            float dist = Misc.getDistanceLY(token.getLocationInHyperspace(), system.getLocation());
            if (dist > maxRangeLY || !(dist < minDist)) continue;
            minDist = dist;
            closest = system;
        }
        return closest;
    }

    public static StarSystemAPI getNearestStarSystem(SectorEntityToken token) {
        if (token.getContainingLocation() instanceof StarSystemAPI) {
            return (StarSystemAPI)token.getContainingLocation();
        }
        float minDist = Float.MAX_VALUE;
        StarSystemAPI closest = null;
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            float dist = Misc.getDistanceLY(token.getLocationInHyperspace(), system.getLocation());
            if (!(dist < minDist)) continue;
            minDist = dist;
            closest = system;
        }
        return closest;
    }

    public static StarSystemAPI getNearbyStarSystem(SectorEntityToken token) {
        if (token.getContainingLocation() instanceof StarSystemAPI) {
            return (StarSystemAPI)token.getContainingLocation();
        }
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            if (!token.isInOrNearSystem(system)) continue;
            return system;
        }
        return null;
    }

    public static boolean showRuleDialog(SectorEntityToken entity, String initialTrigger) {
        RuleBasedInteractionDialogPluginImpl plugin = initialTrigger != null ? new RuleBasedInteractionDialogPluginImpl(initialTrigger) : new RuleBasedInteractionDialogPluginImpl();
        return Global.getSector().getCampaignUI().showInteractionDialog(plugin, entity);
    }

    public static float getAngleInDegreesStrict(Vector2f v) {
        float angle = (float)Math.atan2(v.y, v.x) * DEG_PER_RAD;
        return angle;
    }

    public static float getAngleInDegreesStrict(Vector2f from, Vector2f to) {
        float dx = to.x - from.x;
        float dy = to.y - from.y;
        float angle = (float)Math.atan2(dy, dx) * DEG_PER_RAD;
        return angle;
    }

    public static float getAngleInDegrees(Vector2f v) {
        return Global.getSettings().getAngleInDegreesFast(v);
    }

    public static float getAngleInDegrees(Vector2f from, Vector2f to) {
        return Global.getSettings().getAngleInDegreesFast(from, to);
    }

    public static Vector2f normalise(Vector2f v) {
        if (v.lengthSquared() > Float.MIN_VALUE) {
            return (Vector2f)v.normalise();
        }
        return new Vector2f(1.0f, 0.0f);
    }

    public static float normalizeAngle(float angleDeg) {
        return (angleDeg % 360.0f + 360.0f) % 360.0f;
    }

    public static MarketAPI findNearestLocalMarket(SectorEntityToken token, float maxDist, BaseEventPlugin.MarketFilter filter) {
        List<MarketAPI> localMarkets = Misc.getMarketsInLocation(token.getContainingLocation());
        float distToLocalMarket = Float.MAX_VALUE;
        MarketAPI closest = null;
        for (MarketAPI market : localMarkets) {
            float currDist;
            if (filter != null && !filter.acceptMarket(market) || market.getPrimaryEntity() == null || market.getPrimaryEntity().getContainingLocation() != token.getContainingLocation() || (currDist = Misc.getDistance(market.getPrimaryEntity().getLocation(), token.getLocation())) > maxDist || !(currDist < distToLocalMarket)) continue;
            distToLocalMarket = currDist;
            closest = market;
        }
        return closest;
    }

    public static List<MarketAPI> findNearbyLocalMarkets(SectorEntityToken token, float maxDist, BaseEventPlugin.MarketFilter filter) {
        List<MarketAPI> localMarkets = Misc.getMarketsInLocation(token.getContainingLocation());
        ArrayList<MarketAPI> result = new ArrayList<MarketAPI>();
        for (MarketAPI market : localMarkets) {
            float currDist;
            if (filter != null && !filter.acceptMarket(market) || market.getPrimaryEntity() == null || market.getPrimaryEntity().getContainingLocation() != token.getContainingLocation() || (currDist = Misc.getDistance(market.getPrimaryEntity().getLocation(), token.getLocation())) > maxDist) continue;
            result.add(market);
        }
        return result;
    }

    public static MarketAPI findNearestLocalMarketWithSameFaction(final SectorEntityToken token, float maxDist) {
        return Misc.findNearestLocalMarket(token, maxDist, new BaseEventPlugin.MarketFilter(){

            @Override
            public boolean acceptMarket(MarketAPI curr) {
                return curr.getFaction() == token.getFaction();
            }
        });
    }

    public static Vector2f getUnitVector(Vector2f from, Vector2f to) {
        return Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(from, to));
    }

    public static Vector2f getUnitVectorAtDegreeAngle(float degrees) {
        Vector2f result = new Vector2f();
        float radians = degrees * RAD_PER_DEG;
        result.x = (float)Math.cos(radians);
        result.y = (float)Math.sin(radians);
        return result;
    }

    public static Vector2f rotateAroundOrigin(Vector2f v, float angle) {
        float cos = (float)Math.cos(angle * RAD_PER_DEG);
        float sin = (float)Math.sin(angle * RAD_PER_DEG);
        Vector2f r = new Vector2f();
        r.x = v.x * cos - v.y * sin;
        r.y = v.x * sin + v.y * cos;
        return r;
    }

    public static Vector2f rotateAroundOrigin(Vector2f v, float angle, Vector2f origin) {
        float cos = (float)Math.cos(angle * RAD_PER_DEG);
        float sin = (float)Math.sin(angle * RAD_PER_DEG);
        Vector2f r = Vector2f.sub((Vector2f)v, (Vector2f)origin, (Vector2f)new Vector2f());
        Vector2f r2 = new Vector2f();
        r2.x = r.x * cos - r.y * sin;
        r2.y = r.x * sin + r.y * cos;
        Vector2f.add((Vector2f)r2, (Vector2f)origin, (Vector2f)r2);
        return r2;
    }

    public static boolean isBetween(float one, float two, float check) {
        one = Misc.normalizeAngle(one);
        two = Misc.normalizeAngle(two);
        if ((check = Misc.normalizeAngle(check)) >= one && check <= two) {
            return true;
        }
        if (one > two) {
            if (check <= two) {
                return true;
            }
            if (check >= one) {
                return true;
            }
        }
        return false;
    }

    public static float getShieldedCargoFraction(CampaignFleetAPI fleet) {
        float shielded = 0.0f;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            if (member.isMothballed() || !member.getVariant().hasHullMod("shielded_holds")) continue;
            shielded += member.getCargoCapacity();
        }
        float max = fleet.getCargo().getMaxCapacity();
        if (max < 1.0f) {
            return 0.0f;
        }
        return shielded / max;
    }

    public static Color interpolateColor(Color from, Color to, float progress) {
        float red = (float)from.getRed() + ((float)to.getRed() - (float)from.getRed()) * progress;
        float green = (float)from.getGreen() + ((float)to.getGreen() - (float)from.getGreen()) * progress;
        float blue = (float)from.getBlue() + ((float)to.getBlue() - (float)from.getBlue()) * progress;
        float alpha = (float)from.getAlpha() + ((float)to.getAlpha() - (float)from.getAlpha()) * progress;
        red = Math.round(red);
        green = Math.round(green);
        blue = Math.round(blue);
        alpha = Math.round(alpha);
        return new Color((int)red, (int)green, (int)blue, (int)alpha);
    }

    public static Color genColor(Color min, Color max, Random random) {
        Color color = new Color((int)((double)min.getRed() + (double)(max.getRed() - min.getRed()) * random.nextDouble()), (int)((double)min.getGreen() + (double)(max.getGreen() - min.getGreen()) * random.nextDouble()), (int)((double)min.getBlue() + (double)(max.getBlue() - min.getBlue()) * random.nextDouble()), 255);
        return color;
    }

    public static Vector2f interpolateVector(Vector2f from, Vector2f to, float progress) {
        Vector2f v = new Vector2f((ReadableVector2f)from);
        v.x += (to.x - from.x) * progress;
        v.y += (to.y - from.y) * progress;
        return v;
    }

    public static float interpolate(float from, float to, float progress) {
        to = from + (to - from) * progress;
        return to;
    }

    public static Color scaleColor(Color color, float factor) {
        return new Color((int)((float)color.getRed() * factor), (int)((float)color.getGreen() * factor), (int)((float)color.getBlue() * factor), (int)((float)color.getAlpha() * factor));
    }

    public static Color scaleColorOnly(Color color, float factor) {
        return new Color((int)((float)color.getRed() * factor), (int)((float)color.getGreen() * factor), (int)((float)color.getBlue() * factor), color.getAlpha());
    }

    public static Color scaleAlpha(Color color, float factor) {
        return new Color((int)((float)color.getRed() * 1.0f), (int)((float)color.getGreen() * 1.0f), (int)((float)color.getBlue() * 1.0f), (int)((float)color.getAlpha() * factor));
    }

    public static Color setAlpha(Color color, int alpha) {
        if (alpha < 0) {
            alpha = 0;
        }
        if (alpha > 255) {
            alpha = 255;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static float getSizeNum(ShipAPI.HullSize size) {
        if (size == null) {
            return 1.0f;
        }
        switch (size) {
            case CAPITAL_SHIP: {
                return 5.0f;
            }
            case CRUISER: {
                return 3.0f;
            }
            case DESTROYER: {
                return 2.0f;
            }
            case FIGHTER: 
            case FRIGATE: 
            case DEFAULT: {
                return 1.0f;
            }
        }
        return 1.0f;
    }

    public static void unsetAll(String prefix, String memKey, MemoryAPI memory) {
        HashMap<String, MemoryAPI> memoryMap = new HashMap<String, MemoryAPI>();
        memoryMap.put(memKey, memory);
        new unsetAll().execute(null, null, Misc.tokenize(prefix), memoryMap);
    }

    public static float getTargetingRadius(Vector2f from, CombatEntityAPI target, boolean considerShield) {
        return Global.getSettings().getTargetingRadius(from, target, considerShield);
    }

    public static float getClosingSpeed(Vector2f p1, Vector2f p2, Vector2f v1, Vector2f v2) {
        Vector2f dir = Vector2f.sub((Vector2f)p1, (Vector2f)p2, (Vector2f)new Vector2f());
        Misc.normalise(dir);
        Vector2f relVel = Vector2f.sub((Vector2f)v2, (Vector2f)v1, (Vector2f)new Vector2f());
        float closingSpeed = Vector2f.dot((Vector2f)dir, (Vector2f)relVel);
        return closingSpeed;
    }

    public static DecimalFormat getFormat() {
        if (format == null) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.getDefault());
            format = new DecimalFormat("###,###,###,###,###", symbols);
        }
        return format;
    }

    public static String getWithDGS(float num) {
        return Misc.getFormat().format(num);
    }

    public static String getDGSCredits(float num) {
        return Misc.getFormat().format((int)num) + "\u00a2";
    }

    public static Vector2f getInterceptPointBasic(SectorEntityToken from, SectorEntityToken to) {
        float dist = Misc.getDistance(from.getLocation(), to.getLocation()) - from.getRadius() - to.getRadius();
        if (dist <= 0.0f) {
            return new Vector2f((ReadableVector2f)to.getLocation());
        }
        float closingSpeed = Misc.getClosingSpeed(from.getLocation(), to.getLocation(), from.getVelocity(), to.getVelocity());
        if (closingSpeed <= 10.0f) {
            return new Vector2f((ReadableVector2f)to.getLocation());
        }
        Vector2f toTarget = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(from.getLocation(), to.getLocation()));
        Vector2f vel = new Vector2f((ReadableVector2f)from.getVelocity());
        Misc.normalise(vel);
        float dot = Vector2f.dot((Vector2f)toTarget, (Vector2f)vel);
        if (dot < 0.0f) {
            return new Vector2f((ReadableVector2f)to.getLocation());
        }
        float time = dist / closingSpeed;
        Vector2f point = new Vector2f((ReadableVector2f)to.getVelocity());
        point.scale(time);
        Vector2f.add((Vector2f)point, (Vector2f)to.getLocation(), (Vector2f)point);
        return point;
    }

    public static boolean setFlagWithReason(MemoryAPI memory, String flagKey, String reason, boolean value, float expire2) {
        String requiredKey = flagKey + "_" + reason;
        if (value) {
            memory.set(flagKey, true);
            memory.set(requiredKey, value, expire2);
            memory.addRequired(flagKey, requiredKey);
        } else {
            memory.unset(requiredKey);
        }
        return memory.contains(flagKey);
    }

    public static boolean flagHasReason(MemoryAPI memory, String flagKey, String reason) {
        String requiredKey = flagKey + "_" + reason;
        return memory.getBoolean(requiredKey);
    }

    public static void clearFlag(MemoryAPI memory, String flagKey) {
        for (String req : memory.getRequired(flagKey)) {
            memory.unset(req);
        }
    }

    public static void makeLowRepImpact(CampaignFleetAPI fleet, String reason) {
        Misc.setFlagWithReason(fleet.getMemoryWithoutUpdate(), "$lowRepImpact", reason, true, -1.0f);
    }

    public static void makeNoRepImpact(CampaignFleetAPI fleet, String reason) {
        Misc.setFlagWithReason(fleet.getMemoryWithoutUpdate(), "$lowRepImpact", reason, true, -1.0f);
        Misc.setFlagWithReason(fleet.getMemoryWithoutUpdate(), "$noRepImpact", reason, true, -1.0f);
    }

    public static void makeHostile(CampaignFleetAPI fleet) {
        fleet.getMemoryWithoutUpdate().set("$cfai_makeHostile", true);
    }

    public static void makeHostileToPlayerTradeFleets(CampaignFleetAPI fleet) {
        fleet.getMemoryWithoutUpdate().set("$cfai_makeHostileToPlayerTradeFleets", true);
    }

    public static void makeHostileToAllTradeFleets(CampaignFleetAPI fleet) {
        fleet.getMemoryWithoutUpdate().set("$cfai_makeHostileToAllTradeFleets", true);
    }

    public static void makeNonHostileToFaction(CampaignFleetAPI fleet, String factionId, float dur) {
        Misc.makeNonHostileToFaction(fleet, factionId, true, dur);
    }

    public static void makeNonHostileToFaction(CampaignFleetAPI fleet, String factionId, boolean nonHostile, float dur) {
        String flag = "$cfai_makeNonHostile_" + factionId;
        if (!nonHostile) {
            fleet.getMemoryWithoutUpdate().unset(flag);
        } else {
            fleet.getMemoryWithoutUpdate().set(flag, true, dur);
        }
    }

    public static void makeHostileToFaction(CampaignFleetAPI fleet, String factionId, float dur) {
        Misc.makeHostileToFaction(fleet, factionId, true, dur);
    }

    public static void makeHostileToFaction(CampaignFleetAPI fleet, String factionId, boolean hostile, float dur) {
        String flag = "$cfai_makeHostile_" + factionId;
        if (!hostile) {
            fleet.getMemoryWithoutUpdate().unset(flag);
        } else {
            fleet.getMemoryWithoutUpdate().set(flag, true, dur);
        }
    }

    public static boolean isFleetMadeHostileToFaction(CampaignFleetAPI fleet, FactionAPI faction) {
        return Misc.isFleetMadeHostileToFaction(fleet, faction.getId());
    }

    public static boolean isFleetMadeHostileToFaction(CampaignFleetAPI fleet, String factionId) {
        if ("player".equals(factionId) && fleet.getMemoryWithoutUpdate().contains("$cfai_makeHostile")) {
            return true;
        }
        String flag = "$cfai_makeHostile_" + factionId;
        return fleet.getMemoryWithoutUpdate().getBoolean(flag);
    }

    public static void makeNotLowRepImpact(CampaignFleetAPI fleet, String reason) {
        Misc.setFlagWithReason(fleet.getMemoryWithoutUpdate(), "$lowRepImpact", reason, false, -1.0f);
        Misc.setFlagWithReason(fleet.getMemoryWithoutUpdate(), "$noRepImpact", reason, false, -1.0f);
    }

    public static String getAgoStringForTimestamp(long timestamp) {
        CampaignClockAPI clock = Global.getSector().getClock();
        float days = clock.getElapsedDaysSince(timestamp);
        if (days <= 1.0f) {
            return "\u4eca\u5929";
        }
        if (days <= 6.0f) {
            return (int)Math.ceil(days) + " \u5929\u524d";
        }
        if (days <= 7.0f) {
            return "1 \u5468\u524d";
        }
        if (days <= 14.0f) {
            return "2 \u5468\u524d";
        }
        if (days <= 21.0f) {
            return "3 \u5468\u524d";
        }
        if (days <= 44.0f) {
            return "1 \u4e2a\u6708\u524d";
        }
        if (days < 74.0f) {
            return "2 \u4e2a\u6708\u524d";
        }
        if (days < 104.0f) {
            return "3 \u4e2a\u6708\u524d";
        }
        return "\u8d85\u8fc7 3 \u4e2a\u6708\u524d";
    }

    public static String getDetailedAgoString(long timestamp) {
        CampaignClockAPI clock = Global.getSector().getClock();
        int days = (int)clock.getElapsedDaysSince(timestamp);
        if (days == 0) {
            return "0 \u5929\u524d";
        }
        if (days == 1) {
            return "1 \u5929\u524d";
        }
        if (days <= 6) {
            return (int)Math.ceil(days) + " \u5929\u524d";
        }
        if (days <= 7) {
            return "1 \u5468\u524d";
        }
        if (days <= 14) {
            return "2 \u5468\u524d";
        }
        if (days <= 21) {
            return "3 \u5468\u524d";
        }
        int months = days / 30;
        if (months <= 12) {
            if (months <= 1) {
                return "1 \u4e2a\u6708\u524d";
            }
            return "" + months + " \u4e2a\u6708\u524d";
        }
        int years = months / 12;
        if (years <= 1) {
            return "1 \u661f\u5e74\u524d";
        }
        return "" + years + " \u661f\u5e74\u524d";
    }

    public static String getAtLeastStringForDays(int days) {
        if ((float)days <= 1.0f) {
            return "\u4e00\u5929";
        }
        if ((float)days <= 6.0f) {
            return "\u51e0\u5929";
        }
        if (days <= 13) {
            return "\u4e00\u5468";
        }
        if (days <= 20) {
            return "\u4e24\u5468";
        }
        if (days <= 29) {
            return "\u4e09\u5468";
        }
        if (days <= 59) {
            return "\u4e00\u4e2a\u6708";
        }
        if (days < 89) {
            return "\u4e24\u4e2a\u6708";
        }
        if (days < 119) {
            return "\u4e09\u4e2a\u6708";
        }
        return "\u8bb8\u591a\u4e2a\u6708";
    }

    public static String getStringForDays(int days) {
        if ((float)days <= 1.0f) {
            return "\u4e00\u5929";
        }
        if ((float)days <= 6.0f) {
            return "\u51e0\u5929";
        }
        if (days <= 13) {
            return "\u4e00\u5468";
        }
        if (days <= 20) {
            return "\u4e24\u5468";
        }
        if (days <= 29) {
            return "\u4e09\u5468";
        }
        if (days <= 59) {
            return "\u4e00\u4e2a\u6708";
        }
        if (days < 89) {
            return "\u4e24\u4e2a\u6708";
        }
        if (days < 119) {
            return "\u4e09\u4e2a\u6708";
        }
        return "\u8bb8\u591a\u4e2a\u6708";
    }

    public static float getBurnLevelForSpeed(float speed) {
        if ((speed -= Global.getSettings().getBaseTravelSpeed()) < 0.0f || speed <= Global.getSettings().getFloat("minTravelSpeed") + 1.0f) {
            speed = 0.0f;
        }
        float currBurn = speed / Global.getSettings().getSpeedPerBurnLevel();
        return Math.round(currBurn);
    }

    public static float getFractionalBurnLevelForSpeed(float speed) {
        if ((speed -= Global.getSettings().getBaseTravelSpeed()) < 0.0f || speed <= Global.getSettings().getFloat("minTravelSpeed") + 1.0f) {
            speed = 0.0f;
        }
        float currBurn = speed / Global.getSettings().getSpeedPerBurnLevel();
        return currBurn;
    }

    public static float getSpeedForBurnLevel(float burnLevel) {
        float speed = Global.getSettings().getBaseTravelSpeed() + burnLevel * Global.getSettings().getSpeedPerBurnLevel();
        return speed;
    }

    public static float getFuelPerDay(CampaignFleetAPI fleet, float burnLevel) {
        float speed = Global.getSettings().getBaseTravelSpeed() + Global.getSettings().getSpeedPerBurnLevel() * burnLevel;
        return Misc.getFuelPerDayAtSpeed(fleet, speed);
    }

    public static float getFuelPerDayAtSpeed(CampaignFleetAPI fleet, float speed) {
        float perLY = fleet.getLogistics().getFuelCostPerLightYear();
        speed *= Global.getSector().getClock().getSecondsPerDay();
        return (speed /= Global.getSettings().getUnitsPerLightYear()) * perLY;
    }

    public static float getLYPerDayAtBurn(CampaignFleetAPI fleet, float burnLevel) {
        float speed = Global.getSettings().getBaseTravelSpeed() + Global.getSettings().getSpeedPerBurnLevel() * burnLevel;
        return Misc.getLYPerDayAtSpeed(fleet, speed);
    }

    public static float getLYPerDayAtSpeed(CampaignFleetAPI fleet, float speed) {
        speed *= Global.getSector().getClock().getSecondsPerDay();
        return (speed /= Global.getSettings().getUnitsPerLightYear()) * 1.0f;
    }

    public static float getDistance(Vector3f v1, Vector3f v2) {
        return Vector3f.sub((Vector3f)v1, (Vector3f)v2, (Vector3f)temp4).length();
    }

    public static float getAngleDiff(float from, float to) {
        float diff = Misc.normalizeAngle(from - to);
        if (diff > 180.0f) {
            return 360.0f - diff;
        }
        return diff;
    }

    public static boolean isInArc(float direction, float arc, Vector2f from, Vector2f to) {
        float arcTo;
        float arcFrom;
        Vector2f towardsTo;
        direction = Misc.normalizeAngle(direction);
        if (arc >= 360.0f) {
            return true;
        }
        if (direction < 0.0f) {
            direction = 360.0f + direction;
        }
        if ((towardsTo = new Vector2f(to.x - from.x, to.y - from.y)).lengthSquared() == 0.0f) {
            return false;
        }
        float dir = Misc.getAngleInDegrees(towardsTo);
        if (dir < 0.0f) {
            dir = 360.0f + dir;
        }
        if ((arcFrom = direction - arc / 2.0f) < 0.0f) {
            arcFrom = 360.0f + arcFrom;
        }
        if (arcFrom > 360.0f) {
            arcFrom -= 360.0f;
        }
        if ((arcTo = direction + arc / 2.0f) < 0.0f) {
            arcTo = 360.0f + arcTo;
        }
        if (arcTo > 360.0f) {
            arcTo -= 360.0f;
        }
        if (dir >= arcFrom && dir <= arcTo) {
            return true;
        }
        if (dir >= arcFrom && arcFrom > arcTo) {
            return true;
        }
        return dir <= arcTo && arcFrom > arcTo;
    }

    public static boolean isInArc(float direction, float arc, float test) {
        float arcTo;
        float arcFrom;
        float dir;
        test = Misc.normalizeAngle(test);
        if (arc >= 360.0f) {
            return true;
        }
        if (direction < 0.0f) {
            direction = 360.0f + direction;
        }
        if ((dir = test) < 0.0f) {
            dir = 360.0f + dir;
        }
        if ((arcFrom = direction - arc / 2.0f) < 0.0f) {
            arcFrom = 360.0f + arcFrom;
        }
        if (arcFrom > 360.0f) {
            arcFrom -= 360.0f;
        }
        if ((arcTo = direction + arc / 2.0f) < 0.0f) {
            arcTo = 360.0f + arcTo;
        }
        if (arcTo > 360.0f) {
            arcTo -= 360.0f;
        }
        if (dir >= arcFrom && dir <= arcTo) {
            return true;
        }
        if (dir >= arcFrom && arcFrom > arcTo) {
            return true;
        }
        return dir <= arcTo && arcFrom > arcTo;
    }

    public static SectorEntityToken addNebulaFromPNG(String image, float centerX, float centerY, LocationAPI location, String category, String key, int tilesWide, int tilesHigh, StarAge age) {
        return Misc.addNebulaFromPNG(image, centerX, centerY, location, category, key, tilesWide, tilesHigh, "nebula", age);
    }

    public static SectorEntityToken addNebulaFromPNG(String image, float centerX, float centerY, LocationAPI location, String category, String key, int tilesWide, int tilesHigh, String terrainType, StarAge age) {
        try {
            BufferedImage img = null;
            img = ImageIO.read(Global.getSettings().openStream(image));
            int chunkSize = 10000;
            int w = img.getWidth();
            int h = img.getHeight();
            Raster data = img.getData();
            for (int i = 0; i < w; i += chunkSize) {
                int j = 0;
                if (j >= h) continue;
                int chunkWidth = chunkSize;
                if (i + chunkSize > w) {
                    chunkWidth = w - i;
                }
                int chunkHeight = chunkSize;
                if (j + chunkSize > h) {
                    chunkHeight = h - i;
                }
                StringBuilder string = new StringBuilder();
                for (int y = j + chunkHeight - 1; y >= j; --y) {
                    for (int x = i; x < i + chunkWidth; ++x) {
                        int[] pixel = data.getPixel(x, h - y - 1, (int[])null);
                        int total = pixel[0] + pixel[1] + pixel[2];
                        if (total > 0) {
                            string.append("x");
                            continue;
                        }
                        string.append(" ");
                    }
                }
                float tileSize = 400.0f;
                float x = centerX - tileSize * (float)w / 2.0f + (float)i * tileSize + (float)chunkWidth / 2.0f * tileSize;
                float y = centerY - tileSize * (float)h / 2.0f + (float)j * tileSize + (float)chunkHeight / 2.0f * tileSize;
                SectorEntityToken curr = location.addTerrain(terrainType, new BaseTiledTerrain.TileParams(string.toString(), chunkWidth, chunkHeight, category, key, tilesWide, tilesHigh, null));
                curr.getLocation().set(x, y);
                if (location instanceof StarSystemAPI) {
                    StarSystemAPI system = (StarSystemAPI)location;
                    system.setAge(age);
                    system.setHasSystemwideNebula(true);
                }
                return curr;
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void renderQuad(float x, float y, float width, float height, Color color, float alphaMult) {
        GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alphaMult)));
        GL11.glBegin((int)7);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glEnd();
    }

    public static float distanceFromLineToPoint(Vector2f p1, Vector2f p2, Vector2f p3) {
        float u = (p3.x - p1.x) * (p2.x - p1.x) + (p3.y - p1.y) * (p2.y - p1.y);
        float denom = Vector2f.sub((Vector2f)p2, (Vector2f)p1, (Vector2f)new Vector2f()).length();
        denom *= denom;
        Vector2f i = new Vector2f();
        i.x = p1.x + (u /= denom) * (p2.x - p1.x);
        i.y = p1.y + u * (p2.y - p1.y);
        return Vector2f.sub((Vector2f)i, (Vector2f)p3, (Vector2f)new Vector2f()).length();
    }

    public static Vector2f closestPointOnLineToPoint(Vector2f p1, Vector2f p2, Vector2f p3) {
        float u = (p3.x - p1.x) * (p2.x - p1.x) + (p3.y - p1.y) * (p2.y - p1.y);
        float denom = Vector2f.sub((Vector2f)p2, (Vector2f)p1, (Vector2f)new Vector2f()).length();
        denom *= denom;
        Vector2f i = new Vector2f();
        i.x = p1.x + (u /= denom) * (p2.x - p1.x);
        i.y = p1.y + u * (p2.y - p1.y);
        return i;
    }

    public static Vector2f closestPointOnSegmentToPoint(Vector2f p1, Vector2f p2, Vector2f p3) {
        float u = (p3.x - p1.x) * (p2.x - p1.x) + (p3.y - p1.y) * (p2.y - p1.y);
        float denom = Vector2f.sub((Vector2f)p2, (Vector2f)p1, (Vector2f)new Vector2f()).length();
        if ((u /= (denom *= denom)) < 0.0f) {
            u = 0.0f;
        }
        if (u > 1.0f) {
            u = 1.0f;
        }
        Vector2f i = new Vector2f();
        i.x = p1.x + u * (p2.x - p1.x);
        i.y = p1.y + u * (p2.y - p1.y);
        return i;
    }

    public static boolean isPointInBounds(Vector2f p1, List<Vector2f> bounds) {
        Vector2f p2 = new Vector2f((ReadableVector2f)p1);
        p2.x += 10000.0f;
        int count = 0;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < bounds.size() - 1; ++j) {
                Vector2f s2;
                Vector2f s1 = bounds.get(j);
                Vector2f p = Misc.intersectSegments(p1, p2, s1, s2 = bounds.get(j + 1));
                if (p == null || Math.abs(p.x - s1.x) < 0.001f && Math.abs(p.y - s1.y) < 0.001f || Misc.areSegmentsCoincident(p1, p2, s1, s2)) continue;
                ++count;
            }
            if (i != 0 || count % 2 != 1) break;
            count = 0;
            p2.y += 100.0f;
        }
        return count % 2 == 1;
    }

    public static Vector2f intersectSegments(Vector2f a1, Vector2f a2, Vector2f b1, Vector2f b2) {
        float denom = (b2.y - b1.y) * (a2.x - a1.x) - (b2.x - b1.x) * (a2.y - a1.y);
        float numUa = (b2.x - b1.x) * (a1.y - b1.y) - (b2.y - b1.y) * (a1.x - b1.x);
        float numUb = (a2.x - a1.x) * (a1.y - b1.y) - (a2.y - a1.y) * (a1.x - b1.x);
        if (denom == 0.0f && (numUa != 0.0f || numUb != 0.0f)) {
            return null;
        }
        if (denom == 0.0f && numUa == 0.0f && numUb == 0.0f) {
            float maxY;
            float minY;
            float maxX;
            float minX;
            if (a1.x < a2.x) {
                minX = a1.x;
                maxX = a2.x;
            } else {
                minX = a2.x;
                maxX = a1.x;
            }
            if (a1.y < a2.y) {
                minY = a1.y;
                maxY = a2.y;
            } else {
                minY = a2.y;
                maxY = a1.y;
            }
            if (b1.x >= minX && b1.x <= maxX && b1.y >= minY && b1.y <= maxY) {
                return new Vector2f((ReadableVector2f)b1);
            }
            if (b2.x >= minX && b2.x <= maxX && b2.y >= minY && b2.y <= maxY) {
                return new Vector2f((ReadableVector2f)b2);
            }
            return null;
        }
        float Ua = numUa / denom;
        float Ub = numUb / denom;
        if (Ua >= 0.0f && Ua <= 1.0f && Ub >= 0.0f && Ub <= 1.0f) {
            Vector2f result = new Vector2f();
            result.x = a1.x + Ua * (a2.x - a1.x);
            result.y = a1.y + Ua * (a2.y - a1.y);
            return result;
        }
        return null;
    }

    public static Vector2f intersectLines(Vector2f a1, Vector2f a2, Vector2f b1, Vector2f b2) {
        float denom = (b2.y - b1.y) * (a2.x - a1.x) - (b2.x - b1.x) * (a2.y - a1.y);
        float numUa = (b2.x - b1.x) * (a1.y - b1.y) - (b2.y - b1.y) * (a1.x - b1.x);
        float numUb = (a2.x - a1.x) * (a1.y - b1.y) - (a2.y - a1.y) * (a1.x - b1.x);
        if (denom == 0.0f && (numUa != 0.0f || numUb != 0.0f)) {
            return null;
        }
        if (denom == 0.0f && numUa == 0.0f && numUb == 0.0f) {
            return new Vector2f((ReadableVector2f)a1);
        }
        float Ua = numUa / denom;
        float Ub = numUb / denom;
        Vector2f result = new Vector2f();
        result.x = a1.x + Ua * (a2.x - a1.x);
        result.y = a1.y + Ua * (a2.y - a1.y);
        return result;
    }

    public static Vector2f intersectSegmentAndCircle(Vector2f p1, Vector2f p2, Vector2f p3, float r) {
        float minMu;
        float uNom = (p3.x - p1.x) * (p2.x - p1.x) + (p3.y - p1.y) * (p2.y - p1.y);
        float uDenom = (p2.x - p1.x) * (p2.x - p1.x) + (p2.y - p1.y) * (p2.y - p1.y);
        Vector2f closest = new Vector2f();
        if (uDenom == 0.0f) {
            closest.set((ReadableVector2f)p1);
        } else {
            float u = uNom / uDenom;
            closest.x = p1.x + u * (p2.x - p1.x);
            closest.y = p1.y + u * (p2.y - p1.y);
        }
        float distSq = (closest.x - p3.x) * (closest.x - p3.x) + (closest.y - p3.y) * (closest.y - p3.y);
        if (distSq > r * r) {
            return null;
        }
        if (uDenom == 0.0f) {
            return closest;
        }
        float b = 2.0f * ((p2.x - p1.x) * (p1.x - p3.x) + (p2.y - p1.y) * (p1.y - p3.y));
        float \u4e00\u4e2a = (p2.x - p1.x) * (p2.x - p1.x) + (p2.y - p1.y) * (p2.y - p1.y);
        float c = p3.x * p3.x + p3.y * p3.y + p1.x * p1.x + p1.y * p1.y - 2.0f * (p3.x * p1.x + p3.y * p1.y) - r * r;
        float bb4ac = b * b - 4.0f * \u4e00\u4e2a * c;
        if (bb4ac < 0.0f) {
            return null;
        }
        float mu1 = (-b + (float)Math.sqrt(bb4ac)) / (2.0f * \u4e00\u4e2a);
        float mu2 = (-b - (float)Math.sqrt(bb4ac)) / (2.0f * \u4e00\u4e2a);
        if (mu2 < (minMu = mu1) && mu2 >= 0.0f || minMu < 0.0f) {
            minMu = mu2;
        }
        if (minMu < 0.0f || minMu > 1.0f) {
            float p2DistSq = (p2.x - p3.x) * (p2.x - p3.x) + (p2.y - p3.y) * (p2.y - p3.y);
            if (p2DistSq <= r * r) {
                return p2;
            }
            return null;
        }
        Vector2f result = new Vector2f();
        result.x = p1.x + minMu * (p2.x - p1.x);
        result.y = p1.y + minMu * (p2.y - p1.y);
        return result;
    }

    public static boolean areSegmentsCoincident(Vector2f a1, Vector2f a2, Vector2f b1, Vector2f b2) {
        float denom = (b2.y - b1.y) * (a2.x - a1.x) - (b2.x - b1.x) * (a2.y - a1.y);
        float numUa = (b2.x - b1.x) * (a1.y - b1.y) - (b2.y - b1.y) * (a1.x - b1.x);
        float numUb = (a2.x - a1.x) * (a1.y - b1.y) - (a2.y - a1.y) * (a1.x - b1.x);
        if (denom == 0.0f && (numUa != 0.0f || numUb != 0.0f)) {
            return false;
        }
        return denom == 0.0f && numUa == 0.0f && numUb == 0.0f;
    }

    public static Vector2f getPerp(Vector2f v) {
        Vector2f perp = new Vector2f();
        perp.x = v.y;
        perp.y = -v.x;
        return perp;
    }

    public static float getClosestTurnDirection(float facing, float desired) {
        float diff = Misc.normalizeAngle(desired) - Misc.normalizeAngle(facing);
        if (diff < 0.0f) {
            diff += 360.0f;
        }
        if (diff == 0.0f || diff == 360.0f) {
            return 0.0f;
        }
        if (diff > 180.0f) {
            return -1.0f;
        }
        return 1.0f;
    }

    public static float getClosestTurnDirection(float facing, Vector2f from, Vector2f to) {
        float diff = Misc.normalizeAngle(Misc.getAngleInDegrees(from, to)) - Misc.normalizeAngle(facing);
        if (diff < 0.0f) {
            diff += 360.0f;
        }
        if (diff == 0.0f || diff == 360.0f) {
            return 0.0f;
        }
        if (diff > 180.0f) {
            return -1.0f;
        }
        return 1.0f;
    }

    public static float getClosestTurnDirection(Vector2f one, Vector2f two) {
        return Misc.getClosestTurnDirection(Misc.getAngleInDegrees(one), new Vector2f(0.0f, 0.0f), two);
    }

    public static Vector2f getDiff(Vector2f v1, Vector2f v2) {
        return Vector2f.sub((Vector2f)v1, (Vector2f)v2, (Vector2f)new Vector2f());
    }

    public static MarketAPI getSourceMarket(CampaignFleetAPI fleet) {
        String id = fleet.getMemoryWithoutUpdate().getString("$sourceMarket");
        if (id == null) {
            return null;
        }
        MarketAPI market = Global.getSector().getEconomy().getMarket(id);
        return market;
    }

    public static SectorEntityToken getSourceEntity(CampaignFleetAPI fleet) {
        String id = fleet.getMemoryWithoutUpdate().getString("$sourceMarket");
        if (id == null) {
            return null;
        }
        MarketAPI market = Global.getSector().getEconomy().getMarket(id);
        if (market != null && market.getPrimaryEntity() != null) {
            return market.getPrimaryEntity();
        }
        SectorEntityToken entity = Global.getSector().getEntityById(id);
        return entity;
    }

    public static float getSpawnChanceMult(Vector2f locInHyper) {
        if (Global.getSector().getPlayerFleet() == null) {
            return 1.0f;
        }
        float min = Global.getSettings().getFloat("minFleetSpawnChanceMult");
        float range = Global.getSettings().getFloat("minFleetSpawnChanceRangeLY");
        Vector2f playerLoc = Global.getSector().getPlayerFleet().getLocationInHyperspace();
        float distLY = Misc.getDistanceLY(playerLoc, locInHyper);
        float f = 1.0f - Math.min(1.0f, distLY / range);
        return min + (1.0f - min) * f * f;
    }

    public static Vector2f pickHyperLocationNotNearPlayer(Vector2f from, float minDist) {
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        float r = 2000.0f;
        if (player == null || !player.isInHyperspace()) {
            return Misc.getPointWithinRadius(from, r);
        }
        float dist = Misc.getDistance(player.getLocation(), from);
        if (dist > minDist + r) {
            return Misc.getPointWithinRadius(from, r);
        }
        float dir = Misc.getAngleInDegrees(player.getLocation(), from);
        Vector2f v = Misc.getUnitVectorAtDegreeAngle(dir);
        v.scale(minDist + 2000.0f - dist);
        Vector2f.add((Vector2f)v, (Vector2f)from, (Vector2f)v);
        return Misc.getPointWithinRadius(v, r);
    }

    public static Vector2f pickLocationNotNearPlayer(LocationAPI where, Vector2f from, float minDist) {
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        float r = 2000.0f;
        if (player == null || player.getContainingLocation() != where) {
            return Misc.getPointWithinRadius(from, r);
        }
        float dist = Misc.getDistance(player.getLocation(), from);
        if (dist > minDist + r) {
            return Misc.getPointWithinRadius(from, r);
        }
        float dir = Misc.getAngleInDegrees(player.getLocation(), from);
        Vector2f v = Misc.getUnitVectorAtDegreeAngle(dir);
        v.scale(minDist + 2000.0f - dist);
        Vector2f.add((Vector2f)v, (Vector2f)from, (Vector2f)v);
        return Misc.getPointWithinRadius(v, r);
    }

    public static float getBattleJoinRange() {
        return Global.getSettings().getFloat("battleJoinRange");
    }

    public static void wiggle(Vector2f v, float max) {
        v.x += max * 2.0f * ((float)Math.random() - 0.5f);
        v.y += max * 2.0f * ((float)Math.random() - 0.5f);
        if (v.length() == 0.0f || v.lengthSquared() == 0.0f) {
            v.x += max * 0.25f;
        }
    }

    public static boolean isPlayerOrCombinedPlayerPrimary(CampaignFleetAPI fleet) {
        if (fleet.isPlayerFleet()) {
            return true;
        }
        return fleet.getBattle() != null && fleet.getBattle().isOnPlayerSide(fleet) && fleet.getBattle().isPlayerPrimary();
    }

    public static boolean isPlayerOrCombinedContainingPlayer(CampaignFleetAPI fleet) {
        if (fleet.isPlayerFleet()) {
            return true;
        }
        return fleet.getBattle() != null && fleet.getBattle().isOnPlayerSide(fleet);
    }

    public static AsteroidSource getAsteroidSource(SectorEntityToken asteroid) {
        if (asteroid.getCustomData().containsKey(ASTEROID_SOURCE)) {
            return (AsteroidSource)asteroid.getCustomData().get(ASTEROID_SOURCE);
        }
        return null;
    }

    public static void setAsteroidSource(SectorEntityToken asteroid, AsteroidSource source) {
        asteroid.getCustomData().put(ASTEROID_SOURCE, source);
    }

    public static void clearAsteroidSource(SectorEntityToken asteroid) {
        asteroid.getCustomData().remove(ASTEROID_SOURCE);
    }

    public static boolean isFastStart() {
        return Global.getSector().getMemoryWithoutUpdate().getBoolean("$fastStart");
    }

    public static boolean isFastStartExplorer() {
        return Global.getSector().getMemoryWithoutUpdate().getBoolean("$fastStartExplorer");
    }

    public static boolean isFastStartMerc() {
        return Global.getSector().getMemoryWithoutUpdate().getBoolean("$fastStartMerc");
    }

    public static boolean isEasy() {
        return "easy".equals(Global.getSector().getDifficulty());
    }

    public static boolean isNormal() {
        return "normal".equals(Global.getSector().getDifficulty());
    }

    public static CampaignTerrainAPI getHyperspaceTerrain() {
        for (CampaignTerrainAPI curr : Global.getSector().getHyperspace().getTerrainCopy()) {
            if (!(curr.getPlugin() instanceof HyperspaceTerrainPlugin)) continue;
            return curr;
        }
        return null;
    }

    public static HyperspaceTerrainPlugin getHyperspaceTerrainPlugin() {
        CampaignTerrainAPI hyper = Misc.getHyperspaceTerrain();
        if (hyper != null) {
            return (HyperspaceTerrainPlugin)hyper.getPlugin();
        }
        return null;
    }

    public static boolean isInAbyss(Vector2f loc) {
        return Misc.getAbyssalDepth(loc) > 0.0f;
    }

    public static boolean isInAbyss(SectorEntityToken entity) {
        return Misc.getAbyssalDepth(entity) > 0.0f;
    }

    public static float getAbyssalDepth(Vector2f loc) {
        HyperspaceTerrainPlugin plugin = Misc.getHyperspaceTerrainPlugin();
        if (plugin == null) {
            return 0.0f;
        }
        return plugin.getAbyssalDepth(loc);
    }

    public static List<StarSystemAPI> getAbyssalSystems() {
        HyperspaceTerrainPlugin plugin = Misc.getHyperspaceTerrainPlugin();
        if (plugin == null) {
            return new ArrayList<StarSystemAPI>();
        }
        return plugin.getAbyssalSystems();
    }

    public static float getAbyssalDepthOfPlayer() {
        return Misc.getAbyssalDepth(Global.getSector().getPlayerFleet());
    }

    public static float getAbyssalDepth(SectorEntityToken entity) {
        if (entity == null || !entity.isInHyperspace()) {
            return 0.0f;
        }
        return Misc.getAbyssalDepth(entity.getLocation());
    }

    public static boolean isInsideBlackHole(CampaignFleetAPI fleet, boolean includeEventHorizon) {
        for (PlanetAPI planet : fleet.getContainingLocation().getPlanets()) {
            StarCoronaTerrainPlugin corona;
            if (!planet.isStar() || planet.getSpec() == null || !planet.getSpec().isBlackHole()) continue;
            float dist = Misc.getDistance(fleet, planet);
            if (dist < planet.getRadius() + fleet.getRadius()) {
                return true;
            }
            if (!includeEventHorizon || (corona = Misc.getCoronaFor(planet)) == null || !corona.containsEntity(fleet)) continue;
            return true;
        }
        return false;
    }

    public static StarCoronaTerrainPlugin getCoronaFor(PlanetAPI star) {
        if (star == null) {
            return null;
        }
        for (CampaignTerrainAPI curr : star.getContainingLocation().getTerrainCopy()) {
            StarCoronaTerrainPlugin corona;
            if (!(curr.getPlugin() instanceof StarCoronaTerrainPlugin) || (corona = (StarCoronaTerrainPlugin)curr.getPlugin()).getRelatedEntity() != star) continue;
            return corona;
        }
        return null;
    }

    public static MagneticFieldTerrainPlugin getMagneticFieldFor(PlanetAPI planet) {
        if (planet == null || planet.getContainingLocation() == null) {
            return null;
        }
        for (CampaignTerrainAPI curr : planet.getContainingLocation().getTerrainCopy()) {
            MagneticFieldTerrainPlugin field;
            if (!(curr.getPlugin() instanceof MagneticFieldTerrainPlugin) || (field = (MagneticFieldTerrainPlugin)curr.getPlugin()).getRelatedEntity() != planet) continue;
            return field;
        }
        return null;
    }

    public static PulsarBeamTerrainPlugin getPulsarFor(PlanetAPI star) {
        for (CampaignTerrainAPI curr : star.getContainingLocation().getTerrainCopy()) {
            PulsarBeamTerrainPlugin corona;
            if (!(curr.getPlugin() instanceof PulsarBeamTerrainPlugin) || (corona = (PulsarBeamTerrainPlugin)curr.getPlugin()).getRelatedEntity() != star) continue;
            return corona;
        }
        return null;
    }

    public static boolean hasPulsar(StarSystemAPI system) {
        return system != null && system.hasPulsar();
    }

    public static String getCommissionFactionId() {
        String str = Global.getSector().getCharacterData().getMemoryWithoutUpdate().getString("$fcm_faction");
        return str;
    }

    public static FactionAPI getCommissionFaction() {
        String id = Misc.getCommissionFactionId();
        if (id != null) {
            return Global.getSector().getFaction(id);
        }
        return null;
    }

    public static FactionCommissionIntel getCommissionIntel() {
        Object obj = Global.getSector().getCharacterData().getMemoryWithoutUpdate().get("$fcm_eventRef");
        if (obj instanceof FactionCommissionIntel) {
            return (FactionCommissionIntel)obj;
        }
        return null;
    }

    public static boolean caresAboutPlayerTransponder(CampaignFleetAPI fleet) {
        MarketAPI source;
        if (fleet.getFaction().isPlayerFaction()) {
            return false;
        }
        boolean caresAboutTransponder = true;
        if (fleet.getFaction().getCustomBoolean("allowsTransponderOffTrade")) {
            caresAboutTransponder = false;
        }
        if ((source = Misc.getSourceMarket(fleet)) != null && source.hasCondition("free_market")) {
            caresAboutTransponder = false;
        }
        if (fleet.getMemoryWithoutUpdate().getBoolean("$patrolAllowTOff")) {
            caresAboutTransponder = false;
        }
        if (fleet.getMemoryWithoutUpdate().getBoolean("$cfai_makeNonHostile")) {
            caresAboutTransponder = false;
        }
        if (caresAboutTransponder && source != null && source.getPrimaryEntity() != null) {
            CampaignFleetAPI player = Global.getSector().getPlayerFleet();
            caresAboutTransponder = player == null || player.isInHyperspace() ? false : source.getPrimaryEntity().getContainingLocation() == player.getContainingLocation();
        }
        return caresAboutTransponder;
    }

    public static ShipAPI findClosestShipEnemyOf(ShipAPI ship, Vector2f locFromForSorting, ShipAPI.HullSize smallestToNote, float maxRange, boolean considerShipRadius) {
        return Misc.findClosestShipEnemyOf(ship, locFromForSorting, smallestToNote, maxRange, considerShipRadius, null);
    }

    public static ShipAPI findClosestShipEnemyOf(ShipAPI ship, Vector2f locFromForSorting, ShipAPI.HullSize smallestToNote, float maxRange, boolean considerShipRadius, FindShipFilter filter) {
        CombatEngineAPI engine = Global.getCombatEngine();
        List<ShipAPI> ships = engine.getShips();
        float minDist = Float.MAX_VALUE;
        ShipAPI closest = null;
        for (ShipAPI other : ships) {
            if (other.getHullSize().ordinal() < smallestToNote.ordinal() || other.isShuttlePod() || other.isHulk() || ship.getOwner() == other.getOwner() || other.getOwner() == 100 || filter != null && !filter.matches(other)) continue;
            float dist = Misc.getDistance(ship.getLocation(), other.getLocation());
            float distSort = Misc.getDistance(locFromForSorting, other.getLocation());
            float radSum = ship.getCollisionRadius() + other.getCollisionRadius();
            if (!considerShipRadius) {
                radSum = 0.0f;
            }
            if (dist > maxRange + radSum || !(distSort < minDist)) continue;
            closest = other;
            minDist = distSort;
        }
        return closest;
    }

    public static <T extends Enum<T>> T mapToEnum(JSONObject json, String key, Class<T> enumType, T defaultOption) throws JSONException {
        return Misc.mapToEnum(json, key, enumType, defaultOption, true);
    }

    public static <T extends Enum<T>> T mapToEnum(JSONObject json, String key, Class<T> enumType, T defaultOption, boolean required) throws JSONException {
        String val = json.optString(key);
        if (val == null || val.equals("")) {
            if (defaultOption == null && required) {
                throw new RuntimeException("Key [" + key + "] is required");
            }
            return defaultOption;
        }
        try {
            return Enum.valueOf(enumType, val);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Key [" + key + "] has invalid value [" + val + "] in [" + json.toString() + "]");
        }
    }

    public static Color getColor(JSONObject json, String key) throws JSONException {
        if (!json.has(key)) {
            return Color.white;
        }
        JSONArray arr = json.getJSONArray(key);
        return new Color(arr.getInt(0), arr.getInt(1), arr.getInt(2), arr.getInt(3));
    }

    public static Color optColor(JSONObject json, String key, Color defaultValue) throws JSONException {
        if (!json.has(key)) {
            return defaultValue;
        }
        JSONArray arr = json.getJSONArray(key);
        return new Color(arr.getInt(0), arr.getInt(1), arr.getInt(2), arr.getInt(3));
    }

    public static Vector2f getVector(JSONObject json, String arrayKey, Vector2f def) throws JSONException {
        if (!json.has(arrayKey)) {
            return def;
        }
        return Misc.getVector(json, arrayKey);
    }

    public static Vector2f getVector(JSONObject json, String arrayKey) throws JSONException {
        Vector2f v = new Vector2f();
        JSONArray arr = json.getJSONArray(arrayKey);
        v.set((float)arr.getDouble(0), (float)arr.getDouble(1));
        return v;
    }

    public static Vector3f getVector3f(JSONObject json, String arrayKey) throws JSONException {
        Vector3f v = new Vector3f();
        JSONArray arr = json.getJSONArray(arrayKey);
        v.set((float)arr.getDouble(0), (float)arr.getDouble(1), (float)arr.getDouble(1));
        return v;
    }

    public static Vector2f optVector(JSONObject json, String arrayKey) {
        Vector2f v = new Vector2f();
        JSONArray arr = json.optJSONArray(arrayKey);
        if (arr == null) {
            return null;
        }
        v.set((float)arr.optDouble(0), (float)arr.optDouble(1));
        return v;
    }

    public static Vector3f optVector3f(JSONObject json, String arrayKey) throws JSONException {
        Vector3f v = new Vector3f();
        JSONArray arr = json.optJSONArray(arrayKey);
        if (arr == null) {
            return new Vector3f();
        }
        v.set((float)arr.getDouble(0), (float)arr.getDouble(1), (float)arr.getDouble(2));
        return v;
    }

    public static Vector2f getVector(JSONObject json, String arrayKey, int index) throws JSONException {
        Vector2f v = new Vector2f();
        JSONArray arr = json.getJSONArray(arrayKey);
        v.set((float)arr.getDouble(index * 2 + 0), (float)arr.getDouble(index * 2 + 1));
        return v;
    }

    public static void normalizeNoise(float[][] noise) {
        float minNoise = 1.0f;
        float maxNoise = 0.0f;
        for (int i = 0; i < noise.length; ++i) {
            for (int j = 0; j < noise[0].length; ++j) {
                if (noise[i][j] == -1.0f) continue;
                if (noise[i][j] > maxNoise) {
                    maxNoise = noise[i][j];
                }
                if (!(noise[i][j] < minNoise)) continue;
                minNoise = noise[i][j];
            }
        }
        if (minNoise >= maxNoise) {
            return;
        }
        float range = maxNoise - minNoise;
        for (int i = 0; i < noise.length; ++i) {
            for (int j = 0; j < noise[0].length; ++j) {
                float newNoise;
                noise[i][j] = noise[i][j] != -1.0f ? (newNoise = (noise[i][j] - minNoise) / range) : (i > 0 ? noise[i - 1][j] : (i < noise.length - 1 ? noise[i + 1][j] : 0.5f));
            }
        }
    }

    public static float[][] initNoise(Random random, int w, int h, float spikes) {
        if (random == null) {
            random = Misc.random;
        }
        float[][] noise = new float[w][h];
        for (int i = 0; i < noise.length; ++i) {
            for (int j = 0; j < noise[0].length; ++j) {
                noise[i][j] = -1.0f;
            }
        }
        noise[0][0] = random.nextFloat() * spikes;
        noise[0][noise[0].length - 1] = random.nextFloat() * spikes;
        noise[noise.length - 1][0] = random.nextFloat() * spikes;
        noise[noise.length - 1][noise[0].length - 1] = random.nextFloat() * spikes;
        return noise;
    }

    public static void genFractalNoise(Random random, float[][] noise, int x1, int y1, int x2, int y2, int iter, float spikes) {
        if (x1 + 1 >= x2 || y1 + 1 >= y2) {
            return;
        }
        int midX = (x1 + x2) / 2;
        int midY = (y1 + y2) / 2;
        Misc.fill(random, noise, midX, y1, x1, y1, x2, y1, iter, spikes);
        Misc.fill(random, noise, midX, y2, x1, y2, x2, y2, iter, spikes);
        Misc.fill(random, noise, x1, midY, x1, y1, x1, y2, iter, spikes);
        Misc.fill(random, noise, x2, midY, x2, y1, x2, y2, iter, spikes);
        Misc.fill(random, noise, midX, midY, midX, y1, midX, y2, iter, spikes);
        float midValue1 = noise[midX][midY];
        Misc.fill(random, noise, midX, midY, x1, midY, x2, midY, iter, spikes);
        float midValue2 = noise[midX][midY];
        noise[midX][midY] = (midValue1 + midValue2) / 2.0f;
        Misc.genFractalNoise(random, noise, x1, y1, midX, midY, iter + 1, spikes);
        Misc.genFractalNoise(random, noise, x1, midY, midX, y2, iter + 1, spikes);
        Misc.genFractalNoise(random, noise, midX, y1, x2, midY, iter + 1, spikes);
        Misc.genFractalNoise(random, noise, midX, midY, x2, y2, iter + 1, spikes);
    }

    private static void fill(Random random, float[][] noise, int x, int y, int x1, int y1, int x2, int y2, int iter, float spikes) {
        if (noise[x][y] == -1.0f) {
            float avg = (noise[x1][y1] + noise[x2][y2]) / 2.0f;
            noise[x][y] = avg + (float)Math.pow(spikes, iter) * (float)((double)random.nextFloat() - 0.5);
        }
    }

    public static float computeAngleSpan(float radius, float range) {
        if (range <= 1.0f) {
            return 180.0f;
        }
        return 2.0f * radius / ((float)Math.PI * 2 * range) * 360.0f;
    }

    public static float computeAngleRadius(float angle, float range) {
        float rad = (float)Math.toRadians(angle);
        return rad * range;
    }

    public static float approach(float curr, float dest, float minSpeed, float diffSpeedMult, float amount) {
        float diff = dest - curr;
        float delta = (Math.signum(diff) * minSpeed + diff * diffSpeedMult) * amount;
        if (Math.abs(delta) > Math.abs(diff)) {
            delta = diff;
        }
        return curr + delta;
    }

    public static void cleanBuffer(Buffer toBeDestroyed) {
        try {
            if (toBeDestroyed instanceof DirectBuffer) {
                Cleaner cleaner = ((DirectBuffer)((Object)toBeDestroyed)).cleaner();
                if (cleaner != null) {
                    cleaner.clean();
                }
                Global.getLogger(Misc.class).info((Object)String.format("Cleaned buffer (using cast)", new Object[0]));
                return;
            }
            Method cleanerMethod = toBeDestroyed.getClass().getMethod("cleaner", new Class[0]);
            cleanerMethod.setAccessible(true);
            Object cleaner = cleanerMethod.invoke((Object)toBeDestroyed, new Object[0]);
            if (cleaner != null) {
                Method cleanMethod = cleaner.getClass().getMethod("clean", new Class[0]);
                cleanMethod.setAccessible(true);
                cleanMethod.invoke(cleaner, new Object[0]);
                Global.getLogger(Misc.class).info((Object)String.format("Cleaned buffer (using reflection)", new Object[0]));
            } else {
                Global.getLogger(Misc.class).warn((Object)String.format("Buffer can not be cleaned", new Object[0]));
            }
        }
        catch (Exception e) {
            Global.getLogger(Misc.class).warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static float getFleetwideTotalStat(CampaignFleetAPI fleet, String dynamicMemberStatId) {
        float total = 0.0f;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            if (member.isMothballed()) continue;
            total += member.getStats().getDynamic().getValue(dynamicMemberStatId);
        }
        return total;
    }

    public static float getFleetwideTotalMod(CampaignFleetAPI fleet, String dynamicMemberStatId, float base) {
        return Misc.getFleetwideTotalMod(fleet, dynamicMemberStatId, base, null);
    }

    public static float getFleetwideTotalMod(CampaignFleetAPI fleet, String dynamicMemberStatId, float base, ShipAPI ship) {
        float total = 0.0f;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            if (member.isMothballed()) continue;
            if (ship != null && ship.getFleetMember() == member) {
                total += ship.getMutableStats().getDynamic().getValue(dynamicMemberStatId, base);
                continue;
            }
            total += member.getStats().getDynamic().getValue(dynamicMemberStatId, base);
        }
        return total;
    }

    public static String getStarId(PlanetAPI planet) {
        StarSystemAPI system;
        String starId = planet.getContainingLocation().getId();
        if (planet.getContainingLocation() instanceof StarSystemAPI && (system = (StarSystemAPI)planet.getContainingLocation()).getStar() != null) {
            starId = system.getStar().getId();
        }
        if (planet.getOrbitFocus() instanceof PlanetAPI) {
            PlanetAPI parent = (PlanetAPI)planet.getOrbitFocus();
            if (parent.isStar()) {
                starId = parent.getId();
            } else if (parent.getOrbitFocus() instanceof PlanetAPI && (parent = (PlanetAPI)parent.getOrbitFocus()).isStar()) {
                starId = parent.getId();
            }
        }
        return starId;
    }

    public static MarketAPI.SurveyLevel getMinSystemSurveyLevel(StarSystemAPI system) {
        MarketAPI.SurveyLevel minLevel = MarketAPI.SurveyLevel.FULL;
        boolean empty = true;
        for (PlanetAPI planet : system.getPlanets()) {
            MarketAPI market;
            if (planet.isStar() || (market = planet.getMarket()) == null) continue;
            empty = false;
            MarketAPI.SurveyLevel level = market.getSurveyLevel();
            if (level.ordinal() >= minLevel.ordinal()) continue;
            minLevel = level;
        }
        if (!system.isEnteredByPlayer() && empty) {
            minLevel = MarketAPI.SurveyLevel.NONE;
        }
        if (system.isEnteredByPlayer() && empty) {
            minLevel = MarketAPI.SurveyLevel.FULL;
        }
        return minLevel;
    }

    public static boolean hasAnySurveyDataFor(StarSystemAPI system) {
        for (PlanetAPI planet : system.getPlanets()) {
            MarketAPI.SurveyLevel level;
            MarketAPI market;
            if (planet.isStar() || (market = planet.getMarket()) == null || (level = market.getSurveyLevel()) == MarketAPI.SurveyLevel.NONE) continue;
            return true;
        }
        return false;
    }

    public static void setAllPlanetsKnown(String systemName) {
        StarSystemAPI system = Global.getSector().getStarSystem(systemName);
        if (system == null) {
            throw new RuntimeException("Star system [" + systemName + "] not found");
        }
        Misc.setAllPlanetsKnown(system);
    }

    public static void setAllPlanetsKnown(StarSystemAPI system) {
        for (PlanetAPI planet : system.getPlanets()) {
            MarketAPI market;
            if (planet.isStar() || (market = planet.getMarket()) == null) continue;
            if (!market.isPlanetConditionMarketOnly()) {
                market.setSurveyLevel(MarketAPI.SurveyLevel.FULL);
                continue;
            }
            if (market.getSurveyLevel() != MarketAPI.SurveyLevel.NONE) continue;
            market.setSurveyLevel(MarketAPI.SurveyLevel.SEEN);
        }
    }

    public static void setAllPlanetsSurveyed(StarSystemAPI system, boolean setRuinsExplored) {
        for (PlanetAPI planet : system.getPlanets()) {
            MarketAPI market;
            if (planet.isStar() || (market = planet.getMarket()) == null) continue;
            market.setSurveyLevel(MarketAPI.SurveyLevel.FULL);
            for (MarketConditionAPI mc : market.getConditions()) {
                mc.setSurveyed(true);
            }
            if (!setRuinsExplored || !Misc.hasRuins(market)) continue;
            market.getMemoryWithoutUpdate().set("$ruinsExplored", true);
        }
    }

    public static void generatePlanetConditions(String systemName, StarAge age) {
        StarSystemAPI system = Global.getSector().getStarSystem(systemName);
        if (system == null) {
            throw new RuntimeException("Star system [" + systemName + "] not found");
        }
        Misc.generatePlanetConditions(system, age);
    }

    public static void generatePlanetConditions(StarSystemAPI system, StarAge age) {
        for (PlanetAPI planet : system.getPlanets()) {
            if (planet.isStar() || planet.getMarket() != null && !planet.getMarket().getConditions().isEmpty()) continue;
            PlanetConditionGenerator.generateConditionsForPlanet(planet, age);
        }
    }

    public static int getEstimatedOrbitIndex(PlanetAPI planet) {
        Vector2f centerLoc = new Vector2f();
        float centerRadius = 0.0f;
        float planetRadius = planet.getRadius();
        PlanetAPI parent = null;
        PlanetAPI parentParent = null;
        if (planet.getOrbitFocus() instanceof PlanetAPI) {
            parent = (PlanetAPI)planet.getOrbitFocus();
            if (parent.getOrbitFocus() instanceof PlanetAPI) {
                parentParent = (PlanetAPI)parent.getOrbitFocus();
            }
            if (parent.isStar()) {
                centerLoc = parent.getLocation();
                centerRadius = parent.getRadius();
            } else if (parentParent != null && parentParent.isStar()) {
                centerLoc = parentParent.getLocation();
                centerRadius = parentParent.getRadius();
                planetRadius = parent.getRadius();
            }
        }
        float approximateExtraRadiusPerOrbit = 400.0f;
        float dist = Misc.getDistance(centerLoc, planet.getLocation());
        int orbitIndex = (int)((dist - centerRadius - planetRadius - 750.0f - 250.0f) / (1000.0f + approximateExtraRadiusPerOrbit));
        if (orbitIndex == 0) {
            orbitIndex = (int)((dist - centerRadius - planetRadius - 750.0f - 250.0f) / 1000.0f);
        }
        if (orbitIndex < 0) {
            orbitIndex = 0;
        }
        return orbitIndex;
    }

    public static Random getRandom(long seed, int level) {
        if (seed == 0L) {
            return random;
        }
        Random r = new Random(seed);
        for (int i = 0; i < level; ++i) {
            r.nextLong();
        }
        return new Random(r.nextLong());
    }

    public static void addSurveyDataFor(PlanetAPI planet, TextPanelAPI text) {
        SurveyPlugin plugin = (SurveyPlugin)Global.getSettings().getNewPluginInstance("surveyPlugin");
        plugin.init(Global.getSector().getPlayerFleet(), planet);
        String dataType = plugin.getSurveyDataType(planet);
        if (dataType != null) {
            Global.getSector().getPlayerFleet().getCargo().addCommodity(dataType, 1.0f);
            if (text != null) {
                AddRemoveCommodity.addCommodityGainText(dataType, 1, text);
            }
        }
    }

    public static void setFullySurveyed(MarketAPI market, TextPanelAPI text, boolean withNotification) {
        for (MarketConditionAPI mc : market.getConditions()) {
            mc.setSurveyed(true);
        }
        market.setSurveyLevel(MarketAPI.SurveyLevel.FULL);
        if (withNotification && market.getPrimaryEntity() instanceof PlanetAPI) {
            PlanetAPI planet = (PlanetAPI)market.getPrimaryEntity();
            String string = "\u83b7\u5f97\u5b8c\u6574\u7684\u8c03\u67e5\u6570\u636e " + planet.getName() + ", " + planet.getTypeNameWithWorld().toLowerCase();
            if (text != null) {
                text.setFontSmallInsignia();
                text.addParagraph(string, planet.getSpec().getIconColor());
                text.setFontInsignia();
            } else {
                MessageIntel intel = new MessageIntel("\u5b8c\u6574\u7684\u8c03\u67e5\u6570\u636e\uff1a" + planet.getName() + ", " + planet.getTypeNameWithWorld(), Misc.getBasePlayerColor());
                intel.setIcon(Global.getSettings().getSpriteName("intel", "new_planet_info"));
                Global.getSector().getCampaignUI().addMessage(intel, CommMessageAPI.MessageClickAction.INTEL_TAB, planet);
            }
        }
    }

    public static void setPreliminarySurveyed(MarketAPI market, TextPanelAPI text, boolean withNotification) {
        market.setSurveyLevel(MarketAPI.SurveyLevel.PRELIMINARY);
        if (withNotification && market.getPrimaryEntity() instanceof PlanetAPI) {
            PlanetAPI planet = (PlanetAPI)market.getPrimaryEntity();
            String string = "\u83b7\u5f97\u521d\u6b65\u8c03\u67e5\u6570\u636e " + planet.getName() + ", " + planet.getTypeNameWithWorld().toLowerCase();
            if (text != null) {
                text.setFontSmallInsignia();
                text.addParagraph(string, planet.getSpec().getIconColor());
                text.setFontInsignia();
            } else {
                MessageIntel intel = new MessageIntel("\u521d\u6b65\u8c03\u67e5\u6570\u636e\uff1a" + planet.getName() + ", " + planet.getTypeNameWithWorld(), Misc.getBasePlayerColor());
                intel.setIcon(Global.getSettings().getSpriteName("intel", "new_planet_info"));
                Global.getSector().getCampaignUI().addMessage(intel, CommMessageAPI.MessageClickAction.INTEL_TAB, planet);
            }
        }
    }

    public static void setSeen(MarketAPI market, TextPanelAPI text, boolean withNotification) {
        market.setSurveyLevel(MarketAPI.SurveyLevel.SEEN);
        if (withNotification && market.getPrimaryEntity() instanceof PlanetAPI) {
            PlanetAPI planet = (PlanetAPI)market.getPrimaryEntity();
            String type = planet.getSpec().getName();
            if (!planet.isGasGiant()) {
                type = type + " \u884c\u661f";
            }
            String string = "\u65b0\u7684\u884c\u661f\u6570\u636e\uff1a" + planet.getName() + ", " + type;
            if (text != null) {
                text.setFontSmallInsignia();
                text.addParagraph(string, planet.getSpec().getIconColor());
                text.setFontInsignia();
            } else {
                MessageIntel intel = new MessageIntel(string, Misc.getBasePlayerColor());
                intel.setIcon(Global.getSettings().getSpriteName("intel", "new_planet_info"));
                Global.getSector().getCampaignUI().addMessage(intel, CommMessageAPI.MessageClickAction.INTEL_TAB, planet);
            }
        }
    }

    public static String getStringWithTokenReplacement(String format, SectorEntityToken entity, Map<String, MemoryAPI> memoryMap) {
        return Global.getSector().getRules().performTokenReplacement(null, format, entity, memoryMap);
    }

    public static void renderQuadAlpha(float x, float y, float width, float height, Color color, float alphaMult) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)0);
        GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alphaMult)));
        GL11.glBegin((int)7);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glEnd();
    }

    public static void fadeAndExpire(SectorEntityToken entity) {
        Misc.fadeAndExpire(entity, 1.0f);
    }

    public static void fadeAndExpire(final SectorEntityToken entity, final float seconds) {
        if (entity.hasTag("fading_out_and_expiring")) {
            return;
        }
        entity.addTag("non_clickable");
        entity.addTag("fading_out_and_expiring");
        entity.addScript(new EveryFrameScript(){
            float elapsed = 0.0f;

            @Override
            public boolean runWhilePaused() {
                return false;
            }

            @Override
            public boolean isDone() {
                return entity.isExpired();
            }

            @Override
            public void advance(float amount) {
                float b;
                this.elapsed += amount;
                if (this.elapsed > seconds) {
                    entity.setExpired(true);
                }
                if ((b = 1.0f - this.elapsed / seconds) < 0.0f) {
                    b = 0.0f;
                }
                if (b > 1.0f) {
                    b = 1.0f;
                }
                entity.forceSensorFaderBrightness(Math.min(entity.getSensorFaderBrightness(), b));
                entity.setAlwaysUseSensorFaderBrightness(true);
            }
        });
    }

    public static void fadeInOutAndExpire(final SectorEntityToken entity, final float in, final float dur, final float out) {
        entity.addTag("non_clickable");
        entity.forceSensorFaderBrightness(0.0f);
        entity.setAlwaysUseSensorFaderBrightness(true);
        entity.addScript(new EveryFrameScript(){
            float elapsed = 0.0f;

            @Override
            public boolean runWhilePaused() {
                return false;
            }

            @Override
            public boolean isDone() {
                return entity.isExpired();
            }

            @Override
            public void advance(float amount) {
                this.elapsed += amount;
                if (this.elapsed > in + dur + out) {
                    entity.setExpired(true);
                }
                float b = 1.0f;
                if (this.elapsed < in) {
                    b = this.elapsed / in;
                } else if (this.elapsed > in + dur) {
                    b = 1.0f - (this.elapsed - in - dur) / out;
                }
                if (b < 0.0f) {
                    b = 0.0f;
                }
                if (b > 1.0f) {
                    b = 1.0f;
                }
                entity.forceSensorFaderBrightness(Math.min(entity.getSensorFaderBrightness(), b));
                entity.setAlwaysUseSensorFaderBrightness(true);
            }
        });
    }

    public static void fadeIn(final SectorEntityToken entity, final float in) {
        entity.forceSensorFaderBrightness(0.0f);
        entity.setAlwaysUseSensorFaderBrightness(true);
        entity.addScript(new EveryFrameScript(){
            float elapsed = 0.0f;

            @Override
            public boolean runWhilePaused() {
                return false;
            }

            @Override
            public boolean isDone() {
                return this.elapsed > in;
            }

            @Override
            public void advance(float amount) {
                this.elapsed += amount;
                if (this.elapsed > in) {
                    entity.setAlwaysUseSensorFaderBrightness(false);
                    return;
                }
                float b = this.elapsed / in;
                if (b < 0.0f) {
                    b = 0.0f;
                }
                if (b > 1.0f) {
                    b = 1.0f;
                }
                entity.forceSensorFaderBrightness(Math.min(entity.getSensorFaderBrightness(), b));
                entity.setAlwaysUseSensorFaderBrightness(true);
            }
        });
    }

    public static CustomCampaignEntityAPI addCargoPods(LocationAPI where, Vector2f loc) {
        CustomCampaignEntityAPI pods = where.addCustomEntity(null, null, "cargo_pods", "neutral");
        pods.getLocation().x = loc.x;
        pods.getLocation().y = loc.y;
        Vector2f vel = Misc.getUnitVectorAtDegreeAngle((float)Math.random() * 360.0f);
        vel.scale(5.0f + 10.0f * (float)Math.random());
        pods.getVelocity().set((ReadableVector2f)vel);
        pods.setDiscoverable(null);
        pods.setDiscoveryXP(null);
        pods.setSensorProfile(Float.valueOf(1.0f));
        return pods;
    }

    public static SectorEntityToken addDebrisField(LocationAPI loc, DebrisFieldTerrainPlugin.DebrisFieldParams params, Random random) {
        if (random == null) {
            random = Misc.random;
        }
        SectorEntityToken debris = loc.addTerrain("debris_field", params);
        debris.setSensorProfile(Float.valueOf(1.0f));
        debris.setDiscoverable(true);
        debris.setName(((CampaignTerrainAPI)debris).getPlugin().getTerrainName());
        float range = DebrisFieldTerrainPlugin.computeDetectionRange(params.bandWidthInEngine);
        debris.getDetectedRangeMod().modifyFlat("gen", range);
        debris.getMemoryWithoutUpdate().set("$salvageSeed", random.nextLong());
        SalvageEntityGenDataSpec.DropData data = new SalvageEntityGenDataSpec.DropData();
        data.group = "basic";
        data.value = (int)((1000.0f + params.bandWidthInEngine) * 5.0f);
        debris.addDropValue(data);
        debris.setDiscoveryXP(Float.valueOf((int)(params.bandWidthInEngine * 0.2f)));
        if (params.baseSalvageXP <= 0L) {
            debris.setSalvageXP(Float.valueOf((int)(params.bandWidthInEngine * 0.6f)));
        }
        return debris;
    }

    public static boolean isUnboardable(FleetMemberAPI member) {
        if (member.getVariant() != null && member.getVariant().hasTag("unboardable")) {
            return true;
        }
        return Misc.isUnboardable(member.getHullSpec());
    }

    public static boolean isUnboardable(ShipHullSpecAPI hullSpec) {
        if (hullSpec.getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.UNBOARDABLE)) {
            for (String tag : Misc.getAllowedRecoveryTags()) {
                if (!hullSpec.hasTag(tag)) continue;
                return false;
            }
            if (hullSpec.isDefaultDHull()) {
                ShipHullSpecAPI parent = hullSpec.getDParentHull();
                for (String tag : Misc.getAllowedRecoveryTags()) {
                    if (!parent.hasTag(tag)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isShipRecoverable(FleetMemberAPI member, CampaignFleetAPI recoverer, boolean own, boolean useOfficerRecovery, float chanceMult) {
        if (own) {
            if (!member.getVariant().getSMods().isEmpty()) {
                return true;
            }
            if (!member.getVariant().getSModdedBuiltIns().isEmpty()) {
                return true;
            }
            if (member.getCaptain() != null && !member.getCaptain().isDefault()) {
                return true;
            }
        }
        if (member.getVariant().hasTag("always_recoverable")) {
            return true;
        }
        Random rand = new Random((long)(1000000 * member.getId().hashCode()) + Global.getSector().getPlayerBattleSeed());
        float chance = Global.getSettings().getFloat("baseShipRecoveryChance");
        if (own) {
            chance = Global.getSettings().getFloat("baseOwnShipRecoveryChance");
        }
        chance = member.getStats().getDynamic().getMod("individual_ship_recovery_mod").computeEffective(chance);
        if (recoverer != null) {
            chance = recoverer.getStats().getDynamic().getMod("ship_recovery_mod").computeEffective(chance);
            if (useOfficerRecovery) {
                chance = recoverer.getStats().getDynamic().getMod("officer_ship_recovery_mod").computeEffective(chance);
            }
        }
        if ((chance *= chanceMult) < 0.0f) {
            chance = 0.0f;
        }
        if (chance > 1.0f) {
            chance = 1.0f;
        }
        boolean recoverable = rand.nextFloat() < chance;
        return recoverable;
    }

    public static JumpPointAPI findNearestJumpPointTo(SectorEntityToken entity) {
        return Misc.findNearestJumpPointTo(entity, false);
    }

    public static JumpPointAPI findNearestJumpPointTo(SectorEntityToken entity, boolean allowWormhole) {
        float min = Float.MAX_VALUE;
        JumpPointAPI result = null;
        List points = entity.getContainingLocation().getEntities(JumpPointAPI.class);
        for (JumpPointAPI curr : points) {
            float dist;
            if (!allowWormhole && curr.isWormhole() || curr.getMemoryWithoutUpdate().getBoolean("$unstable") || !((dist = Misc.getDistance(entity.getLocation(), curr.getLocation())) < min)) continue;
            min = dist;
            result = curr;
        }
        return result;
    }

    public static JumpPointAPI findNearestJumpPointThatCouldBeExitedFrom(SectorEntityToken entity) {
        float min = Float.MAX_VALUE;
        JumpPointAPI result = null;
        List points = entity.getContainingLocation().getEntities(JumpPointAPI.class);
        for (JumpPointAPI curr : points) {
            float dist;
            if (curr.isGasGiantAnchor() || curr.isStarAnchor() || !((dist = Misc.getDistance(entity.getLocation(), curr.getLocation())) < min)) continue;
            min = dist;
            result = curr;
        }
        return result;
    }

    public static SectorEntityToken findNearestPlanetTo(SectorEntityToken entity, boolean requireGasGiant, boolean allowStars) {
        float min = Float.MAX_VALUE;
        PlanetAPI result = null;
        List<PlanetAPI> planets = entity.getContainingLocation().getPlanets();
        for (PlanetAPI curr : planets) {
            float dist;
            if (requireGasGiant && !curr.isGasGiant() || !allowStars && curr.isStar() || !((dist = Misc.getDistance(entity.getLocation(), curr.getLocation())) < min)) continue;
            min = dist;
            result = curr;
        }
        return result;
    }

    public static final boolean shouldConvertFromStub(LocationAPI containingLocation, Vector2f location) {
        float dist;
        if (Global.getSector().getPlayerFleet() == null) {
            return false;
        }
        Vector2f stubLocInHyper = null;
        stubLocInHyper = containingLocation == null || containingLocation.isHyperspace() ? location : containingLocation.getLocation();
        Vector2f playerLoc = Global.getSector().getPlayerFleet().getLocationInHyperspace();
        boolean sameLoc = containingLocation != null && Global.getSector().getPlayerFleet().getContainingLocation() == containingLocation;
        float maxDist = 6000.0f;
        if (!sameLoc) {
            maxDist = 3000.0f;
        }
        return (dist = Misc.getDistance(playerLoc, stubLocInHyper)) < maxDist;
    }

    public static long genRandomSeed() {
        return Misc.seedUniquifier() ^ System.nanoTime();
    }

    public static long seedUniquifier() {
        long next;
        long current;
        while (!seedUniquifier.compareAndSet(current = seedUniquifier.get(), next = current * 181783497276652981L)) {
        }
        return next;
    }

    public static String genUID() {
        if (Global.getSettings() != null && Global.getSettings().isInGame() && (Global.getSettings().isInCampaignState() || Global.getSettings().isGeneratingNewGame())) {
            return Global.getSector().genUID();
        }
        return UUID.randomUUID().toString();
    }

    public static String colorsToString(List<Color> colors) {
        String result = "";
        for (Color c : colors) {
            result = result + Integer.toHexString(c.getRGB()) + "|";
        }
        if (result.length() > 0) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static List<Color> colorsFromString(String in) {
        ArrayList<Color> result = new ArrayList<Color>();
        for (String p : in.split("\\|")) {
            result.add(new Color((int)Long.parseLong(p, 16)));
        }
        return result;
    }

    public static JumpPointAPI getJumpPointTo(PlanetAPI star) {
        for (Object entity : Global.getSector().getHyperspace().getEntities(JumpPointAPI.class)) {
            JumpPointAPI jp = (JumpPointAPI)entity;
            if (jp.getDestinationVisualEntity() != star) continue;
            return jp;
        }
        return null;
    }

    public static JumpPointAPI findNearestJumpPoint(SectorEntityToken from) {
        float min = Float.MAX_VALUE;
        JumpPointAPI result = null;
        LocationAPI location = from.getContainingLocation();
        List points = location.getEntities(JumpPointAPI.class);
        for (JumpPointAPI curr : points) {
            float dist = Misc.getDistance(from.getLocation(), curr.getLocation());
            if (!(dist < min)) continue;
            min = dist;
            result = curr;
        }
        return result;
    }

    public static String getDHullId(ShipHullSpecAPI spec) {
        String base = spec.getHullId();
        if (base.endsWith(D_HULL_SUFFIX)) {
            return base;
        }
        return base + D_HULL_SUFFIX;
    }

    public static HullModSpecAPI getMod(String id) {
        return Global.getSettings().getHullModSpec(id);
    }

    public static float getDistanceFromArc(float direction, float arc, float angle) {
        direction = Misc.normalizeAngle(direction);
        angle = Misc.normalizeAngle(angle);
        float dist1 = Math.abs(angle - direction) - arc / 2.0f;
        float dist2 = Math.abs(360.0f - Math.abs(angle - direction)) - arc / 2.0f;
        if (dist1 <= 0.0f || dist2 <= 0.0f) {
            return 0.0f;
        }
        return dist1 > dist2 ? dist2 : dist1;
    }

    public static void initConditionMarket(PlanetAPI planet) {
        if (planet.getMarket() != null) {
            Global.getSector().getEconomy().removeMarket(planet.getMarket());
        }
        MarketAPI market = Global.getFactory().createMarket("market_" + planet.getId(), planet.getName(), 1);
        market.setPlanetConditionMarketOnly(true);
        market.setPrimaryEntity(planet);
        market.setFactionId("neutral");
        planet.setMarket(market);
        long seed = StarSystemGenerator.random.nextLong();
        planet.getMemoryWithoutUpdate().set("$salvageSeed", seed);
    }

    public static void initEconomyMarket(PlanetAPI planet) {
        if (planet.getMarket() != null) {
            Global.getSector().getEconomy().removeMarket(planet.getMarket());
        }
        MarketAPI market = Global.getFactory().createMarket("market_" + planet.getId(), planet.getName(), 1);
        market.setPrimaryEntity(planet);
        market.setFactionId("neutral");
        planet.setMarket(market);
        Global.getSector().getEconomy().addMarket(market, true);
    }

    public static String getSurveyLevelString(MarketAPI.SurveyLevel level, boolean withBrackets) {
        String str = " ";
        if (level == MarketAPI.SurveyLevel.NONE) {
            str = UNKNOWN;
        } else if (level == MarketAPI.SurveyLevel.SEEN) {
            str = UNSURVEYED;
        } else if (level == MarketAPI.SurveyLevel.PRELIMINARY) {
            str = PRELIMINARY;
        } else if (level == MarketAPI.SurveyLevel.FULL) {
            str = FULL;
        }
        if (withBrackets) {
            str = "[" + str + "]";
        }
        return str;
    }

    public static void setDefenderOverride(SectorEntityToken entity, DefenderDataOverride override) {
        entity.getMemoryWithoutUpdate().set("$salvageDOv", override);
    }

    public static void setSalvageSpecial(SectorEntityToken entity, Object data) {
        entity.getMemoryWithoutUpdate().set("$salvageSpecialData", data);
    }

    public static void setPrevSalvageSpecial(SectorEntityToken entity, Object data) {
        entity.getMemoryWithoutUpdate().set("$prevSalvageSpecialData", data);
    }

    public static Object getSalvageSpecial(SectorEntityToken entity) {
        return entity.getMemoryWithoutUpdate().get("$salvageSpecialData");
    }

    public static Object getPrevSalvageSpecial(SectorEntityToken entity) {
        return entity.getMemoryWithoutUpdate().get("$prevSalvageSpecialData");
    }

    public static List<StarSystemAPI> getSystemsInRange(SectorEntityToken from, Set<StarSystemAPI> exclude, boolean nonEmpty, float maxRange) {
        ArrayList<StarSystemAPI> systems = new ArrayList<StarSystemAPI>();
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            float dist;
            if (exclude != null && exclude.contains(system) || (dist = Misc.getDistance(from.getLocationInHyperspace(), system.getLocation())) > maxRange || nonEmpty && !Misc.systemHasPlanets(system)) continue;
            systems.add(system);
        }
        return systems;
    }

    public static PlanetAPI getPulsarInSystem(StarSystemAPI system) {
        if (system.getStar() != null && system.getStar().getSpec().isPulsar()) {
            return system.getStar();
        }
        if (system.getSecondary() != null && system.getSecondary().getSpec().isPulsar()) {
            return system.getSecondary();
        }
        if (system.getTertiary() != null && system.getTertiary().getSpec().isPulsar()) {
            return system.getTertiary();
        }
        return null;
    }

    public static boolean systemHasPlanets(StarSystemAPI system) {
        for (PlanetAPI p : system.getPlanets()) {
            if (p.isStar()) continue;
            return true;
        }
        return false;
    }

    public static float getCampaignShipScaleMult(ShipAPI.HullSize size) {
        switch (size) {
            case CAPITAL_SHIP: {
                return 0.07f;
            }
            case CRUISER: {
                return 0.08f;
            }
            case DESTROYER: {
                return 0.09f;
            }
            case FRIGATE: {
                return 0.11f;
            }
            case FIGHTER: {
                return 0.15f;
            }
            case DEFAULT: {
                return 0.1f;
            }
        }
        return 0.1f;
    }

    public static WeightedRandomPicker<String> createStringPicker(Object ... params) {
        return Misc.createStringPicker(StarSystemGenerator.random, params);
    }

    public static WeightedRandomPicker<String> createStringPicker(Random random, Object ... params) {
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(random);
        for (int i = 0; i < params.length; i += 2) {
            String item = (String)params[i];
            float weight = 0.0f;
            if (params[i + 1] instanceof Float) {
                weight = ((Float)params[i + 1]).floatValue();
            } else if (params[i + 1] instanceof Integer) {
                weight = ((Integer)params[i + 1]).intValue();
            }
            picker.add(item, weight);
        }
        return picker;
    }

    public static void setWarningBeaconGlowColor(SectorEntityToken beacon, Color color) {
        beacon.getMemoryWithoutUpdate().set(WarningBeaconEntityPlugin.GLOW_COLOR_KEY, color);
    }

    public static void setWarningBeaconPingColor(SectorEntityToken beacon, Color color) {
        beacon.getMemoryWithoutUpdate().set(WarningBeaconEntityPlugin.PING_COLOR_KEY, color);
    }

    public static void setWarningBeaconColors(SectorEntityToken beacon, Color glow, Color ping) {
        if (glow != null) {
            Misc.setWarningBeaconGlowColor(beacon, glow);
        }
        if (ping != null) {
            Misc.setWarningBeaconPingColor(beacon, ping);
        }
    }

    public static List<CampaignFleetAPI> getNearbyFleets(SectorEntityToken from, float maxDist) {
        ArrayList<CampaignFleetAPI> result = new ArrayList<CampaignFleetAPI>();
        for (CampaignFleetAPI other : from.getContainingLocation().getFleets()) {
            float dist;
            if (from == other || !((dist = Misc.getDistance(from.getLocation(), other.getLocation())) <= maxDist)) continue;
            result.add(other);
        }
        return result;
    }

    public static List<CampaignFleetAPI> getVisibleFleets(SectorEntityToken from, boolean includeSensorContacts) {
        ArrayList<CampaignFleetAPI> result = new ArrayList<CampaignFleetAPI>();
        for (CampaignFleetAPI other : from.getContainingLocation().getFleets()) {
            if (from == other) continue;
            SectorEntityToken.VisibilityLevel level = other.getVisibilityLevelTo(from);
            if (level == SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS || level == SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS) {
                result.add(other);
                continue;
            }
            if (level != SectorEntityToken.VisibilityLevel.SENSOR_CONTACT || !includeSensorContacts) continue;
            result.add(other);
        }
        return result;
    }

    public static boolean isSameCargo(CargoAPI baseOne, CargoAPI baseTwo) {
        CargoAPI one = Global.getFactory().createCargo(true);
        one.addAll(baseOne);
        one.sort();
        CargoAPI two = Global.getFactory().createCargo(true);
        two.addAll(baseTwo);
        two.sort();
        if (one.getStacksCopy().size() != two.getStacksCopy().size()) {
            return false;
        }
        List<CargoStackAPI> stacks1 = one.getStacksCopy();
        List<CargoStackAPI> stacks2 = two.getStacksCopy();
        for (int i = 0; i < stacks1.size(); ++i) {
            CargoStackAPI s1 = stacks1.get(i);
            CargoStackAPI s2 = stacks2.get(i);
            if ((s1 == null || s2 == null) && s1 != s2) {
                return false;
            }
            if (s1.getSize() != s2.getSize()) {
                return false;
            }
            if (s1.getType() != s2.getType()) {
                return false;
            }
            if ((s1.getData() == null || s2.getData() == null) && s1.getData() != s2.getData()) {
                return false;
            }
            if (s1.getData().equals(s2.getData())) continue;
            return false;
        }
        return true;
    }

    public static JumpPointAPI getDistressJumpPoint(StarSystemAPI system) {
        SectorEntityToken jumpPoint = null;
        float minDist = Float.MAX_VALUE;
        for (SectorEntityToken curr : system.getJumpPoints()) {
            float dist = Misc.getDistance(system.getCenter().getLocation(), curr.getLocation());
            if (!(dist < minDist)) continue;
            jumpPoint = curr;
            minDist = dist;
        }
        if (jumpPoint instanceof JumpPointAPI) {
            return (JumpPointAPI)jumpPoint;
        }
        return null;
    }

    public static void clearTarget(CampaignFleetAPI fleet, boolean forgetTransponder) {
        fleet.setInteractionTarget(null);
        if (fleet.getAI() instanceof ModularFleetAIAPI) {
            ModularFleetAIAPI ai = (ModularFleetAIAPI)fleet.getAI();
            ai.getTacticalModule().setTarget(null);
            ai.getTacticalModule().setPriorityTarget(null, 0.0f, false);
        }
        if (forgetTransponder) {
            Misc.forgetAboutTransponder(fleet);
        }
    }

    public static void giveStandardReturnToSourceAssignments(CampaignFleetAPI fleet) {
        Misc.giveStandardReturnToSourceAssignments(fleet, true);
    }

    public static boolean isFleetReturningToDespawn(CampaignFleetAPI fleet) {
        return fleet.getMemoryWithoutUpdate().getBoolean(FLEET_RETURNING_TO_DESPAWN);
    }

    public static void giveStandardReturnToSourceAssignments(CampaignFleetAPI fleet, boolean withClear) {
        if (withClear) {
            fleet.clearAssignments();
        }
        fleet.getMemoryWithoutUpdate().set(FLEET_RETURNING_TO_DESPAWN, true);
        MarketAPI source = Misc.getSourceMarket(fleet);
        if (source != null) {
            fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, source.getPrimaryEntity(), 1000.0f, "\u8fd4\u56de " + source.getName());
            fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, source.getPrimaryEntity(), 1.0f + 1.0f * (float)Math.random());
            fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, source.getPrimaryEntity(), 1000.0f);
        } else {
            SectorEntityToken entity = Misc.getSourceEntity(fleet);
            if (entity != null) {
                fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, entity, 1000.0f, "\u8fd4\u56de " + entity.getName());
                fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, entity, 1.0f + 1.0f * (float)Math.random());
                fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, entity, 1000.0f);
            } else {
                SectorEntityToken token = Global.getSector().getHyperspace().createToken(0.0f, 0.0f);
                fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, token, 1000.0f);
            }
        }
    }

    public static void giveStandardReturnAssignments(CampaignFleetAPI fleet, SectorEntityToken where, String text, boolean withClear) {
        if (withClear) {
            fleet.clearAssignments();
        }
        fleet.getMemoryWithoutUpdate().set(FLEET_RETURNING_TO_DESPAWN, true);
        if (text == null) {
            fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, where, 1000.0f, "\u8fd4\u56de " + where.getName());
        } else {
            fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, where, 1000.0f, text + " " + where.getName());
        }
        fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, where, 5.0f + 5.0f * (float)Math.random());
        fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, where, 1000.0f);
    }

    public static void adjustRep(float repChangeFaction, RepLevel limit, String factionId, float repChangePerson, RepLevel personLimit, PersonAPI person, TextPanelAPI text) {
        if (repChangeFaction != 0.0f) {
            CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
            impact.delta = repChangeFaction;
            impact.limit = limit;
            Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, text, true), factionId);
            if (person != null) {
                impact.delta = repChangePerson;
                impact.limit = personLimit;
                Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, text, true), person);
            }
        }
    }

    public static void interruptAbilitiesWithTag(CampaignFleetAPI fleet, String tag) {
        block0: for (AbilityPlugin curr : fleet.getAbilities().values()) {
            if (!curr.isActive()) continue;
            for (String t : curr.getSpec().getTags()) {
                if (!t.equals(tag)) continue;
                curr.deactivate();
                continue block0;
            }
        }
    }

    public static Vector2f getInterceptPoint(CampaignFleetAPI from, SectorEntityToken to) {
        float maxTime;
        Vector2f p2;
        Vector2f p1;
        float dist;
        float time;
        Vector2f v2 = Vector2f.sub((Vector2f)to.getVelocity(), (Vector2f)from.getVelocity(), (Vector2f)new Vector2f());
        float s1 = from.getTravelSpeed();
        float s2 = v2.length();
        if (s1 < 10.0f) {
            s1 = 10.0f;
        }
        if (s2 < 10.0f) {
            s2 = 10.0f;
        }
        if ((time = (dist = Misc.getDistance(p1 = new Vector2f((ReadableVector2f)from.getLocation()), p2 = new Vector2f((ReadableVector2f)to.getLocation()))) / s1) > (maxTime = dist / s2 * 0.75f)) {
            time = maxTime;
        }
        Vector2f p3 = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(v2));
        p3.scale(time * s2);
        Vector2f.add((Vector2f)p2, (Vector2f)p3, (Vector2f)p3);
        Vector2f overshoot = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(p1, p3));
        overshoot.scale(3000.0f);
        Vector2f.add((Vector2f)p3, (Vector2f)overshoot, (Vector2f)p3);
        return p3;
    }

    public static Vector2f getInterceptPoint(SectorEntityToken from, SectorEntityToken to, float maxSpeedFrom) {
        float maxTime;
        Vector2f p2;
        Vector2f p1;
        float dist;
        float time;
        Vector2f v2 = Vector2f.sub((Vector2f)to.getVelocity(), (Vector2f)from.getVelocity(), (Vector2f)new Vector2f());
        float s1 = maxSpeedFrom;
        float s2 = v2.length();
        if (s1 < 10.0f) {
            s1 = 10.0f;
        }
        if (s2 < 10.0f) {
            s2 = 10.0f;
        }
        if ((time = (dist = Misc.getDistance(p1 = new Vector2f((ReadableVector2f)from.getLocation()), p2 = new Vector2f((ReadableVector2f)to.getLocation()))) / s1) > (maxTime = dist / s2 * 0.75f)) {
            time = maxTime;
        }
        Vector2f p3 = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(v2));
        p3.scale(time * s2);
        Vector2f.add((Vector2f)p2, (Vector2f)p3, (Vector2f)p3);
        Vector2f overshoot = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(p1, p3));
        overshoot.scale(3000.0f);
        Vector2f.add((Vector2f)p3, (Vector2f)overshoot, (Vector2f)p3);
        return p3;
    }

    public static void stopPlayerFleet() {
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (player != null) {
            player.setVelocity(0.0f, 0.0f);
        }
    }

    public static String getListOfResources(Map<String, Integer> res, List<String> quantities) {
        ArrayList<String> list = new ArrayList<String>();
        for (String con : res.keySet()) {
            CommoditySpecAPI spec = Global.getSettings().getCommoditySpec(con);
            int qty = res.get(con);
            list.add("" + qty + " " + spec.getName().toLowerCase());
            quantities.add("" + qty);
        }
        return Misc.getAndJoined(list);
    }

    public static void setColor(Color color) {
        GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)color.getAlpha()));
    }

    public static void setColor(Color color, float alphaMult) {
        GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alphaMult)));
    }

    public static void setColor(Color color, int alpha) {
        GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)alpha));
    }

    public static boolean doesMarketHaveMissionImportantPeopleOrIsMarketMissionImportant(SectorEntityToken entity) {
        MarketAPI market = entity.getMarket();
        if (market == null) {
            return false;
        }
        if (market.getPrimaryEntity() != entity) {
            return false;
        }
        if (market.getMemoryWithoutUpdate().getBoolean("$missionImportant")) {
            return true;
        }
        if (market != null && market.getCommDirectory() != null) {
            for (CommDirectoryEntryAPI entry : market.getCommDirectory().getEntriesCopy()) {
                PersonAPI person;
                if (entry.getType() != CommDirectoryEntryAPI.EntryType.PERSON || !(entry.getEntryData() instanceof PersonAPI) || !(person = (PersonAPI)entry.getEntryData()).getMemoryWithoutUpdate().getBoolean("$missionImportant")) continue;
                return true;
            }
        }
        return false;
    }

    public static void makeImportant(SectorEntityToken entity, String reason) {
        Misc.makeImportant(entity.getMemoryWithoutUpdate(), reason, -1.0f);
    }

    public static void makeImportant(SectorEntityToken entity, String reason, float dur) {
        Misc.makeImportant(entity.getMemoryWithoutUpdate(), reason, dur);
    }

    public static void makeImportant(PersonAPI person, String reason) {
        Misc.makeImportant(person.getMemoryWithoutUpdate(), reason, -1.0f);
    }

    public static void makeImportant(PersonAPI person, String reason, float dur) {
        Misc.makeImportant(person.getMemoryWithoutUpdate(), reason, dur);
    }

    public static void makeImportant(MemoryAPI memory, String reason) {
        Misc.setFlagWithReason(memory, "$missionImportant", reason, true, -1.0f);
    }

    public static void makeImportant(MemoryAPI memory, String reason, float dur) {
        Misc.setFlagWithReason(memory, "$missionImportant", reason, true, dur);
    }

    public static boolean isImportantForReason(MemoryAPI memory, String reason) {
        String flagKey = "$missionImportant";
        return Misc.flagHasReason(memory, flagKey, reason);
    }

    public static void makeUnimportant(SectorEntityToken entity, String reason) {
        Misc.makeUnimportant(entity.getMemoryWithoutUpdate(), reason);
    }

    public static void makeUnimportant(PersonAPI person, String reason) {
        Misc.makeUnimportant(person.getMemoryWithoutUpdate(), reason);
    }

    public static void makeUnimportant(MemoryAPI memory, String reason) {
        Misc.setFlagWithReason(memory, "$missionImportant", reason, false, 0.0f);
    }

    public static void cleanUpMissionMemory(MemoryAPI memory, String prefix) {
        ArrayList<String> unset2 = new ArrayList<String>();
        for (String key : memory.getKeys()) {
            if (!key.startsWith("$" + prefix)) continue;
            unset2.add(key);
        }
        for (String key : unset2) {
            memory.unset(key);
        }
        if (prefix.endsWith("_")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        Misc.setFlagWithReason(memory, "$missionImportant", prefix, false, 0.0f);
    }

    public static void clearAreaAroundPlayer(float minDist) {
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (player == null) {
            return;
        }
        for (CampaignFleetAPI other : player.getContainingLocation().getFleets()) {
            float dist;
            if (player == other || other.getBattle() != null || other.getOrbit() != null || !other.isHostileTo(player) || !((dist = Misc.getDistance(player.getLocation(), other.getLocation())) < minDist)) continue;
            float angle = Misc.getAngleInDegrees(player.getLocation(), other.getLocation());
            Vector2f v = Misc.getUnitVectorAtDegreeAngle(angle);
            v.scale(minDist);
            Vector2f.add((Vector2f)v, (Vector2f)other.getLocation(), (Vector2f)v);
            other.setLocation(v.x, v.y);
        }
    }

    public static long getSalvageSeed(SectorEntityToken entity) {
        return Misc.getSalvageSeed(entity, false);
    }

    public static long getSalvageSeed(SectorEntityToken entity, boolean nonRandom) {
        long seed = entity.getMemoryWithoutUpdate().getLong("$salvageSeed");
        if (seed == 0L) {
            String id = entity.getId();
            if (id == null) {
                id = Misc.genUID();
            }
            seed = nonRandom ? (long)(entity.getId().hashCode() * 17000) * 1181783497276652981L : Misc.seedUniquifier() ^ (long)(entity.getId().hashCode() * 17000);
            Random r = new Random(seed);
            for (int i = 0; i < 5; ++i) {
                r.nextLong();
            }
            long result = r.nextLong();
            entity.getMemoryWithoutUpdate().set("$salvageSeed", result);
            return result;
        }
        return seed;
    }

    public static long getNameBasedSeed(SectorEntityToken entity) {
        String id = entity.getName();
        if (id == null) {
            id = Misc.genUID();
        }
        long seed = entity.getId().hashCode() * 17000;
        Random r = new Random(seed);
        for (int i = 0; i < 53; ++i) {
            r.nextLong();
        }
        long result = r.nextLong();
        return result;
    }

    public static void forgetAboutTransponder(CampaignFleetAPI fleet) {
        MemoryAPI mem = fleet.getMemoryWithoutUpdate();
        if (mem.getBoolean("$cfai_makeHostileWhileTOff")) {
            mem.removeAllRequired("$cfai_makeHostileWhileTOff");
        }
        mem.unset("$sawPlayerTransponderOff");
        mem.unset("$sawPlayerTransponderOn");
    }

    public static void setAbandonedStationMarket(String marketId, SectorEntityToken station) {
        station.getMemoryWithoutUpdate().set("$abandonedStation", true);
        MarketAPI market = Global.getFactory().createMarket(marketId, station.getName(), 0);
        market.setSurveyLevel(MarketAPI.SurveyLevel.FULL);
        market.setPrimaryEntity(station);
        market.setFactionId(station.getFaction().getId());
        market.addCondition("abandoned_station");
        market.addSubmarket("storage");
        market.setPlanetConditionMarketOnly(false);
        ((StoragePlugin)market.getSubmarket("storage").getPlugin()).setPlayerPaidToUnlock(true);
        station.setMarket(market);
        station.getMemoryWithoutUpdate().unset("$tradeMode");
    }

    public static float getDesiredMoveDir(CampaignFleetAPI fleet) {
        if (fleet.getMoveDestination() == null) {
            return 0.0f;
        }
        if (fleet.wasSlowMoving()) {
            Vector2f vel = fleet.getVelocity();
            Vector2f neg = new Vector2f((ReadableVector2f)vel);
            neg.negate();
            return Misc.getAngleInDegrees(neg);
        }
        return Misc.getAngleInDegrees(fleet.getLocation(), fleet.getMoveDestination());
    }

    public static boolean isPermaKnowsWhoPlayerIs(CampaignFleetAPI fleet) {
        MemoryAPI mem = fleet.getMemoryWithoutUpdate();
        return mem.contains("$sawPlayerTransponderOn") && mem.getExpire("$sawPlayerTransponderOn") < 0.0f;
    }

    public static ImmigrationPlugin getImmigrationPlugin(MarketAPI market) {
        ImmigrationPlugin plugin = Global.getSector().getPluginPicker().pickImmigrationPlugin(market);
        if (plugin == null) {
            plugin = new CoreImmigrationPluginImpl(market);
        }
        return plugin;
    }

    public static AICoreAdminPlugin getAICoreAdminPlugin(String commodityId) {
        AICoreAdminPlugin plugin = Global.getSector().getPluginPicker().pickAICoreAdminPlugin(commodityId);
        return plugin;
    }

    public static AICoreOfficerPlugin getAICoreOfficerPlugin(String commodityId) {
        AICoreOfficerPlugin plugin = Global.getSector().getPluginPicker().pickAICoreOfficerPlugin(commodityId);
        return plugin;
    }

    public static AbandonMarketPlugin getAbandonMarketPlugin(MarketAPI market) {
        AbandonMarketPlugin plugin = Global.getSector().getGenericPlugins().pickPlugin(AbandonMarketPlugin.class, market);
        return plugin;
    }

    public static StabilizeMarketPlugin getStabilizeMarketPlugin(MarketAPI market) {
        StabilizeMarketPlugin plugin = Global.getSector().getGenericPlugins().pickPlugin(StabilizeMarketPlugin.class, market);
        return plugin;
    }

    public static FleetInflater getInflater(CampaignFleetAPI fleet, Object params) {
        FleetInflater plugin = Global.getSector().getPluginPicker().pickFleetInflater(fleet, params);
        return plugin;
    }

    public static boolean playerHasStorageAccess(MarketAPI market) {
        SubmarketAPI storage = market.getSubmarket("storage");
        return storage != null && storage.getPlugin().getOnClickAction(null) == SubmarketPlugin.OnClickAction.OPEN_SUBMARKET;
    }

    public static float getMarketSizeProgress(MarketAPI market) {
        ImmigrationPlugin plugin = Misc.getImmigrationPlugin(market);
        float min = plugin.getWeightForMarketSize(market.getSize());
        float max = plugin.getWeightForMarketSize(market.getSize() + 1);
        float curr = market.getPopulation().getWeightValue();
        if (max <= min) {
            return 0.0f;
        }
        float f = (curr - min) / (max - min);
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public static float getStorageFeeFraction() {
        float storageFreeFraction = Global.getSettings().getFloat("storageFreeFraction");
        return storageFreeFraction;
    }

    public static int getStorageCostPerMonth(MarketAPI market) {
        return (int)(Misc.getStorageTotalValue(market) * Misc.getStorageFeeFraction());
    }

    public static SubmarketPlugin getStorage(MarketAPI market) {
        if (market == null) {
            return null;
        }
        SubmarketAPI submarket = market.getSubmarket("storage");
        if (submarket == null) {
            return null;
        }
        return (StoragePlugin)submarket.getPlugin();
    }

    public static SubmarketPlugin getLocalResources(MarketAPI market) {
        SubmarketAPI submarket = market.getSubmarket("local_resources");
        if (submarket == null) {
            return null;
        }
        return submarket.getPlugin();
    }

    public static CargoAPI getStorageCargo(MarketAPI market) {
        if (market == null) {
            return null;
        }
        SubmarketAPI submarket = market.getSubmarket("storage");
        if (submarket == null) {
            return null;
        }
        return submarket.getCargo();
    }

    public static CargoAPI getLocalResourcesCargo(MarketAPI market) {
        SubmarketAPI submarket = market.getSubmarket("local_resources");
        if (submarket == null) {
            return null;
        }
        return submarket.getCargo();
    }

    public static float getStorageTotalValue(MarketAPI market) {
        return Misc.getStorageCargoValue(market) + Misc.getStorageShipValue(market);
    }

    public static float getStorageCargoValue(MarketAPI market) {
        SubmarketPlugin plugin = Misc.getStorage(market);
        if (plugin == null) {
            return 0.0f;
        }
        float value = 0.0f;
        for (CargoStackAPI stack : plugin.getCargo().getStacksCopy()) {
            value += stack.getSize() * (float)stack.getBaseValuePerUnit();
        }
        return value;
    }

    public static float getStorageShipValue(MarketAPI market) {
        SubmarketPlugin plugin = Misc.getStorage(market);
        if (plugin == null) {
            return 0.0f;
        }
        float value = 0.0f;
        for (FleetMemberAPI member : plugin.getCargo().getMothballedShips().getMembersListCopy()) {
            value += member.getBaseValue();
        }
        return value;
    }

    public static boolean addStorageInfo(TooltipMakerAPI tooltip, Color color, Color dark, MarketAPI market, boolean includeLocalResources, boolean addSectionIfEmpty) {
        int cost;
        String title;
        SubmarketPlugin storage = Misc.getStorage(market);
        SubmarketPlugin local = Misc.getLocalResources(market);
        CargoAPI cargo = Global.getFactory().createCargo(true);
        ArrayList<FleetMemberAPI> ships = new ArrayList<FleetMemberAPI>();
        if (storage != null) {
            cargo.addAll(storage.getCargo());
            ships.addAll(storage.getCargo().getMothballedShips().getMembersListCopy());
        }
        if (local != null && includeLocalResources) {
            cargo.addAll(local.getCargo());
            ships.addAll(local.getCargo().getMothballedShips().getMembersListCopy());
        }
        float opad = 15.0f;
        if (!cargo.isEmpty() || addSectionIfEmpty) {
            title = "\u5b58\u50a8\u7684\u8d27\u7269";
            if (includeLocalResources && local != null) {
                title = "\u4ed3\u5e93\u5b58\u50a8\u4e0e\u8d44\u6e90\u5e93\u5b58";
            }
            tooltip.addSectionHeading(title, color, dark, Alignment.MID, opad);
            opad = 10.0f;
            tooltip.showCargo(cargo, 10, true, opad);
        }
        if (!ships.isEmpty() || addSectionIfEmpty) {
            title = "\u5165\u5e93\u4e2d\u7684\u8230\u8239";
            if (includeLocalResources && local != null) {
                title = "\u5165\u5e93\u4e2d\u7684\u8230\u8239";
            }
            tooltip.addSectionHeading(title, color, dark, Alignment.MID, opad);
            opad = 10.0f;
            tooltip.showShips(ships, 10, true, opad);
        }
        if (!market.isPlayerOwned() && (cost = Misc.getStorageCostPerMonth(market)) > 0) {
            tooltip.addPara("\u6bcf\u6708\u4ed3\u7ba1\u8d39\uff1a%s", opad, Misc.getHighlightColor(), Misc.getDGSCredits(cost));
        }
        if (addSectionIfEmpty) {
            return true;
        }
        return !cargo.isEmpty() || !ships.isEmpty();
    }

    public static String getTokenReplaced(String in, SectorEntityToken entity) {
        in = Global.getSector().getRules().performTokenReplacement(null, in, entity, null);
        return in;
    }

    public static float getOutpostPenalty() {
        return Global.getSettings().getFloat("colonyOverMaxPenalty");
    }

    public static float getAdminSalary(PersonAPI admin) {
        int tier = (int)admin.getMemoryWithoutUpdate().getFloat("$ome_adminTier");
        String salaryKey = "adminSalaryTier" + tier;
        float s = Global.getSettings().getInt(salaryKey);
        return s;
    }

    public static float getOfficerSalary(PersonAPI officer) {
        return Misc.getOfficerSalary(officer, Misc.isMercenary(officer));
    }

    public static float getOfficerSalary(PersonAPI officer, boolean mercenary) {
        int officerBase = Global.getSettings().getInt("officerSalaryBase");
        int officerPerLevel = Global.getSettings().getInt("officerSalaryPerLevel");
        float payMult = 1.0f;
        if (mercenary) {
            payMult = Global.getSettings().getFloat("officerMercPayMult");
        }
        float salary = (float)(officerBase + officer.getStats().getLevel() * officerPerLevel) * payMult;
        return salary;
    }

    public static String getHullIdForVariantId(String variantId) {
        String hull = variantToHullCache.get(variantId);
        if (hull != null) {
            return hull;
        }
        ShipVariantAPI variant = Global.getSettings().getVariant(variantId);
        hull = variant.getHullSpec().getHullId();
        variantToHullCache.put(variantId, hull);
        return hull;
    }

    public static int getFPForVariantId(String variantId) {
        Integer fp = variantToFPCache.get(variantId);
        if (fp != null) {
            return fp;
        }
        ShipVariantAPI variant = Global.getSettings().getVariant(variantId);
        fp = variant.getHullSpec().getFleetPoints();
        variantToFPCache.put(variantId, fp);
        return fp;
    }

    public static FactionPersonalityPickerPlugin getFactionPersonalityPicker() {
        return (FactionPersonalityPickerPlugin)Global.getSettings().getPlugin("factionPersonalityPicker");
    }

    public static float getAdjustedStrength(float fp, MarketAPI market) {
        fp *= Math.max(0.25f, 0.5f + Math.min(1.0f, Misc.getShipQuality(market)));
        if (market != null) {
            float numShipsMult = market.getStats().getDynamic().getMod("combat_fleet_size_mult").computeEffective(0.0f);
            fp *= numShipsMult;
            float pts = market.getFaction().getDoctrine().getOfficerQuality();
            fp *= 1.0f + (pts - 1.0f) / 4.0f;
        }
        return fp;
    }

    public static float getAdjustedFP(float fp, MarketAPI market) {
        if (market != null) {
            float numShipsMult = market.getStats().getDynamic().getMod("combat_fleet_size_mult").computeEffective(0.0f);
            fp *= numShipsMult;
        }
        return fp;
    }

    public static float getShipQuality(MarketAPI market) {
        return Misc.getShipQuality(market, null);
    }

    public static float getShipQuality(MarketAPI market, String factionId) {
        return ShipQuality.getShipQuality(market, factionId);
    }

    public static FactionAPI.ShipPickMode getShipPickMode(MarketAPI market) {
        return Misc.getShipPickMode(market, null);
    }

    public static FactionAPI.ShipPickMode getShipPickMode(MarketAPI market, String factionId) {
        ShipQuality.QualityData d = ShipQuality.getInstance().getQualityData(market);
        if (d.market != null) {
            if (factionId == null && d.market.getFaction() != market.getFaction()) {
                return FactionAPI.ShipPickMode.IMPORTED;
            }
            if (factionId != null && !factionId.equals(d.market.getFactionId())) {
                return FactionAPI.ShipPickMode.IMPORTED;
            }
            return FactionAPI.ShipPickMode.PRIORITY_THEN_ALL;
        }
        return FactionAPI.ShipPickMode.IMPORTED;
    }

    public static boolean isBusy(CampaignFleetAPI fleet) {
        return fleet.getMemoryWithoutUpdate().getBoolean("$core_fleetBusy");
    }

    public static SectorEntityToken getStationEntity(MarketAPI market, CampaignFleetAPI fleet) {
        for (SectorEntityToken entity : market.getConnectedEntities()) {
            CampaignFleetAPI curr;
            if (!entity.hasTag("station") || (curr = Misc.getStationFleet(entity)) == null || curr != fleet) continue;
            return entity;
        }
        return null;
    }

    public static CampaignFleetAPI getStationFleet(MarketAPI market) {
        for (SectorEntityToken entity : market.getConnectedEntities()) {
            CampaignFleetAPI fleet;
            if (!entity.hasTag("station") || (fleet = Misc.getStationFleet(entity)) == null) continue;
            return fleet;
        }
        return null;
    }

    public static CampaignFleetAPI getStationFleet(SectorEntityToken station) {
        Object test;
        if (station.hasTag("station") && (test = station.getMemoryWithoutUpdate().get("$stationFleet")) instanceof CampaignFleetAPI) {
            return (CampaignFleetAPI)test;
        }
        return null;
    }

    public static CampaignFleetAPI getStationBaseFleet(MarketAPI market) {
        for (SectorEntityToken entity : market.getConnectedEntities()) {
            CampaignFleetAPI fleet;
            if (!entity.hasTag("station") || (fleet = Misc.getStationBaseFleet(entity)) == null) continue;
            return fleet;
        }
        return null;
    }

    public static CampaignFleetAPI getStationBaseFleet(SectorEntityToken station) {
        Object test;
        if (station.hasTag("station") && (test = station.getMemoryWithoutUpdate().get("$stationBaseFleet")) instanceof CampaignFleetAPI) {
            return (CampaignFleetAPI)test;
        }
        return null;
    }

    public static MarketAPI getStationMarket(CampaignFleetAPI station) {
        Object test = station.getMemoryWithoutUpdate().get("$stationMarket");
        if (test instanceof MarketAPI) {
            return (MarketAPI)test;
        }
        return null;
    }

    public static Industry getStationIndustry(MarketAPI market) {
        for (Industry ind : market.getIndustries()) {
            if (!ind.getSpec().hasTag("station")) continue;
            return ind;
        }
        return null;
    }

    public static boolean isActiveModule(ShipVariantAPI variant) {
        boolean notActiveModule = variant.getHullSpec().getOrdnancePoints(null) <= 0 && variant.getWeaponGroups().isEmpty() && variant.getHullSpec().getFighterBays() <= 0;
        return !notActiveModule;
    }

    public static boolean isActiveModule(ShipAPI ship) {
        boolean notActiveModule = ship.getVariant().getHullSpec().getOrdnancePoints(null) <= 0 && ship.getVariant().getWeaponGroups().isEmpty() && ship.getMutableStats().getNumFighterBays().getModifiedValue() <= 0.0f;
        return !notActiveModule;
    }

    public static void addCreditsMessage(String format, int credits) {
        Global.getSector().getCampaignUI().getMessageDisplay().addMessage(String.format(format, Misc.getDGSCredits(credits)), Misc.getTooltipTitleAndLightHighlightColor(), Misc.getDGSCredits(credits), Misc.getHighlightColor());
    }

    public static Vector2f getSystemJumpPointHyperExitLocation(JumpPointAPI jp) {
        for (JumpPointAPI.JumpDestination d : jp.getDestinations()) {
            if (d.getDestination() == null || d.getDestination().getContainingLocation() == null || !d.getDestination().getContainingLocation().isHyperspace()) continue;
            return d.getDestination().getLocation();
        }
        return jp.getLocationInHyperspace();
    }

    public static boolean isNear(SectorEntityToken entity, Vector2f hyperLoc) {
        float maxRange = Global.getSettings().getFloat("commRelayRangeAroundSystem");
        float dist = Misc.getDistanceLY(entity.getLocationInHyperspace(), hyperLoc);
        return !(dist > maxRange);
    }

    public static float getDays(float amount) {
        return Global.getSector().getClock().convertToDays(amount);
    }

    public static float getProbabilityMult(float desired, float current, float deviationMult) {
        float deviation = desired * deviationMult;
        float exponent = (desired - current) / deviation;
        if (exponent > 4.0f) {
            exponent = 4.0f;
        }
        float probMult = (float)Math.pow(10.0, exponent);
        return probMult;
    }

    public static boolean isHyperspaceAnchor(SectorEntityToken entity) {
        return entity != null && entity.hasTag("system_anchor");
    }

    public static StarSystemAPI getStarSystemForAnchor(SectorEntityToken anchor) {
        return (StarSystemAPI)anchor.getMemoryWithoutUpdate().get("$anchor_starSystem");
    }

    public static void showCost(TextPanelAPI text, Color color, Color dark, String[] res, int[] quantities) {
        Misc.showCost(text, "\u8d44\u6e90\uff1a\u6d88\u8017 (\u53ef\u7528) ", true, color, dark, res, quantities);
    }

    public static void showCost(TextPanelAPI text, String title, boolean withAvailable, Color color, Color dark, String[] res, int[] quantities) {
        Misc.showCost(text, title, withAvailable, -1.0f, color, dark, res, quantities, null);
    }

    public static void showCost(TextPanelAPI text, String title, boolean withAvailable, float widthOverride, Color color, Color dark, String[] res, int[] quantities, boolean[] consumed) {
        if (color == null) {
            color = Misc.getBasePlayerColor();
        }
        if (dark == null) {
            dark = Misc.getDarkPlayerColor();
        }
        HashSet<String> unmet = new HashSet<String>();
        LinkedHashSet<String> all = new LinkedHashSet<String>();
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        for (int i = 0; i < res.length; ++i) {
            int quantity = quantities[i];
            String commodityId = res[i];
            if ((float)quantity > cargo.getQuantity(CargoAPI.CargoItemType.RESOURCES, commodityId)) {
                unmet.add(commodityId);
            }
            all.add(commodityId);
        }
        float costHeight = 67.0f;
        ResourceCostPanelAPI cost = text.addCostPanel(title, costHeight, color, dark);
        cost.setNumberOnlyMode(true);
        cost.setWithBorder(false);
        cost.setAlignment(Alignment.LMID);
        if (widthOverride > 0.0f) {
            cost.setComWidthOverride(widthOverride);
        }
        boolean dgs = true;
        for (int i = 0; i < res.length; ++i) {
            String commodityId = res[i];
            int required = quantities[i];
            int available = (int)cargo.getCommodityQuantity(commodityId);
            Color curr = color;
            if (withAvailable && (float)required > cargo.getQuantity(CargoAPI.CargoItemType.RESOURCES, commodityId)) {
                curr = Misc.getNegativeHighlightColor();
            }
            if (dgs) {
                if (withAvailable) {
                    cost.addCost(commodityId, Misc.getWithDGS(required) + " (" + Misc.getWithDGS(available) + ")", curr);
                } else {
                    cost.addCost(commodityId, Misc.getWithDGS(required), curr);
                }
                if (consumed == null || !consumed[i]) continue;
                cost.setLastCostConsumed(true);
                continue;
            }
            if (withAvailable) {
                cost.addCost(commodityId, "" + required + " (" + available + ")", curr);
            } else {
                cost.addCost(commodityId, "" + required, curr);
            }
            if (consumed == null || !consumed[i]) continue;
            cost.setLastCostConsumed(true);
        }
        cost.update();
    }

    public static boolean isPlayerFactionSetUp() {
        String key = "$shownFactionConfigDialog";
        return Global.getSector().getMemoryWithoutUpdate().contains(key);
    }

    public static boolean isPatrol(CampaignFleetAPI fleet) {
        return fleet.getMemoryWithoutUpdate().getBoolean("$isPatrol");
    }

    public static boolean isSmuggler(CampaignFleetAPI fleet) {
        return fleet.getMemoryWithoutUpdate().getBoolean("$isSmuggler");
    }

    public static boolean isTrader(CampaignFleetAPI fleet) {
        return fleet.getMemoryWithoutUpdate().getBoolean("$isTradeFleet");
    }

    public static boolean isPirate(CampaignFleetAPI fleet) {
        return fleet.getMemoryWithoutUpdate().getBoolean("$isPirate");
    }

    public static boolean isScavenger(CampaignFleetAPI fleet) {
        return fleet.getMemoryWithoutUpdate().getBoolean("$isScavenger");
    }

    public static boolean isRaider(CampaignFleetAPI fleet) {
        return fleet.getMemoryWithoutUpdate().getBoolean("$isRaider");
    }

    public static boolean isWarFleet(CampaignFleetAPI fleet) {
        return fleet.getMemoryWithoutUpdate().getBoolean("$isWarFleet");
    }

    public static Pair<SectorEntityToken, CampaignFleetAPI> getNearestStationInSupportRange(CampaignFleetAPI from) {
        SectorEntityToken closestEntity = null;
        CampaignFleetAPI closest = null;
        float minDist = Float.MAX_VALUE;
        for (SectorEntityToken sectorEntityToken : from.getContainingLocation().getCustomEntitiesWithTag("station")) {
            float dist;
            CampaignFleetAPI fleet = Misc.getStationFleet(sectorEntityToken);
            if (fleet == null || fleet.isEmpty() || !Misc.isStationInSupportRange(from, fleet) || !((dist = Misc.getDistance(from.getLocation(), sectorEntityToken.getLocation())) < minDist)) continue;
            closest = fleet;
            closestEntity = sectorEntityToken;
            minDist = dist;
        }
        for (CampaignFleetAPI campaignFleetAPI : from.getContainingLocation().getFleets()) {
            float dist;
            if (!campaignFleetAPI.isStationMode() || campaignFleetAPI.isHidden() || !Misc.isStationInSupportRange(from, campaignFleetAPI) || !((dist = Misc.getDistance(from.getLocation(), campaignFleetAPI.getLocation())) < minDist)) continue;
            closest = campaignFleetAPI;
            closestEntity = null;
            minDist = dist;
        }
        if (closest == null) {
            return null;
        }
        return new Pair<Object, Object>(closestEntity, closest);
    }

    public static boolean isStationInSupportRange(CampaignFleetAPI fleet, CampaignFleetAPI station) {
        float check = Misc.getBattleJoinRange();
        float distPrimary = 10000.0f;
        MarketAPI market = Misc.getStationMarket(station);
        if (market != null) {
            distPrimary = Misc.getDistance(fleet.getLocation(), market.getPrimaryEntity().getLocation());
        }
        float distStation = Misc.getDistance(fleet.getLocation(), station.getLocation());
        return !(distPrimary > check) || !(distStation > check);
    }

    public static float getMemberStrength(FleetMemberAPI member) {
        return Misc.getMemberStrength(member, true, true, true);
    }

    public static float getMemberStrength(FleetMemberAPI member, boolean withHull, boolean withQuality, boolean withCaptain) {
        float min;
        float str = member.getMemberStrength();
        if (str < (min = 0.25f)) {
            str = min;
        }
        float quality = 0.5f;
        float sMods = 0.0f;
        if (member.getFleetData() != null && member.getFleetData().getFleet() != null) {
            CampaignFleetAPI fleet = member.getFleetData().getFleet();
            if (fleet.getInflater() != null && !fleet.isInflated()) {
                quality = fleet.getInflater().getQuality();
                sMods = fleet.getInflater().getAverageNumSMods();
            } else {
                CampaignFleetAPI source;
                BattleAPI battle = fleet.getBattle();
                CampaignFleetAPI campaignFleetAPI = source = battle == null ? null : battle.getSourceFleet(member);
                if (source != null && source.getInflater() != null && !source.isInflated()) {
                    quality = source.getInflater().getQuality();
                    sMods = source.getInflater().getAverageNumSMods();
                } else {
                    float dmods = DModManager.getNumDMods(member.getVariant());
                    quality = 1.0f - Global.getSettings().getFloat("qualityPerDMod") * dmods;
                    if (quality < 0.0f) {
                        quality = 0.0f;
                    }
                    sMods = member.getVariant().getSMods().size();
                }
            }
        }
        if (member.isStation()) {
            quality = 1.0f;
        }
        if (sMods > 0.0f) {
            quality += sMods * Global.getSettings().getFloat("qualityPerSMod");
        }
        float captainMult = 1.0f;
        if (member.getCaptain() != null) {
            float captainLevel = (float)member.getCaptain().getStats().getLevel() - 1.0f;
            captainMult = member.isStation() ? (captainMult += captainLevel / (MAX_OFFICER_LEVEL * 2.0f)) : (captainMult += captainLevel / MAX_OFFICER_LEVEL);
        }
        if (withQuality) {
            str *= Math.max(0.25f, 0.8f + quality * 0.4f);
        }
        if (withHull) {
            str *= 0.5f + 0.5f * member.getStatus().getHullFraction();
        }
        if (withCaptain) {
            str *= captainMult;
        }
        return str;
    }

    public static void increaseMarketHostileTimeout(MarketAPI market, float days) {
        MemoryAPI mem = market.getMemoryWithoutUpdate();
        float expire2 = days;
        if (mem.contains("$playerHostileTimeout")) {
            expire2 += mem.getExpire("$playerHostileTimeout");
        }
        if (expire2 > 180.0f) {
            expire2 = 180.0f;
        }
        if (expire2 > 0.0f) {
            mem.set("$playerHostileTimeout", true, expire2);
        }
    }

    public static void removeRadioChatter(MarketAPI market) {
        if (market.getContainingLocation() == null) {
            return;
        }
        for (CampaignTerrainAPI terrain : market.getContainingLocation().getTerrainCopy()) {
            float dist;
            if (!"radio_chatter".equals(terrain.getType()) || !((dist = Misc.getDistance(terrain, market.getPrimaryEntity())) < 200.0f)) continue;
            market.getContainingLocation().removeEntity(terrain);
        }
    }

    public static Color getDesignTypeColor(String designType) {
        return Global.getSettings().getDesignTypeColor(designType);
    }

    public static Color getDesignTypeColorDim(String designType) {
        Color c = Global.getSettings().getDesignTypeColor(designType);
        return Misc.scaleColorOnly(c, 0.53f);
    }

    public static LabelAPI addDesignTypePara(TooltipMakerAPI tooltip, String design, float pad) {
        if (design != null && !design.isEmpty()) {
            return tooltip.addPara("\u8bbe\u8ba1\u7c7b\u578b\uff1a %s", pad, Misc.getGrayColor(), Global.getSettings().getDesignTypeColor(design), design);
        }
        return null;
    }

    public static float getFleetRadiusTerrainEffectMult(CampaignFleetAPI fleet) {
        float min = Global.getSettings().getBaseFleetSelectionRadius() + Global.getSettings().getFleetSelectionRadiusPerUnitSize();
        float max = Global.getSettings().getMaxFleetSelectionRadius();
        float radius = fleet.getRadius();
        float mult = (radius - min) / (max - min);
        if (mult > 1.0f) {
            mult = 1.0f;
        }
        if (mult < MIN_TERRAIN_EFFECT_MULT) {
            mult = MIN_TERRAIN_EFFECT_MULT;
        }
        float skillMod = fleet.getCommanderStats().getDynamic().getValue("nav_penalty_mult");
        mult *= skillMod;
        mult = (float)Math.round(mult * 100.0f) / 100.0f;
        return mult;
    }

    public static float getBurnMultForTerrain(CampaignFleetAPI fleet) {
        float mult = Misc.getFleetRadiusTerrainEffectMult(fleet);
        mult = 1.0f - BURN_PENALTY_MULT * mult;
        if ((mult = (float)Math.round(mult * 100.0f) / 100.0f) < 0.1f) {
            mult = 0.1f;
        }
        return mult;
    }

    public static void addHitGlow(LocationAPI location, Vector2f loc, Vector2f vel, float size, Color color) {
        float dur = 1.0f + (float)Math.random();
        Misc.addHitGlow(location, loc, vel, size, dur, color);
    }

    public static void addHitGlow(LocationAPI location, Vector2f loc, Vector2f vel, float size, float dur, Color color) {
        location.addHitParticle(loc, vel, size, 0.4f, dur, color);
        location.addHitParticle(loc, vel, size * 0.25f, 0.4f, dur, color);
        location.addHitParticle(loc, vel, size * 0.15f, 1.0f, dur, Color.white);
    }

    public static ParticleControllerAPI[] addGlowyParticle(LocationAPI location, Vector2f loc, Vector2f vel, float size, float rampUp, float dur, Color color) {
        ParticleControllerAPI[] result = new ParticleControllerAPI[]{location.addParticle(loc, vel, size, 0.4f, rampUp, dur, color), location.addParticle(loc, vel, size * 0.25f, 0.4f, rampUp, dur, color), location.addParticle(loc, vel, size * 0.15f, 1.0f, rampUp, dur, Color.white)};
        return result;
    }

    public static int getShippingCapacity(MarketAPI market, boolean inFaction) {
        float \u4e00\u4e2a = (float)Math.round(market.getAccessibilityMod().computeEffective(0.0f) * 100.0f) / 100.0f;
        if (inFaction) {
            \u4e00\u4e2a += SAME_FACTION_BONUS;
        }
        return (int)Math.max(0.0f, \u4e00\u4e2a / PER_UNIT_SHIPPING);
    }

    public static String getStrengthDesc(float strAdjustedFP) {
        String strDesc = strAdjustedFP < 50.0f ? "\u975e\u5e38\u5f31\u5c0f" : (strAdjustedFP < 150.0f ? "\u6bd4\u8f83\u5f31\u5c0f" : (strAdjustedFP < 300.0f ? "\u9887\u5177\u5a01\u80c1" : (strAdjustedFP < 750.0f ? "\u6bd4\u8f83\u5f3a\u5927" : (strAdjustedFP < 1250.0f ? "\u76f8\u5f53\u5f3a\u5927" : "\u975e\u5e38\u5f3a\u5927"))));
        return strDesc;
    }

    public static boolean isMilitary(MarketAPI market) {
        return market != null && market.getMemoryWithoutUpdate().getBoolean("$military");
    }

    public static boolean hasHeavyIndustry(MarketAPI market) {
        boolean heavyIndustry = false;
        for (Industry curr : market.getIndustries()) {
            if (!curr.getSpec().hasTag("heavyindustry")) continue;
            heavyIndustry = true;
        }
        return heavyIndustry;
    }

    public static boolean hasOrbitalStation(MarketAPI market) {
        for (Industry curr : market.getIndustries()) {
            if (!curr.getSpec().hasTag("station")) continue;
            return true;
        }
        return false;
    }

    public static FactionAPI getClaimingFaction(SectorEntityToken planet) {
        String claimedBy;
        if (planet.getStarSystem() != null && (claimedBy = planet.getStarSystem().getMemoryWithoutUpdate().getString("$claimingFaction")) != null) {
            return Global.getSector().getFaction(claimedBy);
        }
        int max = 0;
        MarketAPI result = null;
        List<MarketAPI> markets = Global.getSector().getEconomy().getMarkets(planet.getContainingLocation());
        for (MarketAPI curr : markets) {
            boolean territorial;
            JSONObject json;
            if (curr.isHidden() || curr.getFaction().isPlayerFaction()) continue;
            int score = curr.getSize();
            for (MarketAPI other : markets) {
                if (other == curr || other.getFaction() != curr.getFaction()) continue;
                ++score;
            }
            if (Misc.isMilitary(curr)) {
                score += 10;
            }
            if (score <= max || (json = curr.getFaction().getCustom().optJSONObject("punitiveExpeditionData")) == null || !(territorial = json.optBoolean("territorial"))) continue;
            max = score;
            result = curr;
        }
        if (result == null) {
            return null;
        }
        return result.getFaction();
    }

    public static int computeTotalShutdownRefund(MarketAPI market) {
        int total = 0;
        for (Industry industry : market.getIndustries()) {
            total += Misc.computeShutdownRefund(market, industry);
        }
        return total;
    }

    public static int computeShutdownRefund(MarketAPI market, Industry industry) {
        String up;
        float refund = 0.0f;
        Industry upInd = null;
        if (industry.isUpgrading() && (up = industry.getSpec().getUpgrade()) != null) {
            upInd = market.instantiateIndustry(up);
        }
        if (industry.isUpgrading() && upInd != null) {
            refund += upInd.getBuildCost();
        }
        float refundFraction = Global.getSettings().getFloat("industryRefundFraction");
        Industry curr = industry;
        while (curr != null) {
            refund = curr.isBuilding() && !curr.isUpgrading() ? (refund += curr.getBuildCost()) : (refund += curr.getBuildCost() * refundFraction);
            String down = curr.getSpec().getDowngrade();
            if (down != null) {
                curr = market.instantiateIndustry(down);
                continue;
            }
            curr = null;
        }
        return (int)refund;
    }

    public static SectorEntityToken addWarningBeacon(SectorEntityToken center, BaseThemeGenerator.OrbitGap gap, String beaconTag) {
        CustomCampaignEntityAPI beacon = center.getContainingLocation().addCustomEntity(null, null, "warning_beacon", "neutral");
        beacon.addTag(beaconTag);
        float radius = (gap.start + gap.end) / 2.0f;
        float orbitDays = radius / (10.0f + StarSystemGenerator.random.nextFloat() * 5.0f);
        beacon.setCircularOrbitPointingDown(center, StarSystemGenerator.random.nextFloat() * 360.0f, radius, orbitDays);
        Color glowColor = new Color(255, 200, 0, 255);
        Color pingColor = new Color(255, 200, 0, 255);
        if (beaconTag.equals("beacon_medium")) {
            glowColor = new Color(250, 155, 0, 255);
            pingColor = new Color(250, 155, 0, 255);
        } else if (beaconTag.equals("beacon_high")) {
            glowColor = new Color(250, 55, 0, 255);
            pingColor = new Color(250, 125, 0, 255);
        }
        Misc.setWarningBeaconColors(beacon, glowColor, pingColor);
        return beacon;
    }

    public static CampaignUIAPI.CoreUITradeMode getTradeMode(MemoryAPI memory) {
        CampaignUIAPI.CoreUITradeMode mode = CampaignUIAPI.CoreUITradeMode.OPEN;
        String val = memory.getString("$tradeMode");
        if (val != null && !val.isEmpty()) {
            mode = CampaignUIAPI.CoreUITradeMode.valueOf(val);
        }
        return mode;
    }

    public static boolean isSpacerStart() {
        return Global.getSector().getMemoryWithoutUpdate().getBoolean("$spacerStart");
    }

    public static Industry getSpaceport(MarketAPI market) {
        for (Industry ind : market.getIndustries()) {
            if (!ind.getSpec().hasTag("spaceport")) continue;
            return ind;
        }
        return null;
    }

    public static Color setBrightness(Color color, int brightness) {
        float max = color.getRed();
        if ((float)color.getGreen() > max) {
            max = color.getGreen();
        }
        if ((float)color.getBlue() > max) {
            max = color.getBlue();
        }
        float f = (float)brightness / max;
        color = Misc.scaleColorSaturate(color, f);
        return color;
    }

    public static Color scaleColorSaturate(Color color, float factor) {
        int red = (int)((float)color.getRed() * factor);
        int green = (int)((float)color.getGreen() * factor);
        int blue = (int)((float)color.getBlue() * factor);
        int alpha = (int)((float)color.getAlpha() * factor);
        if (red > 255) {
            red = 255;
        }
        if (green > 255) {
            green = 255;
        }
        if (blue > 255) {
            blue = 255;
        }
        if (alpha > 255) {
            alpha = 255;
        }
        return new Color(red, green, blue, alpha);
    }

    public static int getMaxOfficers(CampaignFleetAPI fleet) {
        int max = (int)fleet.getCommander().getStats().getOfficerNumber().getModifiedValue();
        return max;
    }

    public static int getNumNonMercOfficers(CampaignFleetAPI fleet) {
        int count = 0;
        for (OfficerDataAPI od : fleet.getFleetData().getOfficersCopy()) {
            if (Misc.isMercenary(od.getPerson())) continue;
            ++count;
        }
        return count;
    }

    public static List<OfficerDataAPI> getMercs(CampaignFleetAPI fleet) {
        ArrayList<OfficerDataAPI> mercs = new ArrayList<OfficerDataAPI>();
        for (OfficerDataAPI od : fleet.getFleetData().getOfficersCopy()) {
            if (!Misc.isMercenary(od.getPerson())) continue;
            mercs.add(od);
        }
        return mercs;
    }

    public static int getMaxIndustries(MarketAPI market) {
        return Math.round(market.getStats().getDynamic().getMod("max_industries").computeEffective(0.0f));
    }

    public static int getNumIndustries(MarketAPI market) {
        int count = 0;
        for (Industry curr : market.getIndustries()) {
            Industry upInd;
            String up;
            if (curr.isIndustry()) {
                ++count;
                continue;
            }
            if (!curr.isUpgrading() || (up = curr.getSpec().getUpgrade()) == null || !(upInd = market.instantiateIndustry(up)).isIndustry()) continue;
            ++count;
        }
        for (ConstructionQueue.ConstructionQueueItem item : market.getConstructionQueue().getItems()) {
            IndustrySpecAPI spec = Global.getSettings().getIndustrySpec(item.id);
            if (!spec.hasTag("industry")) continue;
            ++count;
        }
        return count;
    }

    public static int getNumImprovedIndustries(MarketAPI market) {
        int count = 0;
        for (Industry curr : market.getIndustries()) {
            if (!curr.isImproved()) continue;
            ++count;
        }
        return count;
    }

    public static int getNumStableLocations(StarSystemAPI system) {
        int count = system.getEntitiesWithTag("stable_location").size();
        count += system.getEntitiesWithTag("objective").size();
        for (SectorEntityToken e : system.getJumpPoints()) {
            JumpPointAPI jp;
            if (!(e instanceof JumpPointAPI) || !(jp = (JumpPointAPI)e).isWormhole()) continue;
            ++count;
        }
        return count;
    }

    public static Industry getCurrentlyBeingConstructed(MarketAPI market) {
        for (Industry curr : market.getIndustries()) {
            if (curr.getSpec().hasTag("population") || !curr.isBuilding() || curr.isUpgrading()) continue;
            return curr;
        }
        return null;
    }

    public static Color getRelColor(float rel) {
        Color relColor = new Color(125, 125, 125, 255);
        if (rel > 1.0f) {
            rel = 1.0f;
        }
        if (rel < -1.0f) {
            rel = -1.0f;
        }
        if (rel > 0.0f) {
            relColor = Misc.interpolateColor(relColor, Misc.getPositiveHighlightColor(), Math.max(0.15f, rel));
        } else if (rel < 0.0f) {
            relColor = Misc.interpolateColor(relColor, Misc.getNegativeHighlightColor(), Math.max(0.15f, -rel));
        }
        return relColor;
    }

    public static MusicPlayerPlugin getMusicPlayerPlugin() {
        if (musicPlugin == null) {
            musicPlugin = (MusicPlayerPlugin)Global.getSettings().getNewPluginInstance("musicPlugin");
        }
        return musicPlugin;
    }

    public static int getDangerLevel(CampaignFleetAPI fleet) {
        float strength;
        if (fleet.getMemoryWithoutUpdate().contains(DANGER_LEVEL_OVERRIDE)) {
            return (int)fleet.getMemoryWithoutUpdate().getFloat(DANGER_LEVEL_OVERRIDE);
        }
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        float playerStr = 0.0f;
        float fleetStr = 0.0f;
        for (FleetMemberAPI member : pf.getFleetData().getMembersListCopy()) {
            strength = Misc.getMemberStrength(member, true, true, true);
            playerStr += strength;
        }
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            strength = Misc.getMemberStrength(member, true, true, true);
            fleetStr += strength;
        }
        if (playerStr > fleetStr * 3.0f) {
            return 1;
        }
        if (playerStr > fleetStr * 1.5f) {
            return 2;
        }
        if (playerStr > fleetStr * 0.75f) {
            return 3;
        }
        if (playerStr > fleetStr * 0.33f) {
            return 4;
        }
        return 5;
    }

    public static float getHitGlowSize(float baseSize, float baseDamage, ApplyDamageResultAPI result) {
        if (result == null || baseDamage <= 0.0f) {
            return baseSize;
        }
        float sd = result.getDamageToShields() + result.getOverMaxDamageToShields();
        float ad = result.getTotalDamageToArmor();
        float hd = result.getDamageToHull();
        float ed = result.getEmpDamage();
        DamageType type = result.getType();
        return Misc.getHitGlowSize(baseSize, baseDamage, type, sd, ad, hd, ed);
    }

    public static float getHitGlowSize(float baseSize, float baseDamage, DamageType type, float sd, float ad, float hd, float ed) {
        float maxMult;
        float mult;
        float minBonus = 0.0f;
        if (type == DamageType.KINETIC) {
            sd *= 0.5f;
        } else if (type == DamageType.HIGH_EXPLOSIVE) {
            if ((ad *= 0.5f) > 0.0f) {
                minBonus = 0.1f;
            }
        } else if (type == DamageType.FRAGMENTATION) {
            if (hd > 0.0f) {
                minBonus = 0.2f * (hd / (hd + ad));
            }
            sd *= 2.0f;
            ad *= 2.0f;
            hd *= 2.0f;
        }
        float totalDamage = sd + ad + hd;
        if (totalDamage <= 0.0f) {
            return baseSize;
        }
        if (totalDamage < baseDamage && (totalDamage += ed) > baseDamage) {
            totalDamage = baseDamage;
        }
        float minSize = 15.0f;
        float minMult = minSize / baseSize;
        if ((minMult = Math.max(minMult, 0.67f + minBonus)) > 1.0f) {
            minMult = 1.0f;
        }
        if ((mult = totalDamage / baseDamage) < minMult) {
            mult = minMult;
        }
        if (mult > (maxMult = 1.5f)) {
            mult = maxMult;
        }
        return baseSize * mult;
    }

    public static int getNumEliteSkills(PersonAPI person) {
        int count = 0;
        for (MutableCharacterStatsAPI.SkillLevelAPI sl : person.getStats().getSkillsCopy()) {
            if (!(sl.getLevel() >= 2.0f)) continue;
            ++count;
        }
        return count;
    }

    public static boolean isMentored(PersonAPI person) {
        return person.getMemoryWithoutUpdate().is(MENTORED, true);
    }

    public static void setMentored(PersonAPI person, boolean mentored) {
        person.getMemoryWithoutUpdate().set(MENTORED, mentored);
    }

    public static boolean isMercenary(PersonAPI person) {
        return person != null && person.getMemoryWithoutUpdate().is(IS_MERCENARY, true);
    }

    public static void setMercHiredNow(PersonAPI person) {
        person.getMemoryWithoutUpdate().set(MERCENARY_HIRE_TIMESTAMP, Global.getSector().getClock().getTimestamp());
    }

    public static float getMercDaysSinceHired(PersonAPI person) {
        long ts = person.getMemoryWithoutUpdate().getLong(MERCENARY_HIRE_TIMESTAMP);
        return Global.getSector().getClock().getElapsedDaysSince(ts);
    }

    public static void setMercenary(PersonAPI person, boolean mercenary) {
        person.getMemoryWithoutUpdate().set(IS_MERCENARY, mercenary);
    }

    public static boolean isUnremovable(PersonAPI person) {
        return person != null && person.getMemoryWithoutUpdate().is(CAPTAIN_UNREMOVABLE, true);
    }

    public static void setUnremovable(PersonAPI person, boolean unremovable) {
        person.getMemoryWithoutUpdate().set(CAPTAIN_UNREMOVABLE, unremovable);
    }

    public static boolean isAutomated(MutableShipStatsAPI stats) {
        if (stats == null) {
            return false;
        }
        return Misc.isAutomated(stats.getFleetMember());
    }

    public static boolean isAutomated(FleetMemberAPI member) {
        return member != null && member.getVariant() != null && Misc.isAutomated(member.getVariant());
    }

    public static boolean isAutomated(ShipVariantAPI variant) {
        return variant != null && variant.hasHullMod("automated");
    }

    public static boolean isAutomated(ShipAPI ship) {
        if (ship == null) {
            return false;
        }
        return Misc.isAutomated(ship.getVariant());
    }

    public static Set<String> getAllowedRecoveryTags() {
        HashSet tags = (HashSet)Global.getSector().getMemoryWithoutUpdate().get(RECOVERY_TAGS_KEY);
        if (tags == null) {
            tags = new HashSet();
            Global.getSector().getMemoryWithoutUpdate().set(RECOVERY_TAGS_KEY, tags);
        }
        return tags;
    }

    public static int getMaxPermanentMods(ShipAPI ship) {
        if (ship == null) {
            return 0;
        }
        return Math.round(ship.getMutableStats().getDynamic().getMod("max_permanent_hullmods_mod").computeEffective(MAX_PERMA_MODS));
    }

    public static int getMaxPermanentMods(FleetMemberAPI member, MutableCharacterStatsAPI stats) {
        if (member == null) {
            return 0;
        }
        PersonAPI prev = member.getFleetCommanderForStats();
        PersonAPI fake = Global.getFactory().createPerson();
        fake.setStats(stats);
        member.setFleetCommanderForStats(fake, null);
        int num = Math.round(member.getStats().getDynamic().getMod("max_permanent_hullmods_mod").computeEffective(MAX_PERMA_MODS));
        member.setFleetCommanderForStats(prev, null);
        return num;
    }

    public static float getBuildInBonusXP(HullModSpecAPI mod, ShipAPI.HullSize size) {
        float fraction = 0.0f;
        switch (size) {
            case CAPITAL_SHIP: {
                fraction = Global.getSettings().getBonusXP("permModCapital");
                break;
            }
            case CRUISER: {
                fraction = Global.getSettings().getBonusXP("permModCruiser");
                break;
            }
            case DESTROYER: {
                fraction = Global.getSettings().getBonusXP("permModDestroyer");
                break;
            }
            case FRIGATE: {
                fraction = Global.getSettings().getBonusXP("permModFrigate");
            }
        }
        if (fraction < 0.0f) {
            fraction = 0.0f;
        }
        if (fraction > 1.0f) {
            fraction = 1.0f;
        }
        return fraction;
    }

    public static int getOPCost(HullModSpecAPI mod, ShipAPI.HullSize size) {
        switch (size) {
            case CAPITAL_SHIP: {
                return mod.getCapitalCost();
            }
            case CRUISER: {
                return mod.getCruiserCost();
            }
            case DESTROYER: {
                return mod.getDestroyerCost();
            }
            case FRIGATE: {
                return mod.getFrigateCost();
            }
        }
        return mod.getFrigateCost();
    }

    public static boolean isSpecialMod(ShipVariantAPI variant, HullModSpecAPI spec) {
        if (spec.isHidden()) {
            return false;
        }
        if (spec.isHiddenEverywhere()) {
            return false;
        }
        if (spec.hasTag("dmod")) {
            return false;
        }
        if (!variant.getPermaMods().contains(spec.getId())) {
            return false;
        }
        if (variant.getHullSpec().getBuiltInMods().contains(spec.getId())) {
            return false;
        }
        return variant.getSMods().contains(spec.getId());
    }

    public static boolean hasSModdableBuiltIns(ShipVariantAPI variant) {
        if (!CAN_SMOD_BUILT_IN || variant == null) {
            return false;
        }
        int num = 0;
        for (String id : variant.getHullMods()) {
            HullModSpecAPI spec = Global.getSettings().getHullModSpec(id);
            if (spec.isHidden() || spec.isHiddenEverywhere() || spec.hasTag("dmod") || !variant.getHullSpec().isBuiltInMod(id) || !spec.getEffect().hasSModEffect() || spec.getEffect().isSModEffectAPenalty() || variant.getSModdedBuiltIns().contains(id)) continue;
            ++num;
        }
        return num > 0;
    }

    public static int getCurrSpecialMods(ShipVariantAPI variant) {
        if (variant == null) {
            return 0;
        }
        int num = 0;
        for (String id : variant.getHullMods()) {
            HullModSpecAPI spec = Global.getSettings().getHullModSpec(id);
            if (!Misc.isSpecialMod(variant, spec)) continue;
            ++num;
        }
        return num;
    }

    public static List<HullModSpecAPI> getCurrSpecialModsList(ShipVariantAPI variant) {
        ArrayList<HullModSpecAPI> result = new ArrayList<HullModSpecAPI>();
        if (variant == null) {
            return result;
        }
        boolean num = false;
        for (String id : variant.getHullMods()) {
            HullModSpecAPI spec = Global.getSettings().getHullModSpec(id);
            if (!Misc.isSpecialMod(variant, spec)) continue;
            result.add(spec);
        }
        return result;
    }

    public static boolean isSlowMoving(CampaignFleetAPI fleet) {
        return fleet.getCurrBurnLevel() <= (float)Misc.getGoSlowBurnLevel(fleet);
    }

    public static int getGoSlowBurnLevel(CampaignFleetAPI fleet) {
        float bonus = fleet.getStats().getDynamic().getMod("move_slow_speed_bonus_mod").computeEffective(0.0f);
        int burn = Math.round(fleet.getFleetData().getMinBurnLevel() * SNEAK_BURN_MULT);
        burn = (int)((float)burn + bonus);
        return burn;
    }

    public static void applyDamage(FleetMemberAPI member, Random random, FleetMemberDamageLevel level, boolean withCRDamage, String crDamageId, String crDamageReason, boolean withMessage, TextPanelAPI textPanel, String messageText) {
        float damageMult = 1.0f;
        switch (level) {
            case LOW: {
                damageMult = 3.0f;
                break;
            }
            case MEDIUM: {
                damageMult = 10.0f;
                break;
            }
            case HIGH: {
                damageMult = 20.0f;
            }
        }
        Misc.applyDamage(member, random, damageMult, withCRDamage, crDamageId, crDamageReason, withMessage, textPanel, messageText);
    }

    public static void applyDamage(FleetMemberAPI member, Random random, float damageMult, boolean withCRDamage, String crDamageId, String crDamageReason, boolean withMessage, TextPanelAPI textPanel, String messageText) {
        if (random == null) {
            random = Misc.random;
        }
        float hitStrength = member.getHullSpec().getArmorRating() * 2.0f;
        float hullDamageFraction = 0.025f * (damageMult *= 0.75f + random.nextFloat() * 0.5f);
        float max = 0.5f + random.nextFloat() * 0.1f;
        float min = 0.01f + random.nextFloat() * 0.04f;
        if (hullDamageFraction > max) {
            hullDamageFraction = max;
        }
        if (hullDamageFraction < min) {
            hullDamageFraction = min;
        }
        if (hitStrength > 0.0f) {
            boolean isPF;
            float numHits = 3.0f;
            int i = 0;
            while ((float)i < numHits) {
                member.getStatus().applyDamage(hitStrength / numHits, hullDamageFraction / numHits);
                ++i;
            }
            if (member.getStatus().getHullFraction() < 0.01f) {
                member.getStatus().setHullFraction(0.01f);
            }
            boolean bl = isPF = member != null && member.getFleetData() != null && member.getFleetData().getFleet() != null && member.getFleetData().getFleet().isPlayerFleet();
            if (withCRDamage) {
                float crPerDep = member.getDeployCost();
                float currCR = member.getRepairTracker().getBaseCR();
                float crDamage = Math.min(currCR, crPerDep * 0.1f * damageMult);
                if (crDamage > 0.0f) {
                    if (isPF) {
                        member.getRepairTracker().applyCREvent(-crDamage, crDamageId, crDamageReason);
                    } else {
                        member.getRepairTracker().applyCREvent(-crDamage, null, null);
                    }
                }
            }
            if (withMessage && isPF) {
                MessageIntel intel = new MessageIntel(messageText, Misc.getNegativeHighlightColor());
                intel.setIcon(Global.getSettings().getSpriteName("intel", "damage_report"));
                if (textPanel != null) {
                    Global.getSector().getIntelManager().addIntelToTextPanel(intel, textPanel);
                } else {
                    Global.getSector().getCampaignUI().addMessage(intel, CommMessageAPI.MessageClickAction.REFIT_TAB, member);
                }
            }
        }
    }

    public static float getBonusXPForRecovering(FleetMemberAPI member) {
        float ownedShip = Global.getSettings().getBonusXP("recoverOwnedShip");
        float threshold = Global.getSettings().getBonusXP("recoverNoBonusXPDeploymentPoints");
        if (member.getOwner() == 0) {
            return ownedShip;
        }
        float f = 1.0f - member.getDeploymentPointsCost() / threshold;
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public static float[] getBonusXPForScuttling(FleetMemberAPI member) {
        float points = 0.0f;
        float xp = 0.0f;
        for (SModRecord record : PlaythroughLog.getInstance().getSModsInstalled()) {
            if (member != record.getMember() || record.getMember() == null) continue;
            points += (float)record.getSPSpent();
            xp += record.getBonusXPFractionGained() * (float)record.getSPSpent();
        }
        if (points > 0.0f) {
            return new float[]{points, 1.0f - xp / points};
        }
        return new float[]{0.0f, 0.0f};
    }

    public static float getSpawnFPMult(CampaignFleetAPI fleet) {
        float mult = fleet.getMemoryWithoutUpdate().getFloat(FleetFactoryV3.KEY_SPAWN_FP_MULT);
        if (mult == 0.0f) {
            mult = 1.0f;
        }
        return mult;
    }

    public static void setSpawnFPMult(CampaignFleetAPI fleet, float mult) {
        fleet.getMemoryWithoutUpdate().set(FleetFactoryV3.KEY_SPAWN_FP_MULT, Float.valueOf(mult));
    }

    public static boolean isDecentralized(FactionAPI faction) {
        return faction != null && faction.getCustomBoolean("decentralized");
    }

    public static String getPersonalityName(PersonAPI person) {
        String personalityName = person.getPersonalityAPI().getDisplayName();
        if (person.isAICore() && "reckless".equals(person.getPersonalityAPI().getId())) {
            personalityName = "\u65e0\u6240\u754f\u60e7";
        }
        return personalityName;
    }

    public static void setRaidedTimestamp(MarketAPI market) {
        market.getMemoryWithoutUpdate().set(LAST_RAIDED_AT, Global.getSector().getClock().getTimestamp());
    }

    public static float getDaysSinceLastRaided(MarketAPI market) {
        Long ts = market.getMemoryWithoutUpdate().getLong(LAST_RAIDED_AT);
        if (ts == null) {
            return Float.MAX_VALUE;
        }
        return Global.getSector().getClock().getElapsedDaysSince(ts);
    }

    public static int computeEconUnitChangeFromTradeModChange(CommodityOnMarketAPI com, int quantity) {
        float currQty = com.getCombinedTradeModQuantity();
        int currMod = (int)com.getModValueForQuantity(currQty);
        float quantityWithTX = com.getTradeMod().getModifiedValue() + (float)quantity + Math.max(com.getTradeModPlus().getModifiedValue(), 0.0f) + Math.min(com.getTradeModMinus().getModifiedValue(), 0.0f);
        int newMod = (int)com.getModValueForQuantity(quantityWithTX);
        int diff = newMod - currMod;
        return diff;
    }

    public static void affectAvailabilityWithinReason(CommodityOnMarketAPI com, int quantity) {
        int units = Misc.computeEconUnitChangeFromTradeModChange(com, quantity);
        int maxUnits = Math.min(3, Math.max(com.getMaxDemand(), com.getMaxSupply()));
        if (Math.abs(units) > maxUnits) {
            int sign = (int)Math.signum(quantity);
            quantity = Math.round(com.getQuantityForModValue(maxUnits));
            quantity *= sign;
        }
        com.addTradeMod("mod_" + Misc.genUID(), quantity, BaseSubmarketPlugin.TRADE_IMPACT_DAYS);
    }

    public static boolean isOpenlyPopulated(StarSystemAPI system) {
        for (MarketAPI market : Misc.getMarketsInLocation(system)) {
            if (market.isHidden()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAtLeastOneOfTags(Collection<String> tags, String ... other) {
        for (String tag : other) {
            if (!tags.contains(tag)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasUnexploredRuins(MarketAPI market) {
        return market != null && market.isPlanetConditionMarketOnly() && Misc.hasRuins(market) && !market.getMemoryWithoutUpdate().getBoolean("$ruinsExplored");
    }

    public static boolean hasRuins(MarketAPI market) {
        return market != null && (market.hasCondition("ruins_scattered") || market.hasCondition("ruins_widespread") || market.hasCondition("ruins_extensive") || market.hasCondition("ruins_vast"));
    }

    public static boolean hasFarmland(MarketAPI market) {
        return market != null && (market.hasCondition("farmland_poor") || market.hasCondition("farmland_adequate") || market.hasCondition("farmland_rich") || market.hasCondition("farmland_bountiful"));
    }

    public static void addDefeatTrigger(CampaignFleetAPI fleet, String trigger) {
        List<String> triggers = Misc.getDefeatTriggers(fleet, true);
        triggers.add(trigger);
    }

    public static void removeDefeatTrigger(CampaignFleetAPI fleet, String trigger) {
        List<String> triggers = Misc.getDefeatTriggers(fleet, false);
        if (triggers != null) {
            triggers.remove(trigger);
            Misc.clearDefeatTriggersIfNeeded(fleet);
        }
    }

    public static List<String> getDefeatTriggers(CampaignFleetAPI fleet, boolean createIfNecessary) {
        MemoryAPI mem = fleet.getMemoryWithoutUpdate();
        ArrayList<String> triggers = null;
        if (!mem.contains(DEFEAT_TRIGGERS)) {
            if (!createIfNecessary) {
                return null;
            }
            triggers = new ArrayList<String>();
            mem.set(DEFEAT_TRIGGERS, triggers);
        } else {
            triggers = (ArrayList<String>)mem.get(DEFEAT_TRIGGERS);
        }
        return triggers;
    }

    public static void clearDefeatTriggersIfNeeded(CampaignFleetAPI fleet) {
        List<String> triggers = Misc.getDefeatTriggers(fleet, false);
        if (triggers != null && triggers.isEmpty()) {
            MemoryAPI mem = fleet.getMemoryWithoutUpdate();
            mem.unset(DEFEAT_TRIGGERS);
        }
    }

    public static boolean shouldShowDamageFloaty(ShipAPI source, ShipAPI target) {
        CombatEngineAPI engine = Global.getCombatEngine();
        ShipAPI playerShip = engine.getPlayerShip();
        boolean sourceIsPlayerShipWing = false;
        sourceIsPlayerShipWing = source != null && source.getWing() != null && source.getWing().getSourceShip() == playerShip;
        CombatEntityAPI followedEntity = engine.getCombatUI().getEntityToFollowV2();
        boolean showFloaty = target == playerShip || target == followedEntity || source == playerShip || sourceIsPlayerShipWing || target == playerShip.getShipTarget() || engine.hasAttachedFloaty(target);
        showFloaty = showFloaty && !target.isFighter();
        showFloaty = showFloaty && Global.getSettings().isShowDamageFloaties();
        return showFloaty;
    }

    public static boolean canCheckVram() {
        if (canCheckVramNVIDIA == null) {
            String str = GL11.glGetString((int)7939);
            if (str != null) {
                List<String> extensions = Arrays.asList(str.split(" "));
                canCheckVramNVIDIA = extensions.contains("GL_NVX_gpu_memory_info");
            } else {
                canCheckVramNVIDIA = false;
            }
        }
        return true;
    }

    public static int getVramFreeKB() {
        if (canCheckVramNVIDIA.booleanValue()) {
            return GL11.glGetInteger((int)36937);
        }
        return GL11.glGetInteger((int)34812);
    }

    public static int getVramMaximumKB() {
        return GL11.glGetInteger((int)36936);
    }

    public static int getVramDedicatedKB() {
        return GL11.glGetInteger((int)36935);
    }

    public static int getVramUsedKB() {
        return Misc.getVramMaximumKB() - Misc.getVramFreeKB();
    }

    public static void playSound(ApplyDamageResultAPI result, Vector2f loc, Vector2f vel, String lightShields, String solidShields, String heavyShields, String lightHull, String solidHull, String heavyHull) {
        float fluxDam;
        float hullDam;
        float armorDam;
        float shieldDam = result.getDamageToShields();
        float totalDam = shieldDam + (armorDam = result.getTotalDamageToArmor()) + (hullDam = result.getDamageToHull());
        if (totalDam + (fluxDam = result.getEmpDamage()) <= 0.0f) {
            return;
        }
        float vol = 1.0f;
        float volMult = IMPACT_VOLUME_MULT;
        if (shieldDam > 0.0f) {
            String soundId = null;
            if (shieldDam < 70.0f) {
                vol = shieldDam / 20.0f;
                if (vol > 1.0f) {
                    vol = 1.0f;
                }
                soundId = lightShields;
            } else {
                soundId = shieldDam < 200.0f ? solidShields : heavyShields;
            }
            if (soundId != null) {
                Global.getSoundPlayer().playSound(soundId, 1.0f, vol * volMult, loc, vel);
            }
            return;
        }
        String soundId = null;
        float physicalDam = armorDam + hullDam + fluxDam;
        if (physicalDam < 5.0f) {
            vol = physicalDam / 5.0f;
            if (vol > 1.0f) {
                vol = 1.0f;
            }
            soundId = lightHull;
        } else {
            soundId = physicalDam < 40.0f ? lightHull : (physicalDam < 150.0f ? solidHull : heavyHull);
        }
        if (soundId != null) {
            Global.getSoundPlayer().playSound(soundId, 1.0f, vol * volMult, loc, vel);
        }
    }

    public static float getShipWeight(ShipAPI ship) {
        return Misc.getShipWeight(ship, true);
    }

    public static float getShipWeight(ShipAPI ship, boolean adjustForNonCombat) {
        if (ship.isDrone()) {
            return 0.1f;
        }
        boolean nonCombat = ship.isNonCombat(false);
        float weight = 0.0f;
        switch (ship.getHullSize()) {
            case CAPITAL_SHIP: {
                weight += 8.0f;
                break;
            }
            case CRUISER: {
                weight += 4.0f;
                break;
            }
            case DESTROYER: {
                weight += 2.0f;
                break;
            }
            case FRIGATE: {
                weight += 1.0f;
                break;
            }
            case FIGHTER: {
                weight += 1.0f;
            }
        }
        if (nonCombat && adjustForNonCombat) {
            weight *= 0.25f;
        }
        if (ship.isDrone()) {
            weight *= 0.1f;
        }
        return weight;
    }

    public static float getIncapacitatedTime(ShipAPI ship) {
        float incapTime = 0.0f;
        if (ship.getFluxTracker().isVenting()) {
            incapTime = ship.getFluxTracker().getTimeToVent();
        } else if (ship.getFluxTracker().isOverloaded()) {
            incapTime = ship.getFluxTracker().getOverloadTimeRemaining();
        }
        return incapTime;
    }

    public static boolean isAvoidingPlayerHalfheartedly(CampaignFleetAPI fleet) {
        if (fleet.getMemoryWithoutUpdate().getBoolean("$cfai_neverAvoidPlayerSlowly")) {
            return false;
        }
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        boolean avoidingPlayer = fleet.getMemoryWithoutUpdate().getBoolean("$cfai_avoidPlayerSlowly");
        if (avoidingPlayer && !fleet.isHostileTo(player)) {
            return true;
        }
        CampaignFleetAPI fleeingFrom = fleet.getMemoryWithoutUpdate().getFleet("$ai_fleeingFrom");
        return fleeingFrom != null && fleeingFrom.isPlayerFleet() && Misc.shouldNotWantRunFromPlayerEvenIfWeaker(fleet) && fleet.isHostileTo(player);
    }

    public static boolean isPirateFaction(FactionAPI faction) {
        return faction != null && faction.getCustomBoolean("pirateBehavior");
    }

    public static String getAOrAnFor(String word) {
        Pattern p;
        word = word.toLowerCase();
        for (String other : new String[]{"euler", "heir", "honest", "hono"}) {
            if (!word.startsWith(other)) continue;
            return "\u4e00\u4e2a";
        }
        if (word.startsWith("hour") && !word.startsWith("houri")) {
            return "\u4e00\u4e2a";
        }
        for (String regex : new String[]{"^e[uw]", "^onc?e\b", "^uni([^nmd]|mo)", "^u[bcfhjkqrst][aeiou]"}) {
            p = Pattern.compile("(?is)" + regex + ".*");
            Matcher m = p.matcher(word);
            if (!m.matches()) continue;
            return "\u4e00\u4e2a";
        }
        p = Pattern.compile("(?is)^U[NK][AIEO]");
        Matcher m = p.matcher(word);
        if (m.matches()) {
            return "\u4e00\u4e2a";
        }
        for (String letter : new String[]{"\u4e00\u4e2a", "e", "i", "o", "u"}) {
            if (!word.startsWith(letter)) continue;
            return "\u4e00\u4e2a";
        }
        p = Pattern.compile("(?is)^y(b[lor]|cl[ea]|fere|gg|p[ios]|rou|tt).*");
        m = p.matcher(word);
        if (m.matches()) {
            return "\u4e00\u4e2a";
        }
        return "\u4e00\u4e2a";
    }

    public static void moveToMarket(PersonAPI person, MarketAPI destination, boolean alwaysAddToCommDirectory) {
        ContactIntel intel = ContactIntel.getContactIntel(person);
        if (intel != null) {
            intel.relocateToMarket(destination, false);
        } else {
            boolean addToComms = alwaysAddToCommDirectory;
            boolean hidden = false;
            if (person.getMarket() != null) {
                MarketAPI market = person.getMarket();
                CommDirectoryEntryAPI entry = market.getCommDirectory().getEntryForPerson(person);
                if (entry != null) {
                    addToComms = true;
                    hidden = entry.isHidden();
                }
                market.removePerson(person);
                market.getCommDirectory().removePerson(person);
            }
            if (!destination.getPeopleCopy().contains(person)) {
                destination.addPerson(person);
            }
            person.setMarket(destination);
            if (addToComms && destination.getCommDirectory() != null && destination.getCommDirectory().getEntryForPerson(person) == null) {
                CommDirectoryEntryAPI entry;
                destination.getCommDirectory().addPerson(person);
                if (hidden && (entry = destination.getCommDirectory().getEntryForPerson(person)) != null) {
                    entry.setHidden(true);
                }
            }
        }
    }

    public static void makeStoryCritical(String marketId, String reason) {
        Misc.makeStoryCritical(Global.getSector().getEconomy().getMarket(marketId), reason);
    }

    public static void makeStoryCritical(MarketAPI market, String reason) {
        Misc.makeStoryCritical(market.getMemoryWithoutUpdate(), reason);
    }

    public static void makeStoryCritical(MemoryAPI memory, String reason) {
        Misc.setFlagWithReason(memory, "$story_critical", reason, true, -1.0f);
    }

    public static void makeNonStoryCritical(MarketAPI market, String reason) {
        Misc.makeNonStoryCritical(market.getMemoryWithoutUpdate(), reason);
    }

    public static void makeNonStoryCritical(MemoryAPI memory, String reason) {
        Misc.setFlagWithReason(memory, "$story_critical", reason, false, -1.0f);
    }

    public static boolean isStoryCritical(MarketAPI market) {
        return Misc.isStoryCritical(market.getMemoryWithoutUpdate());
    }

    public static boolean isStoryCritical(MemoryAPI memory) {
        return memory.getBoolean("$story_critical");
    }

    public static boolean isInsignificant(CampaignFleetAPI fleet) {
        boolean recentlyBeaten = fleet.getMemoryWithoutUpdate().getBoolean("$cfai_recentlyDefeatedByPlayer");
        if (recentlyBeaten) {
            return true;
        }
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        if (pf == null) {
            return true;
        }
        if (fleet.getAI() != null) {
            CampaignFleetAIAPI.EncounterOption opt = fleet.getAI().pickEncounterOption(null, pf);
            if (opt == CampaignFleetAIAPI.EncounterOption.DISENGAGE || opt == CampaignFleetAIAPI.EncounterOption.HOLD_VS_STRONGER) {
                return true;
            }
            if (opt == CampaignFleetAIAPI.EncounterOption.ENGAGE) {
                return false;
            }
        }
        int pfCount = pf.getFleetSizeCount();
        int otherCount = fleet.getFleetSizeCount();
        return otherCount <= pfCount / 4;
    }

    public static boolean shouldNotWantRunFromPlayerEvenIfWeaker(CampaignFleetAPI fleet) {
        boolean recentlyBeaten = fleet.getMemoryWithoutUpdate().getBoolean("$cfai_recentlyDefeatedByPlayer");
        if (recentlyBeaten) {
            return true;
        }
        if (fleet.getFleetData() == null) {
            return false;
        }
        float count = 0.0f;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            if (member.isCivilian() || member.getHullSpec() == null) continue;
            switch (member.getHullSpec().getHullSize()) {
                case CAPITAL_SHIP: {
                    count += 4.0f;
                    break;
                }
                case CRUISER: {
                    count += 3.0f;
                    break;
                }
                case DESTROYER: {
                    count += 2.0f;
                    break;
                }
                case FRIGATE: {
                    count += 1.0f;
                }
            }
        }
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        float pfCount = 0.0f;
        for (FleetMemberAPI member : pf.getFleetData().getMembersListCopy()) {
            if (member.isCivilian() || member.getHullSpec() == null) continue;
            switch (member.getHullSpec().getHullSize()) {
                case CAPITAL_SHIP: {
                    pfCount += 4.0f;
                    break;
                }
                case CRUISER: {
                    pfCount += 3.0f;
                    break;
                }
                case DESTROYER: {
                    pfCount += 2.0f;
                    break;
                }
                case FRIGATE: {
                    pfCount += 1.0f;
                }
            }
        }
        if (count > pfCount * 0.67f) {
            return true;
        }
        return Misc.isInsignificant(fleet) && count <= 6.0f;
    }

    public static float findKth(float[] arr, int k) {
        if (arr == null || arr.length <= k || k < 0) {
            return -1.0f;
        }
        int from = 0;
        int to = arr.length - 1;
        while (from < to) {
            int r = from;
            int w = to;
            float mid = arr[(r + w) / 2];
            while (r < w) {
                if (arr[r] >= mid) {
                    float tmp = arr[w];
                    arr[w] = arr[r];
                    arr[r] = tmp;
                    --w;
                    continue;
                }
                ++r;
            }
            if (arr[r] > mid) {
                --r;
            }
            if (k <= r) {
                to = r;
                continue;
            }
            from = r + 1;
        }
        return arr[k];
    }

    public static float getAdjustedBaseRange(float base, ShipAPI ship, WeaponAPI weapon) {
        if (ship == null || weapon == null) {
            return base;
        }
        float flat = CombatListenerUtil.getWeaponBaseRangeFlatMod(ship, weapon);
        float percent = CombatListenerUtil.getWeaponBaseRangePercentMod(ship, weapon);
        float mult = CombatListenerUtil.getWeaponBaseRangeMultMod(ship, weapon);
        return (base * (1.0f + percent / 100.0f) + flat) * mult;
    }

    public static Vector2f bezier(Vector2f p0, Vector2f p1, Vector2f p2, float t) {
        if (t < 0.0f) {
            t = 0.0f;
        }
        if (t > 1.0f) {
            t = 1.0f;
        }
        Vector2f r = new Vector2f();
        r.x = (1.0f - t) * (1.0f - t) * p0.x + 2.0f * (1.0f - t) * t * p1.x + t * t * p2.x;
        r.y = (1.0f - t) * (1.0f - t) * p0.y + 2.0f * (1.0f - t) * t * p1.y + t * t * p2.y;
        return r;
    }

    public static Vector2f bezierCubic(Vector2f p0, Vector2f p1, Vector2f p2, Vector2f p3, float t) {
        if (t < 0.0f) {
            t = 0.0f;
        }
        if (t > 1.0f) {
            t = 1.0f;
        }
        Vector2f r = new Vector2f();
        r.x = (1.0f - t) * (1.0f - t) * (1.0f - t) * p0.x + 3.0f * (1.0f - t) * (1.0f - t) * t * p1.x + 3.0f * (1.0f - t) * t * t * p2.x + t * t * t * p3.x;
        r.y = (1.0f - t) * (1.0f - t) * (1.0f - t) * p0.y + 3.0f * (1.0f - t) * (1.0f - t) * t * p1.y + 3.0f * (1.0f - t) * t * t * p2.y + t * t * t * p3.y;
        return r;
    }

    public static boolean isInsideSlipstream(Vector2f loc, float radius) {
        return Misc.isInsideSlipstream(loc, radius, Global.getSector().getHyperspace());
    }

    public static boolean isInsideSlipstream(Vector2f loc, float radius, LocationAPI location) {
        if (location == null) {
            return false;
        }
        for (CampaignTerrainAPI ter : location.getTerrainCopy()) {
            SlipstreamTerrainPlugin2 plugin;
            if (!(ter.getPlugin() instanceof SlipstreamTerrainPlugin2) || !(plugin = (SlipstreamTerrainPlugin2)ter.getPlugin()).containsPoint(loc, radius)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInsideSlipstream(SectorEntityToken entity) {
        if (entity == null || entity.getContainingLocation() == null) {
            return false;
        }
        for (CampaignTerrainAPI ter : entity.getContainingLocation().getTerrainCopy()) {
            SlipstreamTerrainPlugin2 plugin;
            if (!(ter.getPlugin() instanceof SlipstreamTerrainPlugin2) || !(plugin = (SlipstreamTerrainPlugin2)ter.getPlugin()).containsEntity(entity)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOutsideSector(Vector2f loc) {
        float sw = Global.getSettings().getFloat("sectorWidth");
        float sh = Global.getSettings().getFloat("sectorHeight");
        return loc.x < -sw / 2.0f || loc.x > sw / 2.0f || loc.y < -sh / 2.0f || loc.y > sh / 2.0f;
    }

    public static boolean crossesAnySlipstream(LocationAPI location, Vector2f from, Vector2f to) {
        block0: for (CampaignTerrainAPI ter : location.getTerrainCopy()) {
            if (!(ter.getPlugin() instanceof SlipstreamTerrainPlugin2)) continue;
            SlipstreamTerrainPlugin2 plugin = (SlipstreamTerrainPlugin2)ter.getPlugin();
            List<SlipstreamTerrainPlugin2.SlipstreamSegment> segments = plugin.getSegments();
            int skip = Math.max(20, segments.size() / 10);
            for (int i = 0; i < segments.size(); i += skip) {
                int i2 = i + skip;
                if (i2 > segments.size() - skip / 2) {
                    i2 = segments.size() - 1;
                }
                if (i2 >= segments.size()) {
                    i2 = segments.size() - 1;
                }
                if (i2 <= i) continue block0;
                Vector2f p = Misc.intersectSegments(segments.get((int)i).loc, segments.get((int)i2).loc, from, to);
                if (p == null) continue;
                return true;
            }
        }
        return false;
    }

    public static void computeCoreWorldsExtent() {
        Vector2f min = new Vector2f();
        Vector2f max = new Vector2f();
        for (StarSystemAPI curr : Global.getSector().getStarSystems()) {
            if (!curr.hasTag("theme_core")) continue;
            Vector2f loc = curr.getLocation();
            min.x = Math.min(min.x, loc.x);
            min.y = Math.min(min.y, loc.y);
            max.x = Math.max(max.x, loc.x);
            max.y = Math.max(max.y, loc.y);
        }
        Vector2f core = Vector2f.add((Vector2f)min, (Vector2f)max, (Vector2f)new Vector2f());
        core.scale(0.5f);
        Global.getSector().getMemoryWithoutUpdate().set("$coreWorldsMin", min);
        Global.getSector().getMemoryWithoutUpdate().set("$coreWorldsMax", max);
        Global.getSector().getMemoryWithoutUpdate().set("$coreWorldsCenter", core);
    }

    public static Vector2f getCoreMin() {
        Vector2f v = (Vector2f)Global.getSector().getMemoryWithoutUpdate().get("$coreWorldsMin");
        if (v == null) {
            Misc.computeCoreWorldsExtent();
            v = (Vector2f)Global.getSector().getMemoryWithoutUpdate().get("$coreWorldsMin");
        }
        return v;
    }

    public static Vector2f getCoreMax() {
        Vector2f v = (Vector2f)Global.getSector().getMemoryWithoutUpdate().get("$coreWorldsMax");
        if (v == null) {
            Misc.computeCoreWorldsExtent();
            v = (Vector2f)Global.getSector().getMemoryWithoutUpdate().get("$coreWorldsMax");
        }
        return v;
    }

    public static Vector2f getCoreCenter() {
        Vector2f v = (Vector2f)Global.getSector().getMemoryWithoutUpdate().get("$coreWorldsCenter");
        if (v == null) {
            Misc.computeCoreWorldsExtent();
            v = (Vector2f)Global.getSector().getMemoryWithoutUpdate().get("$coreWorldsCenter");
        }
        return v;
    }

    public static boolean turnTowardsPointV2(MissileAPI missile, Vector2f point, float angVel) {
        float desiredFacing = Misc.getAngleInDegrees(missile.getLocation(), point);
        return Misc.turnTowardsFacingV2(missile, desiredFacing, angVel);
    }

    public static boolean turnTowardsFacingV2(MissileAPI missile, float desiredFacing, float relativeAngVel) {
        float turnVel = missile.getAngularVelocity() - relativeAngVel;
        float absTurnVel = Math.abs(turnVel);
        float turnDecel = missile.getEngineController().getTurnDeceleration();
        float decelTime = absTurnVel / turnDecel;
        float decelDistance = absTurnVel * decelTime - 0.5f * turnDecel * decelTime * decelTime;
        float facingAfterNaturalDecel = missile.getFacing() + Math.signum(turnVel) * decelDistance;
        float diffWithEventualFacing = Misc.getAngleDiff(facingAfterNaturalDecel, desiredFacing);
        float diffWithCurrFacing = Misc.getAngleDiff(missile.getFacing(), desiredFacing);
        if (diffWithEventualFacing > 1.0f) {
            float turnDir = Misc.getClosestTurnDirection(missile.getFacing(), desiredFacing);
            if (Math.signum(turnVel) == Math.signum(turnDir) && decelDistance > diffWithCurrFacing) {
                turnDir = -turnDir;
            }
            if (turnDir < 0.0f) {
                missile.giveCommand(ShipCommand.TURN_RIGHT);
            } else if (turnDir >= 0.0f) {
                missile.giveCommand(ShipCommand.TURN_LEFT);
            } else {
                return false;
            }
        }
        return false;
    }

    public static int getUntrustwortyCount() {
        int count = Global.getSector().getPlayerMemoryWithoutUpdate().getInt("$untrustworthy");
        return count;
    }

    public static void incrUntrustwortyCount() {
        int count = Misc.getUntrustwortyCount();
        Global.getSector().getPlayerMemoryWithoutUpdate().set("$untrustworthy", count + 1);
    }

    public static ReputationActionResponsePlugin.ReputationAdjustmentResult adjustRep(PersonAPI person, float delta, TextPanelAPI text) {
        return Misc.adjustRep(person, delta, null, text);
    }

    public static ReputationActionResponsePlugin.ReputationAdjustmentResult adjustRep(PersonAPI person, float delta, RepLevel limit, TextPanelAPI text) {
        return Misc.adjustRep(person, delta, limit, text, true, true);
    }

    public static ReputationActionResponsePlugin.ReputationAdjustmentResult adjustRep(PersonAPI person, float delta, RepLevel limit, TextPanelAPI text, boolean addMessageOnNoChange, boolean withMessage) {
        CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
        impact.delta = delta;
        if (limit != null) {
            impact.limit = limit;
        }
        return Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, text, addMessageOnNoChange, withMessage), person);
    }

    public static ReputationActionResponsePlugin.ReputationAdjustmentResult adjustRep(String factionId, float delta, TextPanelAPI text) {
        return Misc.adjustRep(factionId, delta, null, text);
    }

    public static ReputationActionResponsePlugin.ReputationAdjustmentResult adjustRep(String factionId, float delta, RepLevel limit, TextPanelAPI text) {
        return Misc.adjustRep(factionId, delta, limit, text, true, true);
    }

    public static ReputationActionResponsePlugin.ReputationAdjustmentResult adjustRep(String factionId, float delta, RepLevel limit, TextPanelAPI text, boolean addMessageOnNoChange, boolean withMessage) {
        CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
        impact.delta = delta;
        if (limit != null) {
            impact.limit = limit;
        }
        return Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, text, addMessageOnNoChange, withMessage), factionId);
    }

    public static String getHullSizeStr(ShipAPI.HullSize size) {
        switch (size) {
            case CAPITAL_SHIP: {
                return "\u4e3b\u529b\u8230";
            }
            case CRUISER: {
                return "\u5de1\u6d0b\u8230";
            }
            case DESTROYER: {
                return "\u9a71\u9010\u8230";
            }
            case FIGHTER: {
                return "\u6218\u673a";
            }
            case FRIGATE: {
                return "\u62a4\u536b\u8230";
            }
        }
        return "\u672a\u77e5";
    }

    public static float getColorDist(Color one, Color two) {
        float r = Math.abs(one.getRed() - two.getRed());
        float g = Math.abs(one.getGreen() - two.getGreen());
        float b = Math.abs(one.getBlue() - two.getBlue());
        float \u4e00\u4e2a = Math.abs(one.getAlpha() - two.getAlpha());
        return (float)Math.sqrt(r * r + g * g + b * b + \u4e00\u4e2a * \u4e00\u4e2a);
    }

    public static boolean isFringe(SectorEntityToken entity) {
        return Misc.isFringe(entity.getLocationInHyperspace());
    }

    public static boolean isFringe(StarSystemAPI system) {
        return Misc.isFringe(system.getLocation());
    }

    public static boolean isFringe(Vector2f loc) {
        return Misc.getFringeFactor(loc) > FRINGE_THRESHOLD;
    }

    public static float getFringeFactor(Vector2f loc) {
        float sh;
        float b;
        float y;
        float mult;
        float x = loc.x;
        float sw = Global.getSettings().getFloat("sectorWidth");
        float \u4e00\u4e2a = sw * 0.5f * (mult = 0.8f);
        float f = x * x / (\u4e00\u4e2a * \u4e00\u4e2a) + (y = loc.y) * y / ((b = (sh = Global.getSettings().getFloat("sectorHeight")) * 0.5f * mult) * b);
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public static boolean isHiddenBase(MarketAPI market) {
        return market.getMemoryWithoutUpdate().getBoolean(MemFlags.HIDDEN_BASE_MEM_FLAG);
    }

    public static boolean isReversePolarity(SectorEntityToken entity) {
        return entity.getMemoryWithoutUpdate().getBoolean(ReversePolarityToggle.REVERSED_POLARITY);
    }

    public static String genEntityCatalogId(CatalogEntryType type) {
        return Misc.genEntityCatalogId(-1, -1, -1, type);
    }

    public static String genEntityCatalogId(int cycleOverride, int monthOverride, int dayOverride, CatalogEntryType type) {
        return Misc.genEntityCatalogId(null, cycleOverride, monthOverride, dayOverride, type);
    }

    public static String genEntityCatalogId(String firstChar, int cycleOverride, int monthOverride, int dayOverride, CatalogEntryType type) {
        String base = "Perseus";
        int cycle = Global.getSector().getClock().getCycle();
        cycle += 3000;
        if (cycleOverride > 0) {
            cycle = cycleOverride;
        }
        int month = Global.getSector().getClock().getMonth();
        if (monthOverride > 0) {
            month = monthOverride;
        }
        int day = Global.getSector().getClock().getDay();
        if (dayOverride > 0) {
            day = dayOverride;
        }
        String s1 = Integer.toHexString(cycle).toUpperCase();
        Random r = StarSystemGenerator.random;
        String s0 = Integer.toHexString(r.nextInt(16)).toUpperCase();
        if (firstChar != null) {
            s0 = firstChar;
        }
        String s2 = Integer.toHexString(month).toUpperCase();
        String s3 = Integer.toHexString(day).toUpperCase();
        while (s1.length() < 3) {
            s1 = "0" + s1;
        }
        while (s3.length() < 2) {
            s3 = "0" + s3;
        }
        return base + " " + s0 + s1 + "-" + s2 + s3 + type.suffix;
    }

    public static enum CatalogEntryType {
        PLANET("P"),
        GIANT("G"),
        STAR("S"),
        BLACK_HOLE("B");

        public String suffix;

        private CatalogEntryType(String suffix) {
            this.suffix = suffix;
        }
    }

    public static enum FleetMemberDamageLevel {
        LOW,
        MEDIUM,
        HIGH;

    }

    public static interface FindShipFilter {
        public boolean matches(ShipAPI var1);
    }

    public static interface FleetFilter {
        public boolean accept(CampaignFleetAPI var1);
    }

    public static class Token {
        public String string;
        public TokenType type;
        public String varNameWithoutMemoryKeyIfKeyIsValid = null;
        public String varMemoryKey = null;

        public Token(String string, TokenType type) {
            int index;
            this.string = string;
            this.type = type;
            if (this.isVariable() && (index = string.indexOf(".")) > 0 && index < string.length() - 1) {
                this.varMemoryKey = string.substring(1, index);
                this.varNameWithoutMemoryKeyIfKeyIsValid = "$" + string.substring(index + 1);
            }
        }

        public VarAndMemory getVarNameAndMemory(Map<String, MemoryAPI> memoryMap) {
            String varName = this.varNameWithoutMemoryKeyIfKeyIsValid;
            MemoryAPI memory = memoryMap.get(this.varMemoryKey);
            if (memory == null) {
                varName = this.string;
                memory = memoryMap.get("local");
            }
            if (memory == null) {
                throw new RuleException("No memory found for keys: " + this.varMemoryKey + ", " + "local");
            }
            VarAndMemory result = new VarAndMemory();
            result.name = varName;
            result.memory = memory;
            return result;
        }

        public String getStringWithTokenReplacement(String ruleId, InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
            String text = this.getString(memoryMap);
            if (text == null) {
                return null;
            }
            text = Global.getSector().getRules().performTokenReplacement(ruleId, text, dialog.getInteractionTarget(), memoryMap);
            return text;
        }

        public String getString(Map<String, MemoryAPI> memoryMap) {
            String string = null;
            if (this.isVariable()) {
                VarAndMemory var = this.getVarNameAndMemory(memoryMap);
                string = var.memory.getString(var.name);
            } else {
                string = this.string;
            }
            return string;
        }

        public Object getObject(Map<String, MemoryAPI> memoryMap) {
            Object o = null;
            if (this.isVariable()) {
                VarAndMemory var = this.getVarNameAndMemory(memoryMap);
                o = var.memory.get(var.name);
            }
            return o;
        }

        public boolean getBoolean(Map<String, MemoryAPI> memoryMap) {
            String str = this.getString(memoryMap);
            return Boolean.parseBoolean(str);
        }

        public boolean isBoolean(Map<String, MemoryAPI> memoryMap) {
            String str = this.getString(memoryMap);
            return str.toLowerCase().equals("true") || str.toLowerCase().equals("false");
        }

        public boolean isFloat(Map<String, MemoryAPI> memoryMap) {
            String str = null;
            if (this.isVariable()) {
                VarAndMemory var = this.getVarNameAndMemory(memoryMap);
                str = var.memory.getString(var.name);
            } else {
                str = this.string;
            }
            try {
                Float.parseFloat(str);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        public float getFloat(Map<String, MemoryAPI> memoryMap) {
            float result = 0.0f;
            if (this.isVariable()) {
                VarAndMemory var = this.getVarNameAndMemory(memoryMap);
                result = var.memory.getFloat(var.name);
            } else {
                result = Float.parseFloat(this.string);
            }
            return result;
        }

        public int getInt(Map<String, MemoryAPI> memoryMap) {
            return Math.round(this.getFloat(memoryMap));
        }

        public Color getColor(Map<String, MemoryAPI> memoryMap) {
            Object object = null;
            if (this.isVariable()) {
                VarAndMemory var = this.getVarNameAndMemory(memoryMap);
                object = var.memory.get(var.name);
            }
            if (object instanceof Color) {
                return (Color)object;
            }
            String string = this.getString(memoryMap);
            try {
                String[] parts = string.split(Pattern.quote(","));
                return new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
            }
            catch (Exception e) {
                if ("bad".equals(string)) {
                    string = "textEnemyColor";
                } else if ("good".equals(string)) {
                    string = "textFriendColor";
                } else if ("highlight".equals(string)) {
                    string = "buttonShortcut";
                } else if ("h".equals(string)) {
                    string = "buttonShortcut";
                } else {
                    if ("story".equals(string)) {
                        return Misc.getStoryOptionColor();
                    }
                    if ("gray".equals(string)) {
                        return Misc.getGrayColor();
                    }
                    if ("grey".equals(string)) {
                        return Misc.getGrayColor();
                    }
                    FactionAPI faction = Global.getSector().getFaction(string);
                    if (faction != null) {
                        return faction.getBaseUIColor();
                    }
                }
                return Global.getSettings().getColor(string);
            }
        }

        public boolean isLiteral() {
            return this.type == TokenType.LITERAL;
        }

        public boolean isVariable() {
            return this.type == TokenType.VARIABLE;
        }

        public boolean isOperator() {
            return this.type == TokenType.OPERATOR;
        }

        public String toString() {
            if (this.isVariable()) {
                return this.string + " (" + this.type.name() + ", memkey: " + this.varMemoryKey + ", name: " + this.varNameWithoutMemoryKeyIfKeyIsValid + ")";
            }
            return this.string + " (" + this.type.name() + ")";
        }
    }

    public static class VarAndMemory {
        public String name;
        public MemoryAPI memory;
    }

    public static enum TokenType {
        VARIABLE,
        LITERAL,
        OPERATOR;

    }
}

