/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.util;

import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.ValueShifterAPI;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ValueShifterUtil
implements ValueShifterAPI {
    protected float base;
    protected float curr;
    protected boolean useSquareOfProgress = true;
    protected transient float averageShift;
    protected Map<Object, ShiftData2> data = new LinkedHashMap<Object, ShiftData2>();

    public ValueShifterUtil(float base) {
        this.base = base;
        this.curr = base;
    }

    public boolean isUseSquareOfProgress() {
        return this.useSquareOfProgress;
    }

    public void setUseSquareOfProgress(boolean useSquareOfProgress) {
        this.useSquareOfProgress = useSquareOfProgress;
    }

    public boolean isShifted() {
        return !this.data.isEmpty();
    }

    public float getBase() {
        return this.base;
    }

    public void setBase(float base) {
        this.base = base;
    }

    public float getCurr() {
        return this.curr;
    }

    public void shift(Object source, float to, float durIn, float durOut, float shift) {
        ShiftData2 sd = this.data.get(source);
        if (sd == null) {
            sd = new ShiftData2();
            sd.fader = new FaderUtil(0.0f, durIn, durOut);
            sd.fader.setBounceDown(true);
            this.data.put(source, sd);
        }
        sd.to = to;
        sd.shift = shift;
        sd.fader.setDuration(durIn, durOut);
        sd.fader.fadeIn();
        sd.nudged = true;
    }

    public void advance(float amount) {
        Iterator<ShiftData2> iter = this.data.values().iterator();
        while (iter.hasNext()) {
            ShiftData2 sd = iter.next();
            if (!sd.nudged) {
                sd.fader.fadeOut();
            }
            sd.nudged = false;
            sd.fader.advance(amount);
            if (!sd.fader.isFadedOut()) continue;
            iter.remove();
        }
        this.updateCurr();
    }

    protected void updateCurr() {
        if (this.data.isEmpty()) {
            this.curr = this.base;
            this.averageShift = 0.0f;
            return;
        }
        float totalWeight = 0.0f;
        for (ShiftData2 sd : this.data.values()) {
            float progress = sd.fader.getBrightness();
            if (this.useSquareOfProgress) {
                progress *= progress;
            }
            totalWeight += progress;
        }
        this.averageShift = totalWeight / (float)this.data.size();
        if (totalWeight <= 0.0f) {
            this.curr = this.base;
            return;
        }
        float result = this.base;
        for (ShiftData2 sd : this.data.values()) {
            float progress = sd.fader.getBrightness();
            if (this.useSquareOfProgress) {
                progress *= progress;
            }
            result += (sd.to - this.base) * sd.shift * progress / (totalWeight - progress + 1.0f);
        }
        this.curr = result;
    }

    public float getAverageShift() {
        return this.averageShift;
    }

    public float getShiftProgress(Object key) {
        if (this.data.containsKey(key)) {
            return this.data.get((Object)key).fader.getBrightness();
        }
        return 0.0f;
    }

    public static void main(String[] args) {
        ValueShifterUtil c = new ValueShifterUtil(10.0f);
        int i = 0;
        while (i < 10) {
            c.shift("c1", 25.0f, 1.0f, 1.0f, 1.0f);
            c.shift("c2", 20.0f, 1.0f, 1.0f, 1.0f);
            c.advance(0.1f);
            ++i;
        }
        System.out.println(c.getCurr());
    }

    public static class ShiftData2 {
        public float to;
        public FaderUtil fader;
        public float shift;
        public boolean nudged;
    }
}

