/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.util;

import com.fs.starfarer.api.graphics.SpriteAPI;
import java.awt.Color;
import org.lwjgl.opengl.GL11;

public class WarpingSpriteRendererUtil {
    private int verticesWide;
    private int verticesTall;
    private WSVertex[][] vertices;

    public WarpingSpriteRendererUtil(int verticesWide, int verticesTall, float minWarpRadius, float maxWarpRadius, float warpRateMult) {
        this.verticesWide = verticesWide;
        this.verticesTall = verticesTall;
        this.vertices = new WSVertex[verticesWide][verticesTall];
        int i = 0;
        while (i < verticesWide) {
            int j = 0;
            while (j < verticesTall) {
                this.vertices[i][j] = new WSVertex();
                this.vertices[i][j].radius.set(minWarpRadius, maxWarpRadius);
                this.vertices[i][j].radius.rate *= warpRateMult;
                this.vertices[i][j].theta.rate *= warpRateMult;
                ++j;
            }
            ++i;
        }
        this.readResolve();
    }

    Object readResolve() {
        return this;
    }

    public void advance(float amount) {
        int i = 0;
        while (i < this.verticesWide) {
            int j = 0;
            while (j < this.verticesTall) {
                this.vertices[i][j].advance(amount);
                ++j;
            }
            ++i;
        }
    }

    public void renderNoBlendOrRotate(SpriteAPI sprite, float x, float y) {
        this.renderNoBlendOrRotate(sprite, x, y, true);
    }

    public void renderNoBlendOrRotate(SpriteAPI sprite, float xOff, float yOff, boolean disableBlend) {
        sprite.bindTexture();
        GL11.glPushMatrix();
        Color color = sprite.getColor();
        GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * sprite.getAlphaMult())));
        GL11.glTranslatef((float)xOff, (float)yOff, (float)0.0f);
        GL11.glEnable((int)3553);
        if (disableBlend) {
            GL11.glDisable((int)3042);
        }
        float w = sprite.getWidth();
        float h = sprite.getHeight();
        float tw = sprite.getTextureWidth() - 0.001f;
        float th = sprite.getTextureHeight() - 0.001f;
        float cw = w / (float)(this.verticesWide - 1);
        float ch = h / (float)(this.verticesTall - 1);
        float ctw = tw / (float)(this.verticesWide - 1);
        float cth = th / (float)(this.verticesTall - 1);
        float i = 0.0f;
        while (i < (float)(this.verticesWide - 1)) {
            GL11.glBegin((int)8);
            float j = 0.0f;
            while (j < (float)this.verticesTall) {
                float cos;
                float sin;
                float radius;
                float theta;
                float x1 = cw * i;
                float y1 = ch * j;
                float x2 = cw * (i + 1.0f);
                float y2 = ch * j;
                float tx1 = ctw * i;
                float ty1 = cth * j;
                float tx2 = ctw * (i + 1.0f);
                float ty2 = cth * j;
                if (i != 0.0f && i != (float)(this.verticesWide - 1) && j != 0.0f && j != (float)(this.verticesTall - 1)) {
                    theta = (float)Math.toRadians(this.vertices[(int)i][(int)j].theta.getValue());
                    radius = this.vertices[(int)i][(int)j].radius.getValue();
                    sin = (float)Math.sin(theta);
                    cos = (float)Math.cos(theta);
                    x1 += cos * radius;
                    y1 += sin * radius;
                }
                if (i + 1.0f != 0.0f && i + 1.0f != (float)(this.verticesWide - 1) && j != 0.0f && j != (float)(this.verticesTall - 1)) {
                    theta = (float)Math.toRadians(this.vertices[(int)i + 1][(int)j].theta.getValue());
                    radius = this.vertices[(int)i + 1][(int)j].radius.getValue();
                    sin = (float)Math.sin(theta);
                    cos = (float)Math.cos(theta);
                    x2 += cos * radius;
                    y2 += sin * radius;
                }
                GL11.glTexCoord2f((float)tx1, (float)ty1);
                GL11.glVertex2f((float)x1, (float)y1);
                GL11.glTexCoord2f((float)tx2, (float)ty2);
                GL11.glVertex2f((float)x2, (float)y2);
                j += 1.0f;
            }
            GL11.glEnd();
            i += 1.0f;
        }
        GL11.glPopMatrix();
    }

    public static class MutatingValue {
        protected float value;
        protected float min;
        protected float max;
        protected float rate;
        protected float rateSign;
        protected float sign = 0.0f;

        public MutatingValue() {
        }

        public MutatingValue(float min, float max, float rate) {
            this.min = min;
            this.max = max;
            this.rate = Math.abs(rate);
            this.value = min + (float)Math.random() * (max - min);
            this.rateSign = Math.signum(rate);
        }

        public void set(float min, float max) {
            this.min = min;
            this.max = max;
            this.value = min + (float)Math.random() * (max - min);
        }

        public void advance(float amount) {
            this.value = this.rateSign != 0.0f ? (this.value += amount * this.rate * this.rateSign) : (this.value += amount * this.rate);
            if (this.value > this.max) {
                this.value = this.max;
                this.rateSign = -1.0f;
            } else if (this.value < this.min) {
                this.value = this.min;
                this.rateSign = 1.0f;
            }
        }

        public float getValue() {
            if (this.sign != 0.0f) {
                return this.value * this.sign;
            }
            return this.value;
        }

        public void setValue(float value) {
            this.value = value;
        }

        public float getMin() {
            return this.min;
        }

        public void setMin(float min) {
            this.min = min;
        }

        public float getMax() {
            return this.max;
        }

        public void setMax(float max) {
            this.max = max;
        }

        public float getRate() {
            return this.rate;
        }

        public void setRate(float rate) {
            this.rate = Math.abs(rate);
        }

        public float getSign() {
            return this.sign;
        }

        public void setSign(float sign) {
            this.sign = Math.signum(sign);
        }

        public void setRandomSign() {
            this.sign = (float)Math.signum(Math.random() - 0.5);
            if (this.sign == 0.0f) {
                this.sign = 1.0f;
            }
        }

        public void setRandomRateSign() {
            this.rateSign = (float)Math.signum(Math.random() - 0.5);
            if (this.rateSign == 0.0f) {
                this.rateSign = 1.0f;
            }
        }

        public float getRateSign() {
            return this.rateSign;
        }

        public void setRateSign(float rateSign) {
            this.rateSign = rateSign;
        }
    }

    public static class WSVertex {
        public MutatingValue theta = new MutatingValue(-360.0f * ((float)Math.random() * 30.0f + 1.0f), 360.0f * ((float)Math.random() * 30.0f + 1.0f), 30.0f + 70.0f * (float)Math.random());
        public MutatingValue radius = new MutatingValue(0.0f, 10.0f + 15.0f * (float)Math.random(), 3.0f + 7.0f * (float)Math.random());

        public void advance(float amount) {
            this.theta.advance(amount);
            this.radius.advance(amount);
        }

        Object writeReplace() {
            this.theta.setMax((int)this.theta.getMax());
            this.theta.setMin((int)this.theta.getMin());
            this.theta.setRate((int)this.theta.getRate());
            this.theta.setValue((int)this.theta.getValue());
            this.radius.setMax((int)this.radius.getMax());
            this.radius.setMin((int)this.radius.getMin());
            this.radius.setRate((int)this.radius.getRate());
            this.radius.setValue((int)this.radius.getValue());
            return this;
        }
    }
}

