//=============================================================================
// JP_Auto_Battle.js
//=============================================================================

/*:
*
* @plugindesc V1.0 自动战斗
* @author 青灯独酌
*
* @param isopen
* @desc 是否开启自动战斗功能。
* @type boolean
* @on 开启
* @off 不开启
* @default true
*
* @param open_btn
* @desc 没有开启自动战斗时的按钮图
* @default auto_battle_btn
* @require 1
* @dir img/Battle__ui/
* @type file
*
* @param open_btn_hover
* @desc 鼠标悬停在按钮上的图
* @default auto_battle_btn2
* @require 1
* @dir img/Battle__ui/
* @type file
*
* @param open_btn_press
* @desc 已经开启自动战斗的按钮图
* @default auto_battle_btn3
* @require 1
* @dir img/Battle__ui/
* @type file
* 
* @param btn_x
* @desc 按钮的X坐标
* @default 300
*
* @param btn_y
* @desc 按钮的y坐标
* @default 300
*
*
* @help
* 开启自动战斗时将会占用一回合，自动战斗将在下一回合生效。
* 按钮图在img/Battle__ui/目录下，如果没有此文件夹，请自行创建。
* 插件指令
* 	Jp_AutoBattle_Btn_open	//打开自动战斗
* 	Jp_AutoBattle_Btn_close	//关闭自动战斗
* =============================================================================
* 版本：1.0.0
* 基础功能完成.
* =============================================================================
*/

var Imported = Imported || {};
Imported.JP_Auto_Battle = true;
var Jp = Jp || {}; 
// 参数处理
Jp.AutoBattle = PluginManager.parameters('JP_Auto_Battle');
Jp.AutoBattle.btn = [Jp.AutoBattle['isopen'],Jp.AutoBattle['open_btn'],Jp.AutoBattle['open_btn_hover'],Jp.AutoBattle['open_btn_press'],Jp.AutoBattle['btn_x'],Jp.AutoBattle['btn_y']];
var JP_AutoBattle_btn_touched = false;//记录悬停状态，避免重复执行

//初始化
var _JP_AutoBattle_initialize = Game_System.prototype.initialize;
Game_System.prototype.initialize = function(){
	_JP_AutoBattle_initialize.call(this);
	this.Jp_AutoBattle();
};
Game_System.prototype.Jp_AutoBattle =function(){
	this.Jp_AutoBattle_btnState = 1;//记录自动战斗状态，1为手动战斗，3为自动战斗
	this.Jp_AutoRecovery_isOpen = Jp.AutoBattle.btn[0];//记录是否开启自动战斗功能
};

// ** 资源文件夹
//=============================================================================
ImageManager.load_AutoBattleHud = function(filename) {
    return this.loadBitmap('img/Battle__ui/', filename, 0, true);
};

var _JP_AutoBattle_createSprit = Scene_Battle.prototype.createSpriteset;
Scene_Battle.prototype.createSpriteset = function() {
	_JP_AutoBattle_createSprit.call(this);
	this.JP_AutoBattle_createbtn();
};

Scene_Battle.prototype.JP_AutoBattle_createbtn = function(){
	if($gameSystem.Jp_AutoRecovery_isOpen == "true" ){
		this.temp_AutoBattle_btn = new Jp_AutoBattle_Btn(); 
		this.temp_AutoBattle_btn.mz = 120;
		this.addChild(this.temp_AutoBattle_btn);	
	}else {
			for(var i = 0; i<$gameParty.allMembers().length; i++){
				$gameParty.allMembers()[i].JP_removeAutoBattleModel();//移除自动战斗
			}
			$gameSystem.Jp_AutoBattle_btnState = 1;
	}
};
//定义按钮
function Jp_AutoBattle_Btn() {
    this.initialize.apply(this, arguments)
};
Jp_AutoBattle_Btn.prototype = Object.create(Sprite.prototype);
Jp_AutoBattle_Btn.prototype.constructor = Jp_AutoBattle_Btn;

//初始化设置
Jp_AutoBattle_Btn.prototype.initialize = function() {
	Sprite.prototype.initialize.call(this);
	this.JP_AutoBattle_btn_details();
	
};
//按钮详情
Jp_AutoBattle_Btn.prototype.JP_AutoBattle_btn_details = function() {
	this.AutoBattle_Btn = new Sprite(ImageManager.load_AutoBattleHud(Jp.AutoBattle.btn[1]));
	this.AutoBattle_Btn.x = Number(Jp.AutoBattle.btn[4]);
	this.AutoBattle_Btn.y = Number(Jp.AutoBattle.btn[5]);
	this.addChild(this.AutoBattle_Btn);
	if($gameSystem.Jp_AutoBattle_btnState == 3){
			this.AutoBattle_Btn.bitmap = ImageManager.load_AutoBattleHud(Jp.AutoBattle.btn[3]);
			this.JP_set_AutoBattle(1);//设置为自动战斗
	}else {
		$gameSystem.Jp_AutoBattle_btnState = 1;
		this.AutoBattle_Btn.bitmap = ImageManager.load_AutoBattleHud(Jp.AutoBattle.btn[1]);
		this.JP_set_AutoBattle(2);//取消自动战斗
	}
};
Jp_AutoBattle_Btn.prototype.update = function(){
	//切换悬停状态
	if(this.JP_isHover(this.AutoBattle_Btn) && JP_AutoBattle_btn_touched == false){
		this.AutoBattle_Btn.bitmap = ImageManager.load_AutoBattleHud(Jp.AutoBattle.btn[2]);
		SoundManager.playCursor();
		JP_AutoBattle_btn_touched = true;
	}
	
	//未开启状态
	if(!this.JP_isHover(this.AutoBattle_Btn) && $gameSystem.Jp_AutoBattle_btnState == 1){
		this.AutoBattle_Btn.bitmap = ImageManager.load_AutoBattleHud(Jp.AutoBattle.btn[1]);
		JP_AutoBattle_btn_touched = false;
	}
	
	//已开启状态
	if(!this.JP_isHover(this.AutoBattle_Btn) && $gameSystem.Jp_AutoBattle_btnState == 3){
		this.AutoBattle_Btn.bitmap = ImageManager.load_AutoBattleHud(Jp.AutoBattle.btn[3]);
		JP_AutoBattle_btn_touched = false;
	}
	//点击状态切换
	if(this.JP_isPress(this.AutoBattle_Btn)){
		if($gameSystem.Jp_AutoBattle_btnState == 1 && TouchInput.isTriggered()){
			this.AutoBattle_Btn.bitmap = ImageManager.load_AutoBattleHud(Jp.AutoBattle.btn[3]);
			SoundManager.playOk();
			$gameSystem.Jp_AutoBattle_btnState = 3;
			this.JP_set_AutoBattle(1);//设置为自动战斗
		}else if($gameSystem.Jp_AutoBattle_btnState == 3 && TouchInput.isTriggered()){
			this.AutoBattle_Btn.bitmap = ImageManager.load_AutoBattleHud(Jp.AutoBattle.btn[1]);
			SoundManager.playOk();
			$gameSystem.Jp_AutoBattle_btnState = 1;
			this.JP_set_AutoBattle(2);//移除自动战斗
		}
	}
};

//判断是否自动战斗
var _JP_AutoBattle_isAutoBattle = Game_BattlerBase.prototype.isAutoBattle;
Game_BattlerBase.prototype.isAutoBattle=function(){
        var normol = _JP_AutoBattle_isAutoBattle.call(this);
        return this._isAutoBattle || normol;
};
//设置为自动战斗
Game_Actor.prototype.JP_autoBattleModel=function()
{
	this._isAutoBattle = true;
};
//移除自动战斗
Game_Actor.prototype.JP_removeAutoBattleModel=function()
{
	this._isAutoBattle=false;
};
Jp_AutoBattle_Btn.prototype.JP_set_AutoBattle = function(type){
	switch (type){
		case 1:
			for(var i = 0; i<$gameParty.allMembers().length; i++){
				$gameParty.allMembers()[i].JP_autoBattleModel();//设置为自动战斗
			}
			break;
		case 2:
			for(var i = 0; i<$gameParty.allMembers().length; i++){
				$gameParty.allMembers()[i].JP_removeAutoBattleModel();//移除自动战斗
			}
			break;
	}
};
//悬停监控
Jp_AutoBattle_Btn.prototype.JP_isHover = function(sprite) {
	 if (sprite == null){ return false };
	 if (sprite.bitmap == null){ return false };
	 if (!sprite.bitmap.isReady() ){ return false };
	 var cw = sprite.bitmap.width;
	 var ch = sprite.bitmap.height;
	 if (sprite.visible === false) {return false};
	 if (sprite.opacity === 0) {return false};
	 if (_jp_mouse_x < sprite.x) {return false};
	 if (_jp_mouse_x > sprite.x + cw) {return false};
	 if (_jp_mouse_y < sprite.y) {return false};
	 if (_jp_mouse_y > sprite.y + ch) {return false};
	 return true;	
};
// * 点击监听
Jp_AutoBattle_Btn.prototype.JP_isPress = function(sprite) {
	 if (sprite == null){ return false };
	 if (sprite.bitmap == null){ return false };
	 if (!sprite.bitmap.isReady() ){ return false };
	 if ( !TouchInput.isPressed() ) {return false};		//需要确定是否为鼠标点击
	 var cw = sprite.bitmap.width;
	 var ch = sprite.bitmap.height;
	 if (sprite.visible === false) {return false};
	 if (sprite.opacity === 0) {return false};
	 if (TouchInput.x < sprite.x) {return false};
	 if (TouchInput.x > sprite.x + cw) {return false};
	 if (TouchInput.y < sprite.y) {return false};
	 if (TouchInput.y > sprite.y + ch) {return false};
	 return true;	
};

// ** 获取鼠标位置
//=============================================================================
if( typeof(_jp_mouse_getCurPos) == "undefined" ){	//防止重复定义
	_jp_mouse_x = 0;
	_jp_mouse_y = 0;
	var _jp_mouse_getCurPos = TouchInput._onMouseMove;
	TouchInput._onMouseMove = function(event) {		//绑定在TouchInput中
		_jp_mouse_getCurPos.call(this,event);
        _jp_mouse_x = Graphics.pageToCanvasX(event.pageX);
        _jp_mouse_y = Graphics.pageToCanvasY(event.pageY);
	};
}

//插件指令
var _Jp_AutoBattle_Btn_pluginCommand =Game_Interpreter.prototype.pluginCommand;
Game_Interpreter.prototype.pluginCommand = function(command, args) {
	_Jp_AutoBattle_Btn_pluginCommand.call(this, command, args);
	if(command == "Jp_AutoBattle_Btn_open"){
		$gameSystem.Jp_AutoRecovery_isOpen = "true";
	}
	 if(command == "Jp_AutoBattle_Btn_close"){
		$gameSystem.Jp_AutoRecovery_isOpen = "false";
	}
};
