//=============================================================================
// JP_Auto_EnemyPosition.js
//=============================================================================
/*:
*
* @plugindesc V1.2 敌人自动站位
* @author 青灯独酌
*
*
* @param enemy_x
* @desc 第一个敌人的x坐标
* @default 150
*
* @param enemy_y
* @desc 第一个敌人的y坐标
* @default 220
*
* @param enemy_interval_x
* @desc 同列敌人的横向间隔，间隔建议为正值，为负值时影响鼠标点选。
* @default 48
*
* @param enemy_interval_y
* @desc 同列敌人的垂直向间隔
* @default 150
*
* @param eachRow_num
* @desc 每列人数，不能为0
* @default 4
* 
* @param eachRow_x
* @desc 每列的X间隔
* @default 150
*
* @param eachRow_y
* @desc 每列的坐标间隔
* @default 5 
*
* @param notAuto_enemyId
* @desc 不自动站位的怪物ID，可填多个，中间用英文半角的 , 隔开。
* @default 
*
* @param hide_enemySuffix
* @desc 隐藏相同ID怪物名字的后缀，true：隐藏，false：不隐藏
* @default true
* @help
* 敌群自动站位，可以根据自己需要设置不需要站位的怪物ID。
* 参考了project1论坛过眼云烟的怪物自动站位插件。
* =============================================================================
* 版本：1.2.0
* 增加隐藏敌群怪物名字后缀的功能。
* =============================================================================
* 版本：1.1.0
* 增加每列的Y坐标间隔。
* =============================================================================
* 版本：1.0.0
* 基础功能完成。
* =============================================================================
*/

var Imported = Imported || {};
Imported.JP_Auto_EnemyPosition = true;
var Jp = Jp || {};
//参数处理
Jp.Auto_EnemyPosition = PluginManager.parameters('JP_Auto_EnemyPosition');
Jp.Auto_EnemyPosition.enemy_x = Number(Jp.Auto_EnemyPosition['enemy_x']);
Jp.Auto_EnemyPosition.enemy_y = Number(Jp.Auto_EnemyPosition['enemy_y']);
Jp.Auto_EnemyPosition.enemy_interval_x = Number(Jp.Auto_EnemyPosition['enemy_interval_x']);
Jp.Auto_EnemyPosition.enemy_interval_y = Number(Jp.Auto_EnemyPosition['enemy_interval_y']);
Jp.Auto_EnemyPosition.eachRow_num = Number(Jp.Auto_EnemyPosition['eachRow_num']);
Jp.Auto_EnemyPosition.eachRow_x = Number(Jp.Auto_EnemyPosition['eachRow_x']);
Jp.Auto_EnemyPosition.eachRow_y = Number(Jp.Auto_EnemyPosition['eachRow_y']);
Jp.Auto_EnemyPosition.notAuto_enemyId = Jp.Auto_EnemyPosition['notAuto_enemyId'].split(",");
Jp.Auto_EnemyPosition.hide_enemySuffix = String(Jp.Auto_EnemyPosition['hide_enemySuffix']);
for(var i = 0; i < Jp.Auto_EnemyPosition.notAuto_enemyId.length; i++){
	Jp.Auto_EnemyPosition.notAuto_enemyId[i] = Number(Jp.Auto_EnemyPosition.notAuto_enemyId[i]);
}
//隐藏怪物名字后缀
if(Jp.Auto_EnemyPosition.hide_enemySuffix == "true"){
	Game_Enemy.prototype.name = function() {
		return this.originalName();
	};
}
//自动站位
(function() {
        Game_Enemy.prototype.screenX = function() {
				if(Jp.Auto_EnemyPosition.notAuto_enemyId.indexOf(this._enemyId) < 0){
					var Enemy_x = Jp.Auto_EnemyPosition.enemy_x + (this.index()%Jp.Auto_EnemyPosition.eachRow_num) *Jp.Auto_EnemyPosition.enemy_interval_x + Math.floor(this.index()/Jp.Auto_EnemyPosition.eachRow_num)*Jp.Auto_EnemyPosition.eachRow_x;
					return Enemy_x;
				}else return this._screenX;
        };
        Game_Enemy.prototype.screenY = function() {
				if(Jp.Auto_EnemyPosition.notAuto_enemyId.indexOf(this._enemyId) < 0){
				var Enemy_y = Jp.Auto_EnemyPosition.enemy_y + (this.index()%Jp.Auto_EnemyPosition.eachRow_num) * Jp.Auto_EnemyPosition.enemy_interval_y + Math.floor(this.index()/Jp.Auto_EnemyPosition.eachRow_num)*Jp.Auto_EnemyPosition.eachRow_y;
				return Enemy_y;
				}else return this._screenY;
        };
})();