//=============================================================================
// JP_Auto_Recovery.js
//=============================================================================
/*:
*
* @plugindesc V1.1.1 战斗或升级后自动回血回魔
* @author 青灯独酌
*
* @param levelup_Recovery
* @desc 升级后，升级角色是否自动回血/回魔。
* @type boolean
* @on 开启
* @off 不开启
* @default true
*
* @param levelup_Recovery_Proportion
* @desc 升级后回复的比例，0为不回，0.5回复一半，1为会回满。
* @default 1
*
* @param battle_Recovery
* @desc 战斗结束后，战斗角色自动回血/回魔。
* @type boolean
* @on 开启
* @off 不开启
* @default true
*
* @param battle_Recovery_Proportion
* @desc 战斗结束后回复的比例，0为不回，0.5回复一半，1为会回满。
* @default 1
*
*
* @param levelup_Animation
* @desc 升级时人物在地图上播放的特效。
* @default 52
* 
* @help
* 角色升级或战斗后，将根据设置的回复比例，自动回血/回魔。
* 如果使用了战斗相关插件，请把此插件放到战斗插件下方。
* 插件指令
* 	Jp_AutoRecovery_open_levelup_Recovery	//打开升级自动回复
* 	Jp_AutoRecovery_close_levelup_Recovery	//关闭升级自动回复
*	Jp_AutoRecovery_open_battle_Recovery	//打开战斗结束自动回复
*	Jp_AutoRecovery_close_battle_Recovery	//关闭战斗结束自动回复
* =============================================================================
* 版本：1.1.1
* 修复死亡角色回血BUG。
* =============================================================================
* 版本：1.1.0
* 修复使用插件命令后，如果重新登录，之前使用过度插件命令失效问题。
* =============================================================================
* 版本：1.0.0
* 基础功能完成.
* =============================================================================
*/
var Imported = Imported || {};
Imported.JP_Auto_Recovery = true;
var Jp = Jp || {}; 
//参数处理
Jp.AutoRecovery = PluginManager.parameters('JP_Auto_Recovery');
Jp.AutoRecovery.levelup_Recovery = [Jp.AutoRecovery['levelup_Recovery'], Jp.AutoRecovery['levelup_Recovery_Proportion']];
Jp.AutoRecovery.battle_Recovery = [Jp.AutoRecovery['battle_Recovery'], Jp.AutoRecovery['battle_Recovery_Proportion']];
Jp.AutoRecovery.levelup_Animation = Number(Jp.AutoRecovery['levelup_Animation']);

//初始化
var _JP_AutoRecovery_initialize = Game_System.prototype.initialize;
Game_System.prototype.initialize = function(){
	_JP_AutoRecovery_initialize.call(this);
	this.Jp_AutoRecovery();
};
Game_System.prototype.Jp_AutoRecovery =function(){
	this.Jp_AutoRecovery_levelup = Jp.AutoRecovery.levelup_Recovery;
	this.Jp_AutoRecovery_battle = Jp.AutoRecovery.battle_Recovery;
};

//战斗结束回血
var _JP_AutoRecovery_onBattleWin = Game_System.prototype.onBattleWin;
Game_System.prototype.onBattleWin = function() {
	_JP_AutoRecovery_onBattleWin.call(this);
	if($gameSystem.Jp_AutoRecovery_battle[0] == "true"){
		for(var i = 0; i<$gameParty.battleMembers().length; i++){//战斗结束自动回血
			if(!$gameParty.battleMembers()[i].isStateAffected(1)){
				var addhp = Math.floor($gameParty.battleMembers()[i].mhp * Number($gameSystem.Jp_AutoRecovery_battle[1]));
				var addmp = Math.floor($gameParty.battleMembers()[i].mmp * Number($gameSystem.Jp_AutoRecovery_battle[1]));
				$gameParty.battleMembers()[i].gainHp(addhp);
				$gameParty.battleMembers()[i].gainMp(addmp);
			}
		}
	}
};

//升级回血
var _JP_AutoRecovery_levelUp = Game_Actor.prototype.levelUp;
Game_Actor.prototype.levelUp = function() {
	_JP_AutoRecovery_levelUp.call(this);
	if($gameSystem.Jp_AutoRecovery_levelup[0] == "true"){
		if(!this.isStateAffected(1)){
			var addhp = Math.floor(this.mhp * Number($gameSystem.Jp_AutoRecovery_levelup[1]));
			var addmp = Math.floor(this.mmp * Number($gameSystem.Jp_AutoRecovery_levelup[1]));
			this.gainHp(addhp);
			this.gainMp(addmp);
		}
	}
	if(Jp.AutoRecovery.levelup_Animation !=null){
		$gamePlayer.requestAnimation(Jp.AutoRecovery.levelup_Animation);
	}
}

//插件指令
var _Jp_AutoRecovery_pluginCommand =Game_Interpreter.prototype.pluginCommand;
Game_Interpreter.prototype.pluginCommand = function(command, args) {
	_Jp_AutoRecovery_pluginCommand.call(this, command, args);
	switch(command){
		case "Jp_AutoRecovery_open_levelup_Recovery":
			$gameSystem.Jp_AutoRecovery_levelup[0] = "true";
			break;
		case "Jp_AutoRecovery_close_levelup_Recovery":
			$gameSystem.Jp_AutoRecovery_levelup[0] = "false";
			break;
		case "Jp_AutoRecovery_open_battle_Recovery":
			$gameSystem.Jp_AutoRecovery_battle[0] = "true";
			break;
		case "Jp_AutoRecovery_close_battle_Recovery":
			$gameSystem.Jp_AutoRecovery_battle[0] = "false";
			break;
	}
};
