//=============================================================================
// JP_ChangeActor.js
//=============================================================================

/*:
*
* @plugindesc V1.0 装备/技能/状态界面切换角色按钮
* @author 青灯独酌
*
* @param next_btn
* @desc 下一人物按钮——常态
* @default next_btn_1
* @require 1
* @dir img/Menu__layer/
* @type file
*
* @param next_btn_hover
* @desc 下一人物按钮——高亮（弃用）
* @default next_btn_2
* @require 1
* @dir img/Menu__layer/
* @type file
*
* @param next_btn_press
* @desc 下一人物按钮——按下（弃用）
* @default next_btn_3
* @require 1
* @dir img/Menu__layer/
* @type file
* 
* @param next_btn_x
* @desc 下一人物按钮的X坐标
* @default 300
*
* @param next_btn_y
* @desc 下一人物按钮的y坐标
* @default 300
*
* @param front_btn
* @desc 下一人物按钮——常态
* @default front_btn_1
* @require 1
* @dir img/Menu__layer/
* @type file
*
* @param front_btn_hover
* @desc 下一人物按钮——高亮（弃用）
* @default front_btn_2
* @require 1
* @dir img/Menu__layer/
* @type file
*
* @param front_btn_press
* @desc 下一人物按钮——按下（弃用）
* @default front_btn_3
* @require 1
* @dir img/Menu__layer/
* @type file
* 
* @param front_btn_x
* @desc 下一人物按钮的X坐标
* @default 0
*
* @param front_btn_y
* @desc 下一人物按钮的y坐标
* @default 300
*
* @help
* 按钮将在装备与技能界面显示。
* 按钮图在img/Menu__layer/目录下，如果没有此文件夹，请自行创建。
* =============================================================================
* 版本：1.0.0
* 基础功能完成，菜鸟写的，感谢水大佬（芯☆淡茹水）的帮助！
* =============================================================================
*/

var Imported = Imported || {};
Imported.JP_ChangeActor = true;
var Jp = Jp || {}; 
// 参数处理
Jp.ChangeActor = PluginManager.parameters('JP_ChangeActor');
Jp.ChangeActor.nextbtn = [1,Jp.ChangeActor['next_btn'],Jp.ChangeActor['next_btn_hover'],Jp.ChangeActor['next_btn_press'],Jp.ChangeActor['next_btn_x'],Jp.ChangeActor['next_btn_y']];
Jp.ChangeActor.frontbtn = [1,Jp.ChangeActor['front_btn'],Jp.ChangeActor['front_btn_hover'],Jp.ChangeActor['front_btn_press'],Jp.ChangeActor['front_btn_x'],Jp.ChangeActor['front_btn_y']];

// ** 资源文件夹
//=============================================================================
ImageManager.load_ChangeActorHud = function(filename) {
    return this.loadBitmap('img/Menu__layer/', filename, 0, true);
};
// 场景有 previousActor 和 nextActor 方法的，都需要生成 按钮 。
Scene_Base.prototype.needChangeActorBtn = function() {
    return !!this.previousActor && !!this.nextActor;
};
//装备界面
var _JP_ChangeActor_createSprit_equip = Scene_Equip.prototype.create;
Scene_Equip.prototype.create = function() {
	_JP_ChangeActor_createSprit_equip.call(this);
	this.JP_ChangeActor_createbtn();
};

Scene_Equip.prototype.JP_ChangeActor_createbtn = function(){
	var lx = Number(Jp.ChangeActor.frontbtn[4]); ly = Number(Jp.ChangeActor.frontbtn[5]); 
	var rx = Number(Jp.ChangeActor.nextbtn[4]),  ry = Number(Jp.ChangeActor.nextbtn[5]);
	var leftName  = Jp.ChangeActor.frontbtn[1],  rightName = Jp.ChangeActor.nextbtn[1];
	this._changeActorBtn_left  = new Jp_ChangeActor_Btn(lx, ly, leftName);
	this._changeActorBtn_Right = new Jp_ChangeActor_Btn(rx, ry, rightName);
	this._changeActorBtn_left.setPressMethod(this.previousActor.bind(this)); // 绑定这个按钮按下时运行的方法。
	this._changeActorBtn_Right.setPressMethod(this.nextActor.bind(this));    // 绑定这个按钮按下时运行的方法。
	this.addChild(this._changeActorBtn_left);
	this.addChild(this._changeActorBtn_Right);
};


//技能界面
var _JP_ChangeActor_createSprit_skill = Scene_Skill.prototype.create;
Scene_Skill.prototype.create = function() {
	_JP_ChangeActor_createSprit_skill.call(this);
	this.JP_ChangeActor_createbtn();
};

Scene_Skill.prototype.JP_ChangeActor_createbtn = function(){
	var lx = Number(Jp.ChangeActor.frontbtn[4]); ly = Number(Jp.ChangeActor.frontbtn[5]); 
	var rx = Number(Jp.ChangeActor.nextbtn[4]),  ry = Number(Jp.ChangeActor.nextbtn[5]);
	var leftName  = Jp.ChangeActor.frontbtn[1],  rightName = Jp.ChangeActor.nextbtn[1];
	this._changeActorBtn_left  = new Jp_ChangeActor_Btn(lx, ly, leftName);
	this._changeActorBtn_Right = new Jp_ChangeActor_Btn(rx, ry, rightName);
	this._changeActorBtn_left.setPressMethod(this.previousActor.bind(this)); // 绑定这个按钮按下时运行的方法。
	this._changeActorBtn_Right.setPressMethod(this.nextActor.bind(this));    // 绑定这个按钮按下时运行的方法。
	this.addChild(this._changeActorBtn_left);
	this.addChild(this._changeActorBtn_Right);
};
//状态界面
var _JP_ChangeActor_createSprit_status = Scene_Status.prototype.create;
Scene_Status.prototype.create = function() {
	_JP_ChangeActor_createSprit_status.call(this);
	this.JP_ChangeActor_createbtn();
};

Scene_Status.prototype.JP_ChangeActor_createbtn = function(){
	var lx = Number(Jp.ChangeActor.frontbtn[4]); ly = Number(Jp.ChangeActor.frontbtn[5]); 
	var rx = Number(Jp.ChangeActor.nextbtn[4]),  ry = Number(Jp.ChangeActor.nextbtn[5]);
	var leftName  = Jp.ChangeActor.frontbtn[1],  rightName = Jp.ChangeActor.nextbtn[1];
	this._changeActorBtn_left  = new Jp_ChangeActor_Btn(lx, ly, leftName);
	this._changeActorBtn_Right = new Jp_ChangeActor_Btn(rx, ry, rightName);
	this._changeActorBtn_left.setPressMethod(this.previousActor.bind(this)); // 绑定这个按钮按下时运行的方法。
	this._changeActorBtn_Right.setPressMethod(this.nextActor.bind(this));    // 绑定这个按钮按下时运行的方法。
	this.addChild(this._changeActorBtn_left);
	this.addChild(this._changeActorBtn_Right);
};
//yep技能学习
if(Imported.YEP_SkillLearnSystem){
	var _JP_ChangeActor_createSprit_LearnSkill = Scene_LearnSkill.prototype.create;
	Scene_LearnSkill.prototype.create = function() {
		_JP_ChangeActor_createSprit_LearnSkill.call(this);
		this.JP_ChangeActor_createbtn();
	};

	Scene_LearnSkill.prototype.JP_ChangeActor_createbtn = function(){
		var lx = Number(Jp.ChangeActor.frontbtn[4]); ly = Number(Jp.ChangeActor.frontbtn[5]); 
		var rx = Number(Jp.ChangeActor.nextbtn[4]),  ry = Number(Jp.ChangeActor.nextbtn[5]);
		var leftName  = Jp.ChangeActor.frontbtn[1],  rightName = Jp.ChangeActor.nextbtn[1];
		this._changeActorBtn_left  = new Jp_ChangeActor_Btn(lx, ly, leftName);
		this._changeActorBtn_Right = new Jp_ChangeActor_Btn(rx, ry, rightName);
		this._changeActorBtn_left.setPressMethod(this.previousActor.bind(this)); // 绑定这个按钮按下时运行的方法。
		this._changeActorBtn_Right.setPressMethod(this.nextActor.bind(this));    // 绑定这个按钮按下时运行的方法。
		this.addChild(this._changeActorBtn_left);
		this.addChild(this._changeActorBtn_Right);
	};
}

//定义按钮
function Jp_ChangeActor_Btn() {
    this.initialize.apply(this, arguments)
};
Jp_ChangeActor_Btn.prototype = Object.create(Sprite.prototype);
Jp_ChangeActor_Btn.prototype.constructor = Jp_ChangeActor_Btn;

//初始化设置
Jp_ChangeActor_Btn.prototype.initialize = function(x, y, imageName) {
	Sprite.prototype.initialize.call(this);
	this.bitmap = ImageManager.load_ChangeActorHud(imageName);
	this.move(x, y);
};
// 鼠标是否接触
Jp_ChangeActor_Btn.prototype.isTouch = function() {
	if (!this.visible || !this.bitmap) return false;
	var w = this.width, h = this.height;
	var x = this.x - w * this.anchor.x;
	var y = this.y - h * this.anchor.y;
	var tx = TouchInput.x, ty = TouchInput.y;
	return tx > x && ty > y && tx < (x+w) && ty < (y+h);
};
// 设置按下时运行的方法
Jp_ChangeActor_Btn.prototype.setPressMethod = function(method) {
	this._pressMethod = method;
};
// 调用按下时运行的方法
Jp_ChangeActor_Btn.prototype.callPressMethod = function() {
	this._pressMethod && this._pressMethod();
};
// 是否有效
Jp_ChangeActor_Btn.prototype.isEnabled = function() {
	return true;
};
Jp_ChangeActor_Btn.prototype.press = function() {
	if (this._pressCount > 0) return; // 按钮正在被按下时， 返回。
	if (!this.isEnabled())    return SoundManager.playBuzzer();
	SoundManager.playOk();
	this._pressCount = 5;   // 计数 5 帧 ，这个可以自己调
	this.scale = new Point(0.95, 0.95); // 略微缩小一点，表示 被按下 的动作
	this.callPressMethod();

};
Jp_ChangeActor_Btn.prototype.reduction = function() {
	this.scale = new Point(1, 1);  // 计数完成后，还原原来的大小
};
Jp_ChangeActor_Btn.prototype.update = function() {
	Sprite.prototype.update.call(this);
	this.updateTouch();
	this.updatePressed();
};
Jp_ChangeActor_Btn.prototype.updateTouch = function() {
	if (TouchInput.isTriggered()) {
		this.isTouch() && this.press();
	}
};
Jp_ChangeActor_Btn.prototype.updatePressed = function() {
	if (this._pressCount > 0) {
		this._pressCount--;
		this._pressCount === 0 && this.reduction();
	}
};
