//=============================================================================
// JP_Level_Text.js
//=============================================================================
/*:
*
* @plugindesc V1.0 等级替换成境界显示
* @author 青灯独酌
*
*
* @help
* 每个等级对应的境界名字请打开插件源文件自行配置Jp.JP_Level_Text字段。
* 如果需要实现突破境界的效果，可使用本人的JP_MaxLevel.js插件。
* 
* 把此插件放到适配插件之后才能生效。
* 已经适配插件如下
* YEP_SaveCore（1.04）
* MOG_SceneMenu(v1.2)[Drill_up汉化v1.8]
* MOG_BattleResult(v1.3)[Drill_up汉化v1.3]
* MOG_ActorHud(v1.9)[Drill_up汉化v1.5]
* =============================================================================
* =============================================================================
* 版本：1.0.0
* 基础功能完成。
* =============================================================================
*/

var Imported = Imported || {};
Imported.JP_Level_Text = true;
var Jp = Jp || {};
//参数处理
Jp.JP_Level_Text =[];
Jp.JP_Level_Text = [
	"留空",
	"练气一层",
	"练气二层",
	"练气三层",
	"练气四层",
	"练气五层",
	"练气六层",
	"练气七层",
	"练气八层",
	"练气九层",
	"练气十层",
	"筑基一层",
	"筑基二层",
	"筑基三层",
	"筑基四层",
	"筑基五层",
	"筑基六层",
	"筑基七层",
	"筑基八层",
	"筑基九层",
	"筑基十层",
	"金丹一层",
	"金丹二层",
	"金丹三层",
	"金丹四层",
	"金丹五层",
	"金丹六层",
	"金丹七层",
	"金丹八层",
	"金丹九层",
	"金丹十层",
	"元婴一层",
	"元婴二层",
	"元婴三层",
	"元婴四层",
	"元婴五层",
	"元婴六层",
	"元婴七层",
	"元婴八层",
	"元婴九层",
	"元婴十层",
	"化神一层",
	"化神二层",
	"化神三层",
	"化神四层",
	"化神五层",
	"化神六层",
	"化神七层",
	"化神八层",
	"化神九层",
	"化神十层",
	"分神一层",
	"分神二层",
	"分神三层",
	"分神四层",
	"分神五层",
	"分神六层",
	"分神七层",
	"分神八层",
	"分神九层",
	"分神十层",
	"合体一层",
	"合体二层",
	"合体三层",
	"合体四层",
	"合体五层",
	"合体六层",
	"合体七层",
	"合体八层",
	"合体九层",
	"合体十层",
	"大乘一层",
	"大乘二层",
	"大乘三层",
	"大乘四层",
	"大乘五层",
	"大乘六层",
	"大乘七层",
	"大乘八层",
	"大乘九层",
	"大乘十层",
	"渡劫一层",
	"渡劫二层",
	"渡劫三层",
	"渡劫四层",
	"渡劫五层",
	"渡劫六层",
	"渡劫七层",
	"渡劫八层",
	"渡劫九层",
	"渡劫十层",
	"羽化一层",
	"羽化二层",
	"羽化三层",
	"羽化四层",
	"羽化五层",
	"羽化六层",
	"羽化七层",
	"羽化八层",
	"羽化九层",
	"羽化十层",
	"仙人一层",
	"仙人二层",
	"仙人三层",
	"仙人四层",
	"仙人五层",
	"仙人六层",
	"仙人七层",
	"仙人八层",
	"仙人九层",
	"仙人十层"
];

//初始化
Game_System.prototype.JP_levleText = function(level){
	return Jp.JP_Level_Text[level]; 
};
//重写系统窗口默认的绘制等级方法
Window_Base.prototype.drawActorLevel = function(actor, x, y) {
    this.changeTextColor(this.systemColor());
    this.drawText(TextManager.levelA, x, y, 48);
    this.resetTextColor();
    this.drawText($gameSystem.JP_levleText(actor.level), x + 50, y, $gameSystem.JP_levleText(actor.level).length*20, 'left');
};

//屏蔽升级后的提示窗口
Game_Actor.prototype.displayLevelUp = function(newSkills) {
    var text = TextManager.levelUp.format(this._name, TextManager.level, this._level);
    //$gameMessage.newPage();
    //$gameMessage.add(text);
    newSkills.forEach(function(skill) {
        //$gameMessage.add(TextManager.obtainSkill.format(skill.name));
    });
};

//重写YEP_SaveCore（存档核心）绘制等级的方法
if(Imported.YEP_SaveCore){
	Window_SaveInfo.prototype.drawPartyLevels = function(dy) {
	  if (!Yanfly.Param.SaveInfoActorLv) return dy;
	  this._drawLevel = true;
	  var length = this._saveContents.party.maxBattleMembers();
	  var dw = this.contents.width / length;;
	  dw = Math.floor(dw);
	  var dx = 0;
	  var fmt = Yanfly.Param.SaveInfoActorLvFmt;
	  for (var i = 0; i < length; ++i) {
		var actorId = this._saveContents.party._actors[i];
		var member = this._saveContents.actors._data[actorId];
		if (member) {
		  var lv = Yanfly.Util.toGroup(member.level);
		  var leve_text = $gameSystem.JP_levleText(lv);
		  var text = fmt.format(TextManager.levelA, TextManager.level, leve_text);
		  var tw = this.textWidthEx(text);
		  var dif = Math.floor(Math.max(0, dw - tw) / 2);
		  this.drawTextEx(text, dx + dif, dy);
		}
		dx += dw
	  }
	  this._drawLevel = false;
	  return dy += this.lineHeight();
	};
};
//重写YEP_StatusMenuCore（身份状态菜单核心）绘制等级的方法
if(Imported.YEP_StatusMenuCore){
	Window_StatusInfo.prototype.drawGeneralParam = function() {
    var rect = new Rectangle();
    rect.width = (this.contents.width - this.standardPadding()) / 2;
    rect.y = this.lineHeight() * 2;
    rect.height = this.lineHeight();
    var dx = rect.x + this.textPadding();
    var dw = rect.width - this.textPadding() * 2;
    this.drawDarkRect(rect.x, rect.y, rect.width, rect.height);
    this.changeTextColor(this.systemColor());
		this.drawText(TextManager.level, dx, rect.y, dw, 'left');
		this.changeTextColor(this.normalColor());
		text = Yanfly.Util.toGroup($gameSystem.JP_levleText(this._actor.level));
		this.drawText(text, dx, rect.y, dw, 'right');
    for (var i = 0; i < 8; ++i) {
      if (i < 2) {
        rect.y += this.lineHeight();
      } else if (i === 2) {
        rect.y += this.lineHeight();
        rect.width /= 2;
        dw = rect.width - this.textPadding() * 2;
      } else if (i % 2 === 0) {
        rect.x = 0;
        dx = rect.x + this.textPadding();
        rect.y += this.lineHeight();
      } else {
        rect.x += rect.width;
        dx += rect.width;
      }
      this.drawDarkRect(rect.x, rect.y, rect.width, rect.height);
      this.changeTextColor(this.systemColor());
  		this.drawText(TextManager.param(i), dx, rect.y, dw, 'left');
  		this.changeTextColor(this.normalColor());
  		text = Yanfly.Util.toGroup(this._actor.param(i));
  		this.drawText(text, dx, rect.y, dw, 'right');
    }
};
	
};
//重写MOG_SceneMenu（自定义主菜单）绘制等级的方法
if(Imported.MOG_SceneMenu){
	MCharStatus.prototype.createLVNumber = function() {
		var x = this._layout.x + Moghunter.scMenu_LVNumberX;
		var y = this._layout.y + Moghunter.scMenu_LVNumberY;
		var leve_text = $gameSystem.JP_levleText(this._actor.level);
		this.JP_leve_text_bitmap = new Sprite(new Bitmap(300,50));
		this.JP_leve_text_bitmap.x = x;
		this.JP_leve_text_bitmap.y = y;
		this.addChild(this.JP_leve_text_bitmap);
		this.JP_leve_text_bitmap.bitmap.drawText(leve_text, 0, 0, leve_text.length*20,50,"left");
	};
};

//重写MOG_BattleResult（战斗结果）绘制等级的方法
if(Imported.MOG_BattleResult){
	BattleResult.prototype.createParameters = function() {
		var x = Moghunter.bresult_par1_x;
		var y = Moghunter.bresult_par1_y;
		var leve_text = $gameSystem.JP_levleText(this._actopar[0]);
		this._par = new Sprite(new Bitmap(Graphics.boxWidth,Graphics.boxHeight));
		this._par.opacity = 0;
		this._par.fontSize = 30;
		this._par.bitmap.drawText(leve_text,x,y,100,32);
		this._par.bitmap.drawText(this._actopar[1],x,y + 35 * 1,100,32);
		this._par.bitmap.drawText(this._actopar[2],x,y + 35 * 2,100,32);
		this._par.bitmap.drawText(this._actopar[3],x,y + 35 * 3,100,32);
		this._par.bitmap.drawText(this._actopar[4],x,y + 35 * 4,100,32);	
		this._par.bitmap.drawText(this._actopar[5],x,y + 35 * 5,100,32);
		this._par.bitmap.drawText(this._actopar[6],x,y + 35 * 6,100,32);
		this._par.bitmap.drawText(this._actopar[7],x,y + 35 * 7,100,32);
		this._par.bitmap.drawText(this._actopar[8],x,y + 35 * 8,100,32);
		var x = Moghunter.bresult_par2_x;
		var y = Moghunter.bresult_par2_y;	
		var leve_text = $gameSystem.JP_levleText(this._actor._level);
		this._par.bitmap.drawText(leve_text,x,y,leve_text.length*20,32);
		this._par.bitmap.drawText(this._actor.mhp,x,y + 35 * 1,100,32);
		this._par.bitmap.drawText(this._actor.mmp,x,y + 35 * 2,100,32);
		this._par.bitmap.drawText(this._actor.atk,x,y + 35 * 3,100,32);
		this._par.bitmap.drawText(this._actor.def,x,y + 35 * 4,100,32);	
		this._par.bitmap.drawText(this._actor.mat,x,y + 35 * 5,100,32);
		this._par.bitmap.drawText(this._actor.mdf,x,y + 35 * 6,100,32);
		this._par.bitmap.drawText(this._actor.agi,x,y + 35 * 7,100,32);
		this._par.bitmap.drawText(this._actor.luk,x,y + 35 * 8,100,32);	
		this.addChild(this._par);
	};
};

//重写MOG_ActorHud（角色头像）绘制等级的方法
if(Imported.MOG_ActorHud){
	Actor_Hud.prototype.create_level_number = function() {
		if (String(Moghunter.ahud_level_number_visible) != "true") {return};
		if (!this._battler) {return};
		var x = Moghunter.ahud_pos_x + Moghunter.ahud_level_number_pos_x;
		var y = Moghunter.ahud_pos_y + Moghunter.ahud_level_number_pos_y;
		this._level_number_old = this._battler.level;
		this.JP_leve_text_bitmap = new Sprite(new Bitmap(300,50));
		this.JP_leve_text_bitmap.x = x;
		this.JP_leve_text_bitmap.y = y;
		this.JP_leve_text_bitmap.bitmap.fontSize = 18;
		var leve_text = $gameSystem.JP_levleText(this._level_number_old);
		this.addChild(this.JP_leve_text_bitmap);
		this.JP_leve_text_bitmap.bitmap.drawText(leve_text, 0, 0, leve_text.length*20,50,Moghunter.ahud_level_number_align);
	};
	//重写MOG_ActorHud（角色头像）经验更新的方法
	Actor_Hud.prototype.update_exp = function() {
		if (this._exp_meter) {
			this._exp_meter.opacity += 15; 
			if (this.need_refresh_parameter(3)) {
				if (this._battler.isMaxLevel()) {
					this.refresh_meter(this._exp_meter,1,1,0,1,1);
				} else {
					this.refresh_meter(this._exp_meter,this._battler.current_exp_r(),this._battler.nextLevelExp_r(),0,1,1);
				};
				this._exp_old = this._battler.currentExp();
			};
		};
		var dif_number = this.update_dif(this._level_number_old,this._battler.level,30)
		if (this._level_number_old != dif_number) {this._level_number_old = dif_number;
			var x = Moghunter.ahud_pos_x + Moghunter.ahud_level_number_pos_x;
			var y = Moghunter.ahud_pos_y + Moghunter.ahud_level_number_pos_y;
			var leve_text = $gameSystem.JP_levleText(this._level_number_old);
			this.JP_leve_text_bitmap.bitmap.clear();
			this.JP_leve_text_bitmap.bitmap.drawText(leve_text, 0, 0, leve_text.length*20,50,Moghunter.ahud_level_number_align);};
	};
};
//重写小C宠物插件中宠物列表中的等级
if(Imported.CP_PetCore){
	Window_PetList.prototype.drawItem = function(index){
	var pet = this._list[index];
	var rect = this.itemRect(index);

	this.resetTextColor();
	if(pet.isInBattle())
		this.changeTextColor(this.fightColor());
	this.drawText(pet.name(), rect.x, rect.y, rect.width / 2, "left");
	if(CP.PetManager.SHOW_PET_LEVEL)
		this.drawText($gameSystem.JP_levleText(pet.level), rect.x + rect.width / 2, rect.y, rect.width / 2, "right");
	};
};
