//=============================================================================
// JP_MapBtn.js
//=============================================================================
/*:
*
* @plugindesc V1.1 地图场景显示按钮
* @author 青灯独酌
*
*
* @help
* 1、如果用到鼠标的八方向移动插件，请把此插件放在八方向移动插件之下。
* 2、使用到的图片资源存放在img/Map__ui/目录下，如果没有，请自行创建。
* 插件指令
* 	JP_MapBtn_show x   //显示第x个按钮
*	JP_MapBtn_hide x   //隐藏第x个按钮
* ==================================================================
* 版本：1.1.0
* 1、更改用插件命令修改按钮刷新时的方式。
* 2、更改点击按钮后有概率不能用鼠标移动 bug。
* =================================================================
* 版本：1.0.0
* 基础功能完成
//================================================================  
* @param ----按钮1----
* @default 
*
* @param btn1_show
* @parent ----按钮1----
* @type boolean
* @on 使用
* @off 不使用
* @desc 是否使用按钮1
* @default false

* @param btn1_Normal
* @parent ----按钮1----
* @desc 正常状态下按钮1所用的图片资源。
* @default btn1_Normal
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn1_Hover
* @parent ----按钮1----
* @desc 鼠标悬停在按钮上显示的图片资源。
* @default btn1_Hover
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn1_Press
* @parent ----按钮1----
* @desc 点击按钮时显示的资源。。
* @default btn1_Press
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn1_X
* @parent ----按钮1----
* @desc 按钮显示的X坐标。
* @default 300
*
* @param btn1_Y
* @parent ----按钮1----
* @desc 按钮显示的Y坐标。
* @default 0
*
* @param btn1_Event
* @parent ----按钮1----
* @desc 按钮触发的公共事件ID。
* @default 
*
*
* @param ----按钮2----
* @default 
*
* @param btn2_show
* @parent ----按钮2----
* @type boolean
* @on 使用
* @off 不使用
* @desc 是否使用按钮2
* @default false
*
* @param btn2_Normal
* @parent ----按钮2----
* @desc 正常状态下按钮所用的图片资源。
* @default btn1_Normal
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn2_Hover
* @parent ----按钮2----
* @desc 鼠标悬停在按钮上显示的图片资源。
* @default btn1_Hover
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn2_Press
* @parent ----按钮2----
* @desc 点击按钮时显示的资源。。
* @default btn1_Press
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn2_X
* @parent ----按钮2----
* @desc 按钮显示的X坐标。
* @default 300
*
* @param btn2_Y
* @parent ----按钮2----
* @desc 按钮显示的Y坐标。
* @default 0
*
* @param btn2_Event
* @parent ----按钮2----
* @desc 按钮触发的公共事件ID。
* @default 
*
*
* @param ----按钮3----
* @default 
*
* @param btn3_show
* @parent ----按钮3----
* @type boolean
* @on 使用
* @off 不使用
* @desc 是否使用按钮3
* @default false
*
* @param btn3_Normal
* @parent ----按钮3----
* @desc 正常状态下按钮所用的图片资源。
* @default btn1_Normal
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn3_Hover
* @parent ----按钮3----
* @desc 鼠标悬停在按钮上显示的图片资源。
* @default btn1_Hover
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn3_Press
* @parent ----按钮3----
* @desc 点击按钮时显示的资源。。
* @default btn1_Press
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn3_X
* @parent ----按钮3----
* @desc 按钮显示的X坐标。
* @default 300
*
* @param btn3_Y
* @parent ----按钮3----
* @desc 按钮显示的Y坐标。
* @default 0
*
* @param btn3_Event
* @parent ----按钮3----
* @desc 按钮触发的公共事件ID。
* @default 
*
*
* @param ----按钮4----
* @default 
*
* @param btn4_show
* @parent ----按钮4----
* @type boolean
* @on 使用
* @off 不使用
* @desc 是否使用按钮4
* @default false
*
* @param btn4_Normal
* @parent ----按钮4----
* @desc 正常状态下按钮所用的图片资源。
* @default btn1_Normal
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn4_Hover
* @parent ----按钮4----
* @desc 鼠标悬停在按钮上显示的图片资源。
* @default btn1_Hover
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn4_Press
* @parent ----按钮4----
* @desc 点击按钮时显示的资源。。
* @default btn1_Press
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn4_X
* @parent ----按钮4----
* @desc 按钮显示的X坐标。
* @default 300
*
* @param btn4_Y
* @parent ----按钮4----
* @desc 按钮显示的Y坐标。
* @default 0
*
* @param btn4_Event
* @parent ----按钮4----
* @desc 按钮触发的公共事件ID。
* @default 
*
*
* @param ----按钮5----
* @default 
*
* @param btn5_show
* @parent ----按钮5----
* @type boolean
* @on 使用
* @off 不使用
* @desc 是否使用按钮5
* @default false
*
* @param btn5_Normal
* @parent ----按钮5----
* @desc 正常状态下按钮所用的图片资源。
* @default btn1_Normal
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn5_Hover
* @parent ----按钮5----
* @desc 鼠标悬停在按钮上显示的图片资源。
* @default btn1_Hover
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn5_Press
* @parent ----按钮5----
* @desc 点击按钮时显示的资源。。
* @default btn1_Press
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn5_X
* @parent ----按钮5----
* @desc 按钮显示的X坐标。
* @default 300
*
* @param btn5_Y
* @parent ----按钮5----
* @desc 按钮显示的Y坐标。
* @default 0
*
* @param btn5_Event
* @parent ----按钮5----
* @desc 按钮触发的公共事件ID。
* @default 
*
*
* @param ----按钮6----
* @default 
*
* @param btn6_show
* @parent ----按钮6----
* @type boolean
* @on 使用
* @off 不使用
* @desc 是否使用按钮6
* @default false
*
* @param btn6_Normal
* @parent ----按钮6----
* @desc 正常状态下按钮所用的图片资源。
* @default btn1_Normal
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn6_Hover
* @parent ----按钮6----
* @desc 鼠标悬停在按钮上显示的图片资源。
* @default btn1_Hover
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn6_Press
* @parent ----按钮6----
* @desc 点击按钮时显示的资源。。
* @default btn1_Press
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn6_X
* @parent ----按钮6----
* @desc 按钮显示的X坐标。
* @default 300
*
* @param btn6_Y
* @parent ----按钮6----
* @desc 按钮显示的Y坐标。
* @default 0
*
* @param btn6_Event
* @parent ----按钮6----
* @desc 按钮触发的公共事件ID。
* @default 
* 
* @param ----按钮7----
* @default 
*
* @param btn7_show
* @parent ----按钮7----
* @type boolean
* @on 使用
* @off 不使用
* @desc 是否使用按钮7
* @default false
*
* @param btn7_Normal
* @parent ----按钮7----
* @desc 正常状态下按钮所用的图片资源。
* @default btn1_Normal
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn7_Hover
* @parent ----按钮7----
* @desc 鼠标悬停在按钮上显示的图片资源。
* @default btn1_Hover
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn7_Press
* @parent ----按钮7----
* @desc 点击按钮时显示的资源。。
* @default btn1_Press
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn7_X
* @parent ----按钮7----
* @desc 按钮显示的X坐标。
* @default 300
*
* @param btn7_Y
* @parent ----按钮7----
* @desc 按钮显示的Y坐标。
* @default 0
*
* @param btn7_Event
* @parent ----按钮7----
* @desc 按钮触发的公共事件ID。
* @default 
*
* @param ----按钮8----
* @default 
*
* @param btn8_show
* @parent ----按钮8----
* @type boolean
* @on 使用
* @off 不使用
* @desc 是否使用按钮8
* @default false
*
* @param btn8_Normal
* @parent ----按钮8----
* @desc 正常状态下按钮所用的图片资源。
* @default btn1_Normal
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn8_Hover
* @parent ----按钮8----
* @desc 鼠标悬停在按钮上显示的图片资源。
* @default btn1_Hover
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn8_Press
* @parent ----按钮8----
* @desc 点击按钮时显示的资源。。
* @default btn1_Press
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn8_X
* @parent ----按钮8----
* @desc 按钮显示的X坐标。
* @default 300
*
* @param btn8_Y
* @parent ----按钮8----
* @desc 按钮显示的Y坐标。
* @default 0
*
* @param btn8_Event
* @parent ----按钮8----
* @desc 按钮触发的公共事件ID。
* @default 
*
* @param ----按钮9----
* @default 
*
* @param btn9_show
* @parent ----按钮9----
* @type boolean
* @on 使用
* @off 不使用
* @desc 是否使用按钮9
* @default false
*
* @param btn9_Normal
* @parent ----按钮9----
* @desc 正常状态下按钮所用的图片资源。
* @default btn1_Normal
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn9_Hover
* @parent ----按钮9----
* @desc 鼠标悬停在按钮上显示的图片资源。
* @default btn1_Hover
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn9_Press
* @parent ----按钮9----
* @desc 点击按钮时显示的资源。。
* @default btn1_Press
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn9_X
* @parent ----按钮9----
* @desc 按钮显示的X坐标。
* @default 300
*
* @param btn9_Y
* @parent ----按钮9----
* @desc 按钮显示的Y坐标。
* @default 0
*
* @param btn9_Event
* @parent ----按钮9----
* @desc 按钮触发的公共事件ID。
* @default 
*
* @param ----按钮10----
* @default 
*
* @param btn10_show
* @parent ----按钮10----
* @type boolean
* @on 使用
* @off 不使用
* @desc 是否使用按钮10
* @default false
*
* @param btn10_Normal
* @parent ----按钮10----
* @desc 正常状态下按钮所用的图片资源。
* @default btn1_Normal
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn10_Hover
* @parent ----按钮10----
* @desc 鼠标悬停在按钮上显示的图片资源。
* @default btn1_Hover
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn10_Press
* @parent ----按钮10----
* @desc 点击按钮时显示的资源。。
* @default btn1_Press
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn10_X
* @parent ----按钮10----
* @desc 按钮显示的X坐标。
* @default 300
*
* @param btn10_Y
* @parent ----按钮10----
* @desc 按钮显示的Y坐标。
* @default 0
*
* @param btn10_Event
* @parent ----按钮10----
* @desc 按钮触发的公共事件ID。
* @default 
*
* @param ----按钮11----
* @default 
*
* @param btn11_show
* @parent ----按钮11----
* @type boolean
* @on 使用
* @off 不使用
* @desc 是否使用按钮11
* @default false
*
* @param btn11_Normal
* @parent ----按钮11----
* @desc 正常状态下按钮所用的图片资源。
* @default btn1_Normal
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn11_Hover
* @parent ----按钮11----
* @desc 鼠标悬停在按钮上显示的图片资源。
* @default btn1_Hover
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn11_Press
* @parent ----按钮11----
* @desc 点击按钮时显示的资源。。
* @default btn1_Press
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn11_X
* @parent ----按钮11----
* @desc 按钮显示的X坐标。
* @default 300
*
* @param btn11_Y
* @parent ----按钮11----
* @desc 按钮显示的Y坐标。
* @default 0
*
* @param btn11_Event
* @parent ----按钮11----
* @desc 按钮触发的公共事件ID。
* @default 
*
* @param ----按钮12----
* @default 
*
* @param btn12_show
* @parent ----按钮12----
* @type boolean
* @on 使用
* @off 不使用
* @desc 是否使用按钮12
* @default false
*
* @param btn12_Normal
* @parent ----按钮12----
* @desc 正常状态下按钮所用的图片资源。
* @default btn1_Normal
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn12_Hover
* @parent ----按钮12----
* @desc 鼠标悬停在按钮上显示的图片资源。
* @default btn1_Hover
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn12_Press
* @parent ----按钮12----
* @desc 点击按钮时显示的资源。。
* @default btn1_Press
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn12_X
* @parent ----按钮12----
* @desc 按钮显示的X坐标。
* @default 300
*
* @param btn12_Y
* @parent ----按钮12----
* @desc 按钮显示的Y坐标。
* @default 0
*
* @param btn12_Event
* @parent ----按钮12----
* @desc 按钮触发的公共事件ID。
* @default 
*
* @param ----按钮13----
* @default 
*
* @param btn13_show
* @parent ----按钮13----
* @type boolean
* @on 使用
* @off 不使用
* @desc 是否使用按钮13
* @default false
*
* @param btn13_Normal
* @parent ----按钮13----
* @desc 正常状态下按钮所用的图片资源。
* @default btn1_Normal
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn13_Hover
* @parent ----按钮13----
* @desc 鼠标悬停在按钮上显示的图片资源。
* @default btn1_Hover
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn13_Press
* @parent ----按钮13----
* @desc 点击按钮时显示的资源。。
* @default btn1_Press
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn13_X
* @parent ----按钮13----
* @desc 按钮显示的X坐标。
* @default 300
*
* @param btn13_Y
* @parent ----按钮13----
* @desc 按钮显示的Y坐标。
* @default 0
*
* @param btn13_Event
* @parent ----按钮13----
* @desc 按钮触发的公共事件ID。
* @default 
*
* @param ----按钮14----
* @default 
*
* @param btn14_show
* @parent ----按钮14----
* @type boolean
* @on 使用
* @off 不使用
* @desc 是否使用按钮6
* @default false
*
* @param btn14_Normal
* @parent ----按钮14----
* @desc 正常状态下按钮所用的图片资源。
* @default btn1_Normal
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn14_Hover
* @parent ----按钮14----
* @desc 鼠标悬停在按钮上显示的图片资源。
* @default btn1_Hover
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn14_Press
* @parent ----按钮14----
* @desc 点击按钮时显示的资源。。
* @default btn1_Press
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn14_X
* @parent ----按钮14----
* @desc 按钮显示的X坐标。
* @default 300
*
* @param btn14_Y
* @parent ----按钮14----
* @desc 按钮显示的Y坐标。
* @default 0
*
* @param btn14_Event
* @parent ----按钮14----
* @desc 按钮触发的公共事件ID。
* @default 
*
* @param ----按钮15----
* @default 
*
* @param btn15_show
* @parent ----按钮15----
* @type boolean
* @on 使用
* @off 不使用
* @desc 是否使用按钮15
* @default false
*
* @param btn15_Normal
* @parent ----按钮15----
* @desc 正常状态下按钮所用的图片资源。
* @default btn1_Normal
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn15_Hover
* @parent ----按钮15----
* @desc 鼠标悬停在按钮上显示的图片资源。
* @default btn1_Hover
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn15_Press
* @parent ----按钮15----
* @desc 点击按钮时显示的资源。。
* @default btn1_Press
* @require 1
* @dir img/Map__ui/
* @type file
*
* @param btn15_X
* @parent ----按钮15----
* @desc 按钮显示的X坐标。
* @default 300
*
* @param btn15_Y
* @parent ----按钮15----
* @desc 按钮显示的Y坐标。
* @default 0
*
* @param btn15_Event
* @parent ----按钮15----
* @desc 按钮触发的公共事件ID。
* @default 

*/

//获取参数
var JP_MapBtn_Parameters = PluginManager.parameters('JP_MapBtn');
var JP_mapbtn_btn1 = [];//保存按钮1的信息
var JP_mapbtn_btn2 = [];//保存按钮2的信息
var JP_mapbtn_btn3 = [];//保存按钮3的信息
var JP_mapbtn_btn4 = [];//保存按钮4的信息
var JP_mapbtn_btn5 = [];//保存按钮5的信息
var JP_mapbtn_btn6 = [];//保存按钮6的信息
var JP_mapbtn_btn7 = [];//保存按钮7的信息
var JP_mapbtn_btn8 = [];//保存按钮8的信息
var JP_mapbtn_btn9 = [];//保存按钮9的信息
var JP_mapbtn_btn10 = [];//保存按钮10的信息
var JP_mapbtn_btn11 = [];//保存按钮11的信息
var JP_mapbtn_btn12 = [];//保存按钮12的信息
var JP_mapbtn_btn13 = [];//保存按钮13的信息
var JP_mapbtn_btn14 = [];//保存按钮14的信息
var JP_mapbtn_btn15 = [];//保存按钮15的信息
var JP_mapbtn_show =[];//保存按钮是否显示的信息
var JP_mapbtn_showbtn =[]; //保存显示的按钮的实例信息
var JP_mapbtn_btnlist = [];//保存全部的按钮设置
var _jp_mouse_x = 0;
var _jp_mouse_y = 0;
JP_mapbtn_btn1 =[JP_MapBtn_Parameters.btn1_Normal,JP_MapBtn_Parameters.btn1_Hover,JP_MapBtn_Parameters.btn1_Press,JP_MapBtn_Parameters.btn1_X,JP_MapBtn_Parameters.btn1_Y,JP_MapBtn_Parameters.btn1_Event];
JP_mapbtn_btn2 =[JP_MapBtn_Parameters.btn2_Normal,JP_MapBtn_Parameters.btn2_Hover,JP_MapBtn_Parameters.btn2_Press,JP_MapBtn_Parameters.btn2_X,JP_MapBtn_Parameters.btn2_Y,JP_MapBtn_Parameters.btn2_Event];
JP_mapbtn_btn3 =[JP_MapBtn_Parameters.btn3_Normal,JP_MapBtn_Parameters.btn3_Hover,JP_MapBtn_Parameters.btn3_Press,JP_MapBtn_Parameters.btn3_X,JP_MapBtn_Parameters.btn3_Y,JP_MapBtn_Parameters.btn3_Event];
JP_mapbtn_btn4 =[JP_MapBtn_Parameters.btn4_Normal,JP_MapBtn_Parameters.btn4_Hover,JP_MapBtn_Parameters.btn4_Press,JP_MapBtn_Parameters.btn4_X,JP_MapBtn_Parameters.btn4_Y,JP_MapBtn_Parameters.btn4_Event];
JP_mapbtn_btn5 =[JP_MapBtn_Parameters.btn5_Normal,JP_MapBtn_Parameters.btn5_Hover,JP_MapBtn_Parameters.btn5_Press,JP_MapBtn_Parameters.btn5_X,JP_MapBtn_Parameters.btn5_Y,JP_MapBtn_Parameters.btn5_Event];
JP_mapbtn_btn6 =[JP_MapBtn_Parameters.btn6_Normal,JP_MapBtn_Parameters.btn6_Hover,JP_MapBtn_Parameters.btn6_Press,JP_MapBtn_Parameters.btn6_X,JP_MapBtn_Parameters.btn6_Y,JP_MapBtn_Parameters.btn6_Event];
JP_mapbtn_btn7 =[JP_MapBtn_Parameters.btn7_Normal,JP_MapBtn_Parameters.btn7_Hover,JP_MapBtn_Parameters.btn7_Press,JP_MapBtn_Parameters.btn7_X,JP_MapBtn_Parameters.btn7_Y,JP_MapBtn_Parameters.btn7_Event];
JP_mapbtn_btn8 =[JP_MapBtn_Parameters.btn8_Normal,JP_MapBtn_Parameters.btn8_Hover,JP_MapBtn_Parameters.btn8_Press,JP_MapBtn_Parameters.btn8_X,JP_MapBtn_Parameters.btn8_Y,JP_MapBtn_Parameters.btn8_Event];
JP_mapbtn_btn9 =[JP_MapBtn_Parameters.btn9_Normal,JP_MapBtn_Parameters.btn9_Hover,JP_MapBtn_Parameters.btn9_Press,JP_MapBtn_Parameters.btn9_X,JP_MapBtn_Parameters.btn9_Y,JP_MapBtn_Parameters.btn9_Event];
JP_mapbtn_btn10 =[JP_MapBtn_Parameters.btn10_Normal,JP_MapBtn_Parameters.btn10_Hover,JP_MapBtn_Parameters.btn10_Press,JP_MapBtn_Parameters.btn10_X,JP_MapBtn_Parameters.btn10_Y,JP_MapBtn_Parameters.btn10_Event];
JP_mapbtn_btn11 =[JP_MapBtn_Parameters.btn11_Normal,JP_MapBtn_Parameters.btn11_Hover,JP_MapBtn_Parameters.btn11_Press,JP_MapBtn_Parameters.btn11_X,JP_MapBtn_Parameters.btn11_Y,JP_MapBtn_Parameters.btn11_Event];
JP_mapbtn_btn12 =[JP_MapBtn_Parameters.btn12_Normal,JP_MapBtn_Parameters.btn12_Hover,JP_MapBtn_Parameters.btn12_Press,JP_MapBtn_Parameters.btn12_X,JP_MapBtn_Parameters.btn12_Y,JP_MapBtn_Parameters.btn12_Event];
JP_mapbtn_btn13 =[JP_MapBtn_Parameters.btn13_Normal,JP_MapBtn_Parameters.btn13_Hover,JP_MapBtn_Parameters.btn13_Press,JP_MapBtn_Parameters.btn13_X,JP_MapBtn_Parameters.btn13_Y,JP_MapBtn_Parameters.btn13_Event];
JP_mapbtn_btn14 =[JP_MapBtn_Parameters.btn14_Normal,JP_MapBtn_Parameters.btn14_Hover,JP_MapBtn_Parameters.btn14_Press,JP_MapBtn_Parameters.btn14_X,JP_MapBtn_Parameters.btn14_Y,JP_MapBtn_Parameters.btn14_Event];
JP_mapbtn_btn15 =[JP_MapBtn_Parameters.btn15_Normal,JP_MapBtn_Parameters.btn15_Hover,JP_MapBtn_Parameters.btn15_Press,JP_MapBtn_Parameters.btn15_X,JP_MapBtn_Parameters.btn15_Y,JP_MapBtn_Parameters.btn15_Event];
JP_mapbtn_show = [JP_MapBtn_Parameters.btn1_show,JP_MapBtn_Parameters.btn2_show,JP_MapBtn_Parameters.btn3_show,JP_MapBtn_Parameters.btn4_show,JP_MapBtn_Parameters.btn5_show,JP_MapBtn_Parameters.btn6_show,JP_MapBtn_Parameters.btn7_show,JP_MapBtn_Parameters.btn8_show,JP_MapBtn_Parameters.btn9_show,JP_MapBtn_Parameters.btn10_show,JP_MapBtn_Parameters.btn11_show,JP_MapBtn_Parameters.btn12_show,JP_MapBtn_Parameters.btn13_show,JP_MapBtn_Parameters.btn14_show,JP_MapBtn_Parameters.btn15_show];
JP_mapbtn_btnlist = [JP_mapbtn_btn1,JP_mapbtn_btn2,JP_mapbtn_btn3,JP_mapbtn_btn4,JP_mapbtn_btn5,JP_mapbtn_btn6,JP_mapbtn_btn7,JP_mapbtn_btn8,JP_mapbtn_btn9,JP_mapbtn_btn10,JP_mapbtn_btn11,JP_mapbtn_btn12,JP_mapbtn_btn13,JP_mapbtn_btn14,JP_mapbtn_btn15];
var _JP_MapBtn_findDirectionTo = Game_Character.prototype.findDirectionTo;//保存鼠标移动函数，用于点击按钮时屏蔽移动功能

//初始化
var _JP_mapbtn_initialize = Game_System.prototype.initialize;
Game_System.prototype.initialize = function(){
	_JP_mapbtn_initialize.call(this);
	this.JP_mapbtn_show = JP_mapbtn_show;
};


// ** 资源文件夹
//=============================================================================
ImageManager.load_MapBtnHud = function(filename) {
    return this.loadBitmap('img/Map__ui/', filename, 0, true);
};

//*把创建的按钮添加到地图上显示
var _JP_MapBtn_createSpriteset  = Scene_Map.prototype.createSpriteset;
Scene_Map.prototype.createSpriteset = function() {
	_JP_MapBtn_createSpriteset.call(this);
	//每次返回地图界面重新绘制按钮信息
	this.jp_mapbtn_Refresh();
};
//刷新按钮信息
Scene_Map.prototype.jp_mapbtn_Refresh =function(){
	if(JP_mapbtn_showbtn !== null){
		this.removeChild (JP_mapbtn_showbtn[1]);
		this.removeChild (JP_mapbtn_showbtn[2]);
		this.removeChild (JP_mapbtn_showbtn[3]);
		JP_mapbtn_showbtn =[];
	}
	this.jp_createMapBtnHud();
}

//创建按钮
Scene_Map.prototype.jp_createMapBtnHud = function() {
	this._MapBtn = new Jp_MapBtnHud();
	this._MapBtn.mz = 120;
	this.addChild(this._MapBtn);			
};	

//定义按钮
 function Jp_MapBtnHud() {
    this.initialize.apply(this, arguments)
}
Jp_MapBtnHud.prototype = Object.create(Sprite.prototype);
Jp_MapBtnHud.prototype.constructor = Jp_MapBtnHud;

//初始化设置
Jp_MapBtnHud.prototype.initialize = function() {
	Sprite.prototype.initialize.call(this);
	for(var i=0 ;i< $gameSystem.JP_mapbtn_show.length; i++){
		this.Jp_createmapbtn(i);
		
	}
};

//创建按钮
Jp_MapBtnHud.prototype.Jp_createmapbtn = function(btn_num){
	var newbtn =JP_mapbtn_btnlist[btn_num]; 
	this.mapbtn = new Sprite(ImageManager.load_MapBtnHud(newbtn[0]));
	this.mapbtn_event = newbtn[5];
	this.mapbtn_hover = new Sprite(ImageManager.load_MapBtnHud(newbtn[1]));
	this.mapbtn_press = new Sprite(ImageManager.load_MapBtnHud(newbtn[2]));
	this.mapbtn.x = Number(newbtn[3]);
	this.mapbtn.y = Number(newbtn[4]);
	this.mapbtn_hover.x = Number(newbtn[3]);
	this.mapbtn_hover.y = Number(newbtn[4]);
	this.mapbtn_press.x = Number(newbtn[3]);
	this.mapbtn_press.y = Number(newbtn[4]);
	this.mapbtn.visible = false;	//初始都不显示
	this.mapbtn_hover.visible = false;
	this.mapbtn_hover._touched = false;
	this.mapbtn_press.visible = false;
	this.mapbtn_press._touched = false;
	this.addChild(this.mapbtn);
	this.addChild(this.mapbtn_hover);
	this.addChild(this.mapbtn_press);
	JP_mapbtn_showbtn.push([btn_num,this.mapbtn,this.mapbtn_hover,this.mapbtn_press,this.mapbtn_event]);
};

Jp_MapBtnHud.prototype.update =function(){
	for(var i=0 ;i< $gameSystem.JP_mapbtn_show.length; i++){
		if($gameSystem.JP_mapbtn_show[i] == "true"){
			JP_mapbtn_showbtn[i][1].visible = true;	//
			if($gameMessage.isBusy()){
				JP_mapbtn_showbtn[i][1].visible = false;
			}else this.jp_update_btnimg(i);
		}else JP_mapbtn_showbtn[i][1].visible = false;
	}
}

Jp_MapBtnHud.prototype.jp_update_btnimg = function(btn_num){
	 var currentbtn = JP_mapbtn_showbtn[btn_num];
	 //切换悬停图
	 if(this.JP_isHover(currentbtn[1])){
		if(currentbtn[2]._touched == false){
			currentbtn[1].visible = false;
			currentbtn[2].visible = true;
			currentbtn[2]._touched = true;
			SoundManager.playCursor();
			JP_mapbtn_showbtn.splice(btn_num,1,currentbtn);//更新按钮列表中的属性。
			Game_Character.prototype.findDirectionTo = function(goalX, goalY){};//屏蔽鼠标移动功能
		}
	 }else if(!this.JP_isHover(currentbtn[2]) && currentbtn[2]._touched == true){
		currentbtn[1].visible = true;
		currentbtn[2].visible = false;
		currentbtn[2]._touched = false;
		JP_mapbtn_showbtn.splice(btn_num,1,currentbtn);//更新按钮列表中的属性。
		Game_Character.prototype.findDirectionTo = function(goalX, goalY){return _JP_MapBtn_findDirectionTo.call(this,goalX,goalY);};//重新开启鼠标移动功能
	 }
	 //切换点击图
	 if(this.JP_isPress(currentbtn[2]) || this.JP_isPress(currentbtn[1])){
		if(currentbtn[3]._touched == false){
			currentbtn[1].visible = false;
			currentbtn[2].visible = false;
			currentbtn[3].visible = true;
			currentbtn[3]._touched = true;
			var eventid = Number(currentbtn[4]);
			if (TouchInput.isTriggered()){	//鼠标释放后执行操作
				SoundManager.playOk();
				$gameTemp.reserveCommonEvent(eventid);
				Game_Character.prototype.findDirectionTo = function(goalX, goalY){return _JP_MapBtn_findDirectionTo.call(this,goalX,goalY);};//重新开启鼠标移动功能
			}	
		}
	 }else if(!this.JP_isPress(currentbtn[3])&& currentbtn[3]._touched == true){
			currentbtn[1].visible = true;
			currentbtn[2].visible = false;
			currentbtn[3].visible = false;
			currentbtn[3]._touched = false;
		
	 }
};

//悬停监控
Jp_MapBtnHud.prototype.JP_isHover = function(sprite) {
	 if (sprite == null){ return false };
	 if (sprite.bitmap == null){ return false };
	 if (!sprite.bitmap.isReady() ){ return false };
	 var cw = sprite.bitmap.width;
	 var ch = sprite.bitmap.height;
	 if (sprite.visible === false) {return false};
	 if (sprite.opacity === 0) {return false};
	 if (_jp_mouse_x < sprite.x) {return false};
	 if (_jp_mouse_x > sprite.x + cw) {return false};
	 if (_jp_mouse_y < sprite.y) {return false};
	 if (_jp_mouse_y > sprite.y + ch) {return false};
	 return true;	
};
// * 点击监听
Jp_MapBtnHud.prototype.JP_isPress = function(sprite) {
	 if (sprite == null){ return false };
	 if (sprite.bitmap == null){ return false };
	 if (!sprite.bitmap.isReady() ){ return false };
	 if ( !TouchInput.isPressed() ) {return false};		//需要确定是否为鼠标点击
	 var cw = sprite.bitmap.width;
	 var ch = sprite.bitmap.height;
	 if (sprite.visible === false) {return false};
	 if (sprite.opacity === 0) {return false};
	 if (TouchInput.x < sprite.x) {return false};
	 if (TouchInput.x > sprite.x + cw) {return false};
	 if (TouchInput.y < sprite.y) {return false};
	 if (TouchInput.y > sprite.y + ch) {return false};
	 return true;	
};

// ** 获取鼠标位置
//=============================================================================
if( typeof(_jp_mouse_getCurPos) == "undefined" ){	//防止重复定义
	
	var _jp_mouse_getCurPos = TouchInput._onMouseMove;
	TouchInput._onMouseMove = function(event) {		//绑定在TouchInput中
		_jp_mouse_getCurPos.call(this,event);
        _jp_mouse_x = Graphics.pageToCanvasX(event.pageX);
        _jp_mouse_y = Graphics.pageToCanvasY(event.pageY);
	};
}

//插件指令
var _JP_MapBtn_pluginCommand =Game_Interpreter.prototype.pluginCommand;
Game_Interpreter.prototype.pluginCommand = function(command, args) {
	_JP_MapBtn_pluginCommand.call(this, command, args);
	if(command == "JP_MapBtn_show" && args !=null){
		var btnid = Number(args) - 1;
		$gameSystem.JP_mapbtn_show[btnid] = "true";
	}
	 if(command == "JP_MapBtn_hide" && args !=null){
		var btnid = Number(args) - 1;
		$gameSystem.JP_mapbtn_show[btnid] = "false";
	}
};