//=============================================================================
// JP_MapInfo.js
//=============================================================================

/*:
*
* @plugindesc V1.3 地图名称与坐标显示
* @author 青灯独酌

* @param show
* @type boolean
* @on 显示
* @off 不显示
* @desc 进入游戏时是否初始显示地图坐标信息。
* true - 显示，false - 不显示
* @default true
*
* @param window_x
* @desc 地图窗口的X坐标,0为最左。
* @default 600
*
* @param window_y
* @desc 地图窗口的y坐标,0为最上方。
* @default 0
*
* @param window_bg
* @desc 地图窗口的背景。
* @default mapinfo_bg
* @require 1
* @dir img/Map__ui/
* @type file
*
*
* @param window_width
* @desc 背景的宽度
* @default 180
*
*
* @param window_opacity
* @desc 窗口背景的透明度，0为完全透明，255为完全不透明。
* @default 255
*
*
* @param name_x
* @desc 地图名字相对于背景的水平移量。
* @default 0
*
*
* @param name_y
* @desc 地图名字相对于背景的垂直偏移量0
* @default 5
*
*
* @param point_x
* @desc 地图坐标相对于背景的水平偏移量。
* @default 0
*
*
* @param point_y
* @desc 地图坐标相对于背景的垂直偏移量。
* @default 30
*
*
* @param text_fontsize
* @desc 字体大小,默认15
* @default 15
*
*
* @param text_opacity
* @desc 地图名字与坐标的透明度，0为完全透明，255为完全不透明。
* @default 255
*
* @param show_variable
* @type boolean
* @on 显示
* @off 不显示
* @desc 地图名字后是否显示变量后缀。
* true - 显示，false - 不显示
* @default false
* 
* @param variable_id
* @desc 后缀变量的ID
* @default 2
*
* @param variable_aftertext
* @desc 变量后的后缀
* @default 层
*
* @param variable_mapid
* @desc 显示变量与后缀的地图ID，中间用半角英文 , 隔开,不要加空格。
* @default 1,2,3,4
* 
* @param floating_box_x
* @desc 进入地图时，地图浮动框的X坐标。
* @default 0
*
*
* @param floating_box_y
* @desc 进入地图时，地图浮动框的Y坐标。
* @default 30
*
* @help
* 如果启动变量后缀，地图名字将为：预设名+变量数字+变量后缀
* 	如：新手村1层
* 窗口背景路径为img/Map__ui，如果没有，请创建此文件夹。
* 插价指令如下
* 	隐藏地图坐标信息：JP_MapInfo_hide
* 	显示地图坐标信息：JP_MapInfo_show
*	更新地图名后缀的变量ID为x：JP_MapInfo_updatevariable_id x
* =============================================================================
* 版本：1.3
* 增加进入新地图时，调整地图浮动框位置的设置。
* =============================================================================
* 版本：1.2
* 地图名字后增加变量相关后缀
* =============================================================================
* 版本：1.1
* 整体改版，从原来的默认窗口改为可自定义背景的,修改插件命令
* =============================================================================
* 版本：1.0
* 基础功能完成
* =============================================================================
*/

//获取参数
var Jp_mapInfo_Parameters = PluginManager.parameters('JP_MapInfo');
var Jp_mapInfo_window_x = Number(Jp_mapInfo_Parameters.window_x);
var Jp_mapInfo_window_y = Number(Jp_mapInfo_Parameters.window_y);
var Jp_mapInfo_window_bg = String(Jp_mapInfo_Parameters.window_bg);
var Jp_mapInfo_window_width = Number(Jp_mapInfo_Parameters.window_width);
var Jp_mapInfo_window_opacity = Number(Jp_mapInfo_Parameters.window_opacity);
var Jp_mapInfo_name_x = Number(Jp_mapInfo_Parameters.name_x);
var Jp_mapInfo_name_y = Number(Jp_mapInfo_Parameters.name_y);
var Jp_mapInfo_point_x = Number(Jp_mapInfo_Parameters.point_x);
var Jp_mapInfo_point_y = Number(Jp_mapInfo_Parameters.point_y);
var Jp_mapInfo_text_fontsize = Number(Jp_mapInfo_Parameters.text_fontsize);
var Jp_mapInfo_text_opacity = Number(Jp_mapInfo_Parameters.text_opacity);
var Jp_mapInfo_oldx = 0;
var Jp_mapInfo_oldy = 0;
var Jp_mapInfo_show_variable = String(Jp_mapInfo_Parameters.show_variable);
var Jp_mapInfo_variable_id = Number(Jp_mapInfo_Parameters.variable_id);
var Jp_mapInfo_variable_aftertext = String(Jp_mapInfo_Parameters.variable_aftertext);
var Jp_mapInfo_show_variable_mapid = [];
var Jp_mapInfo_show_variable_mapid = String(Jp_mapInfo_Parameters.variable_mapid).split(",");
var temp_mapname = 0;
var Jp_mapInfo_floating_box_x = Number(Jp_mapInfo_Parameters.floating_box_x);
var Jp_mapInfo_floating_box_y = Number(Jp_mapInfo_Parameters.floating_box_y);
//初始化
var _JP_mapInfo_initialize = Game_System.prototype.initialize;
Game_System.prototype.initialize = function(){
	_JP_mapInfo_initialize.call(this);
	this.Jp_mapInfo();
};
Game_System.prototype.Jp_mapInfo =function(){
	this.Jp_mapInfo_show = (Jp_mapInfo_Parameters.show == "true"? true : false);//记录是否显示
	this.Jp_mapInfo_variable_id = Jp_mapInfo_variable_id;//后缀变量ID
};
// ** 资源文件夹
//=============================================================================
ImageManager.load_mapInfoHud = function(filename) {
    return this.loadBitmap('img/Map__ui/', filename, 0, true);
};
//============================================================
//在地图上创建窗口空间
Scene_Base.prototype.jp_create_mapinfo_HudField = function() {
	this._hudField = new Sprite();
	this._hudField.z = 10;
	this.addChild(this._hudField);
};
//*把创建的窗口添加到地图上显示
var _jp_mapinfoHud_createSpriteset = Scene_Map.prototype.createSpriteset;
Scene_Map.prototype.createSpriteset = function() {
	_jp_mapinfoHud_createSpriteset.call(this);
	this.jp_create_mapinfo_HudField();
	this.jp_createMapInfoHud();
};
Scene_Map.prototype.jp_createMapInfoHud = function() {
	this._MapInfo = new Jp_MapInfoHud();
	this._MapInfo.mz = 120;
	this._hudField.addChild(this._MapInfo);			
};	

//=================================================================
//创建窗口
 function Jp_MapInfoHud() {
    this.initialize.apply(this, arguments)
}
Jp_MapInfoHud.prototype = Object.create(Sprite.prototype);
Jp_MapInfoHud.prototype.constructor = Jp_MapInfoHud;
//==============================
//初始化设置
Jp_MapInfoHud.prototype.initialize = function() {
	Sprite.prototype.initialize.call(this);
	this.Jp_createBackground();	//绘制地图框背景
	this.Jp_createMapText();//绘制地图信息
	this.Jp_refreshText();	//刷新信息
}
//==============================
// * 初始化-背景
Jp_MapInfoHud.prototype.Jp_createBackground = function() {
	this. mapInfo_window_bg = new Sprite(ImageManager.load_mapInfoHud(Jp_mapInfo_window_bg));
	this.mapInfo_window_bg.opacity = Jp_mapInfo_window_opacity;
	this.mapInfo_window_bg.x = Jp_mapInfo_window_x;
	this.mapInfo_window_bg.y = Jp_mapInfo_window_y;
	this.addChild(this.mapInfo_window_bg);
}
//==============================
//*初始化地图名字
Jp_MapInfoHud.prototype.Jp_createMapText =function(){
	this._mapname = new Sprite(new Bitmap(Jp_mapInfo_window_width, Jp_mapInfo_text_fontsize ));
	this._mapname.x = Jp_mapInfo_window_x + Jp_mapInfo_name_x - Jp_mapInfo_window_width/2 ;
	this._mapname.y = Jp_mapInfo_window_y + Jp_mapInfo_name_y;
	this._mapname.bitmap.fontSize = Jp_mapInfo_text_fontsize;
	this.addChild(this._mapname);
	this._mappoint = new Sprite(new Bitmap(Jp_mapInfo_window_width, Jp_mapInfo_text_fontsize ));
	this._mappoint.x = Jp_mapInfo_window_x + Jp_mapInfo_point_x - Jp_mapInfo_window_width/2;
	this._mappoint.y = Jp_mapInfo_window_y + Jp_mapInfo_point_y;
	this._mappoint.bitmap.fontSize = Jp_mapInfo_text_fontsize;
	this.addChild(this._mappoint);
}
//=================
//*绘制地图名字与坐标
Jp_MapInfoHud.prototype.Jp_refreshText = function() {
	this._mapname.bitmap.clear();
	this._mappoint.bitmap.clear();
	Jp_mapInfo_oldx = $gamePlayer.x;
	Jp_mapInfo_oldy = $gamePlayer.y;
	if(Jp_mapInfo_show_variable == "true"){
		if(Jp_mapInfo_show_variable_mapid.indexOf(String($gameMap.mapId()))>=0){
			temp_mapname = $dataMap.displayName + $gameVariables.value($gameSystem.Jp_mapInfo_variable_id) + Jp_mapInfo_variable_aftertext;
		}else temp_mapname = $dataMap.displayName;
	}else temp_mapname = $dataMap.displayName;
	this._mapname.bitmap.drawText(temp_mapname, 0, 0, this._mapname.width, this._mapname.bitmap.fontSize,'center');
	this._mappoint.bitmap.drawText($gamePlayer.x+" , " + $gamePlayer.y, 0, 0, this._mappoint.width, this._mappoint.bitmap.fontSize,'center');
}
//======================
//更新窗口信息
Jp_MapInfoHud.prototype.update = function() {
   if(Jp_mapInfo_oldx != $gamePlayer.x||Jp_mapInfo_oldy != $gamePlayer.y){
		this.Jp_refreshText();	
   } 
	if ($gameSystem.Jp_mapInfo_show == false) {
		this.opacity = 0;
		this._mapname.opacity  = 0;
		this._mappoint.opacity  = 0;
		}; 
	if($gameSystem.Jp_mapInfo_show == true){
		this.opacity = Jp_mapInfo_window_opacity;	//窗口的透明度
		this._mapname.opacity  = Jp_mapInfo_text_opacity;
		this._mappoint.opacity  = Jp_mapInfo_text_opacity;
		};
}; 	

//进入地图时的地图名浮动提示更改
Window_MapName.prototype.refresh = function() {
    this.contents.clear();
    if ($gameMap.displayName()) {
        var width = this.contentsWidth();
        this.drawBackground(0, 0, width, this.lineHeight());
        this.drawText(temp_mapname, 0, 0, width, 'center');
    }
};
//更改浮动框位置
Window_MapName.prototype.initialize = function() {
    var wight = this.windowWidth();
    var height = this.windowHeight();
	var x = Jp_mapInfo_floating_box_x - wight/2;
	var y = Jp_mapInfo_floating_box_y - height/2;
    Window_Base.prototype.initialize.call(this, x, y, wight, height);
    this.opacity = 0;
    this.contentsOpacity = 0;
    this._showCount = 0;
    this.refresh();
};

//插件命令
var Jp_mapInfo_pluginCommand = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function(command, args) {
        Jp_mapInfo_pluginCommand.call(this, command, args);
        // 在这里插入额外的内容
		if (command === 'JP_MapInfo_hide') {
			$gameSystem.Jp_mapInfo_show = false;
        }
		if (command === 'JP_MapInfo_show') {
			$gameSystem.Jp_mapInfo_show = true;
        }
		if(command === 'JP_MapInfo_updatevariable_id'){
			$gameSystem.Jp_mapInfo_variable_id = Number(args);
		}
    };