//=============================================================================
// JP_MaxLevel.js
//=============================================================================
/*:
*
* @plugindesc V1.2 最大等级
* @author 青灯独酌
*
* @param default_MaxLevel
* @desc 默认等级
* @default 99

* @param actor_MaxLevel_list
* @desc 角色最大等级列表,示例:1 10,2 10,3 10,4 10
* @default 1 10,2 10,3 10,4 10
*
* @param gainExp
* @type boolean
* @on 不获得经验
* @off 获得经验
* @desc 达到最大等级后是否还获得经验值。
* true - 不获得经验，false - 获得经验
* @default true
*
* @help
* 1、可以单独设置每个角色的等级，如果没有设置，则使用默认等级。
* 2、格式为 1 10,2 10,3 10,4 10
* 3、第一个数为角色ID，空格后为设置的等级，多个角色用英文半角 , 隔开。
* 4、除去角色ID与等级之间有空格，其他不要有多余的空格。
* 5、如果使用此插件，需要把它放在其他修改最大等级的插件下方。
* 插件指令
* 	Jp_update_maxlevel 1 20//把1号角色的最大等级设置为20，此命令每次
*	只能设置一个角色。
*	Jp_update_maxlevel this 30//用于使用道具调取公共事件的插件命令，
*	把使用道具角色的最大等级修改为30级，道具的使用范围为我方单体。
* 插件指令只对设置了等级上限的角色生效。
* ==================================================================
* 版本：1.2.0
* 增加满级时不能获得经验设置
* ==================================================================
* 版本：1.1.0
* 修复插件命令失效的BUG
* =================================================================
* 版本：1.0.0
* 基础功能完成
//================================================================  
*/
var Imported = Imported || {};
Imported.JP_MaxLevel = true;
var Jp = Jp || {}; 
//参数处理
Jp.MaxLevel = PluginManager.parameters('JP_MaxLevel');
Jp.MaxLevel.default_MaxLevel = Number(Jp.MaxLevel['default_MaxLevel']);
Jp.MaxLevel.actor_MaxLevel_list = Jp.MaxLevel['actor_MaxLevel_list'].split(",");
Jp.MaxLevel.gainExp = Jp.MaxLevel["gainExp"];
for(var i=0; i < Jp.MaxLevel.actor_MaxLevel_list.length; i++){
	Jp.MaxLevel.actor_MaxLevel_list[i] = Jp.MaxLevel.actor_MaxLevel_list[i].split(" ");
}
//初始化
var _Jp_MaxLevel_initialize = Game_System.prototype.initialize;
Game_System.prototype.initialize = function(){
	_Jp_MaxLevel_initialize.call(this);
	this._Jp_MaxLevel = Jp.MaxLevel.actor_MaxLevel_list;
};
//查找设置角色设置的最大等级
 Game_Actor.prototype.Jp_find_actormaxlevel = function(actorId){
	var _temp_MaxLevel = Jp.MaxLevel.default_MaxLevel;
	for (var i=0; i < $gameSystem._Jp_MaxLevel.length; i++){
		 if(Number($gameSystem._Jp_MaxLevel[i][0]) == actorId){
			_temp_MaxLevel = Number($gameSystem._Jp_MaxLevel[i][1]);
		} 
	}
	return _temp_MaxLevel;
}; 
//重新定义最大等级
 Game_Actor.prototype.maxLevel = function() {
	this.actor().maxLevel = this.Jp_find_actormaxlevel(this.actorId());
	return this.actor().maxLevel;
};
//达到最大等级后无法获得经验
Game_Actor.prototype.changeExp = function(exp, show) {
    var temp_gainExp = exp - this.currentExp();//获得的经验
	if(Jp.MaxLevel.gainExp == "true"){this.isMaxLevel()? temp_gainExp = 0 : temp_gainExp;}
	exp = this.currentExp() + temp_gainExp;//累计的经验
	this._exp[this._classId] = Math.max(exp, 0);
    var lastLevel = this._level;
    var lastSkills = this.skills();
    while (!this.isMaxLevel() && this.currentExp() >= this.nextLevelExp()) {
        this.levelUp();
    }
    while (this.currentExp() < this.currentLevelExp()) {
        this.levelDown();
    }
    if (show && this._level > lastLevel) {
        this.displayLevelUp(this.findNewSkills(lastSkills));
    }
    this.refresh();
};

//达到最大等级时显示的替代经验值内容修改
Window_Status.prototype.drawExpInfo = function(x, y) {
    var lineHeight = this.lineHeight();
    var expTotal = TextManager.expTotal.format(TextManager.exp);
    var expNext = TextManager.expNext.format(TextManager.level);
    var value1 = this._actor.currentExp();
    var value2 = this._actor.nextRequiredExp();
    if (this._actor.isMaxLevel()) {
        value1 = '已达瓶颈';
        value2 = '-已达瓶颈-';
    }
    this.changeTextColor(this.systemColor());
    this.drawText(expTotal, x, y + lineHeight * 0, 270);
    this.drawText(expNext, x, y + lineHeight * 2, 270);
    this.resetTextColor();
    this.drawText(value1, x, y + lineHeight * 1, 270, 'right');
    this.drawText(value2, x, y + lineHeight * 3, 270, 'right');
};


//插件指令
var _Jp_MaxLevle_pluginCommand =Game_Interpreter.prototype.pluginCommand;
Game_Interpreter.prototype.pluginCommand = function(command, args) {
	_Jp_MaxLevle_pluginCommand.call(this, command, args);
	// 在这里插入额外的内容
	if(command == "Jp_update_maxlevel" && args != null ){
		if(args[0] == "this"){
			args[0] = $gameParty._targetActorId;//获取使用道具的目标ID
			$gameActors.actor(args[0])._level +=1;//使用后等级提升1级
		}
		for(var i = 0 ; i < $gameSystem._Jp_MaxLevel.length; i++){
			if(Number($gameSystem._Jp_MaxLevel[i][0]) == Number(args[0])){
				$gameSystem._Jp_MaxLevel[i][1] = Number(args[1]);
			}
		}
		
	}
}; 