//=============================================================================
// JP_MenuBackButton.js
//=============================================================================

/*:
*
* @plugindesc V1.0 UI界面返回/按钮
* @author 青灯独酌
*
* @param isopen
* @desc 是否开启本功能。
* @type boolean
* @on 开启
* @off 不开启
* @default true
* 
* @param btn_normal
* @desc 按钮常态资源
* @default backbtn_1
* @require 1
* @dir img/Menu__layer_backBtn/
* @type file
*
* @param btn_hover
* @desc 鼠标悬停时，按钮高亮资源
* @default backbtn_2
* @require 1
* @dir img/Menu__layer_backBtn/
* @type file
*
* @param btn_press
* @desc 鼠标按下时，按钮按下资源
* @default backbtn_3
* @require 1
* @dir img/Menu__layer_backBtn/
* @type file
* 
* @param btn_x
* @desc 按钮的X坐标
* @default 300
*
* @param btn_y
* @desc 按钮的y坐标
* @default 300
*
* @param scene_bg
* @desc 对应场景的背景图
* @default scene_bg
* @require 1
* @dir img/Menu__layer_backBtn/
* @type file
*
* @help
* 在UI界面增加返回上一层的按钮。
* ===============================
* 默认界面对应的关键字如下：
* 菜单界面：Scene_Menu
* 物品界面：Scene_Item
* 技能界面：Scene_Skill
* 装备界面：Scene_Equip
* 状态界面：Scene_Status
* 存档界面：Scene_Save
* 读取存档界面：Scene_Load
* 设置界面：Scene_Options
* =============================================================================
* 版本：1.0.0
* 基础功能完成.
* =============================================================================
*/

var Imported = Imported || {};
Imported.JP_MenuBackButton = true;
var Jp = Jp || {}; 
// 参数处理
Jp.MenuBackButton = PluginManager.parameters('JP_MenuBackButton');
Jp.MenuBackButton.btn = [Jp.MenuBackButton['isopen'],Jp.MenuBackButton['btn_normal'],Jp.MenuBackButton['btn_hover'],Jp.MenuBackButton['btn_press'],Jp.MenuBackButton['btn_x'],Jp.MenuBackButton['btn_y']];
Jp.MenuBackButton.scene_bg = Jp.MenuBackButton['scene_bg'];
var JP_MenuBackButton_btn_touched = false;//记录悬停状态，避免重复执行


// ** 资源文件夹
//=============================================================================
ImageManager.load_MenuBackButton = function(filename) {
    return this.loadBitmap('img/Menu__layer_backBtn/', filename, 0, true);
};

//==============显示关闭按钮的界面========================.
//菜单界面创建背景
var _JP_MenuBackButton_createBackground = Scene_MenuBase.prototype.createBackground;
Scene_MenuBase.prototype.createBackground = function() {
	_JP_MenuBackButton_createBackground.call(this);
	this.MenuBackButton_bg = new Sprite(ImageManager.load_MenuBackButton(Jp.MenuBackButton.scene_bg));
	this.addChild(this.MenuBackButton_bg);
};

//菜单界面创建关闭按钮
var _JP_MenuBackButton_createSprit = Scene_MenuBase.prototype.create;
Scene_MenuBase.prototype.create = function() {
	_JP_MenuBackButton_createSprit.call(this);
	this.JP_MenuBackButton_createbtn();
};
Scene_MenuBase.prototype.JP_MenuBackButton_createbtn = function(){
	if(Jp.MenuBackButton.btn[0] == "true" ){
		this.temp_MenuBackButton_btn = new Jp_MenuBackButton_Btn(); 
		this.temp_MenuBackButton_btn.mz = 120;
		this.addChild(this.temp_MenuBackButton_btn);
	}
};


//定义按钮
function Jp_MenuBackButton_Btn() {
    this.initialize.apply(this, arguments)
};
Jp_MenuBackButton_Btn.prototype = Object.create(Sprite.prototype);
Jp_MenuBackButton_Btn.prototype.constructor = Jp_MenuBackButton_Btn;

//初始化设置
Jp_MenuBackButton_Btn.prototype.initialize = function() {
	Sprite.prototype.initialize.call(this);
	this.Jp_MenuBackButton_Btn_details();
	
};
//按钮详情
Jp_MenuBackButton_Btn.prototype.Jp_MenuBackButton_Btn_details = function() {
	this.MenuBackButton_Btn = new Sprite(ImageManager.load_MenuBackButton(Jp.MenuBackButton.btn[1]));
	this.MenuBackButton_Btn.anchor.x = 0.5;
	this.MenuBackButton_Btn.anchor.y = 0.5;
	this.MenuBackButton_Btn.x = Number(Jp.MenuBackButton.btn[4]);
	this.MenuBackButton_Btn.y = Number(Jp.MenuBackButton.btn[5]);
	this.addChild(this.MenuBackButton_Btn);
};
Jp_MenuBackButton_Btn.prototype.update = function(){
	//切换悬停状态
	if(this.JP_isHover(this.MenuBackButton_Btn) && JP_MenuBackButton_btn_touched == false){
		this.MenuBackButton_Btn.bitmap = ImageManager.load_MenuBackButton(Jp.MenuBackButton.btn[2]);
		SoundManager.playCursor();
		JP_MenuBackButton_btn_touched = true;
	}
	
	//未悬停状态
	if(!this.JP_isHover(this.MenuBackButton_Btn)){
		this.MenuBackButton_Btn.bitmap = ImageManager.load_MenuBackButton(Jp.MenuBackButton.btn[1]);
		JP_MenuBackButton_btn_touched = false;
	}
	
	//点击状态切换
	if(this.JP_isPress(this.MenuBackButton_Btn)){
		if(TouchInput.isTriggered()){
			this.MenuBackButton_Btn.bitmap = ImageManager.load_MenuBackButton(Jp.MenuBackButton.btn[3]);
			SoundManager.playOk();
			SceneManager.pop();
		}
	}
};

//悬停监控
Jp_MenuBackButton_Btn.prototype.JP_isHover = function(sprite) {
	 if (sprite == null){ return false };
	 if (sprite.bitmap == null){ return false };
	 if (!sprite.bitmap.isReady() ){ return false };
	 var cw = sprite.bitmap.width;
	 var ch = sprite.bitmap.height;
	 if (sprite.visible === false) {return false};
	 if (sprite.opacity === 0) {return false};
	 if (_jp_mouse_x < sprite.x - cw *0.5) {return false};
	 if (_jp_mouse_x > sprite.x + cw*0.5) {return false};
	 if (_jp_mouse_y < sprite.y - ch*0.5) {return false};
	 if (_jp_mouse_y > sprite.y + ch*0.5) {return false};
	 return true;	
};
// * 点击监听
Jp_MenuBackButton_Btn.prototype.JP_isPress = function(sprite) {
	 if (sprite == null){ return false };
	 if (sprite.bitmap == null){ return false };
	 if (!sprite.bitmap.isReady() ){ return false };
	 if ( !TouchInput.isPressed() ) {return false};		//需要确定是否为鼠标点击
	 var cw = sprite.bitmap.width;
	 var ch = sprite.bitmap.height;
	 if (sprite.visible === false) {return false};
	 if (sprite.opacity === 0) {return false};
	 if (TouchInput.x < sprite.x - cw *0.5) {return false};
	 if (TouchInput.x > sprite.x + cw*0.5) {return false};
	 if (TouchInput.y < sprite.y- ch*0.5) {return false};
	 if (TouchInput.y > sprite.y + ch*0.5) {return false};
	 return true;	
};

// ** 获取鼠标位置
//=============================================================================
if( typeof(_jp_mouse_getCurPos) == "undefined" ){	//防止重复定义
	_jp_mouse_x = 0;
	_jp_mouse_y = 0;
	var _jp_mouse_getCurPos = TouchInput._onMouseMove;
	TouchInput._onMouseMove = function(event) {		//绑定在TouchInput中
		_jp_mouse_getCurPos.call(this,event);
        _jp_mouse_x = Graphics.pageToCanvasX(event.pageX);
        _jp_mouse_y = Graphics.pageToCanvasY(event.pageY);
	};
}
