//=============================================================================
// JP_Shadow.js
//=============================================================================

/*:
*
* @plugindesc V1.0 地图事件与人物行走图阴影。
* @author 青灯独酌
*
* @param height
* @desc 阴影所在的高度。
* @default 8
*
* @param opacity
* @desc 阴影的透明度。
* @default 150
*
* @help
* 默认在人物脚下增加阴影
* 如果事件备注栏包含 Shadow 字段则会添加阴影
* 跳跃时，阴影会根据跳跃高度调整位置。
* 阴影图为img/system/Shadow1.png
* =============================================================================
* 版本：1.0.0
* 基础功能完成，参考了project1论坛过眼云烟的阴影插件。
* =============================================================================
*/
//获取参数
var JP_Shadow_Parameters = PluginManager.parameters('JP_Shadow');
var JP_Shadow_height = Number(JP_Shadow_Parameters.height);
var JP_Shadow_opacity = Number(JP_Shadow_Parameters.opacity);
//==============================
//初始化设置
var JP_Shadow_initialize = Sprite_Character.prototype.initialize;
Sprite_Character.prototype.initialize = function(obj) {
    JP_Shadow_initialize.call(this,obj);
	if ((obj instanceof Game_Player)||(obj instanceof Game_Follower)){
		if(obj.isJumping()) {
			this.createShadow(obj.jumpHeight());//根据跳跃高度，显示阴影位置
		}else {
			this.createShadow(0);
		}
		this._showShadow = true;
	}
	if ((obj instanceof Game_Event) && (obj.event().note.indexOf("Shadow")>=0)){
		if(obj.isJumping()) {
			this.createShadow(obj.jumpHeight());
		}else {
			this.createShadow(0);
		}
		this._showShadow = true;
	}
};

Sprite_Character.prototype.createShadow = function(jumpHeight) {
    var jumpHeight = Number(jumpHeight);
	this._shadow = new Sprite();
    this._shadow.bitmap = ImageManager.loadSystem('Shadow1');
	this._shadow.x = this.x;
	this._shadow.y = this.y + JP_Shadow_height + jumpHeight;
	this._shadow.anchor.x = 0.5;
    this._shadow.anchor.y = 1;
    this._shadow.z = -1;
    this.addChild(this._shadow);
}	

Sprite_Character.prototype.update_shadow = function() {
	this._shadow.scale.x = this.patternWidth() / 48;
	this._shadow.scale.y = this._shadow.scale.x;
    this._shadow.opacity = JP_Shadow_opacity;
}	
	
var JP_Shadow_update = Sprite_Character.prototype.update;
Sprite_Character.prototype.update = function() {
	JP_Shadow_update.call(this);
	if (this._showShadow == true) {
	this.update_shadow();
	}
}
