//=============================================================================
// JP_VariableUpdateTips.js
//=============================================================================

/*:
*
* @plugindesc V1.1 变量值更新提示
* @author 青灯独酌
*
*
* @param initialshow
* @desc 初始是否显示。
* @type boolean
* @on 使用
* @off 不使用
* @desc 是否使用按钮1
* @default true


* @param VariableId
* @desc 需要提示的变量ID，如果有多个，请用 , 隔开,英文逗号，不要加空格。
* @default 1,2,3
*
*
* @param VariableTips_x
* @desc 变量提示的X坐标，锚点为提示信息的正中间。
* @default 512
*
* @param VariableTips_y
* @desc 变量提示的y坐标,锚点为提示信息的正中间。
* @default 280
*
*
* @param fontSize
* @desc 提示信息的字体大小
* @default 20
*
* @param hide_time
* @desc 消失时间，单位（帧），1帧=1/60（秒）
* @default 90
*
* @param distance
* @desc 向上飘的距离，单位（像素）。
* @default 100
*
* @help
* 当设置的变量发生变动时，在屏幕上弹出浮动文字提示。
* 如果设置的多个变量同时变化，只能显示列表靠后的一个。
* 若变量保存的为数值，会提示数值变化的多少。
* 若变量保存的为字符串，则会提示新的字符串内容。
* 插件指令
*	JP_VariableUpdate_show    //显示变量更新提示
*   JP_VariableUpdate_hide    //隐藏变量更新提示
* =============================================================================
* 版本：1.1
* 增加变量不是数字时的提示，增加初始是否显示的开关与相关的插件命令。
* =============================================================================
* 版本：1.0
* 基础功能完成
* =============================================================================
* =============================================================================
*/
//获取参数
var JP_VariableUpdateTips_Parameters = PluginManager.parameters('JP_VariableUpdateTips');
var JP_VariableUpdateTips_Variable = String(JP_VariableUpdateTips_Parameters.VariableId);
var JP_VariableUpdateTips_VariableId = new Array();
JP_VariableUpdateTips_VariableId = JP_VariableUpdateTips_Variable.split(",");
var JP_VariableUpdateTips_VariableTips_x = Number(JP_VariableUpdateTips_Parameters.VariableTips_x);
var JP_VariableUpdateTips_VariableTips_y = Number(JP_VariableUpdateTips_Parameters.VariableTips_y);
var JP_VariableUpdateTips_fontSize = Number(JP_VariableUpdateTips_Parameters.fontSize);
var JP_VariableUpdateTips_hide_time = Number(JP_VariableUpdateTips_Parameters.hide_time);
var JP_VariableUpdateTips_distance = Number(JP_VariableUpdateTips_Parameters.distance);
var JP_VariableUpdateTips_initialshow = String(JP_VariableUpdateTips_Parameters.initialshow);
var JP_VariableUpdateTips_Variable_Value =[];
//=========================================
//初始化
var _JP_VariableUpdateTips_initialize = Game_System.prototype.initialize;
Game_System.prototype.initialize = function(){
	_JP_VariableUpdateTips_initialize.call(this);
	this.Jp_VariableUpdateTips();
};
Game_System.prototype.Jp_VariableUpdateTips =function(){
	this.JP_VariableUpdateTips_show = JP_VariableUpdateTips_initialshow;//记录是否显示
};


//在地图上创建窗口空间
Scene_Base.prototype.jp_VariableUpdateTips_HudField = function() {
	this._VariableUpdateTips_HudField = new Sprite();
	this._VariableUpdateTips_HudField.z = 11;
	this.addChild(this._VariableUpdateTips_HudField);
};
//*把创建的窗口添加到地图上显示
var _jp_VariableUpdateTips_createSpriteset = Scene_Map.prototype.createSpriteset;
Scene_Map.prototype.createSpriteset = function() {
	_jp_VariableUpdateTips_createSpriteset.call(this);
		for(i = 0; i<JP_VariableUpdateTips_VariableId.length; i++){
			var j=JP_VariableUpdateTips_VariableId[i];
			JP_VariableUpdateTips_Variable_Value[i] = $gameVariables.value(j);//保存设置中第i，实际变量ID为j的数值
		}
	this.jp_VariableUpdateTips_HudField();
	this.jp_create_VariableUpdateTips(); 
};
Scene_Map.prototype.jp_create_VariableUpdateTips = function() {
	this._VariableTips = new jp_VariableUpdateTips();
	//this._VariableUpdateTips.mz = 120;
	this._VariableUpdateTips_HudField.addChild(this._VariableTips);			
};	

//=================================================================
//创建窗口
 function jp_VariableUpdateTips() {
    this.initialize.apply(this, arguments)
}
jp_VariableUpdateTips.prototype = Object.create(Sprite.prototype);
jp_VariableUpdateTips.prototype.constructor = jp_VariableUpdateTips;
//==============================
//初始化设置
jp_VariableUpdateTips.prototype.initialize = function() {
	Sprite.prototype.initialize.call(this);
	this.jp_create_Tips();
	this.show = false;
}
//==============================
//  创建提示信息
jp_VariableUpdateTips.prototype.jp_create_Tips = function() {
	this._Variable_tips = new Sprite(new Bitmap(500, JP_VariableUpdateTips_fontSize ));
	this._Variable_tips.bitmap.fontSize = JP_VariableUpdateTips_fontSize;
	this.addChild(this._Variable_tips);
}
//==============================
//*刷新显示信息
jp_VariableUpdateTips.prototype.jp_update_Tips =function(i){
		this._Variable_tips.bitmap.clear();
		this._Variable_tips.x = JP_VariableUpdateTips_VariableTips_x - 250;//重置出现的坐标点
		this._Variable_tips.y = JP_VariableUpdateTips_VariableTips_y -JP_VariableUpdateTips_fontSize/2;
		this.hide_time=0;//重置消失时间
		this._Variable_tips.opacity  = 255;//重新显示
		this.change_value = $gameVariables.value(JP_VariableUpdateTips_VariableId[i]) - JP_VariableUpdateTips_Variable_Value[i];//计算变量变化值
		if(isNaN(this.change_value)){
			this.change_value = $gameVariables.value(JP_VariableUpdateTips_VariableId[i]);
		}
		JP_VariableUpdateTips_Variable_Value[i] = $gameVariables.value(JP_VariableUpdateTips_VariableId[i]);//给当前变量重新赋值
		this.varName = $dataSystem.variables[JP_VariableUpdateTips_VariableId[i]];//获取变量名
		if(this.change_value > 0){
				this._Variable_tips.bitmap.drawText(this.varName + "+" + this.change_value,0,0,500,JP_VariableUpdateTips_fontSize,'center');
			}else this._Variable_tips.bitmap.drawText(this.varName + this.change_value,0,0,500,JP_VariableUpdateTips_fontSize,'center');
		this.show = true;
		this.move = JP_VariableUpdateTips_distance/JP_VariableUpdateTips_hide_time;//每帧的移动距离
	
}
//======================
//更新窗口信息
jp_VariableUpdateTips.prototype.update = function() {
   if($gameSystem.JP_VariableUpdateTips_show == "true"){
	   for (var i= 0 ; i<JP_VariableUpdateTips_VariableId.length; i++){
			var j=JP_VariableUpdateTips_VariableId[i];
			if(JP_VariableUpdateTips_Variable_Value[i] !== $gameVariables.value(j)){
				this.jp_update_Tips(i);
			}
		}
	}
	if(this.show = true) {
			this._Variable_tips.y = this._Variable_tips.y - this.move;//文字提示移动
			this.hide_time +=1;
			this._Variable_tips.opacity  = 255- 255 * this.hide_time/JP_VariableUpdateTips_hide_time;
			if(this.change_value > 0){
				this._Variable_tips.bitmap.drawText(this.varName + "+" + this.change_value,0,0,500,JP_VariableUpdateTips_fontSize,'center');
			}else this._Variable_tips.bitmap.drawText(this.varName + this.change_value,0,0,500,JP_VariableUpdateTips_fontSize,'center');
			if(this.hide_time >= JP_VariableUpdateTips_hide_time){
				this._Variable_tips.opacity  = 0;//时间到了隐藏提示
				this.show = false;
			}
			
		}
} 	
//插件指令
var _JP_VariableUpdateTips_pluginCommand =Game_Interpreter.prototype.pluginCommand;
Game_Interpreter.prototype.pluginCommand = function(command, args) {
	_JP_VariableUpdateTips_pluginCommand.call(this, command, args);
	if(command == "JP_VariableUpdate_show"){
		for(i = 0; i<JP_VariableUpdateTips_VariableId.length; i++){
			var j=JP_VariableUpdateTips_VariableId[i];
			JP_VariableUpdateTips_Variable_Value[i] = $gameVariables.value(j);//保存设置中第i，实际变量ID为j的数值
		}
		$gameSystem.JP_VariableUpdateTips_show = "true"
	}
	 if(command == "JP_VariableUpdate_hide"){
		$gameSystem.JP_VariableUpdateTips_show = "false"
	}
};

//============================