//=============================================================================
// MoveAnime2.js
//=============================================================================
//Copyright (c) 2016 Trb
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
//
//twitter https://twitter.com/Trb_surasura
/*:
 * @plugindesc 弹道插件 2
 * @author Trb
 * 
 * @version 1.0(2.0)  2016 4/22 前Move_anime.jsから大きく改変したため別プラグインとしました
 *          1.1       2016 7/ 4 アニメーションの表示位置が[頭上]、[中心]だった時、アニメーションの始点がおかしくなる不具合を修正
 * 
 * 
 * @help 可以将动画从使用者向对手放飞。
*设置方法有在技能备忘录栏中写入的方法和用脚本命令设定的方法两种。
*
*---设置方法1-----
*技能备忘录栏里
*<move:a>
*<arc:b>
*<deflection:c>
*<repeat:d>
*请写。(a,b,c,d中分别填写任意数字)
*move的设定是必须的，除此之外不需要的话无需填写也可以。
*
*<move:a>
*这是动画移动的帧数。
*（如果想0帧数放飞的话<move:10>这样写）
*
*<arc:b>
*设定此值后，会沿着b高度的抛物线轨道飞行。
*（arc:1=标准分辨率为1像素）
*
*<deflection:c>
*如果设定此值，则会将加减c的随机数与arc的值相加。
*(<arc:50><deflection:100>这样写的话实际的arc值是-50～150的宽度)
*多段打击技能适用这个设定会造成混乱射击。
*
*<repeat:d>
*设定此值后，重复播放同一动画。
*这是加入YEP_BattleCore后连续攻击时只能显示一次动画的问题
*这是为了对应而追加的功能，
*如果单独使用这个的话，会播放*d次，请注意。
*
*
*---设定方法2-----

*脚本命令：setParams(动画ID,move值,arc值,deflection值)
*中，您可以指定动画ID来设置参数。
*事件指令或单独插件显示的动画、场景中的动画等，
*技能备忘录栏里不能设定的请使用这里。
*
*举例想让ID5号的动画飞到10帧的场合
*setParams(5,10)这样写
*（这里也和备忘录栏一样，不需要arc值、deflection值就可以省略）
*
*一旦设定，只要不覆盖其他值即可，在游戏开始时
*在活动中总结设定的话会很方便。
*但是，如果没有设置用于保存的变量，则无法保存到存储数据中。
 * ==============================================================
 * 
 *---其他功能-----
*
*setStartPosition(动画ID,x,y)
*设定此值后，动画的开始位置不是技能使用者
*指定的坐标。
*
*
*例将ID10号动画从（100,200）的坐标上飞出去
*setParams_sp(10,100,200)
*
*
*clearParams(动画ID)
*重置所有指定的动画ID。
 * 
 * 
 * @param use_field
 * @desc フィールド上でもアニメーションを飛ばせるようにするか
 * フィールドで使わない･･･false  使う･･･true
 * @default false
 * 
 * @param variable
 * @desc setParamsで設定した値を保存する変数番号。
 * 0だと保存されません。
 * @default 0
 * 
 * 
 */
(function () {
	
	var parameters = PluginManager.parameters('MoveAnime2');
	var UseField = String(parameters['use_field']);
	var Variable = parameters['variable'];
	
	var params = [];
	var subjectX = 0;//使用者の座標
	var subjectY = 0;
	//paramsの中身
	var moveDuration = 0, arcRate = 1,deflection = 2,repeats = 3,startX = 4,startY = 5;

//各設定値の代入用関数
	setParams = function(id,move,arc,def,rep){
		id = Math.max(id,0);
		if(!params[id])params[id] = [];
		params[id][moveDuration] = move || 0;
		params[id][arcRate] = arc || 0;
		params[id][deflection] = def || 0;
		params[id][repeats] = rep || 0;
	};

	setStartPosition = function(id,a,b){
		if(!params[id])params[id] = [];
		params[id][startX] = a;
		params[id][startY] = b;
	};

	clearParams = function(id){
		params[id] = [];
	};



	var SBu = Sprite_Battler.prototype.update;
	Sprite_Battler.prototype.update = function() {
		SBu.call(this);
		//行動中のキャラの座標を取得する
		if(this._battler != null && this._battler.isActing()){
			if(!$gameSystem.isSideView() && this._actor){
				//フロントビューの場合
				subjectX = Graphics.boxWidth / 2;
				subjectY = Graphics.boxHeight * 0.8;				
			}else{
				subjectX = this.x;
				subjectY = this.y;
			}
		}
		
	};
	
	var WBsa = Window_BattleLog.prototype.startAction;
	Window_BattleLog.prototype.startAction = function(subject, action, targets) {
		var item = action.item();
		if(Number(item.meta.move)>0){//スキルのメモにムーブ値が設定されていたら代入
			setParams(item.animationId,Number(item.meta.move),Number(item.meta.arc) || 0,
				Number(item.meta.deflection) || 0,Number(item.meta.repeat) || 0);
		}
		WBsa.call(this,subject, action, targets);
	};

	
	Window_BattleLog.prototype.showNormalAnimation = function(targets, animationId, mirror) {
		var animation = $dataAnimations[animationId];
		if (animation) {
			var delay = this.animationBaseDelay();
			var nextDelay = this.animationNextDelay();
			targets.forEach(function(target) {
				target.startAnimation(animationId, mirror, delay);
				delay += nextDelay;
				var repeat = params[animationId] ? params[animationId][repeats] : 0;
				while(repeat > 0 ){//repeat値の分アニメーションを繰り返す処理を追加
					target.startAnimation(animationId, mirror, delay);
					delay += nextDelay;
					repeat -= 1;
				}
			});
		}
	};


	var SAim = Sprite_Animation.prototype.initMembers;
	Sprite_Animation.prototype.initMembers = function() {
		SAim.call(this);
		this._x2 = 0;
		this._y2 = 0;
		this._duration2 = 0;
		this._arcRate = 0;
		this._arc = 0;
	};

	//アニメーションのセットアップ時に各パラメータを代入
	var SAs = Sprite_Animation.prototype.setup;
	Sprite_Animation.prototype.setup = function(target, animation, mirror, delay) {
		if(params[animation.id] ){
			var prm = params[animation.id];
			if(prm[startX]){//startXが設定されてる場合はその値
				var sx = mirror ? Graphics.boxWidth - prm[startX] : prm[startX];
			}else{//そうでない場合は技使用者の座標
				sx = $gameParty.inBattle() ? subjectX : $gamePlayer.screenX();
			}
			if(prm[startY]){
				var sy = prm[startY];
			}else{
				sy = $gameParty.inBattle() ? subjectY : $gamePlayer.screenY();
			}
			
			if($gameParty.inBattle()){//戦闘時
				var t =target._battler ? target : target.parent;
				var pos = animation.position;//アニメーションのポジションに応じて位置補正を加える（ver.1.1修正箇所）
				this._x2 = sx - t.x;
				this._y2 = sy - t.y - t.height * (pos - 2) / 2;//

			}else if(UseField == 'true'){//フィールド時
				this._x2 = sx - target.x;
				this._y2 = sy - target.y;

			}
			this._duration2 = prm[moveDuration];
			this._arc = this._duration2;
			this._arcRate = prm[arcRate] + (Math.random() - 0.5) * prm[deflection] * 2;

		}
		SAs.call(this,target, animation, mirror, delay);
	};
	
	//上で代入した値を元に位置補正を加える
	var SAup = Sprite_Animation.prototype.updatePosition;
	Sprite_Animation.prototype.updatePosition = function() {
		SAup.call(this);
		//表示位置補正の計算
		if(this._duration2 > 0){
			this._x2 -= this._x2/this._duration2;
			this._y2 -= this._y2/this._duration2;
			this.x += this._x2;
			this.y += this._y2 - Math.sin(this._duration2 / this._arc * Math.PI) * this._arcRate;
			this._duration2 -= 1;
		}
	};


	//セーブ時にparamsを変数に入れる
	var SSof = Scene_Save.prototype.onSavefileOk;
	Scene_Save.prototype.onSavefileOk = function() {
		if(Variable > 0){
			$gameVariables._data[Variable] = params.clone();
		}
		SSof.call(this);
	};

	//ロード時にparamsに移す
	var SLol = Scene_Load.prototype.onLoadSuccess;
	Scene_Load.prototype.onLoadSuccess = function() {
		if(Variable > 0){
			try{
				params = $gameVariables._data[Variable].clone();
			}
			catch(e){}
		}
		SLol.call(this);
	};



})();