﻿//=============================================================================
// TMPlugin - バトラー表示拡張
// バージョン: 2.0.0
// 最終更新日: 2016/08/12
// 配布元    : http://hikimoki.sakura.ne.jp/
//-----------------------------------------------------------------------------
// Copyright (c) 2016 tomoaky
// Released under the MIT license.
// http://opensource.org/licenses/mit-license.php
//=============================================================================

/*:
 * @plugindesc 为敌人添加远近感和呼吸效果。
 *
 * @author tomoaky (http://hikimoki.sakura.ne.jp/)
 *
 * @param baseY
 * @desc 放大倍数相同的Y坐标。 
 * 初期値: 400
 * @default 400
 *
 * @param breathH
 * @desc 呼吸的频率。 
 * 初期値: 0.05
 * @default 0.05
 *
 * @param mirrorRate
 * @desc 左右反转的概率 。
 * 初期値: 0.4（ 0 ～ 1 ）
 * @default 0.4
 *
 * @param breathStop
 * @desc 死亡时停止呼吸。
 * 初期値: 1（0 无效/1 有效）
 * @default 1
 *
 * @param shakeEffect
 * @desc 用摇晃效果替换闪烁效果。 
 * 初期値: 1（0 效的/1 有効）
 * @default 1
 *
 * @help
 * 使用方法:
 *
 *   安装此插件后，敌方角色的显示会增加以下效果。 
 *     ・出现在屏幕顶部的敌人会显示得小（远近感）
 *     ・慢慢重复缩放（呼吸） 
 *     ・左右随意翻转 
 *
 *   在侧视图中禁用左/右反转。
 *   通过在敌方角色的备注字段中写入标签，
 *   您可以设置每个敌方角色的制作强度。 
 *
 *   没有插件命令。 
 *
 *   该插件已经过 RPG Maker MV 1.3.0 版测试。 
 *
 *
 * 备注栏（敌方角色）标签 :
 *
 *   <scale:1>
 *     单独设置放大倍数，
 *     远近感表达式不适用于带有此标签的敌方角色。 
 *
 *   <breathH:0.05>
 *     单独设置呼吸的频率。 
 *
 *   <noMirror>
 *     禁止左右颠倒。 
 */

var Imported = Imported || {};
Imported.TMBattlerEx = true;

var TMPlugin = TMPlugin || {};
TMPlugin.BattlerEx = {};
TMPlugin.BattlerEx.Parameters = PluginManager.parameters('TMBattlerEx');
TMPlugin.BattlerEx.BaseY = +(TMPlugin.BattlerEx.Parameters['baseY'] || 400);
TMPlugin.BattlerEx.BreathH = +(TMPlugin.BattlerEx.Parameters['breathH'] || 0.05);
TMPlugin.BattlerEx.MirrorRate = +(TMPlugin.BattlerEx.Parameters['mirrorRate'] || 0.4);
TMPlugin.BattlerEx.BreathStop = TMPlugin.BattlerEx.Parameters['breathStop'] === '1';
TMPlugin.BattlerEx.ShakeEffect = TMPlugin.BattlerEx.Parameters['shakeEffect'] === '1';

(function() {

  //-----------------------------------------------------------------------------
  // Sprite_Enemy
  //
  
  var _Sprite_Enemy_initialize = Sprite_Enemy.prototype.initialize;
  Sprite_Enemy.prototype.initialize = function(battler) {
    _Sprite_Enemy_initialize.call(this, battler);
    var r = +(battler.enemy().meta.scale || this.y / (TMPlugin.BattlerEx.BaseY * 2) + 0.5);
    this._baseScale = new Point(r, r);
    if (!$gameSystem.isSideView() && Math.random() < TMPlugin.BattlerEx.MirrorRate &&
        !battler.enemy().meta.noMirror) {
      this._baseScale.x = 0 - r;
      this._stateIconSprite.scale.x = -1;
    }
    this._breathMax = Math.randomInt(90) + 90;
    this._breathCount = Math.randomInt(this._breathMax);
  };
  
  var _Sprite_Enemy_update = Sprite_Enemy.prototype.update;
  Sprite_Enemy.prototype.update = function() {
    _Sprite_Enemy_update.call(this);
    this.updateScaleEx();
  };

  Sprite_Enemy.prototype.updateScaleEx = function() {
    if (TMPlugin.BattlerEx.BreathStop && !this._enemy.canMove()) return;
    this._breathCount++;
    if (this._breathCount >= this._breathMax) {
      this._breathMax = Math.randomInt(90) + 90;
      this._breathCount = 0;
    }
    var scaleX = this._baseScale.x;
    var scaleY = this._baseScale.y;
    var bh = +(this._enemy.enemy().meta.breathH || TMPlugin.BattlerEx.BreathH);
    scaleY += Math.sin(Math.PI * this._breathCount / (this._breathMax / 2)) * bh;
    this.scale.set(scaleX, scaleY);
  };

  var _Sprite_Enemy_updateBlink = Sprite_Enemy.prototype.updateBlink;
  Sprite_Enemy.prototype.updateBlink = function() {
    if (TMPlugin.BattlerEx.ShakeEffect) {
      var ed = this._effectDuration;
      this.rotation = ed % 4 < 2 ? ed / 200 : 0 - ed / 200;
    } else {
      _Sprite_Enemy_updateBlink.call(this);
    }
  };

})();
