//=================================================================================================
// Automatic_Speaking.js
//=================================================================================================
/*:
* @target MZ
* @plugindesc 道具使用目标限制 （MV + MZ）。
* @author 芯☆淡茹水
* @help
*
* 物品/技能备注：<ClassLimit:id1,id2,id3...>
* 表示该物品使用时有职业限制。
* 例：限制 2， 5， 12， 20  号职业才能使用 ： <ClassLimit:2,5,12,20>
* 未备注的 物品/技能 ，无职业限制。
*
*/
//=================================================================================================
;var XdRs_ItemLimit_Game_Action_testApply = Game_Action.prototype.testApply;
Game_Action.prototype.testApply = function(target) {
    return XdRs_ItemLimit_Game_Action_testApply.call(this, target) && this.testClassLimit(target);
};
Game_Action.prototype.testClassLimit = function(target) {
    if (!this.item() || !this.item().meta.ClassLimit) return true; // 没有备注的，就没有职业限制
    if (!target || !target.isActor()) return false;   // 如果有备注职业限制， 但对象是 敌人 （敌人无职业） 时，就无效。
    var arr = this.item().meta.ClassLimit.split(',').map(function(n){return parseInt(n);});
    return arr.contains(target.currentClass().id);
};
//=================================================================================================
// end
//=================================================================================================