# KOR_Remake 政治经济与官僚系统技术文档

## 概述

本模组实现了一套复杂的马克思主义政治经济学系统，包括：
1. **派系影响力系统** - 延安派、苏联派、国内派、甲山派
2. **官僚派系系统** - 小官僚、技术官僚、官僚资产阶级、权力核心
3. **经济政策系统** - 重工业、轻工业、农业、商业
4. **政治路线系统** - 七种可选路线
5. **官僚资产阶级危机系统** - 历史/激进两条路线

---

## ⚠️ 核心机制：双变量系统

### 这是最重要的设计！

官僚派系使用**双变量系统**：

| 基础值变量 | 显示值变量 | 说明 |
|-----------|-----------|------|
| `CZD_petty_officials` | `CZD_petty_officials_power` | 小官僚 |
| `CZD_technocrats` | `CZD_technocrats_power` | 技术官僚 |
| `CZD_bureaucratic_bourgeoisie` | `CZD_bureaucratic_bourgeoisie_power` | 官僚资产阶级 |
| `CZD_power_core` | `CZD_power_core_power` | 权力核心 |

### 为什么需要双变量？

`CZD_update_bureaucracy` 脚本每次执行时会：

```pdx
# 第1步：用基础值覆盖显示值
set_variable = { CZD_petty_officials_power = CZD_petty_officials }
set_variable = { CZD_technocrats_power = CZD_technocrats }
set_variable = { CZD_bureaucratic_bourgeoisie_power = CZD_bureaucratic_bourgeoisie }

# 第2步：根据经济政策调整显示值
if = {
    limit = { check_variable = { CZD_economic_tendency > 1 } }
    add_to_variable = { CZD_bureaucratic_bourgeoisie_power = 0.5 }
    # ...更多调整
}

# 第3步：归一化使总和为100%
CZD_normalize_bureaucracy = yes

# 第4步（在归一化内）：把显示值存回基础值
set_variable = { CZD_petty_officials = CZD_petty_officials_power }
set_variable = { CZD_technocrats = CZD_technocrats_power }
set_variable = { CZD_bureaucratic_bourgeoisie = CZD_bureaucratic_bourgeoisie_power }
```

### ⚠️ 关键规则

**任何修改官僚派系变量的代码，必须同时修改基础值和显示值！**

```pdx
# ❌ 错误写法 - 修改会在下次更新时丢失
add_to_variable = { CZD_bureaucratic_bourgeoisie_power = 10 }

# ✅ 正确写法 - 同时修改两个变量
add_to_variable = { CZD_bureaucratic_bourgeoisie_power = 10 }
add_to_variable = { CZD_bureaucratic_bourgeoisie = 10 }
```

---

## 派系影响力系统

### 变量（单变量，无双变量问题）

| 变量名 | 说明 | 初始值 |
|-------|------|--------|
| `CZD_yanan_influence` | 延安派影响力 | 25 |
| `CZD_soviet_influence` | 苏联派影响力 | 25 |
| `CZD_domestic_influence` | 国内派影响力 | 25 |
| `CZD_kapsan_influence` | 甲山派影响力 | 25 |

### 政治路线解锁条件

| 路线 | 条件 |
|-----|------|
| 无产阶级专政 | 政治倾向 < -20 且 延安派为多数派 |
| 人民民主专政 | 默认可选 |
| 技术官僚主导 | 技术官僚 > 45% 且 苏联派为多数派 |
| 修正主义 | 政治倾向 > 20 |
| 军国主义 | 军事政策 < 30 且 甲山派为多数派 |
| 官僚资产阶级专政 | 官僚资产阶级 > 40% 且 政治倾向 > 15 且 国内派为多数派 |
| 工团主义 | 轻工业 > 55 且 商业 > 55 且 政治倾向在 -10~+10 且 国内派为多数派 |

---

## 官僚派系系统

### 初始值（总和为100%）

| 派系 | 初始值 | 范围限制 |
|-----|--------|---------|
| 小官僚 `petty_officials` | 55% | 5-60% |
| 技术官僚 `technocrats` | 20% | 5-50% |
| 官僚资产阶级 `bureaucratic_bourgeoisie` | 20% | 0-40% |
| 权力核心 `power_core` | 5% | 10-60% |

### 归一化机制

每次更新后，四个派系的 `_power` 值会被归一化使总和为100%：

```pdx
CZD_normalize_bureaucracy = {
    set_variable = { CZD_bureaucracy_total = 0 }
    add_to_variable = { CZD_bureaucracy_total = CZD_petty_officials_power }
    add_to_variable = { CZD_bureaucracy_total = CZD_technocrats_power }
    add_to_variable = { CZD_bureaucracy_total = CZD_bureaucratic_bourgeoisie_power }
    add_to_variable = { CZD_bureaucracy_total = CZD_power_core_power }
    
    # 归一化到100%
    set_variable = { CZD_bureaucracy_normalize = 100 }
    divide_variable = { CZD_bureaucracy_normalize = CZD_bureaucracy_total }
    multiply_variable = { CZD_petty_officials_power = CZD_bureaucracy_normalize }
    # ... 其他派系同理
}
```

---

## 经济政策系统

### 变量

| 变量名 | 说明 | 范围 |
|-------|------|------|
| `CZD_heavy_industry_policy` | 重工业政策 | 0-100 |
| `CZD_light_industry_policy` | 轻工业政策 | 0-100 |
| `CZD_agriculture_policy` | 农业政策 | 0-100 |
| `CZD_commerce_policy` | 商业政策 | 0-100 |
| `CZD_political_score` | 政治倾向 | 负=左倾，正=右倾 |
| `CZD_economic_tendency` | 经济倾向 | 自动计算 |

### 经济倾向对官僚的影响

- 经济倾向 > 1：官僚资产阶级+0.5，技术官僚+0.3，小官僚-0.3，权力核心-0.2
- 经济倾向 < -1：权力核心+0.5，小官僚+0.3，官僚资产阶级-0.5，技术官僚-0.2

---

## 官僚资产阶级危机系统

### 核心变量

| 变量名 | 说明 |
|-------|------|
| `CZD_bureaucratic_bourgeoisie_power` | 官僚资产阶级力量（触发危机阈值） |
| `CZD_counterrevolution_level` | 反革命叛乱度 |
| `CZD_revolutionary_momentum` | 革命动能 |
| `CZD_purge_intensity` | 清洗强度 |

### 关键Flag

| Flag | 说明 |
|-----|------|
| `CZD_crisis_started` | 危机系统已启动 |
| `CZD_historical_line_active` | 历史路线（金家社会主义） |
| `CZD_radical_line_active` | 激进路线（最后的革命） |
| `CZD_red_dynasty_ending` | 红色王朝结局 |
| `CZD_wuzhangyuan_ending` | 五丈原结局（激进失败） |
| `CZD_world_liberation_ending` | 世界解放结局（激进胜利） |
| `CZD_crisis_resolved` | 危机已解决 |

---

## 文件结构

### 核心脚本效果
- `common/scripted_effects/CZD_political_economy_effects.txt`
  - `CZD_init_political_economy` - 初始化系统
  - `CZD_update_political_economy` - 主更新函数
  - `CZD_update_bureaucracy` - 更新官僚派系
  - `CZD_normalize_bureaucracy` - 归一化官僚派系

- `common/scripted_effects/CZD_crisis_effects.txt`
  - `CZD_crisis_increase_bureaucratic_power` - 增加官僚力量
  - `CZD_crisis_decrease_bureaucratic_power` - 减少官僚力量

### GUI定义
- `common/scripted_guis/CZD_political_economy_gui.txt` - 政治经济面板按钮逻辑
- `common/scripted_guis/CZD_crisis_scripted_gui.txt` - 危机系统GUI
- `interface/CZD_political_economy.gui` - GUI布局

### 事件
- `events/CZD_bureaucracy_events.txt` - 官僚事件
- `events/CZD_crisis_events.txt` - 危机事件
- `events/CZD_political_economy_events.txt` - 政治经济事件
- `events/CZD_class_struggle_events.txt` - 阶级斗争事件

### 决议
- `common/decisions/CZD_debug_decisions.txt` - 调试工具
- `common/decisions/CZD_crisis_decisions.txt` - 危机决议

### 国策
- `common/national_focus/Korea.txt` - 包含大量官僚变量修改

---

## 调试工具

调试决议位于 `CZD_debug_decisions` 分类（需要 `is_debug = yes`）：

| 决议 | 功能 |
|-----|------|
| `CZD_debug_start_crisis` | 启动危机系统 |
| `CZD_debug_add_bureaucracy` | 官僚资产阶级 +10 |
| `CZD_debug_reduce_bureaucracy` | 官僚资产阶级 -10 |
| `CZD_debug_add_technocrats` | 技术官僚 +10 |
| `CZD_debug_reduce_technocrats` | 技术官僚 -10 |
| `CZD_debug_add_yanan_influence` | 延安派影响力 +10 |
| `CZD_debug_add_soviet_influence` | 苏联派影响力 +10 |
| `CZD_debug_add_domestic_influence` | 国内派影响力 +10 |
| `CZD_debug_add_kapsan_influence` | 甲山派影响力 +10 |

---

## 常见问题排查

### 问题：修改官僚变量后数值会回退

**原因**：只修改了 `_power` 变量，没有同时修改基础值

**解决**：确保同时修改两个变量
```pdx
add_to_variable = { CZD_bureaucratic_bourgeoisie_power = 10 }
add_to_variable = { CZD_bureaucratic_bourgeoisie = 10 }
```

### 问题：政治路线按钮无法点击

**检查**：
1. `CZD_political_economy_gui.txt` 中的 `*_btn_click_enabled` 条件
2. 确认使用的是 `_power` 后缀变量（GUI显示的是 `_power` 变量）
3. 检查派系影响力条件是否满足

### 问题：危机系统不触发

**检查**：
1. 是否设置了 `CZD_crisis_started` flag
2. `CZD_bureaucratic_bourgeoisie_power` 是否达到阈值
3. 相关on_action是否正确配置

---

## 版本历史

- 2025-12-04: 修复双变量系统一致性问题，所有事件/决议/脚本效果现在都正确同时修改基础值和显示值
